#
# step1.rb
#   $Id: step1.rb,v 1.1 2000/11/18 18:57:43 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include NMath

nmax = 201
imax = 5
len_2 = 5

ix  = 0
iy0 = 1
iy1 = 2
iy2 = 3
iy3 = 4

z1 = NArray.sfloat(nmax, len_2)

a = []

#-- data ----
for m in 1..imax
  tm = (2*m - 1)*PI
  a[m-1] = (-1.0)**m * 2/tm
end

idx = NArray.sfloat(nmax).indgen!
z1[true,ix] = 1.0*idx/(nmax-1)
tn = 2*PI*z1[true,ix]
z1[ ( (tn>=(PI/2)) & (tn<(PI*3/2)) ).where, iy0] = 1.0
z1[true,iy1] = 0.5 + a[0]*cos(tn)
z1[true,iy2] = 0.5
z1[true,iy3] = 0.5

for k in 1..imax
  tk = 2*k - 1
  tc = a[k-1]*cos(tk*tn)

  z1[true,iy2] = z1[true,iy2] +
    if (k <= 3) then tc else 0 end
  z1[true,iy3] = z1[true,iy3] + tc
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

x  = z1[true,ix]
y0 = z1[true,iy0]
y1 = z1[true,iy1]
y2 = z1[true,iy2]
y3 = z1[true,iy3]

DCL::usspnt(x, y0)
DCL::usspnt(x, y1)
DCL::usspnt(x, y2)
DCL::usspnt(x, y3)

DCL::uspfit
DCL::grstrf

DCL::ussttl('FREQUENCY', '/DAY', 'RESPONSE', '')
DCL::usdaxs

DCL::uulin(x, y0)

DCL::uuslnt(2)
DCL::uuslni(3)
DCL::uulin(x, y1)

DCL::uuslnt(3)
DCL::uulin(x, y2)

DCL::uuslnt(4)
DCL::uulin(x, y3)

DCL::grcls

