/*
 * math2_shtlib.fp
 *
 * $Id: math2_shtlib.fp,v 1.1 2000/11/19 16:00:18 keiko Exp $
 */

/*****************************************************
 * math2/shtlib/shtlib.f
 ****************************************************/
/* 
 *      SUBROUTINE SHTLIB
 */
      SUBROUTINE SHTLIB(
      )

/* 
 *      ENTRY SHTINT(MM,JM,IM,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTINT(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) o WORK
      )

/* 
 *      ENTRY SHTLAP(MM,IND,A,B)
 *      REAL WJ(*),GJ(*),A(*),B(*)
 */
      SUBROUTINE SHTLAP(
          INTEGER MM
          INTEGER IND
          REAL ((MM+1)*(MM+1)) A
          REAL ((MM+1)*(MM+1)) o B
      )

/* 
 *      ENTRY SHTNML(MM,N,M,LR,LI)
 */
      SUBROUTINE SHTNML(
          INTEGER MM
          INTEGER N
          INTEGER M
          INTEGER o LR
          INTEGER o LI
      )

/* 
 *      ENTRY SHTFUN(MM,JM,M,FUN,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTFUN(
          INTEGER MM
          INTEGER JM
          INTEGER M
          REAL ((2*JM+1),(MM-M+1)) o FUN
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTLFW(MM,JM,M,ISW,WM,SM,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTLFW(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (2*JM+1) WM
          REAL (MM-M+1) o SM
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTLBW(MM,JM,M,ISW,SM,WM,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTLBW(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (MM-M+1) SM
          REAL (2*JM+1) o WM
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTS2W(MM,JM,ISW,S,W,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTS2W(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
/*          REAL S */
/*          REAL o W */
          REAL ((MM+1)*(MM+1)) S
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSWA(MM,JM,ISW,M1,M2,S,W,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSWA(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER M1
          INTEGER M2
/*          REAL S */
/*          REAL o W */
          REAL ((MM+1)*(MM+1)) S
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSWZ(MM,JM,ISW,S,WZ,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSWZ(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*JM+1) o WZ
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSWM(MM,JM,M,ISW,S,WR,WI,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSWM(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*JM+1) o WR
          REAL (2*JM+1) o WI
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSWJ(MM,JM,ISW,J,M1,M2,S,WJ,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 *      REAL WJ(*),GJ(*),A(*),B(*)
 */
      SUBROUTINE SHTSWJ(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER J
          INTEGER M1
          INTEGER M2
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*MM+1) o WJ
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTW2S(MM,JM,ISW,S,W,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTW2S(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
/*          REAL S */
/*          REAL o W */
          REAL ((2*JM+1)*(2*MM+1)) S
          REAL ((MM+1),(MM+1)) o W
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTW2G(MM,JM,IM,W,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTW2G(
          INTEGER MM
          INTEGER JM
          INTEGER IM
/*          REAL W */
          REAL ((2*JM+1),(2*MM+1)) W
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTWGA(MM,JM,IM,M1,M2,W,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTWGA(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER M1
          INTEGER M2
/*          REAL W */
          REAL ((2*JM+1),(2*MM+1)) W
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTWGM(MM,JM,IM,M,WR,WI,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTWGM(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER M
          REAL (2*JM+1) WR
          REAL (2*JM+1) WI
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTWGZ(JM,IM,WZ,G)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTWGZ(
          INTEGER JM
          INTEGER IM
          REAL (2*JM+1) WZ
          REAL ((2*IM+1),(2*JM+1)) o G
      )

/* 
 *      ENTRY SHTWGJ(MM,IM,M1,M2,WJ,GJ,Q)
 *      REAL WJ(*),GJ(*),A(*),B(*)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTWGJ(
          INTEGER MM
          INTEGER IM
          INTEGER M1
          INTEGER M2
          REAL (2*MM+1) WJ
          REAL (2*IM+1) o GJ
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTG2W(MM,JM,IM,G,W,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTG2W(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          REAL ((2*IM+1),(2*JM+1)) G
/*          REAL o W */
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTS2G(MM,JM,IM,ISW,S,W,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTS2G(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER ISW
/*          REAL S */
/*          REAL o W */
          REAL ((MM+1)*(MM+1)) S
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSGA(MM,JM,IM,ISW,M1,M2,S,W,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSGA(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER ISW
          INTEGER M1
          INTEGER M2
/*          REAL S */
/*          REAL o W */
          REAL ((MM+1)*(MM+1)) S
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSGZ(MM,JM,IM,ISW,S,WZ,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSGZ(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER ISW
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*JM+1) o WZ
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSGM(MM,JM,IM,M,ISW,S,WR,WI,G,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTSGM(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER M
          INTEGER ISW
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*JM+1) o WR
          REAL (2*JM+1) o WI
          REAL ((2*IM+1),(2*JM+1)) o G
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTSGJ(MM,JM,IM,ISW,J,M1,M2,S,WJ,GJ,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 *      REAL WJ(*),GJ(*),A(*),B(*)
 */
      SUBROUTINE SHTSGJ(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER ISW
          INTEGER J
          INTEGER M1
          INTEGER M2
/*          REAL S */
          REAL ((MM+1)*(MM+1)) S
          REAL (2*MM+1) o WJ
          REAL (2*IM+1) o GJ
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/* 
 *      ENTRY SHTG2S(MM,JM,IM,ISW,G,W,S,Q)
 *      REAL Q(*),FUN(*),S(*),W(*),G(*),SM(*),WM(*),WZ(*),WR(*),WI(*)
 */
      SUBROUTINE SHTG2S(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER ISW
          REAL ((2*IM+1),(2*JM+1)) G
          REAL ((2*JM+1),(2*MM+1)) o W
          REAL ((MM+1)*(MM+1)) o S
          REAL ((JM+1)*(4*JM+5*MM+14)+(MM+1)*(MM+1)+MM+2+6*IM+15) WORK
      )

/*****************************************************
 * math2/shtlib/shinit.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIT(MM,JM,IM,Y,YS,YC,X,XS,XC,XW,Z,PY,PX,R,WFFT)
 *      REAL Y(0:JM),YS(0:JM),YC(0:JM)
 *      REAL X(0:JM),XS(0:JM),XC(0:JM),XW(0:JM)
 *      REAL Z(JM,0:JM,4)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL PX(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHINIT(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          REAL o Y
          REAL (0:JM) o YS
          REAL (0:JM) o YC
          REAL o X
          REAL (0:JM) o XS
          REAL (0:JM) o XC
          REAL (0:JM) o XW
          REAL (JM,0:JM,4) o Z
          REAL (2,0:JM,0:MM) o PY
          REAL (2,0:JM,0:MM) o PX
          REAL ((MM+1)*(MM+1)) o R
          REAL (*) o WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shinix.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIX(JM,X,XS,XC,XW)
 *      IMPLICIT REAL*8(A-H,O-Z)
 *      REAL X(0:JM),XS(0:JM),XC(0:JM),XW(0:JM)
 */
/*
      SUBROUTINE SHINIX(
          INTEGER JM
          REAL o X
          REAL (0:JM) o XS
          REAL (0:JM) o XC
          REAL (0:JM) o XW
      )
*/

/*****************************************************
 * math2/shtlib/shiniy.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIY(JM,Y,YS,YC)
 *      REAL Y(0:JM),YS(0:JM),YC(0:JM)
 */
/*
      SUBROUTINE SHINIY(
          INTEGER JM
          REAL o Y
          REAL (0:JM) o YS
          REAL (0:JM) o YC
      )
*/

/*****************************************************
 * math2/shtlib/shiniz.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIZ(JM,X,Y,Z)
 *      REAL X(0:JM),Y(0:JM)
 *      REAL Z(JM,0:JM,4)
 */
/*
      SUBROUTINE SHINIZ(
          INTEGER JM
          REAL (0:JM) X
          REAL (0:JM) Y
          REAL (JM,0:JM,4) o Z
      )
*/

/*****************************************************
 * math2/shtlib/shinip.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIP(MM,JM,YS,YC,PY)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 */
/*
      SUBROUTINE SHINIP(
          INTEGER MM
          INTEGER JM
          REAL (0:JM) YS
          REAL (0:JM) YC
          REAL (2,0:JM,0:MM) o PY
      )
*/

/*****************************************************
 * math2/shtlib/shinic.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIC(MM,JM,XW,PX)
 *      REAL XW(0:JM),PX(2,0:JM,0:MM)
 */
/*
      SUBROUTINE SHINIC(
          INTEGER MM
          INTEGER JM
          REAL (0:JM) XW
          REAL (2,0:JM,0:MM) o PX
      )
*/

/*****************************************************
 * math2/shtlib/shinir.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIR(MM,R)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHINIR(
          INTEGER MM
          REAL ((MM+1)*(MM+1)) o R
      )
*/

/*****************************************************
 * math2/shtlib/shinif.f
 ****************************************************/
/* 
 *      SUBROUTINE SHINIF(NFFT,WFFT) 
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHINIF(
          INTEGER NFFT
          REAL (*) o WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shnm2l.f
 ****************************************************/
/* 
 *      SUBROUTINE SHNM2L(MM,N,M,LR,LI)
 */
/*
      SUBROUTINE SHNM2L(
          INTEGER MM
          INTEGER N
          INTEGER M
          INTEGER o LR
          INTEGER o LI
      )
*/

/*****************************************************
 * math2/shtlib/sholap.f
 ****************************************************/
/* 
 *      SUBROUTINE SHOLAP(MM,IND,A,B)
 *      REAL A((MM+1)*(MM+1)),B((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHOLAP(
          INTEGER MM
          INTEGER IND
          REAL ((MM+1)*(MM+1)) A
          REAL ((MM+1)*(MM+1)) o B
      )
*/

/*****************************************************
 * math2/shtlib/shfw2g.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFW2G(MM,JM,IM,W,G,H,WFFT)
 *      REAL W(-JM:JM,-MM:MM),G(-IM:IM,-JM:JM)
 *      REAL H(0:2*IM-1)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFW2G(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          REAL (-JM:JM,-MM:MM) W
          REAL (-IM:IM,-JM:JM) o G
          REAL (0:2*IM-1) t H
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfwga.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFWGA(MM,JM,IM,M1,M2,W,G,H,WFFT)
 *      REAL W(-JM:JM,-MM:MM),G(-IM:IM,-JM:JM)
 *      REAL H(0:2*IM-1)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFWGA(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          INTEGER M1
          INTEGER M2
          REAL (-JM:JM,-MM:MM) W
          REAL (-IM:IM,-JM:JM) o G
          REAL (0:2*IM-1) t H
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfwgm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFWGM(JM,IM,M,WR,WI,G,H,WFFT)
 *      REAL WR(-JM:JM),WI(-JM:JM),G(-IM:IM,-JM:JM)
 *      REAL H(0:2*IM-1)
 *      REAL WFFT(*)
 */
/*      SUBROUTINE SHFWGM(
          INTEGER JM
          INTEGER IM
          INTEGER M
          REAL (-JM:JM) WR
          REAL (-JM:JM) WI
          REAL (-IM:IM,-JM:JM) o G
          REAL (0:2*IM-1) t H
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfwgz.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFWGZ(JM,IM,WZ,G)
 *      REAL WZ(-JM:JM),G(-IM:IM,-JM:JM)
 */
/*
      SUBROUTINE SHFWGZ(
          INTEGER JM
          INTEGER IM
          REAL (-JM:JM) WZ
          REAL (-IM:IM,-JM:JM) o G
      )
*/

/*****************************************************
 * math2/shtlib/shfwgj.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFWGJ(MM,IM,M1,M2,WJ,GJ,H,WFFT)
 *      REAL WJ(-MM:MM),GJ(-IM:IM)
 *      REAL H(0:2*IM-1)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFWGJ(
          INTEGER MM
          INTEGER IM
          INTEGER M1
          INTEGER M2
          REAL (-MM:MM) WJ
          REAL (-IM:IM) o GJ
          REAL (0:2*IM-1) t H
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfg2w.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFG2W(MM,JM,IM,G,W,H,WFFT)
 *      REAL G(-IM:IM,-JM:JM),W(-JM:JM,-MM:MM)
 *      REAL H(0:2*IM-1)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFG2W(
          INTEGER MM
          INTEGER JM
          INTEGER IM
          REAL (-IM:IM,-JM:JM) G
          REAL (-JM:JM,-MM:MM) o W
          REAL (0:2*IM-1) t H
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfftf.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFFTF(NFFT,XFFT,WFFT)
 *      REAL XFFT(NFFT)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFFTF(
          INTEGER NFFT
          REAL (NFFT) io XFFT
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shfftb.f
 ****************************************************/
/* 
 *      SUBROUTINE SHFFTB(NFFT,XFFT,WFFT)
 *      REAL XFFT(NFFT)
 *      REAL WFFT(*)
 */
/*
      SUBROUTINE SHFFTB(
          INTEGER NFFT
          REAL (NFFT) io XFFT
          REAL (*) t WFFT
      )
*/

/*****************************************************
 * math2/shtlib/shms2w.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMS2W(MM,JM,ISW,S,W,SD,PM,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),W(-JM:JM,-MM:MM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMS2W(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          REAL ((MM+1)*(MM+1)) S
          REAL (-JM:JM,-MM:MM) o W
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmswa.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMSWA(MM,JM,ISW,M1,M2,S,W,SD,PM,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),W(-JM:JM,-MM:MM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMSWA(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER M1
          INTEGER M2
          REAL ((MM+1)*(MM+1)) S
          REAL (-JM:JM,-MM:MM) o W
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmswz.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMSWZ(MM,JM,ISW,S,WZ,SD,PM,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),WZ(-JM:JM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMSWZ(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          REAL ((MM+1)*(MM+1)) S
          REAL (-JM:JM) o WZ
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmswm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMSWM(MM,JM,M,ISW,S,WR,WI,SD,PM,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),WR(-JM:JM),WI(-JM:JM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMSWM(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL ((MM+1)*(MM+1)) S
          REAL (-JM:JM) o WR
          REAL (-JM:JM) o WI
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmdxm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMDXM(JM,WR,WI)
 *      REAL WR(-JM:JM),WI(-JM:JM)
 */
/*
      SUBROUTINE SHMDXM(
          INTEGER JM
          REAL (-JM:JM) io WR
          REAL (-JM:JM) io WI
      )
*/

/*****************************************************
 * math2/shtlib/shmswj.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMSWJ(MM,JM,ISW,J,M1,M2,S,WJ,SD,PMJ,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),WJ(-MM:MM)
 *      REAL SD(0:MM+1),PMJ(0:MM+1)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMSWJ(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER J
          INTEGER M1
          INTEGER M2
          REAL ((MM+1)*(MM+1)) S
          REAL (-MM:MM) o WJ
          REAL (0:MM+1) t SD
          REAL (0:MM+1) t PMJ
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmwjz.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMWJZ(MM,JM,ISW,J,S,WJD,SD,PMJ,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),WJD
 *      REAL SD(0:MM+1),PMJ(0:MM+1)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMWJZ(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER J
          REAL ((MM+1)*(MM+1)) S
          REAL o WJD
          REAL (0:MM+1) t SD
          REAL (0:MM+1) t PMJ
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmwjm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMWJM(MM,JM,ISW,J,M,S,WJR,WJI,SD,PMJ,YS,YC,PY,R)
 *      REAL S((MM+1)*(MM+1)),WJR,WJI
 *      REAL SD(0:MM+1),PMJ(0:MM+1)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHMWJM(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          INTEGER J
          INTEGER M
          REAL ((MM+1)*(MM+1)) S
          REAL o WJR
          REAL o WJI
          REAL (0:MM+1) t SD
          REAL (0:MM+1) t PMJ
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shmdxj.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMDXJ(WRD,WID)
 *      REAL WRD,WID
 */
/*
      SUBROUTINE SHMDXJ(
          REAL io WRD
          REAL io WID
      )
*/

/*****************************************************
 * math2/shtlib/shmw2s.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMW2S(MM,JM,ISW,W,S,SD,PM,XS,XC,PX,WY,WX,R,Z)
 *      REAL W(-JM:JM,-MM:MM),S((MM+1)*(MM+1))
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL XS(0:JM),XC(0:JM)
 *      REAL PX(2,0:JM,0:MM)
 *      REAL WY(0:JM,2),WX(0:JM,2)
 *      REAL R((MM+1)*(MM+1)),Z(JM,0:JM,4)
 */
/*
      SUBROUTINE SHMW2S(
          INTEGER MM
          INTEGER JM
          INTEGER ISW
          REAL (-JM:JM,-MM:MM) W
          REAL ((MM+1)*(MM+1)) o S
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t XS
          REAL (0:JM) t XC
          REAL (2,0:JM,0:MM) t PX
          REAL (0:JM,2) t WY
          REAL (0:JM,2) t WX
          REAL ((MM+1)*(MM+1)) t R
          REAL (JM,0:JM,4) t Z
      )
*/

/*****************************************************
 * math2/shtlib/shmsri.f
 ****************************************************/
/* 
 *      SUBROUTINE SHMSRI(MM,M,SR,SI)
 *      REAL SR(M:MM),SI(M:MM)
 */
/*
      SUBROUTINE SHMSRI(
          INTEGER MM
          INTEGER M
          REAL (M:MM) io SR
          REAL (M:MM) io SI
      )
*/

/*****************************************************
 * math2/shtlib/shlfwu.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLFWU(MM,JM,M,ISW,WM,SM,SD,XS,XC,PM,WY,WX,PX,R,Z)
 *      REAL SM(M:MM),WM(-JM:JM)
 *      REAL SD(0:MM+1)
 *      REAL XS(0:JM),XC(0:JM)
 *      REAL PM(0:MM+1,0:JM)
 *      REAL WY(0:JM,2),WX(0:JM,2)
 *      REAL PX(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1)),Z(JM,0:JM,4)
 */
/*
      SUBROUTINE SHLFWU(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (-JM:JM) WM
          REAL (M:MM) o SM
          REAL (0:MM+1) t SD
          REAL (0:JM) t XS
          REAL (0:JM) t XC
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM,2) t WY
          REAL (0:JM,2) t WX
          REAL (2,0:JM,0:MM) t PX
          REAL ((MM+1)*(MM+1)) t R
          REAL (JM,0:JM,4) t Z
      )
*/

/*****************************************************
 * math2/shtlib/shlfwm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLFWM(MM,JM,M,ISW,WM,SM,SD,XC,PM,WY,WX,R,Z)
 *      REAL SM(M:MM),WM(-JM:JM)
 *      REAL SD(0:MM+1)
 *      REAL XC(0:JM)
 *      REAL PM(0:MM+1,0:JM)
 *      REAL WY(0:JM,2),WX(0:JM,2)
 *      REAL R((MM+1)*(MM+1)),Z(JM,0:JM,4)
 */
/*
      SUBROUTINE SHLFWM(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (-JM:JM) WM
          REAL (M:MM) SM
          REAL (0:MM+1) o SD
          REAL (0:JM) t XC
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM,2) t WY
          REAL (0:JM,2) t WX
          REAL ((MM+1)*(MM+1)) t R
          REAL (JM,0:JM,4) t Z
      )
*/

/*****************************************************
 * math2/shtlib/shlfwl.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLFWL(MM,JM,N,M,WX,SD,PM)
 *      REAL WX(0:JM,2)
 *      REAL SD,PM(0:MM+1,0:JM)
 */
/*
      SUBROUTINE SHLFWL(
          INTEGER MM
          INTEGER JM
          INTEGER N
          INTEGER M
          REAL (0:JM,2) WX
          REAL o SD
          REAL (0:MM+1,0:JM) PM
      )
*/

/*****************************************************
 * math2/shtlib/shly2x.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLY2X(JM,M,ISW,WM,WX,WY,Z)
 *      REAL WM(-JM:JM)
 *      REAL WY(0:JM,2),WX(0:JM,2)
 *      REAL Z(JM,0:JM,4)
 */
/*
      SUBROUTINE SHLY2X(
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (-JM:JM) WM
          REAL (0:JM,2) o WX
          REAL (0:JM,2) o WY
          REAL (JM,0:JM,4) Z
      )
*/

/*****************************************************
 * math2/shtlib/shlbwu.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLBWU(MM,JM,M,ISW,SM,WM,SD,PM,YS,YC,PY,R)
 *      REAL SM(M:MM)
 *      REAL WM(-JM:JM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM)
 *      REAL PY(2,0:JM,0:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHLBWU(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (M:MM) SM
          REAL (-JM:JM) o WM
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shlbwm.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLBWM(MM,JM,M,ISW,SM,WM,SD,PM,YC,R)
 *      REAL SM(M:MM)
 *      REAL WM(-JM:JM)
 *      REAL SD(0:MM+1),PM(0:MM+1,0:JM)
 *      REAL YC(0:JM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHLBWM(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER ISW
          REAL (M:MM) SM
          REAL (-JM:JM) o WM
          REAL (0:MM+1) t SD
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YC
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shlbwj.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLBWJ(MM,JM,M,J,ISW,SM,WMJ,SD,PMJ,YC,R)
 *      REAL SM(M:MM),WMJ
 *      REAL SD(0:MM+1),PMJ(0:MM+1)
 *      REAL YC(0:JM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHLBWJ(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER J
          INTEGER ISW
          REAL (M:MM) SM
          REAL o WMJ
          REAL (0:MM+1) t SD
          REAL (0:MM+1) t PMJ
          REAL (0:JM) t YC
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shlbwl.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLBWL(MM,M,SD,WS,WA,PMJ)
 *      REAL SD(0:MM+1)
 *      REAL WS,WA
 *      REAL PMJ(0:MM+1)
 */
/*
      SUBROUTINE SHLBWL(
          INTEGER MM
          INTEGER M
          REAL (0:MM+1) SD
          REAL o WS
          REAL o WA
          REAL (0:MM+1) PMJ
      )
*/

/*****************************************************
 * math2/shtlib/shlssd.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLSSD(MM,M,ISW,SM,SD,R)
 *      REAL SM(M:MM)
 *      REAL SD(0:MM+1)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHLSSD(
          INTEGER MM
          INTEGER M
          INTEGER ISW
          REAL (M:MM) SM
          REAL (0:MM+1) o SD
          REAL ((MM+1)*(MM+1)) R
      )
*/

/*****************************************************
 * math2/shtlib/shlsds.f
 ****************************************************/
/* 
 *      SUBROUTINE SHLSDS(MM,M,ISW,SD,SM,R)
 *      REAL SD(0:MM+1)
 *      REAL SM(M:MM)
 *      REAL R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHLSDS(
          INTEGER MM
          INTEGER M
          INTEGER ISW
          REAL (0:MM+1) SD
          REAL (M:MM) o SM
          REAL ((MM+1)*(MM+1)) R
      )
*/

/*****************************************************
 * math2/shtlib/shpfun.f
 ****************************************************/
/* 
 *      SUBROUTINE SHPFUN(MM,JM,M,FUN,PM,YS,YC,PY,R)
 *      REAL FUN(-JM:JM,M:MM)
 *      REAL PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),YC(0:JM),PY(2,0:JM,0:MM),R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHPFUN(
          INTEGER MM
          INTEGER JM
          INTEGER M
          REAL (-JM:JM,M:MM) o FUN
          REAL (0:MM+1,0:JM) t PM
          REAL (0:JM) t YS
          REAL (0:JM) t YC
          REAL (2,0:JM,0:MM) t PY
          REAL ((MM+1)*(MM+1)) t R
      )
*/

/*****************************************************
 * math2/shtlib/shppma.f
 ****************************************************/
/* 
 *      SUBROUTINE SHPPMA(MM,JM,M,PM,YS,PY,R)
 *      REAL PM(0:MM+1,0:JM)
 *      REAL YS(0:JM),PY(2,0:JM,0:MM),R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHPPMA(
          INTEGER MM
          INTEGER JM
          INTEGER M
          REAL (0:MM+1,0:JM) io PM
          REAL (0:JM) YS
          REAL (2,0:JM,0:MM) PY
          REAL ((MM+1)*(MM+1)) R
      )
*/

/*****************************************************
 * math2/shtlib/shppmj.f
 ****************************************************/
/* 
 *      SUBROUTINE SHPPMJ(MM,JM,M,J,PMJ,YS,PY,R)
 *      REAL PMJ(0:MM+1)
 *      REAL YS(0:JM),PY(2,0:JM,0:MM),R((MM+1)*(MM+1))
 */
/*
      SUBROUTINE SHPPMJ(
          INTEGER MM
          INTEGER JM
          INTEGER M
          INTEGER J
          REAL (0:MM+1) io PMJ
          REAL (0:JM) YS
          REAL (2,0:JM,0:MM) PY
          REAL ((MM+1)*(MM+1)) R
      )
*/

