
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libnc-dods, A C++ implementation of netCDF 3 which
// supports reading from local files and OPeNDAP servers.

// Copyright (c) 2004 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

#ifndef client_params_h
#define client_params_h

#include <string>
#include <map>

#include "Error.h"
#include "InternalErr.h"

using namespace std;

class ClientParams{
private:
    string d_url;
    bool d_preload;
    int d_default_limit;
    map<string,int> d_limits;
    
    // Make these private to suppres their use outside the class
    ClientParams() {
        throw InternalErr(__FILE__, __LINE__, "Unimplemented method.");
    }

    ClientParams(const ClientParams &rhs) {
        throw InternalErr(__FILE__, __LINE__, "Unimplemented method.");
    }

    ClientParams &operator=(const ClientParams &rhs) {
        throw InternalErr(__FILE__, __LINE__, "Unimplemented method.");
    }

    friend class NCConnect;

public:

    ClientParams(const string &url) throw(Error);
	virtual ~ClientParams() {}
  
    /** Get the value of the \c preload parameter. */
    bool get_preload() const {
        return d_preload;
    }
    
    /// Get the value of \c limit.
    int get_limit(const string &var_name) const;
    
    /** Get the default value of \c limit. If the \c limit parameter was not 
        included with the URL, return 0. This indicates that DAP String variables
        should use a default size of 255 characters and Sequences should use a
        default size of one instance. */
    int get_default_limit() const {
        return d_default_limit;
    }
    
    /// Get the URL without the client-side parameters.
    string url_without_params() const;
};

// $Log: ClientParams.h,v $
// Revision 1.3  2005/02/17 23:44:13  jimg
// Modifications for processing of command line projections combined
// with the limit stuff and projection info passed in from the API. I also
// consolodated some of the code by moving d_source from various
// classes to NCAccess. This may it so that DODvario() could be simplified
// as could build_constraint() and store_projection() in NCArray.
//
// Revision 1.2  2004/10/28 16:38:19  jimg
// Added support for error handling to ClientParams. Added use of
// ClientParams to NCConnect, although that's not complete yet. NCConnect
// now has an instance of ClientParams. The instance is first built and
// then passed into NCConnect's ctor which stores a const reference to the CP
// object.
//
// Revision 1.1  2004/10/27 19:28:22  jimg
// Added
//

#endif // client_params_h
