require "rbconfig"
require "ftools"
require "getopts"
include Config

package = "gave"

default_bindir = "/usr/local/bin"
default_sitelibdir = CONFIG["sitelibdir"]+"/numru"
default_localedir = "/usr/share/locale"


def usage()
  print "Usage: ruby #$0 [-h|--help] [--bindir=] [--sitelibdir=] [--localedir=]\n"
  exit 1
end

if !getopts("h","help",
                "bindir:#{default_bindir}",
                "sitelibdir:#{default_sitelibdir}",
                "localedir:#{default_localedir}")
   usage()
end

if $OPT_h || $OPT_help
   usage()
end

bindir = $OPT_bindir
sitelibdir = $OPT_sitelibdir
localedir = $OPT_localedir

if localedir[-1]=="/"
  localedir = localedir[0..-2]
end

subdir = sitelibdir+"/"+package

bin_file = [package]
sub_files = %w(draw.rb fileselection.rb fileselection.glade)
locale = %w(ja)

if localedir!=default_localedir
  File.rename(package,"#{package}.org")
  begin
    f = File.open(package,"w")
    File.foreach("#{package}.org"){|l|
      if l =~ /^(\s*gettext_path = )"[^"]*"$/
        l = "#$1\"#{localedir}\"\n"
      end
      f.print l
    }
  ensure
    f.close if defined?(f)
  end
  File.chmod(0755, package)
end


File.makedirs(bindir)
bin_file.each{|f|
  File.install(f,bindir)
}

File.makedirs(subdir)
sub_files.each{|f|
  File.install(f,subdir)
}

locale.each{|l|
  message_dir = "#{localedir}/#{l}/LC_MESSAGES/"
  File.makedirs(message_dir)
  File.install("po/#{l}.mo","#{message_dir}#{package}.mo")
}


