!= ʸؤѴ
!= Convert date into a string
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccaldatetochar.f90,v 1.5 2009-10-18 02:34:48 morikawa Exp $
! Tag Name::  $Name: gtool5-20100705 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

function DCCalDateToChar1( year, month, day, hour, min, sec, zone ) &
  & result(result)
  !
  ! ǯʬäʸѿ (gtool4 netCDF 5.5 פ˽) 
  ! Ѵ֤ޤ.
  !
  ! Convert year, month, day, hour, minute, second into a string
  ! (conformed to gtool4 netCDF Convention
  ! "5.5 Expression of date and time"). 
  !
  use dc_types, only: STRING, TOKEN, DP
  use dc_string, only: toChar, CPrintf, StoA, RoundNum
  use dc_message, only: MessageNotify
  implicit none
  character(STRING):: result
                              ! ɽʸ. 
                              ! ɽˤĤƤ gtool4 netCDF 
                              ! 5.5 򻲾ȤΤ. 
                              ! 
                              ! Strings that express date and time. 
                              ! See gtool4 netCDF Convention 
                              ! 5.5 Expression of date and time for details. 
  integer, intent(in):: year                     ! ǯ. Year.  
  integer, intent(in):: month                    ! . Month. 
  integer, intent(in):: day                      ! . Day. 
  integer, intent(in):: hour                     ! . Hour. 
  integer, intent(in):: min                      ! ʬ. Minute. 
  real(DP), intent(in):: sec                     ! . Sec. 
  character(*), intent(in), optional:: zone      ! UTC λ. Time-zone. 
  integer:: csec_len
  character(TOKEN):: csec, zonew
continue

  if ( present(zone) ) then
    zonew = zone
  else
    zonew = ''
  end if

  csec = toChar(sec)
  csec = RoundNum( csec )
  if ( trim(csec) == '-0.' ) csec = '0.'
  do while ( index('123456789.', csec(len_trim(csec):len_trim(csec)) ) == 0 )
    if ( len_trim(csec) < 2 ) exit
    csec = csec(1:len_trim(csec)-1)
  end do
  if (int(sec) > -1 .and. int(sec) < 10)  csec = '0' // csec
  csec_len = len(trim(adjustl(csec)))
  if (csec(csec_len:csec_len) == '.') csec = csec(1:csec_len-1)

  result = CPrintf('%04d-%02d-%02dT%02d:%02d:%c%c', &
    & i=(/year, month, day, hour, min/), &
    & c1=trim(csec), c2=trim(zonew))

end function DCCalDateToChar1
