!= gtool_historyauto Υƥȥץ
!= Test program of "gtool_historyauto"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: histauto.f90,v 1.1.1.1 2008-09-23 09:56:38 morikawa Exp $
! Tag Name::  $Name: gtool5-20080923-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved. 
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program histauto
  use dc_trace, only: SetDebug
  use dc_types, only: DP, STDERR
  use dc_test, only: AssertEqual
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: DCDiffTimeCreate, operator(+), EvalSec
  use gtool_historyauto, only: HistoryAutoCreate, &
    & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
    & HistoryAutoClose, HistoryAutoPut, HistoryAutoAllVarFix, &
    & HistoryAutoAddVariable
  implicit none

  integer:: i, j
  logical:: err
!  real, allocatable:: u(:,:,:)
  real(DP):: secd
  character(*), parameter:: source = 'histauto.f90'
  character(*), parameter:: institution = 'gtool4 project'
  type(DC_DIFFTIME):: time1, deltime1, endtime1, inttime1
  
continue

  call SetDebug

!  goto 1100

100 continue
  ! ܥƥ
  ! Basic test
  !
  call HistoryAutoCreate( &
    &       title = 'Test01 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /) )  ! (in)

  call DCDiffTimeCreate( time1, & ! (out)
    & sec = 0.0_DP )              ! (in)
  call DCDiffTimeCreate( deltime1, & ! (out)
    & sec = 1.0_DP )                 ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), 'u', 'm s-1', & ! (in)
    & file = 'xhistauto/test01-u.nc' )         ! (in) optional

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'z   ', 'time'/), 'v', 'm s-1', & ! (in)
    & file = 'xhistauto/test01-v.nc', &                ! (in) optional
    & time_average = .true., xtype = 'double' )        ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w1', (/'y   ', 'z   '/), 'w1', 'm s-1', &         ! (in)
    & file = 'xhistauto/test01-w.nc' )                   ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w2', (/'time', 'y   ', 'z   '/), 'w2', 'm s-1', & ! (in)
    & file = 'xhistauto/test01-w.nc' )                   ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 10
    call HistoryAutoPut( time1, 'u', (/ 1.0, 2.0 /) * i )
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j), j = 1, 12 ) /) * i, (/ 3,4 /) ) )
    call HistoryAutoPut( time1, 'w1', &
      &    reshape( (/ ( real(j), j = 1, 12 ) /) * i, (/ 3,4 /) ) )
    call HistoryAutoPut( time1, 'w2', &
      &    reshape( (/ ( real(j), j = 1, 12 ) /) * i, (/ 3,4 /) ) )
    time1 = time1 + deltime1
  end do

  call HistoryAutoPut( time1, 'w', (/ 1.0, 2.0 /), err = err )
  call AssertEqual( 'HistoryAutoPut error handling test 1-1', &
    & answer = .true., check = err )

  call HistoryAutoClose


200 continue
  ! ϥߥ󥰼ưåƥ
  ! Output timing automatically checking test
  !
  call HistoryAutoCreate( &
    &       title = 'Test02 for gtool_historyauto', &     ! (in)
    &      source = source, &                             ! (in)
    & institution = institution, &                        ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'min'  /), & ! (in)
    &  file_prefix = 'xhistauto/test02-', &               ! (in) optional
    &       origin = 0.5, &                               ! (in) optional
    &     interval = 1.0 )                                ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 30.0_DP )                 ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 10.0_DP )                 ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), 'u', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'z   ', 'time'/), 'v', 'm s-1', & ! (in)
    & time_average = .true., xtype = 'double' )        ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 19
!    write(*,*) i, (i - 1) * 10 + 30, ((i - 1) * 10 + 30) / 60.0
    call HistoryAutoPut( time1, 'u', (/ 1.0, 2.0 /) * i )
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j), j = 1, 12 ) /) * i, (/ 3,4 /) ) )
!    write(*,*) '---------------'
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose

300 continue
  ! ɸǡ, ɸŤ, °ƥ
  ! Axes data, axes weights, attributes settings test
  !
  call HistoryAutoCreate( &
    &       title = 'Test03 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm   ', 'm   ', 'deg.', 'sec ' /), & ! (in)
    &    xtypes = (/ 'double' /), &                       ! (in) optional
    &  file_prefix = 'xhistauto/test03-' )                ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -2.0, 0.0, 3.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 1.5, 2.5, 3.5 /) )  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'z', array = (/ 0.0, 20.0, 50.0, 90.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'z', &                                   ! (in)
    & weight = (/ 10.0, 25.0, 45.0, 20.0 /) * 2.0, & ! (in)
    & units = 'deg.*2' , xtype = 'double' )          ! (in) optional

  call HistoryAutoAddAttr( &
    & varname = 'x', attrname = 'test_attr', &   ! (in)
    & value = 'test_attr_value' )                ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'y   ', 'z   ', 'time'/), 'u', 'm s-1' ) ! (in)

  call HistoryAutoAllVarFix

  do i = 1, 3
    call HistoryAutoPut( time1, 'u', &
      & reshape( (/ ( real(j), j = 1, 24 ) /) * i, (/ 2, 3, 4 /) ) )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose

400 continue
  ! NAMELIST Ѥ, ƥ 1
  ! Output settings test 1 with NAMELIST
  !
  call DCDiffTimeCreate( time1, &     ! (out)
    & min = 1 )                       ! (in)
  call DCDiffTimeCreate( endtime1, &  ! (out)
    & hour = -1 )                     ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 30.0_DP )                 ! (in)
  call DCDiffTimeCreate( inttime1, &  ! (out)
    & hour = 1 )                      ! (in)

  call HistoryAutoCreate( &
    &       title = 'Test04 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'hrs'  /), & ! (in)
    & namelist_filename = 'histauto_nml04.nml', &         ! (in) optional
    &     interval = inttime1, &                          ! (in) optional
    &       origin = time1, &                             ! (in) optional
    &     terminus = endtime1 )                           ! (in) optional

  call HistoryAutoAddVariable( &
    & 'u1', (/'x   ', 'time'/), 'u1', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'u2', (/'y   ', 'time'/), 'u2', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'u3', (/'z   ', 'time'/), 'u3', 'm s-1' ) ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), 'v', 'm s-1', & ! (in)
    & time_average = .true. )                  ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), 'z', 'm s-1', & ! (in)
    & xtype = 'double' )                       ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 41
    call HistoryAutoPut( time1, 'u1', (/ ( real(j), j = 1, 2 ) /) * i )
    call HistoryAutoPut( time1, 'u2', (/ ( real(j), j = 1, 3 ) /) * i )
    call HistoryAutoPut( time1, 'u3', (/ ( real(j), j = 1, 4 ) /) * i )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) * i )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) * i )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


500 continue
  ! ڤФƥ 1 (NAMELIST Ѥ)
  ! Slices of spaces test 1 (without NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test05 for gtool_historyauto', & ! (in)
    &      source = source, &                         ! (in)
    & institution = institution, &                    ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 4, 6, 8, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /), & ! (in)
    &  file_prefix = 'xhistauto/test05-', &               ! (in) optional
    & slice_start  = (/  1,  1, 3 /), &                   ! (in) optional
    & slice_end    = (/ -1, -1, 6 /), &                   ! (in) optional
    & slice_stride = (/  1,  2, 1 /) )                    ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -10.0, -2.0, 0.0, 3.0, 6.0, 10.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 4.0, 5.0, 2.5, 3.0, 3.5, 2.0 /) )  ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'x   ', 'y   ', 'time'/), 'v', 'm s-1', & ! (in)
    & time_average = .true. )                          ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'y   ', 'z   ', 'time'/), 'z', 'm s-1', & ! (in)
    & xtype = 'double' )                               ! (in) optional

  call HistoryAutoAddVariable( &
    & 'ns', (/'x   ', 'y   ', 'z   ', 'time'/), & ! (in)
    & 'no slice', 'm s-1', &                      ! (in)
    & slice_start  = (/  1,  1,  1 /), &          ! (in) optional
    & slice_end    = (/ -1, -1, -1 /), &          ! (in) optional
    & slice_stride = (/  1,  1,  1 /) )           ! (in) optional

! 顼å
!
!  call HistoryAutoAddVariable( &
!    & 'u1', (/'x   ', 'time'/), 'u1', 'm s-1', &  ! (in)
!    & file = 'xhistauto/test05-u.nc', &           ! (in) optional
!    & slice_start  = (/  1,  2,  1 /) )           ! (in) optional
!
!  call HistoryAutoAddVariable( &
!    & 'u2', (/'x   ', 'time'/), 'u1', 'm s-1', &  ! (in)
!    & file = 'xhistauto/test05-u.nc', &           ! (in) optional
!    & slice_start  = (/  1,  1,  2 /) )           ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 3
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j), j = 1, 24 ) /) + 100 * i, (/ 4, 6 /) ) )
    call HistoryAutoPut( time1, 'w', &
      &    reshape( (/ ( real(j), j = 1, 48 ) /) + 100 * i, (/ 6, 8 /) ) )
    call HistoryAutoPut( time1, 'ns', &
      &    reshape( (/ ( real(j), j = 1, 192 ) /) + 1000 * i, (/ 4, 6, 8 /) ) )

! 顼å
!
!    call HistoryAutoPut( time1, 'u1', (/ ( real(j), j = 1, 4 ) /) * i )
!    call HistoryAutoPut( time1, 'u2', (/ ( real(j), j = 1, 6 ) /) * i )

    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


600 continue
  ! ڤФƥ 2 (NAMELIST )
  ! Slices of spaces test 2 (with NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test06 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 4, 6, 8, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /), & ! (in)
    &  file_prefix = 'xhistauto/test06-', &               ! (in) optional
    & namelist_filename = 'histauto_nml06.nml' )          ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -10.0, -2.0, 0.0, 3.0, 6.0, 10.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 4.0, 5.0, 2.5, 3.0, 3.5, 2.0 /) )  ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'x   ', 'y   ', 'time'/), 'v', 'm s-1' )  ! (in)

  call HistoryAutoAddVariable( &
    & 'w', (/'y   ', 'z   ', 'time'/), 'z', 'm s-1' )  ! (in)

  call HistoryAutoAddVariable( &
    & 'ns', (/'x   ', 'y   ', 'z   ', 'time'/), & ! (in)
    & 'no slice', 'm s-1' )                       ! (in)

  call HistoryAutoAllVarFix

  do i = 1, 3
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j), j = 1, 24 ) /) + 100 * i, (/ 4, 6, 1 /) ) )
    call HistoryAutoPut( time1, 'w', &
      &    reshape( (/ ( real(j), j = 1, 48 ) /) + 100 * i, (/ 6, 8 /) ) )
    call HistoryAutoPut( time1, 'ns', &
      &    reshape( (/ ( real(j), j = 1, 192 ) /) + 1000 * i, (/ 4, 6, 8 /) ) )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


700 continue
  ! ʿѥƥ 1 (NAMELIST ʤ)
  ! Average of spaces test 1 (without NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test07 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 4, 6, 8, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /), & ! (in)
    &  file_prefix = 'xhistauto/test07-', &               ! (in) optional
    & space_average = (/ .false., .false., .false. /) )   ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -8.0, -4.0, 0.0, 4.0, 6.0, 8.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 5.0,  4.0, 4.0, 3.0, 2.0, 2.0 /) )  ! (in)

  call HistoryAutoAddVariable( &
    & 'u1', (/'x   ', 'time'/), &       ! (in)
    & 'u1', 'm s-1', &                  ! (in)
    & file = 'xhistauto/test07-u.nc', & ! (in) optional
    & space_average = (/ .true. /) )    ! (in) optional

  call HistoryAutoAddVariable( &
    & 'u2', (/'y   ', 'time'/), &              ! (in)
    & 'u2', 'm s-1', &                         ! (in)
    & file = 'xhistauto/test07-u.nc', &        ! (in) optional
    & space_average = (/ .false., .true. /) )  ! (in) optional

  call HistoryAutoAddVariable( &
    & 'v', (/'x   ', 'y   ', 'z   ', 'time'/), &     ! (in)
    & 'v', 'm s-1', &                                ! (in)
    & space_average = (/ .true., .true., .true. /) ) ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w1', (/'x   ', 'y   ', 'z   ', 'time'/), &    ! (in)
    & 'w1', 'm s-1', &                               ! (in)
    & file = 'xhistauto/test07-w.nc', &              ! (in) optional
    & slice_start  = (/  1,  1, 3 /), &              ! (in) optional
    & slice_end    = (/ -1, -1, 6 /), &              ! (in) optional
    & slice_stride = (/  2,  1, 1 /), &              ! (in) optional
    & space_average = (/ .true., .true., .true. /) ) ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w2', (/'x   ', 'y   ', 'z   ', 'time'/), &    ! (in)
    & 'w2', 'm s-1', &                               ! (in)
    & file = 'xhistauto/test07-w.nc', &              ! (in) optional
    & slice_start  = (/  1,  1, 3 /), &              ! (in) optional
    & slice_end    = (/ -1, -1, 6 /), &              ! (in) optional
    & slice_stride = (/  2,  1, 1 /) )               ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 3
    call HistoryAutoPut( time1, 'u1', (/ ( real(j), j = 1, 4 ) /) * 2 + 100 * i )
    call HistoryAutoPut( time1, 'u2', (/ 2.0, 3.0, 4.0, 6.0, 7.0, 15.0 /) + 100 * i )
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )
    call HistoryAutoPut( time1, 'w1', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )
    call HistoryAutoPut( time1, 'w2', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )

    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


800 continue
  ! ʿѥƥ 2 (NAMELIST )
  ! Average of spaces test 2 (with NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test08 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 4, 6, 8, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'sec'  /), & ! (in)
    &  file_prefix = 'xhistauto/test08-', &               ! (in) optional
    & namelist_filename = 'histauto_nml08.nml' )          ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoPutAxis( &
    & dim = 'y', array = (/ -8.0, -4.0, 0.0, 4.0, 6.0, 8.0 /) )  ! (in)

  call HistoryAutoAddWeight( &
    & dim = 'y', weight = (/ 5.0,  4.0, 4.0, 3.0, 2.0, 2.0 /) )  ! (in)

  call HistoryAutoAddVariable( &
    & 'u1', (/'x   ', 'time'/), &       ! (in)
    & 'u1', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'u2', (/'y   ', 'time'/), &       ! (in)
    & 'u2', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'x   ', 'y   ', 'z   ', 'time'/), &     ! (in)
    & 'v', 'm s-1' )                                 ! (in)

  call HistoryAutoAddVariable( &
    & 'w1', (/'x   ', 'y   ', 'z   ', 'time'/), &    ! (in)
    & 'w1', 'm s-1' )                                ! (in)

  call HistoryAutoAddVariable( &
    & 'w2', (/'x   ', 'y   ', 'z   ', 'time'/), &    ! (in)
    & 'w2', 'm s-1' )                                ! (in)

  call HistoryAutoAllVarFix

  do i = 1, 3
    call HistoryAutoPut( time1, 'u1', (/ ( real(j), j = 1, 4 ) /) * 2 + 100 * i )
    call HistoryAutoPut( time1, 'u2', (/ 2.0, 3.0, 4.0, 6.0, 7.0, 15.0 /) + 100 * i )
    call HistoryAutoPut( time1, 'v', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )
    call HistoryAutoPut( time1, 'w1', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )
    call HistoryAutoPut( time1, 'w2', &
      &    reshape( (/ ( real(j * 10), j = 1, 192 ) /) + 10000 * i, (/ 4, 6, 8 /) ) )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


900 continue
  ! ϳ, λƥ 1 (NAMELIST ʤ)
  ! Start and stop of output timing setting test 1 (without NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test09 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'min'  /), & ! (in)
    &  file_prefix = 'xhistauto/test09-', &               ! (in) optional
    &     interval =  2.0, &                              ! (in) optional
    &       origin =  5.0,   terminus = 10.0 )            ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & min = 1 )                       ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 30.0_DP )                 ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), &       ! (in)
    & 'v', 'm s-1', &                  ! (in)
    & time_average = .true., &         ! (in) optional
    & terminus = 15.0 )                ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), &       ! (in)
    & 'w', 'm s-1', &                  ! (in)
    & origin = -1.0, terminus = -1.0 ) ! (in) optional

! 顼å
!
!  call HistoryAutoAddVariable( &
!    & 'err1', (/'x   ', 'time'/), 'err1', 'm s-1', &  ! (in)
!    & file = 'xhistauto/test09-err.nc', &             ! (in) optional
!    & origin = 2.0, terminus = 10.0 )                 ! (in) optional
!
!  call HistoryAutoAddVariable( &
!    & 'err2', (/'x   ', 'time'/), 'err2', 'm s-1', &  ! (in)
!    & file = 'xhistauto/test09-err.nc', &             ! (in) optional
!    & origin = 2.0, terminus = 9.0 )                  ! (in) optional

  call HistoryAutoAllVarFix

  do i = 1, 30
    call HistoryAutoPut( time1, 'u', (/ ( real(j), j = 1, 2 ) /) + 5 * ( i + 1 ) )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) + 50 * ( i + 1 ) )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) + 5 * ( i + 1 ) )

! 顼å
!
!    call HistoryAutoPut( time1, 'err1', (/ ( real(j), j = 1, 2 ) /) + 5 * ( i + 1 ) )
!    call HistoryAutoPut( time1, 'err2', (/ ( real(j), j = 1, 2 ) /) + 5 * ( i + 1 ) )

    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


1000 continue
  ! ϳ, λƥ 2 (NAMELIST )
  ! Start and stop of output timing setting test 2 (with NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test10 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'hrs'  /), & ! (in)
    &  file_prefix = 'xhistauto/test10-', &               ! (in) optional
    & namelist_filename = 'histauto_nml10.nml' )          ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & min = 1 )                       ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 30.0_DP )                 ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), &       ! (in)
    & 'v', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), &       ! (in)
    & 'w', 'm s-1' )                   ! (in)

  call HistoryAutoAllVarFix

  do i = 1, 30
    call HistoryAutoPut( time1, 'u', (/ ( real(j), j = 1, 2 ) /) + 5 * ( i + 1 ) )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) + 50 * ( i + 1 ) )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) + 5 * ( i + 1 ) )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


1100 continue
  ! եʬϥƥ 1 (NAMELIST ʤ)
  ! Separately output file test 1 (without NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test11 for gtool_historyauto', & ! (in)
    &      source = source, &                         ! (in)
    & institution = institution, &                    ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'day'  /), & ! (in)
    &  file_prefix = 'xhistauto/test11-', &               ! (in) optional
    &     interval =  0.25, &                             ! (in) optional
    & newfile_interval = 1 )                              ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & hour = 1 )                      ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                   ! (in)

  !
  ! ʬ䤵줿եκǽΥǡ, ʿͤˤʤʤ. 
  ! (ХȸХХ, Ȥꤢ 2008/07/26 morikawa)
  !
  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), &       ! (in)
    & 'v', 'm s-1', &                  ! (in)
    & time_average = .true., &         ! (in) optional
    & interval = 0.5, &                ! (in) optional
    & origin = 1.5, terminus = 3.5 )   ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), &       ! (in)
    & 'w', 'm s-1', &                  ! (in)
    & interval = 0.5, &                ! (in) optional
    & origin = 1.5, terminus = 3.5 )   ! (in) optional

!
! 顼å
!
!  call HistoryAutoAddVariable( &
!    & 'err', (/'z   ', 'time'/), &       ! (in)
!    & 'err', 'm s-1', &                  ! (in)
!    & newfile_interval = 1, &            ! (in) optional
!    & time_units = 'min' )               ! (in) optional
!
!  call HistoryAutoAddVariable( &
!    & 'err2', (/'z   ', 'time'/), &       ! (in)
!    & 'err2', 'm s-1', &                  ! (in)
!    & file = 'xhistauto/test11-err.nc' )  ! (in) optional
!
!  call HistoryAutoAddVariable( &
!    & 'err3', (/'z   ', 'time'/), &       ! (in)
!    & 'err3', 'm s-1', &                  ! (in)
!    & file = 'xhistauto/test11-err.nc' ) ! (in) optional

  call HistoryAutoAllVarFix

  do i = 0, 100
    call HistoryAutoPut( time1, 'u', (/ ( real(j), j = 1, 2 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) + 100 * i )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose



1200 continue
  ! եʬϥƥ 2 (NAMELIST )
  ! Separately output file test 2 (with NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test12 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'day'  /), & ! (in)
    &  file_prefix = 'xhistauto/test12-', &               ! (in) optional
    & namelist_filename = 'histauto_nml12.nml' )          ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & day = 0 )                       ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & day = 1 )                       ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), &       ! (in)
    & 'v', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), &       ! (in)
    & 'w', 'm s-1' )                   ! (in)

  call HistoryAutoAllVarFix

  do i = 0, 100
    call HistoryAutoPut( time1, 'u', (/ ( real(j), j = 1, 2 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) + 100 * i )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


1300 continue
  ! 󥯤̾Τե̾ȿǤƥ1 (NAMELIST ʤ)
  ! Reflect of rank name to file name test 1 (with NAMELIST)
  !
  call HistoryAutoCreate( &
    &       title = 'Test13 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 0 /), &                     ! (in)
    & longnames = (/ 'x   ', 'y   ', 'z   ', 'time' /), & ! (in)
    &     units = (/ 'm  ',  'm  ',  'm  ',  'min'  /), & ! (in)
    &  file_prefix = 'xhistauto/test13-', &               ! (in) optional
    &     interval = 10.0, &                              ! (in) optional
    &         rank = '01' )                               ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & min = 0 )                       ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & min = 10 )                      ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'x   ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                   ! (in)

  call HistoryAutoAddVariable( &
    & 'v', (/'y   ', 'time'/), &       ! (in)
    & 'v', 'm s-1', &                  ! (in)
    & file = 'xhistauto/test13-v.nc' ) ! (in) optional

  call HistoryAutoAddVariable( &
    & 'w', (/'z   ', 'time'/), &       ! (in)
    & 'w', 'm s-1', &                  ! (in)
    & newfile_interval = 100 )         ! (in) optional

  call HistoryAutoAllVarFix

  do i = 0, 30
    call HistoryAutoPut( time1, 'u', (/ ( real(j), j = 1, 2 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'v', (/ ( real(j), j = 1, 3 ) /) + 100 * i )
    call HistoryAutoPut( time1, 'w', (/ ( real(j), j = 1, 4 ) /) + 100 * i )
    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


1400 continue
  ! 7 ˰¸ѿνϥƥ
  ! Output of variables depended on 7 dimensions test
  !
  call HistoryAutoCreate( &
    &       title = 'Test14 for gtool_historyauto', & ! (in)
    &      source = source, &                       ! (in)
    & institution = institution, &                  ! (in)
    &      dims = (/ 'd1  ', 'd2  ', 'd3  ', 'd4  ', 'd5  ', &
    &                'd6  ', 'd7  ', 'd8  ', 'd9  ', 'time' /), & ! (in)
    &  dimsizes = (/ 2, 3, 4, 3, 2, 3, 4, 3, 2, 0 /), &   ! (in)
    & longnames = (/ 'd1  ', 'd2  ', 'd3  ', 'd4  ', 'd5  ', &
    &                'd6  ', 'd7  ', 'd8  ', 'd9  ', 'time' /), & ! (in)
    &     units = (/ '1   ', '1   ', '1   ', '1   ', '1   ', &
    &                '1   ', '1   ', '1   ', '1   ', 'sec ' /), & ! (in)
    &  file_prefix = 'xhistauto/test14-' )                ! (in) optional

  call DCDiffTimeCreate( time1, &     ! (out)
    & sec = 0.0_DP )                  ! (in)
  call DCDiffTimeCreate( deltime1, &  ! (out)
    & sec = 1.0_DP )                  ! (in)

  call HistoryAutoAddVariable( &
    & 'u', (/'d1  ', 'd2  ', 'd3  ', 'd4  ', 'd5  ', &
    &        'd6  ', 'd7  ', 'time'/), &       ! (in)
    & 'u', 'm s-1' )                                   ! (in)

!
! 顼å
!
!  call HistoryAutoAddVariable( &
!    & 'v', (/'d1  ', 'd2  ', 'd3  ', 'd4  ', 'd5  ', &
!    &        'd6  ', 'd7  ', 'd8  ', 'time'/), &       ! (in)
!    & 'v', 'm s-1' )                                   ! (in)

  call HistoryAutoAddVariable( &
    & 'w', (/'d3  ', 'd4  ', 'd5  ', 'd6  ', 'd7  ', &
    &        'd8  ', 'd9  ', 'time'/), &             ! (in)
    & 'w', 'm s-1', &                                ! (in)
    & space_average = &
    &   (/ .false., .false., .true., .true., .false., .true., .true., .true. /) ) ! (in) optional
  call HistoryAutoAllVarFix

  do i = 0, 2
    call HistoryAutoPut( time1, 'u', &
      & reshape( (/ ( real(j), j = 1, 2*3*4*3*2*3*4 ) /), &
      &                            (/ 2,3,4,3,2,3,4 /)     ) + 10000 * i )
    call HistoryAutoPut( time1, 'w', &
      & reshape( (/ ( real(j)*10, j = 1, 4*3*2*3*4*3*2 ) /), &
      &                               (/ 4,3,2,3,4,3,2 /)     ) + 100000 * i )

!
! 顼å
!
!    call HistoryAutoPut( time1, 'v', &
!      & reshape( (/ ( real(j), j = 1, 2*3*4*3*2*3*4 ) /), &
!      &                            (/ 2,3,4,3,2,3,4 /)     ) + 10000 * i )

    time1 = time1 + deltime1
  end do

  call HistoryAutoClose


end program histauto
