!-------------------------------------------------
!  SLpack module
!-------------------------------------------------
module slpack
  use dcl_common
  interface DclSetFrameSize
    subroutine slsize(size)  !1t[̍Đݒ
      character(len=3), intent(in) :: size  !t[̑傫ƌ
    end subroutine

    subroutine slform(width,height)  !1t[̍Đݒ
      real,      intent(in) :: width       !t[̉,c̎, Pcm
      real,      intent(in) :: height
    end subroutine
  end interface

  contains
!-----------------------------------------------------------------------
!v[`

    subroutine DclDivideFrame(direction,x_num,y_num) !t[̕
      character(len=1), intent(in) :: direction  !w
      integer,   intent(in) :: x_num          !X, Y̕
      integer,   intent(in) :: y_num

      call prcopn('DclDivideFrame')
      call sldiv(direction,x_num,y_num)
      call prccls('DclDivideFrame')
    end subroutine

    subroutine DclSetFrameMargin(left, right, bottom, top)   !}[W̐ݒD 
      real,      intent(in) :: left, right, bottom, top

      call prcopn('DclSetFrameMargin')
      call slmgn(left, right, bottom, top)
      call prccls('DclSetFrameMargin')
    end subroutine

    subroutine DclSetAspectRatio(x,y)  !c̐ݒD   
      real, intent(in)           :: x  !t[̏c^
      real, intent(in), optional :: y  !t[̏c^

      call prcopn('DclSetAspectRatio')
      if(present(y)) then
        yy = y
      else
        yy = 1.
      end if

      call slrat(x,yy)
      call prccls('DclSetAspectRatio')
    end subroutine

    subroutine DclSetFrameTitle(title,side,x_position,y_position,height,num)
      character(len=*),  intent(in) :: title
      character(len=1),  intent(in) :: side
      real,              intent(in) :: x_position, y_position 
      real,              intent(in) :: height
      integer, optional, intent(in) :: num         !Ԗڂ̕񂩂w肷

      call prcopn('DclSetFrameTitle')
      if(present(num)) then
        nt = num
      else
        nt = 1
      end if
      call slsttl(title,side,x_position,y_position,height,nt) 
      call prccls('DclSetFrameTitle')
    end subroutine
!--------------------------------------------------------------------
!拫E
    subroutine DclDrawViewPortFrame(index)  !r[|[g̘g`D
      integer,   intent(in) :: index  !̃CCfNX 

      call sgoopn('DclDrawViewPortFrame', ' ')
      call slpvpr(index)
      call sgocls('DclDrawViewPortFrame')
    end subroutine

    subroutine DclDrawDeviceWindowFrame(index)  !EChE̘g`
      integer,   intent(in) :: index  !̃CCfNX 

      call sgoopn('DclDrawDeviceWindowFrame', ' ')
      call slpwwr(index)
      call sgocls('DclDrawDeviceWindowFrame')
    end subroutine

    subroutine DclDrawDeviceViewPortFrame(index)  !ő̘̈g`
      integer,   intent(in) :: index    !̃CCfNX 

      call sgoopn('DclDrawDeviceViewPortFrame', ' ')
      call slpwvr(index) 
      call sgocls('DclDrawDeviceViewPortFrame')
    end subroutine

    subroutine DclDrawViewPortCorner(index,size)  !r[|[g̃R[i[}[N`
      integer,   intent(in) :: index    !̃CCfNX 
      real,      intent(in) :: size    !R[i[}[N̒

      call sgoopn('DclDrawViewPortCorner', ' ')
      call slpvpc(index,size)
      call sgocls('DclDrawViewPortCorner')
    end subroutine                             

    subroutine DclDrawDeviceWindowCorner(index,size)  !EChẼR[i[}[N`
      integer,   intent(in) :: index    !̃CCfNX 
      real,      intent(in) :: size     !R[i[}[N̒

      call sgoopn('DclDrawDeviceWindowCorner', ' ')
      call slpwwc(index,size)
      call sgocls('DclDrawDeviceWindowCorner')
    end subroutine

    subroutine DclDrawDeviceViewPortCorner(index,size) 
      integer,   intent(in) :: index  !̃CCfNX 
      real,      intent(in) :: size    !R[i[}[N̒

      call sgoopn('DclDrawDeviceViewPortCorner', ' ')
      call slpwvc(index,size)
      call sgocls('DclDrawDeviceViewPortCorner')
    end subroutine

end module

