!c Description: 
!c   ʡؿ pi η׻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-12-12    ̰ϯ 
!c   1.1        2003-12-22    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_exner
  interface 

     subroutine exner(u, w, w_adv, w_byc, w_trb, div, pi)
       use gridset
       real(8), intent(in)      :: u(-bm:,-bm:)
       real(8), intent(in)      :: w(-bm:,-bm:)
       real(8), intent(in)      :: w_adv(-bm:,-bm:)
       real(8), intent(in)      :: w_byc(-bm:,-bm:)
       real(8), intent(in)      :: w_trb(-bm:,-bm:)
       real(8), intent(in)      :: div(-bm:,-bm:)
       real(8), intent(inout)   :: pi(-bm:,-bm:)
     end subroutine exner

  end interface
end module if_exner




subroutine exner(u, w, w_adv, w_byc, w_trb, div, pi)
  !--- ⥸塼ɤ߹
  use gridset
  use prm
  use physprm
  use integrt
  use basicenv
  use jacobian
  use if_heikin
  use if_bibun
  
  !--- ۤηػ
  implicit none
  
  !--- ѿ
  real(8), intent(in)      :: u(-bm:,-bm:)
  real(8), intent(in)      :: w(-bm:,-bm:)
  real(8), intent(in)      :: w_adv(-bm:,-bm:)
  real(8), intent(in)      :: w_byc(-bm:,-bm:)
  real(8), intent(in)      :: w_trb(-bm:,-bm:)
  real(8), intent(in)      :: div(-bm:,-bm:)
  real(8), intent(inout)   :: pi(-bm:,-bm:)
  
  !--- ѿ
  real(8), parameter    :: epsz = 0.0d0
  integer, parameter    :: isw = 1
  integer               :: i
  integer               :: is
  integer, allocatable  :: ip(:)
  real(8), allocatable  :: vw(:)
  integer               :: icon
  real(8), allocatable  :: f1(:)
  real(8), allocatable  :: f2(:)
  real(8), allocatable  :: f3(:)
  real(8), allocatable  :: f4(:)
  real(8), allocatable  :: f5(:)
  real(8), allocatable  :: f6(:)
  real(8), allocatable  :: c2_bs(:)
  real(8), allocatable  :: w_bz(:,:)
  real(8), allocatable  :: div_z(:,:)
  real(8), allocatable  :: pi_z(:,:)
  real(8), allocatable  :: f3_z(:)
  real(8), allocatable  :: f5_z(:)
  real(8), allocatable  :: u_x(:,:)
  real(8), allocatable  :: u_z(:,:)
  real(8), allocatable  :: A(:)
  real(8), allocatable  :: B(:)
  real(8), allocatable  :: C(:)
  real(8), allocatable  :: D(:)

  !--- γ
  allocate(ip(0:km-1), vw(0:km-1))

  allocate(f1(-bm:km+bm), f2(-bm:km+bm), f3(-bm:km+bm), &
       & f4(-bm:km+bm), f5(-bm:km+bm), f6(-bm:km+bm), &
       & c2_bs(-bm:km+bm))

  allocate(A(0:km-1), B(1:km-1), C(0:km-2), D(0:km-1))

  !--- ʬ黻
  call heikin(13, w, w_bz)
  call bibun(112, div, div_z)
  call bibun(112, pi, pi_z)
  call bibun(121, u, u_x)     
  call bibun(122, u, u_z)

  
  !--- i Ѳʤ׻
  do i = 0, im-1

     !--- 
     ip = 0; vw = 0.0d0; is = 0; icon = 0
     f1 = 0.0d0; f2 = 0.0d0; f3 = 0.0d0
     f4 = 0.0d0; f5 = 0.0d0; f6 = 0.0d0
     c2_bs = 0.0d0
     A = 0.0d0; B = 0.0d0; C = 0.0d0; D = 0.0d0; 
     
     !--- ®
     c2_bs(:) = cp * gasr * pi_bs(i,:) * vtheta_bs(i,:) / (cv * rho)
     
     !---  ( 1)
     f1(:) = c2_bs(:) * (dts ** 2.0d0) &
          & / (jcb(i,:) * cp * dens_bs(i,:) * (vtheta_bs(i,:) ** 2.0d0))
     
     !---  ( 2)
     f2(:) = cp * dens_bs(i,:) * (vtheta_bs(i,:) ** 2.0d0) / jcb(i,:)
     
     !---  ( 3)
     f3(:) = dens_bs(i,:) * vtheta_bs(i,:) * w_bz(i,:)
     
     !---  ( 4)
     f4(:) = c2_bs(:) * dts / (cp * vtheta_bs(i,:))
     
!     write(*,*) "f3", f3
!     write(*,*) "w_bz", w_bz(i,:)
!     write(*,*) "f4", f4
     
     
     !---  ( 5)
     f5(:) = &
          &   dens_bs(i,:) * vtheta_bs(i,:) &
          & * (  &
          &       w_bz(i,:) &
          &    - (cp * vtheta_bs(i,:) * dts / jcb(i,:)) &
          &       * (&
          &         - alpha * div_z(i,:) &
          &         + (1.0d0 - beta) * pi_z(i,:) &
          &         ) &
          &    - dts * (- w_adv(i,:) + w_byc(i,:) + w_trb(i,:))&
          &   )
     
     !---  ( 6)
     f6(:) = &
          & - beta * (f1(:) * cp) / dz &
          &    * (cp * (vtheta_bs(i,:)**2.0d0) / jcb(i,:)) &
          &    * (  &
          &         alpha * div_z(i,:) &
          &       - (1.0d0 - beta) * pi_z(i,:) &
          &       + (jcb(i,:) / (cp * vtheta_bs(i,:))) &
          &          * (- w_adv(i,:) + w_byc(i,:) + w_trb(i,:)) &
          &       )

     write(*,*) "f5", f5
     write(*,*) "f6", f6
     
     !--- ʬ
     call bibun(112, f3, f3_z)
     call bibun(112, f5, f5_z)


     
     !----------------------------------------------------------
     !
     !---------------------------------------------------------
     A(0) = &
          &   1.0d0 &
          & + (beta ** 2.0d0) * f1(0) * f2(0) / (dz ** 2.0d0)
     A(1:km-2) = &
          &   1.0d0 &
          & + (     &
          &       (beta ** 2.0d0) * f1(1:km-2) &
          &        * (f2(1:km-2) + f2(0:km-3))     &
          &    ) / (dz ** 2.0d0)
     A(km-1) = &
          &   1.0d0  &
          & + (beta ** 2.0d0) * f1(km-1) * f2(km-2) / (dz ** 2.0d0)
     write(*,*) "A", A
     
     !--- 򤯤ι: гʬ (B)
     B(1:km-1) = &
          & - (beta ** 2.0d0) * f1(1:km-1) * f2(1:km-1) / (dz ** 2.0d0)
     write(*,*) "B", B
     
     !--- 򤯤ι: гʬ (C)
     C(0:km-2) = &
          & - (beta ** 2.0d0) * f1(0:km-2) * f2(-1:km-3) / (dz ** 2.0d0)
!          & - (beta ** 2.0d0) * f1(1:km-1) * f2(0:km-2) / (dz ** 2.0d0)
     write(*,*) "C", C
     
     !--- 
     D(0:km-1) = &
          &   pi(i,0:km-1) &
          & - (1.0d0 - beta) * (f1(0:km-1) / dts) * f3_z(0:km-1) &
          & - f4 * (u_x(i,0:km-1) + g13_bxbz(i,0:km-1) * u_z(i,0:km-1)) &
          & - beta * (f1(0:km-1) / dts) * f5_z(0:km-1)
     D(0) = &
          & D(0) + f6(0)
     D(km-1) = &
          & D(km-1) + f6(km-1)
     write(*,*) "D", D
     
     !--- 
     call dltx(C, A, B, km, D, epsz, isw, is, ip, vw, icon)
     pi(i,0:km-1) = D(0:km-1)
     write(*,*) "׻", pi(i, 0:km-1)
     
     if (icon /= 0) then
        write(*,*) "Condition code is wrong", icon
        stop
     end if

     !--- β
     deallocate(f3_z, f5_z)
     
  end do



  !--- β
  deallocate(ip, vw, f1, f2, f3, f4, f5, f6, &
       & c2_bs, A, B, C, D, w_bz, div_z, pi_z, u_x, u_z)
     


end subroutine exner

