!c Description: 
!c   u ˴ؤήη׻. ʻ u 
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c   1.0        2003-11-21    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_adv_u
  interface

     subroutine adv_u(u, w, u_adv)
       real(8), intent(in)               :: u(:,:)
       real(8), intent(in)               :: w(:,:)
       real(8), intent(out), allocatable :: u_adv(:,:)
     end subroutine adv_u

  end interface
end module if_adv_u



subroutine adv_u(u, w, u_adv)

  !--- ⥸塼ɤ߹
  use gridset
  use physprm
  use if_heikin
  use if_bibun  
  use if_bibun2
  
  !--- ۤηػ
  implicit none

  !--- ѿ
  real(8), intent(in)               :: u(:,:)
  real(8), intent(in)               :: w(:,:)
  real(8), intent(out), allocatable :: u_adv(:,:)

  !--- ѿ
  real(8), allocatable              :: u_dif(:,:)
  real(8), allocatable              :: u_x(:,:)
  real(8), allocatable              :: u_xx(:,:)
  real(8), allocatable              :: u_z(:,:)
  real(8), allocatable              :: u_zz(:,:)
  real(8), allocatable              :: w_bxbz(:,:)


  !--- 
  allocate(u_adv(-bm:im+bm, -bm:km+bm), u_dif(-bm:im+bm, -bm:km+bm))
  u_adv = 0.0d0; u_dif = 0.0d0

  !--- ʿѲ
  call heikin(23, w, w_bxbz)  !ʻ u (2)Ǥ® w (3)

  !--- ʬ黻
  call bibun(221, u, u_x) !ʻ u (2) Ǥ x ʬ (1)
  call bibun(222, u, u_z) !ʻ u (2) Ǥ z ʬ
  call bibun(221, u_x, u_xx)    !ʻ u (2) Ǥ x ʬ
  call bibun2(222, u, u_zz)     !ʻ u (2) Ǥ z ʬ
  
  !--- Ǵ
  u_dif = nuh * u_xx + nuv * u_zz
  
  !--- ή
  u_adv = u * u_x + w_bxbz * u_z + u_dif
  
  !--- β
  deallocate(u_dif, w_bxbz, u_x, u_z, u_xx, u_zz)


!  u_dif(-1:im+1,-1:km+1) = &
!       & nuh * ( &
!       &  u(0:im+2,-1:km+1) - 2.0d0 * u(-1:im+1,-1:km+1) + u(-2:im,-1:km+1)&
!       &       ) &
!       &       / (dx ** 2.0d0)  &
!       & + nuv * ( &
!       &  u(-1:im+1,0:km+2) - 2.0d0 * u(-1:im+1,-1:km+1) + u(-1:im+1,-2:km) &
!       &         ) &
!       &       / (dz ** 2.0d0)
!   
!  u_adv(-1:im+1,-1:km+1) = &
!       & u(-1:im+1,-1:km+1) &
!       &    * (u(0:im+2, -1:km+1) - u(-2:im, -1:km+1)) &
!       &    / (2.0d0 * dx)  &
!       & + (w(0:im+2,0:km+2) + w(0:im+2,-2:km) &
!       &    + w(-2:im,0:km+2) + w(-2:im,-2:km)) &
!       &    * (u(-1:im+1, 0:km+2) - u(-1:im+1, -2:km)) &
!       &    / (4.0d0 * 2.0d0 * dz) &
!       & - u_dif(-1:im+1, -1:km+1)
  
  
end subroutine adv_u
