  program main

    use vtype_module
    use ni3_module
    use netcdf

    implicit none

    integer(i4b)              :: in_im, in_jm, in_km, in_sm, in_tm
    integer(i4b)              :: in_im_margin = 5
    real(dp)    , allocatable :: in_x( : ), in_y( : ), in_s( : ), in_z( : )
    real(dp)                  :: in_t
    real(sp)    , allocatable :: &
         in_arr1dr(:), in_arr2dr(:,:), in_arr3dr(:,:,:), in_arr4dr(:,:,:,:)
    real(dp)    , allocatable :: &
         in_arr1dd(:), in_arr2dd(:,:), in_arr3dd(:,:,:), in_arr4dd(:,:,:,:)

    character(len=extstr)            :: in_ncfn, in_ncfn0
    integer(i4b)                     :: in_ncid

    integer(i4b)              :: in_im0, in_jm0, in_km0, in_sm0, in_tm0


    integer(i4b)              :: out_im, out_km, out_tm
    real(dp)    , allocatable :: out_x( : ), out_y( : ), out_z( : ), out_t( : )
    real(sp)    , allocatable :: &
         out_arr1dr(:), out_arr2dr(:,:), out_arr3dr(:,:,:), out_arr4dr(:,:,:,:)
    real(dp)    , allocatable :: &
         out_arr1dd(:), out_arr2dd(:,:), out_arr3dd(:,:,:), out_arr4dd(:,:,:,:)

    character(len=extstr)            :: out_ncfn, out_ncfn0
    integer(i4b)                     :: out_ncid


    character(len=extstr)            :: mode, name
    integer(i4b)                       :: &
         varid, ndims, nvars, st1( 1 ), co1( 1 ), st( 5 ), co( 5 )
    character(len=extstr), allocatable :: dimname( : )
    real(dp)                           :: fillvalue

    integer(i4b)          :: is, ie, ks, ke, ts, te
    integer(i4b)          :: i, l, n, t

    integer(i4b)          :: nprocs

    integer(i4b)          :: ierr


    character(len=stdstr) :: ctlfn = "nccomb.cntl"


    namelist /proc/  nprocs
    namelist /files/ in_ncfn0, out_ncfn0


    open( 50, file = ctlfn )
    read ( 50, proc  )
    write(  6, proc  )
    read ( 50, files )
    write(  6, files )
    close( 50 )


!!$    nprocs = 2
!!$    nprocs = 3


    out_im = 0

    do n = 0, nprocs - 1

!!$       in_ncfn0 = "arare-R50_TL3_TS03-ssl2_ffc"
       write( in_ncfn, '(a,i6.6,a)' ) trim( in_ncfn0 ) // '_rank', n, ".nc"
       mode    = "read"
       call ni3_open( in_ncfn, mode, in_ncid )
       call ni3_inq_dimlen( in_ncid, "x", in_im )

       out_im = out_im + in_im - 2 * in_im_margin

       call ni3_close( in_ncid )

    end do



!!$    out_ncfn0 = "arare-combined"
    out_ncfn = trim( out_ncfn0 ) // ".nc"
    mode    = "new"
    call ni3_open( out_ncfn, mode, out_ncid )


    is = 1000000000
    ie = 0

    do n = 0, nprocs - 1

       write( in_ncfn, '(a,i6.6,a)' ) trim( in_ncfn0 ) // '_rank', n, ".nc"
       mode    = "read"
       call ni3_open( in_ncfn, mode, in_ncid )


       if( n .eq. 0 ) then
          name = "global"
          call ni3_cp_atts( in_ncid, out_ncid, name )
       end if

       if( n .eq. 0 ) then
          call ni3_inq_dimlen( in_ncid, "x", in_im )
          call ni3_inq_dimlen( in_ncid, "y", in_jm )
          call ni3_inq_dimlen( in_ncid, "z", in_km )
          call ni3_inq_dimlen( in_ncid, "s", in_sm )
          call ni3_inq_dimlen( in_ncid, "t", in_tm )

          allocate( in_x( in_im ) )
          allocate( in_y( in_jm ) )
          allocate( in_z( in_km ) )
          allocate( in_s( in_sm ) )
!!$          allocate( in_t( in_tm ) )
          call ni3_get_var( in_ncid, "x", in_x )
          call ni3_get_var( in_ncid, "y", in_y )
          call ni3_get_var( in_ncid, "z", in_z )
          call ni3_get_var( in_ncid, "s", in_s )
!!$          call ni3_get_var( in_ncid, "t", in_t )

          name = "x"
!!$          call ni3_set_dim( out_ncid, name, NF90_REAL, out_x )
!!$          call ni3_def_dim( out_ncid, name, NF90_REAL, out_im )
          call ni3_def_dim( out_ncid, name, NF90_DOUBLE, out_im )
          call ni3_cp_atts( in_ncid, out_ncid, name )
          name = "y"
!!$          call ni3_set_dim( out_ncid, name, NF90_REAL, in_y )
          call ni3_set_dim( out_ncid, name, NF90_DOUBLE, in_y )
          call ni3_cp_atts( in_ncid, out_ncid, name )
          name = "z"
!!$          call ni3_set_dim( out_ncid, name, NF90_REAL, in_z )
          call ni3_set_dim( out_ncid, name, NF90_DOUBLE, in_z )
          call ni3_cp_atts( in_ncid, out_ncid, name )
          name = "s"
!!$          call ni3_set_dim( out_ncid, name, NF90_REAL, in_s )
          call ni3_set_dim( out_ncid, name, NF90_DOUBLE, in_s )
          call ni3_cp_atts( in_ncid, out_ncid, name )
          name = "t"
!!$          call ni3_set_dim( out_ncid, name, NF90_REAL, in_t )
!!$          call ni3_def_dim( out_ncid, name, NF90_REAL, NF90_GLOBAL )
          call ni3_def_dim( out_ncid, name, NF90_DOUBLE, NF90_GLOBAL )
          call ni3_cp_atts( in_ncid, out_ncid, name )

          deallocate( in_x )
          deallocate( in_y )
          deallocate( in_s )
          deallocate( in_z )
!!$          deallocate( in_t )

          in_im0 = in_im
          in_jm0 = in_jm
          in_km0 = in_km
          in_sm0 = in_sm
          in_tm0 = in_tm
       end if


       call ni3_inq_dimlen( in_ncid, "x", in_im )
       call ni3_inq_dimlen( in_ncid, "y", in_jm )
       call ni3_inq_dimlen( in_ncid, "z", in_km )
       call ni3_inq_dimlen( in_ncid, "s", in_sm )
       call ni3_inq_dimlen( in_ncid, "t", in_tm )
       if( in_jm .ne. in_jm0 ) then
          write( 6, * ) 'Array size is not the same for y : ', in_jm0, in_jm
          stop
       end if
       if( in_km .ne. in_km0 ) then
          write( 6, * ) 'Array size is not the same for z : ', in_km0, in_km
          stop
       end if
       if( in_sm .ne. in_sm0 ) then
          write( 6, * ) 'Array size is not the same for s : ', in_sm0, in_sm
          stop
       end if
       if( in_tm .ne. in_tm0 ) then
          write( 6, * ) 'Array size is not the same for t : ', in_tm0, in_tm
          stop
       end if


       allocate( in_x( in_im ) )
       call ni3_get_var( in_ncid, "x", in_x )


       is = ie + 1
       ie = is + in_im - 2 * in_im_margin - 1
       ks = 1
       ke = in_km
       ts = 1
       te = in_tm


       st1( 1 ) = is
       co1( 1 ) = in_im - 2 * in_im_margin
       call ni3_inq_var( out_ncid, "x", varid )
       call ni3_enddef( out_ncid )
       ierr = nf90_put_var( out_ncid, varid, in_x(in_im_margin+1:in_im-in_im_margin), st1, co1 )
       call ni3_handle_err( ierr )


       deallocate( in_x )


       if( n .eq. 0 ) then
          do t = ts, te
             call ni3_get_varss( in_ncid , "t", t, in_t )
             call ni3_put_varss( out_ncid, "t", t, in_t )
          end do
       end if


       call ni3_inq( in_ncid, ndims, nvars )

       do l = 1, nvars

          call ni3_inq_varname( in_ncid, l, name )

          if( ( name .ne. "x" ) .and. ( name .ne. "y" ) .and. ( name .ne. "z" ) &
               .and. ( name .ne. "s" ) .and. ( name .ne. "t" ) ) then

             call ni3_inq_var( in_ncid, name, ndims = ndims )

             if( n .eq. 0 ) then

               allocate( dimname( ndims ) )

               select case ( ndims )
               case ( 3 )
                 dimname( 1 ) = "x"
                 dimname( 2 ) = "y"
                 dimname( 3 ) = "z"
               case ( 4 )
                 if ( ( trim( name ) == 'QMixBZ' ) .or. ( trim( name ) == 'HumBZ' ) ) then
                   dimname( 1 ) = "x"
                   dimname( 2 ) = "y"
                   dimname( 3 ) = "z"
                   dimname( 4 ) = "s"
                 else
                   dimname( 1 ) = "x"
                   dimname( 2 ) = "y"
                   dimname( 3 ) = "z"
                   dimname( 4 ) = "t"
                 end if
               case ( 5 )
                 dimname( 1 ) = "x"
                 dimname( 2 ) = "y"
                 dimname( 3 ) = "z"
                 dimname( 4 ) = "s"
                 dimname( 5 ) = "t"
               case default
                 write( 6, * ) 'Inappropriate number of dimensions for ', &
                   trim( name ), ', ', ndims
                 stop
               end select

               call ni3_def_var( out_ncid, name, NF90_DOUBLE, ndims, dimname )
!!$                call ni3_def_var( out_ncid, name, NF90_REAL, ndims, dimname )
               deallocate( dimname )
               call ni3_cp_atts( in_ncid, out_ncid, name )

             end if

             call ni3_inq_var( out_ncid, name, varid )


               select case ( ndims )
               case ( 3 )
!!$                 allocate( in_arr3dr( in_im , in_jm, in_km ) )
                 allocate( in_arr3dd( in_im , in_jm, in_km ) )
!!$                 call ni3_get_var( in_ncid, name, in_arr3dr )
                 call ni3_get_var( in_ncid, name, in_arr3dd )
                 st( 1 ) = is
                 st( 2 ) = 1
                 st( 3 ) = 1
                 co( 1 ) = in_im - 2 * in_im_margin
                 co( 2 ) = in_jm
                 co( 3 ) = in_km
                 call ni3_enddef( out_ncid )
!!$                 ierr = nf90_put_var( out_ncid, varid, in_arr3dr(in_im_margin+1:in_im-in_im_margin,:,:), st, co )
                 ierr = nf90_put_var( out_ncid, varid, in_arr3dd(in_im_margin+1:in_im-in_im_margin,:,:), st(1:3), co(1:3) )
                 call ni3_handle_err( ierr )
!!$                 deallocate( in_arr3dr )
                 deallocate( in_arr3dd )
               case ( 4 )
                 if ( ( trim( name ) == 'QMixBZ' ) .or. ( trim( name ) == 'HumBZ' ) ) then
!!$                   allocate( in_arr4dr( in_im , in_jm, in_km, in_sm ) )
                   allocate( in_arr4dd( in_im , in_jm, in_km, in_sm ) )
!!$                   call ni3_get_var( in_ncid, name, in_arr4dr )
                   call ni3_get_var( in_ncid, name, in_arr4dd )
                   st( 1 ) = is
                   st( 2 ) = 1
                   st( 3 ) = 1
                   st( 4 ) = 1
                   st( 5 ) = t
                   co( 1 ) = in_im - 2 * in_im_margin
                   co( 2 ) = in_jm
                   co( 3 ) = in_km
                   co( 4 ) = in_sm
                   co( 5 ) = 1
                   call ni3_enddef( out_ncid )
!!$                   ierr = nf90_put_var( out_ncid, varid, in_arr4dr(in_im_margin+1:in_im-in_im_margin,:,:,:), st, co )
                   ierr = nf90_put_var( out_ncid, varid, in_arr4dd(in_im_margin+1:in_im-in_im_margin,:,:,:), st, co )
                   call ni3_handle_err( ierr )
!!$                   deallocate( in_arr4dr )
                   deallocate( in_arr4dd )
                 else
!!$                   allocate( in_arr3dr( in_im , in_jm, in_km ) )
                   allocate( in_arr3dd( in_im , in_jm, in_km ) )
                   do t = ts, te
!!$                     call ni3_get_varss( in_ncid, name, t, in_arr3dr )
                     call ni3_get_varss( in_ncid, name, t, in_arr3dd )
                     st( 1 ) = is
                     st( 2 ) = 1
                     st( 3 ) = 1
                     st( 4 ) = t
                     co( 1 ) = in_im - 2 * in_im_margin
                     co( 2 ) = in_jm
                     co( 3 ) = in_km
                     co( 4 ) = 1
                     call ni3_enddef( out_ncid )
!!$                     ierr = nf90_put_var( out_ncid, varid, in_arr3dr(in_im_margin+1:in_im-in_im_margin,:,:), st(1:4), co(1:4) )
                     ierr = nf90_put_var( out_ncid, varid, in_arr3dd(in_im_margin+1:in_im-in_im_margin,:,:), st(1:4), co(1:4) )
                     call ni3_handle_err( ierr )
                   end do
!!$                 deallocate( in_arr3dr )
                   deallocate( in_arr3dd )
                 end if
               case ( 5 )
!!$                 allocate( in_arr4dr( in_im , in_jm, in_km, in_sm ) )
                 allocate( in_arr4dd( in_im , in_jm, in_km, in_sm ) )
                 do t = ts, te
!!$                   call ni3_get_varss( in_ncid, name, t, in_arr4dr )
                   call ni3_get_varss( in_ncid, name, t, in_arr4dd )
                   st( 1 ) = is
                   st( 2 ) = 1
                   st( 3 ) = 1
                   st( 4 ) = 1
                   st( 5 ) = t
                   co( 1 ) = in_im - 2 * in_im_margin
                   co( 2 ) = in_jm
                   co( 3 ) = in_km
                   co( 4 ) = in_sm
                   co( 5 ) = 1
                   call ni3_enddef( out_ncid )
!!$                   ierr = nf90_put_var( out_ncid, varid, in_arr4dr(in_im_margin+1:in_im-in_im_margin,:,:,:), st, co )
                   ierr = nf90_put_var( out_ncid, varid, in_arr4dd(in_im_margin+1:in_im-in_im_margin,:,:,:), st, co )
                   call ni3_handle_err( ierr )
                 end do
!!$                 deallocate( in_arr4dr )
                 deallocate( in_arr4dd )
               case default
                 write( 6, * ) 'Inappropriate number of dimensions for ', &
                   trim( name ), ', ', ndims
                 stop
               end select



          end if

       end do

       call ni3_close( in_ncid )

    end do


    call ni3_close( out_ncid )


  end program main
