!= ꥹȥǡ, ͥǡ
!
!= Restart data, initial data input/output
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: restart_file_io.F90,v 1.12 2009-03-18 07:58:11 morikawa Exp $
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module restart_file_io
  !
  != ꥹȥǡ, ͥǡ
  !
  != Restart data, initial data input/output
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ꥹȥǡ⤷ϽͥǡϤԤޤ. 
  ! ϥե, ϥե, ǡνϤδֳ֤
  ! NAMELIST#restart_file_io_nml ꤷޤ. 
  !
  ! ꥹȥǡϥե뤬ꤵʤ, 
  ! initial_data ⥸塼줿ͥǡޤ. 
  !
  ! Restart data or initial data is input/output. 
  ! Settings of input file, output file, and interval of data output 
  ! is configured by "NAMELIST#restart_file_io_nml". 
  !
  ! If input file of restart data is not set, 
  ! initial data is generated in "initial_data" module, and 
  ! obtained data from the module. 
  !
  !== Procedures List
  !
  ! RestartFileOpen   :: ꥹ/ͥեΥץ
  ! RestartFileOutput :: ꥹ/ͥեؤΥǡ
  ! RestartFileClose  :: ꥹ/ͥեΥ
  ! RestartFileGet    :: ꥹ/ͥե
  ! ------------      :: ------------
  ! RestartFileOpen   :: Open restart/initial file
  ! RestartFileOutput :: Data output to restart/initial file
  ! RestartFileClose  :: Close restart/initial file
  ! RestartFileGet    :: Input restart/initial file
  !
  !== NAMELIST
  !
  ! NAMELIST#restart_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gtool_history, only: GT_HISTORY

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RestartFileOpen, RestartFileClose, RestartFileOutPut
  public:: RestartFileGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: restart_file_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  logical, save, public:: restart_file_opened = .false.
                              ! ꥹȥեΥץ˴ؤե饰. 
                              ! Flag of restart file open

  character(STRING), save, public:: InputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of input restart data

  character(STRING), save, public:: OutputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of output restart data
  real, save, public:: IntValue
                              ! ꥹȥǡνϴֳ (). 
                              ! Interval of restart data output (numerical value)
  character(TOKEN), save, public:: IntUnit
                              ! ꥹȥǡνϴֳ (ñ). 
                              ! Interval of restart data output (unit)
  type(DC_DIFFTIME), save, public:: IntTime
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output

  ! ѿ
  ! Private variables
  !
  logical, save:: flag_init_data_save
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gtool_history#GT_HISTORY ѿ
                              ! "gtool_history#GT_HISTORY" variable for restart data

  type(DC_DIFFTIME), save:: PrevOutputTime
                              ! νϻ. 
                              ! Previous output time
  logical, save:: flag_output_end
                              ! ׻ǽνϴλΥե饰. 
                              ! Flag for completion of output at the end time of calculation

  character(*), parameter:: module_name = 'restart_file_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: restart_file_io.F90,v 1.12 2009-03-18 07:58:11 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface RestartFileOpen
    module procedure RestartFileOpen
  end interface

  interface RestartFileClose
    module procedure RestartFileClose
  end interface

  interface RestartFileOutput
    module procedure RestartFileOutput0
    module procedure InitialFileOutput
  end interface

  interface RestartFileGet
    module procedure RestartFileGet
  end interface

contains

  subroutine RestartFileOpen( flag_init_data )
    !
    ! ꥹ/ͥե򥪡ץ󤷤ޤ. 
    !
    ! A restart/initial data file is opened. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ. 
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & StartTime             ! ׻ϻ. 
                              ! Start time of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
      & HistoryPut, HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: CPrintf, LChar

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: toChar, EvalByUnit, operator(+)

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    logical, intent(in), optional:: flag_init_data
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

    ! ѿ
    ! Work variables
    !
    character(STRING):: title_msg
                              ! ɽղäå. 
                              ! Message added to title
    real:: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation
    character(12):: time_unit
                              ! ñ. Units of date and time

    logical:: flag_mpi_init
#ifdef LIB_MPI
    integer:: err_mpi
#endif

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    flag_init_data_save = present_and_true( flag_init_data )
    if ( .not. restart_file_io_inited ) call RestartFileInit
    if ( restart_file_opened ) return

    ! ɽղäå
    ! Configure message added to title
    !
    if ( .not. flag_init_data_save ) then
      title_msg = ' restart data'
    else
      title_msg = ' initial data'
    end if

    ! μ
    ! Get time information
    !
    if ( .not. flag_init_data_save ) then
      origin_time = EvalByUnit( StartTime + IntTime, IntUnit )
    else
      origin_time = EvalByUnit( StartTime, IntUnit )
    end if

    time_unit = IntUnit

#ifdef LIB_MPI
    ! MPI ˤԤƤ뤫ǧ. 
    ! Confirm initialization of MPI
    !
    call MPI_Initialized(flag_mpi_init, err_mpi)
#else
    flag_mpi_init = .false.
#endif

    ! ǡ
    ! Configure axes data
    !
    

    ! ꥹȥեΥץ
    ! Open a restart file
    !
    call HistoryCreate( &
      &      file = OutputFile, &                                   ! (in)
      &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
      &    source = FileSource, institution = FileInstitution, &    ! (in)
      &      dims = (/ 'lon ', 'lat ', 'sig ', 'sigm', 'time' /), & ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &          ! (in)
      & longnames = (/ 'longitude                             ', &
      &                'latitude                              ', &
      &                'sigma at layer midpoints              ', &
      &                'sigma at layer end-points (half level)', &
      &                'time                                  ' /), & ! (in)
      &     units = (/ 'degree_east ', 'degree_north', &
      &                '1           ', '1           ', &
      &                time_unit /), &                                ! (in)
      & xtypes = (/'double', 'double', 'double', &
      &            'double', 'double'/), &                            ! (in)
      &         origin = origin_time, &       ! (in) optional
      &       interval = IntValue, &          ! (in) optional
      & flag_mpi_split = flag_mpi_init, &     ! (in) optional
      &        history = gthst_rst )          ! (out) optional

    ! $ \Delta t $ ˴ؤɲ. 
    ! Add information about $ \Delta t $. 
    !
    if ( .not. flag_init_data_save ) then
      call HistoryAddVariable( &
        & varname = 'deltime', &             ! (in)
        & dims = (/''/), &                   ! (in)
        & longname = 'delta time', &         ! (in)
        & units = 'sec', xtype = 'double', & ! (in)
        & history = gthst_rst )              ! (inout)
      call HistoryPut( &
        & varname = 'deltime', &            ! (in)
        & array = (/ DelTime /), &          ! (in)
        & history = gthst_rst )             ! (inout)
    end if

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & 'lon', attrname = 'standard_name', &     ! (in)
      & value = 'longitude', &                   ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'standard_name', &     ! (in)
      & value = 'latitude', &                    ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'standard_name', &     ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'standard_name', &    ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'standard_name', &    ! (in)
      & value = 'time', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'positive', &          ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'positive', &         ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)

    call HistoryPut( &
      & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'sig', z_Sigma, &               ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sigm', r_Sigma, &              ! (in)
      & history = gthst_rst )           ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( 'lon_weight', &               ! (in)
      & (/'lon'/), &                                       ! (in)
      & 'weight for integration in longitude', 'radian', & ! (in)
      & xtype = 'double', &                                ! (in)
      & history = gthst_rst )                              ! (inout)
    call HistoryAddAttr( &
      & 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lon_weight', x_Lon_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'lat_weight', &                      ! (in)
      & (/'lat'/), &                                              ! (in)
      & 'weight for integration in latitude', units = 'radian', & ! (in)
      & xtype = 'double', &                                       ! (in)
      & history = gthst_rst )                                     ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lat_weight', y_Lat_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'sig_weight', &      ! (in)
      & (/'sig'/), &                              ! (in)
      & 'weight for integration in sigma', '1', & ! (in)
      & xtype = 'double', &                       ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'sig_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'sig_weight', z_DelSigma, &               ! (in)
      & history = gthst_rst )                     ! (inout)

    ! ͽѿ
    ! Predictional variables settings
    !
    if ( flag_init_data_save ) then
      
      ! ǡե
      ! For initial data file
      !
      call HistoryAddVariable( 'U', &                         ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind', 'm s-1', &                         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'V', &                         ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind', 'm s-1', &                        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'Temp', &                      ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature', 'K', &                               ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'QVap', &                      ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'specific humidity', 'kg kg-1', &                   ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'Ps', &                        ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure', 'Pa', &                         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)

    else
      ! ꥹȥǡե
      ! For restart data file
      !
      call HistoryAddVariable( 'UB', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind (at t-\Delta t)', 'm s-1', &         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'VB', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind (at t-\Delta t)', 'm s-1', &        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'TempB', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature (at t-\Delta t)', 'K', &               ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'QVapB', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'specific humidity (at t-\Delta t)', 'kg kg-1', &   ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'PsB', &                       ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure (at t-\Delta t)', 'Pa', &         ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)

      call HistoryAddVariable( 'UN', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'eastward wind (at t)', 'm s-1', &                  ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'VN', &                        ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'northward wind (at t)', 'm s-1', &                 ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'TempN', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'temperature (at t)', 'K', &                        ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'QVapN', &                     ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
        & 'specific humidity (at t)', 'kg kg-1', &            ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
      call HistoryAddVariable( 'PsN', &                       ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
        & 'surface pressure (at t)', 'Pa', &                  ! (in)
        & xtype = 'double', &                                 ! (in)
        & history = gthst_rst )                               ! (inout)
    end if

    restart_file_opened = .true.
  end subroutine RestartFileOpen

  !-------------------------------------------------------------------

  subroutine RestartFileOutput0( &
    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
    & )
    !
    ! ꥹȥǡνϤԤޤ. 
    !
    ! Output restart data

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime               ! ׻λ. 
                              ! End time of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: operator(+), operator(<), operator(-), &
      & operator(==), operator(>=), DCDiffTimePutLine

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    logical:: flag_output
                              ! ϤΥե饰. 
                              ! Flag for output

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) call RestartFileOpen

    ! ꥹȥǡϤǤ뤳ȤΥå
    ! Check restart data output
    !
    if ( flag_init_data_save ) then
      call MessageNotify( 'E', module_name, &
        & 'Now, initial data output mode.' )
    end if

    ! ϥߥ󥰤Υå
    ! Check output timing
    !
    flag_output = TimeN - PrevOutputTime >= IntTime
    if ( TimeN >= EndTime .and. .not. flag_output_end ) then
      flag_output = .true.
      flag_output_end = .true.
    end if
    flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
    flag_output = flag_init_data_save .or. flag_output

    if ( .not. flag_output ) return

    ! Ѥ, ν (˾)  ¸
    ! Save output time (expected) in this time, for next time
    !
    PrevOutputTime = PrevOutputTime + IntTime

    ! 
    ! Set time
    !
    call HistorySetTime( difftime = TimeN, history = gthst_rst )

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'UB', xyz_UB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VB', xyz_VB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempB', xyz_TempB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'QVapB', xyz_QVapB, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'PsB', xy_PsB, history = gthst_rst ) ! (in)

    call HistoryPut( &
      & 'UN', xyz_UN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'VN', xyz_VN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'TempN', xyz_TempN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'QVapN', xyz_QVapN, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'PsN', xy_PsN, history = gthst_rst ) ! (in)

  end subroutine RestartFileOutput0

  !-------------------------------------------------------------------

  subroutine InitialFileOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps  &   ! (in)
    & )
    !
    ! ͥǡνϤԤޤ. 
    !
    ! Output initial data

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime               ! ׻λ. 
                              ! End time of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: operator(+), operator(<), operator(-), &
      & operator(==), operator(>=), DCDiffTimePutLine

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .     ®. Northward wind
    real(DP), intent(in):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ .   ɽ̵. Surface pressure

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) call RestartFileOpen( flag_init_data = .true. )

    ! ͽϤǤ뤳ȤΥå
    ! Check initial data output
    !
    if ( .not. flag_init_data_save ) then
      call MessageNotify( 'E', module_name, &
        & 'Now, restart data output mode.' )
    end if

    ! 
    ! Set time
    !
    call HistorySetTime( difftime = TimeN, history = gthst_rst )

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'U', xyz_U, history = gthst_rst )       ! (in)
    call HistoryPut( &
      & 'V', xyz_V, history = gthst_rst )       ! (in)
    call HistoryPut( &
      & 'Temp', xyz_Temp, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'QVap', xyz_QVap, history = gthst_rst ) ! (in)
    call HistoryPut( &
      & 'Ps', xy_Ps, history = gthst_rst )      ! (in)

  end subroutine InitialFileOutput

  !-------------------------------------------------------------------

  subroutine RestartFileClose
    !
    ! ꥹȥǡեϤνλԤޤ. 
    !
    ! Terminate restart data files output. 

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_file_opened ) return

    call HistoryClose( history = gthst_rst ) ! (inout)

    restart_file_opened = .false.
  end subroutine RestartFileClose

  !-------------------------------------------------------------------

  subroutine RestartFileGet( &
    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, & ! (out)
    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, & ! (out)
    & flag_initial &                                  ! (out) optional
    & )
    !
    ! ꥹ/ͥǡϤԤޤ. 
    ! ꥹ/ͥǡե뤬¸ߤʤˤ, 
    ! initial_data ⥸塼Ѥ, Ԥޤ. 
    !
    ! Input restart/initial data. 
    ! If a restart/initial data file is not exist, 
    ! initial data is created by "initial_data". 


    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime               ! $ \Delta t $ [s]

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    use initial_data, only: InitDataGet

    ! 
    ! Time control
    !
    use timeset, only: &
      & StartTime             ! ׻ϻ. 
                              ! Start time of calculation

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet, HistoryGetAttr

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: EvalByUnit

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(out):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(out):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(out):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(out):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(out):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(out):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(out):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(out):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
    logical, intent(out), optional:: flag_initial
                              ! ꥹȥǡɤ߹ˤ, 
                              ! .false. , ͥǡɤ߹ˤ
                              ! .true. ֤ޤ. 
                              ! 
                              ! If restart data is loaded, .false. is returned.
                              ! On the other hand, if initial data is loaded, 
                              ! .true. is returned. 

    ! ѿ
    ! Work variables
    !
    logical:: flag_init_get   ! ͥǡϻ .true. 
                              ! 
                              ! If initial data is input, 
                              ! this is ".true.".

    character(STRING):: time_range
                              ! λ. 
                              ! Specification of time
    real(DP):: deltime_value
                              ! 'deltime' ѿ. 
                              ! Value of 'deltime' variable. 
    real(DP):: time_check
                              ! åѺѿ
                              ! Work variable for check time
    character(TOKEN):: dummy_str
                              ! ϥåѤΥߡѿ
                              ! Dummy variable for check of input
    logical:: get_err
                              ! ϻΥ顼ե饰. 
                              ! Error flag for input
    real(DP):: returned_time
                              ! ϥǡλ. 
                              ! Time of input data.
    character(TOKEN):: time_units
                              ! ϥǡλñ. 
                              ! Units of time of input data.
    logical:: flag_time_exist
                              ! ϥǡλѤΥե饰. 
                              ! Flag for time of input data.
    real(DP):: start_time
                              ! ׻ϻ. 
                              ! Start time of calculation

    logical:: flag_mpi_init
#ifdef LIB_MPI
    integer:: err_mpi
#endif

    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_file_io_inited ) call RestartFileInit

    ! ǡ initial_data ⥸塼뤫
    ! Data is input from "initial_data" module
    ! 
    if ( trim(InputFile) == '' ) then
      call InitDataGet( &
        & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB )   ! (out)

      call MessageNotify( 'M', module_name, &
        & 'Initial data (not restart data) is input ' // &
        & 'from a module "initial_data". ' // &
        & '*B (t-dt) and *N (t) are same.' )

      xyz_UN    = xyz_UB
      xyz_VN    = xyz_VB
      xyz_TempN = xyz_TempB
      xyz_QVapN = xyz_QVapB
      xy_PsN    = xy_PsB

      if ( present(flag_initial) ) flag_initial = .true.

    ! ǡ InputFile 
    ! Data is input from InputFile
    ! 
    else

#ifdef LIB_MPI
      ! MPI ˤԤƤ뤫ǧ. 
      ! Confirm initialization of MPI
      !
      call MPI_Initialized(flag_mpi_init, err_mpi)
#else
      flag_mpi_init = .false.
#endif

      ! ե̵ͭǧ
      ! Conform an existence of an input file
      ! 
      call HistoryGetAttr( InputFile, 'lon', 'units', & ! (in)
        & dummy_str, &                                  ! (out)
        & flag_mpi_split = flag_mpi_init, &             ! (in) optional
        & err = get_err )                               ! (out)

      if ( get_err ) then
        call MessageNotify( 'E', module_name, &
          & 'restart/initial data file "%c" is not found.', &
          & c1 = trim(InputFile) )
      end if

      ! μ
      ! Get time information
      !
      time_range = 'time=' // &
        &          toChar( EvalbyUnit( StartTime, IntUnit ) )

      ! ͥǡꥹȥǡΥå
      ! Check whether input data is initial data or restart data
      ! 
      call HistoryGet( &
        & InputFile, 'U', &                       ! (in)
        & xyz_UB, &                               ! (out)
        & err = get_err, &                        ! (out) optional
        & quiet = .true., &                       ! (in) optional
        & flag_mpi_split = flag_mpi_init )        ! (in) optional

      if ( .not. get_err ) then
        flag_init_get = .true.
        if ( present(flag_initial) ) flag_initial = .true.

      else
        flag_init_get = .false.
        if ( present(flag_initial) ) flag_initial = .false.

        call HistoryGet( &
          & InputFile, 'UB', &                      ! (in)
          & xyz_UB, &                               ! (out)
          & range = time_range, &                   ! (in) optional
          & quiet = .true., &                       ! (in) optional
          & err = get_err, &                        ! (out) optional
          & returned_time = returned_time, &        ! (out) optional
          & flag_time_exist = flag_time_exist, &    ! (out) optional
          & flag_mpi_split = flag_mpi_init )        ! (in) optional

        if ( get_err ) then
          call MessageNotify( 'E', module_name, &
            & 'One of necessary variables "UB" for restart ' // &
            & 'is not included in "%c"', &
            & c1 = trim(InputFile) )
        end if

        ! ֥ƥåפΥå
        ! Check time step
        !
        deltime_value = 0.
        call HistoryGet( &
          & InputFile, 'deltime', &     ! (in)
          & array = deltime_value, &    ! (out)
          & err = get_err )             ! (out)

        if ( get_err ) then
          call MessageNotify( 'E', module_name, &
            & 'A necessary variable "deltime" for restart ' // &
            & 'is not included in "%c"', &
            & c1 = trim(InputFile) )
        end if

        time_check = deltime_value / DelTime
        if ( 0.999 > time_check .or. time_check > 1.0001 ) then
          call MessageNotify( 'E', module_name, &
            & 'deltime=<%f> [sec] in "%c" is differ from DelTime=<%f> [sec]', &
            & c1 = trim(InputFile), d = (/deltime_value, DelTime/) )
        end if

        ! ǡλȥǥ
        ! Compare Time of data with model time
        !
        if ( .not. flag_time_exist ) then
          call MessageNotify( 'E', module_name, &
            & 'Input data does not depend on time. ' // &
            & 'Restart data must be depended on time. ' )
        end if

        call HistoryGetAttr( InputFile, 'time', 'units', & ! (in)
          & time_units, &                                  ! (out)
          & flag_mpi_split = flag_mpi_init )               ! (in) optional
        start_time = EvalByUnit( StartTime, time_units )

        if ( start_time == 0. ) then
          if ( .not. returned_time == 0. ) then
            call MessageNotify( 'E', module_name, &
              & 'time=<%f> [%c] of data in "%c" is differ from StartTime=<%f> [%c]', &
              & c1 = trim(time_units), c2 = trim(InputFile), c3 = trim(time_units), &
              & d = (/returned_time, start_time/) )
          end if
        else
          time_check = returned_time / start_time
          if ( 0.999 > time_check .or. time_check > 1.0001 ) then
            call MessageNotify( 'E', module_name, &
              & 'time=<%f> of data in "%c" is differ from StartTime=<%f>', &
              & c1 = trim(InputFile), d = (/returned_time, start_time/) )
          end if
        end if

      end if

      ! ǡ
      ! Data input
      ! 
      if ( flag_init_get ) then
        call HistoryGet( &
          & InputFile, 'U', &                 ! (in)
          & array = xyz_UB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'V', &                 ! (in)
          & array = xyz_VB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'Temp', &              ! (in)
          & array = xyz_TempB, &              ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'QVap', &              ! (in)
          & array = xyz_QVapB, &              ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional
        call HistoryGet( &
          & InputFile, 'Ps', &                ! (in)
          & array = xy_PsB, &                 ! (out)
          & flag_mpi_split = flag_mpi_init )  ! (in) optional

        call MessageNotify( 'M', module_name, &
          & 'Initial data (not restart data) is input ' // &
          & 'from a data file "%c". ' // &
          & '*B (t-dt) and *N (t) are same.', &
          & c1 = trim(InputFile) )

        xyz_UN    = xyz_UB
        xyz_VN    = xyz_VB
        xyz_TempN = xyz_TempB
        xyz_QVapN = xyz_QVapB
        xy_PsN    = xy_PsB

      else
        call HistoryGet( &
          & InputFile, 'UB', range = time_range, &  ! (in)
          & array = xyz_UB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'VB', range = time_range, &  ! (in)
          & array = xyz_VB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'TempB', range = time_range, &  ! (in)
          & array = xyz_TempB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        call HistoryGet( &
          & InputFile, 'QVapB', range = time_range, &  ! (in)
          & array = xyz_QVapB, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        call HistoryGet( &
          & InputFile, 'PsB', range = time_range, &  ! (in)
          & array = xy_PsB, &                        ! (out)
          & flag_mpi_split = flag_mpi_init )         ! (in) optional

        call HistoryGet( &
          & InputFile, 'UN', range = time_range, &  ! (in)
          & array = xyz_UN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'VN', range = time_range, &  ! (in)
          & array = xyz_VN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )        ! (in) optional
        call HistoryGet( &
          & InputFile, 'TempN', range = time_range, &  ! (in)
          & array = xyz_TempN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        call HistoryGet( &
          & InputFile, 'QVapN', range = time_range, &  ! (in)
          & array = xyz_QVapN, &                       ! (out)
          & flag_mpi_split = flag_mpi_init )           ! (in) optional
        call HistoryGet( &
          & InputFile, 'PsN', range = time_range, &  ! (in)
          & array = xy_PsN, &                        ! (out)
          & flag_mpi_split = flag_mpi_init )         ! (in) optional

        call MessageNotify( 'M', module_name, &
          & 'Restart data (not initial data) is input ' // &
          & 'from a data file "%c". ', &
          & c1 = trim(InputFile) )
      end if

    end if

  end subroutine RestartFileGet

  !-------------------------------------------------------------------

  subroutine RestartFileInit
    !
    ! restart_file_io ⥸塼νԤޤ. 
    ! NAMELIST#restart_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "restart_file_io" module is initialized. 
    ! "NAMELIST#restart_file_io_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & StartTime             ! ׻ϻ. 
                              ! Start time of calculation

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: DCDiffTimeCreate, operator(-)

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /restart_file_io_nml/ &
      & InputFile, &
      & OutputFile, &
      & IntValue, IntUnit
          !
          ! ǥեͤˤĤƤϽ³ "restart_file_io#RestartFileInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "restart_file_io#RestartFileInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( restart_file_io_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    InputFile  = ''
    if ( .not. flag_init_data_save ) then
      OutputFile = 'rst.nc'
    else
      OutputFile = 'init.nc'
    end if
    IntValue   = 1.0
    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = restart_file_io_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = restart_file_io_nml )
    end if

    ! ϻֳִ֤
    ! Configure time interval of output
    !
    call DCDiffTimeCreate( IntTime, & ! (out)
      & IntValue, IntUnit )           ! (in)
    PrevOutputTime = StartTime

    ! ե饰ν
    ! Initialize flag
    !
    flag_output_end = .false.

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    if ( trim(InputFile) /= '' ) then
      call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
    else
      call MessageNotify( 'M', module_name, '  InputFile  = <Non>' )
      call MessageNotify( 'M', module_name, '  ** Initial data is generated in "initial_data" module' )
    end if
    call MessageNotify( 'M', module_name, 'Output:: ' )
    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
    call MessageNotify( 'M', module_name, '  IntTime    = %r [%c]', r = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    restart_file_io_inited = .true.
  end subroutine RestartFileInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited


    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )


  end subroutine InitCheck

end module restart_file_io
