!= ˡˤʬ
!
!= Time integration with implicit scheme
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: phy_implicit.F90,v 1.12 2009-03-17 05:51:28 morikawa Exp $
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_implicit
  !
  != ˡˤʬ
  !
  != Time integration with implicit scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplTendency      :: ѲΨη׻
  ! PhyImplEvalRadLFluxA :: Ĺȥեå
  ! ------------         :: ------------
  ! PhyImplTendency      :: Calculate tendency
  ! PhyImplEvalRadLFluxA :: Longwave flux correction
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: PhyImplTendency, PhyImplEvalRadLFluxA

  ! ѿ
  ! Public variables
  !
  logical, save, public:: phy_implicit_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'phy_implicit'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: phy_implicit.F90,v 1.12 2009-03-17 05:51:28 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface PhyImplTendency
    module procedure PhyImplTendency
  end interface

  interface PhyImplEvalRadLFluxA
    module procedure PhyImplEvalRadLFluxA
  end interface

contains

  subroutine PhyImplTendency( &
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (in)
    & xyr_RadSFlux, xyr_RadLFlux, &                       ! (in)
    & xy_GroundTempFlux, &                                ! (in)
    & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond, &       ! (in)
    & xy_SurfHeatCapacity, &                              ! (in)
    & xyra_DelRadLFlux, &                                 ! (in)
    & xyr_Press, xyz_Exner, xyr_Exner, &                  ! (in)
    & xyr_VelTransCoef, xyr_TempTransCoef, &              ! (in)
    & xyr_QVapTransCoef, &                                ! (in)
    & xy_SurfVelTransCoef, xy_SurfTempTransCoef, &        ! (in)
    & xy_SurfQVapTransCoef, &                             ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyz_DQVapDt, &     ! (out)
    & xy_DSurfTempDt &                                    ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & GasRDry
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! 
    ! Time control
    !
    use timeset, only: TimeN  ! ƥå $ t $ λ. Time of step $ t $. 


    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾׻
    ! Evaluate saturation specific humidity
    !
#ifdef LIB_SATURATE_NHA1992
    use saturate_nha1992, only: CalcQVapSat, CalcDQVapSatDTemp
#elif LIB_SATURATE_T1930
    use saturate_t1930, only: CalcQVapSat, CalcDQVapSatDTemp
#else
    use saturate_t1930, only: CalcQVapSat, CalcDQVapSatDTemp
#endif

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(in):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(in):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(in):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux

    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux

    real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity

    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    real(DP), intent(in):: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP), intent(in):: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xyr_QVapTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

    real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity

    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{q}{t} $ . 漾Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity
    real(DP):: xy_SurfUVMtx (0:imax-1, 1:jmax)
                              ! ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP):: xyaa_SurfTempMtx (0:imax-1, 1:jmax, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP):: xyaa_SurfQVapMtx (0:imax-1, 1:jmax, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface
    real(DP):: xya_SurfRadLMtx (0:imax-1, 1:jmax, -1:1)
                              ! $ T $ .  : ɽ. 
                              ! implicit matrix: surface
    real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
                              ! $ T q $ λѲ. 
                              ! Tendency of $ T q $ 
    real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xy_SurfExner (0:imax-1, 1:jmax)
                              ! Exner ؿ. 
                              ! Exner function
    real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
                              ! ɽ˰漾. 
                              ! Saturated specific humidity on surface
    real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
                              ! ɽ˰漾Ѳ. 
                              ! Saturated specific humidity tendency on surface

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: l               !  DO 롼Ѻѿ
                              ! Work variables for DO loop of matrices

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_inited ) call PhyImplInit

    ! Ĺȱѹλ
    ! Calculate long wave implicit matrix
    !
    xya_SurfRadLMtx(:,:,0)  = xyra_DelRadLFlux(:,:,0,0)
    xya_SurfRadLMtx(:,:,1)  = xyra_DelRadLFlux(:,:,0,1)
    xya_SurfRadLMtx(:,:,-1) = 0.

    ! ˡΤι
    ! Create matrices for implicit scheme
    !
    do k = 1, kmax
      xyza_UVMtx(:,:,k,0)  = &
        & ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) &
        &    / Grav / ( 2. * DelTime )
      xyra_TempMtx(:,:,k,0) = xyza_UVMtx(:,:,k,0) * CpDry
      xyza_QVapMtx(:,:,k,0) = xyza_UVMtx(:,:,k,0) * CpDry
    end do

    xyra_TempMtx(:,:,0,0) = &
      & xy_SurfHeatCapacity(:,:) / ( 2. * DelTime )

    ! ľȻ͢鱢η׻ (®)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
    !
    xyza_UVMtx  (:,:,1,-1) = 0.
    do k = 2, kmax
      xyza_UVMtx(:,:,k, 0) =   xyza_UVMtx(:,:,k,0) &
        &                    + xyr_VelTransCoef(:,:,k-1)
      xyza_UVMtx(:,:,k,-1) = - xyr_VelTransCoef(:,:,k-1)
    end do

    do k = 1, kmax-1
      xyza_UVMtx(:,:,k, 0) =   xyza_UVMtx(:,:,k,0) &
        &                    + xyr_VelTransCoef(:,:,k)
      xyza_UVMtx(:,:,k, 1) = - xyr_VelTransCoef(:,:,k)
    end do
    xyza_UVMtx  (:,:,kmax, 1) = 0.

    ! ľȻ͢鱢η׻ ()
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
    !
    xyra_TempMtx  (:,:,0:1,-1) = 0.
    do k = 2, kmax
      xyra_TempMtx(:,:,  k, 0) =   xyra_TempMtx(:,:,k,0) &
        &                        + CpDry * xyr_TempTransCoef(:,:,k-1) &
        &                            * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k)
      xyra_TempMtx(:,:,  k,-1) = - CpDry * xyr_TempTransCoef(:,:,k-1) &
        &                            * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1)
    end do

    xyra_TempMtx  (:,:,  0, 1) = 0.
    do k = 1, kmax-1
      xyra_TempMtx(:,:,  k, 0) =   xyra_TempMtx(:,:,k,0) &
        &                        + CpDry * xyr_TempTransCoef(:,:,k) &
        &                            * xyr_Exner(:,:,k) / xyz_Exner(:,:,k)
      xyra_TempMtx(:,:,  k, 1) = - CpDry * xyr_TempTransCoef(:,:,k) &
        &                            * xyr_Exner(:,:,k) / xyz_Exner(:,:,k+1)
    end do
    xyra_TempMtx(:,:, kmax, 1) = 0.

    ! ľȻ͢鱢η׻ (漾)
    ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
    !
    xyza_QVapMtx  (:,:,1,-1) = 0.
    do k = 2, kmax
      xyza_QVapMtx(:,:,k, 0) =   xyza_QVapMtx(:,:,k,0) &
        &                      + CpDry * xyr_QVapTransCoef(:,:,k-1)

      xyza_QVapMtx(:,:,k,-1) = - CpDry * xyr_QVapTransCoef(:,:,k-1)
    end do

    do k = 1, kmax-1
      xyza_QVapMtx(:,:,k, 0) =   xyza_QVapMtx(:,:,k,0) &
        &                      + CpDry * xyr_QVapTransCoef(:,:,k)
      xyza_QVapMtx(:,:,k, 1) = - CpDry * xyr_QVapTransCoef(:,:,k)
    end do
    xyza_QVapMtx(:,:,kmax,1) = 0.

    ! Exner ؿ
    ! Calculate Exner functions
    !
    xy_SurfExner = xyz_Exner(:,:,1) / xyr_Exner(:,:,0)

    ! ˰漾η׻
    ! Calculate saturated specific humidity
    !
    do i = 0, imax-1
      do j = 1, jmax
        xy_SurfQVapSat(i,j) = &
          & CalcQVapSat( xy_SurfTemp(i,j), xyr_Press(i,j,0) )
      end do
    end do

    do i = 0, imax-1
      do j = 1, jmax
        xy_SurfDQVapSatDTemp(i,j) = &
          & CalcDQVapSatDTemp( xy_SurfTemp(i,j), xy_SurfQVapSat(i,j) )
      end do
    end do

    ! ɽ̲͢鱢η׻
    ! Calculate implicit matrices from transfer coefficient of surface process
    !
    xyaa_SurfTempMtx(:,:,0,-1) = 0.
    xyaa_SurfTempMtx(:,:,1, 1) = 0.
    xyaa_SurfQVapMtx(:,:,0,-1) = 0.
    xyaa_SurfQVapMtx(:,:,1, 1) = 0.
    
    xy_SurfUVMtx = xy_SurfVelTransCoef
    
    xyaa_SurfTempMtx(:,:,1, 0) =   CpDry * xy_SurfTempTransCoef / xy_SurfExner
    xyaa_SurfTempMtx(:,:,0, 1) = - CpDry * xy_SurfTempTransCoef / xy_SurfExner
    
    xyaa_SurfQVapMtx(:,:,1, 0) =   CpDry * xy_SurfQVapTransCoef * xy_SurfHumidCoef
    xyaa_SurfQVapMtx(:,:,0, 1) = - CpDry * xy_SurfQVapTransCoef * xy_SurfHumidCoef
    
    do i = 0, imax-1
      do j = 1, jmax
        if ( xy_SurfCond(i,j) >= 1 ) then
          
          xyaa_SurfTempMtx(i,j,1,-1) = - CpDry * xy_SurfTempTransCoef(i,j)
          xyaa_SurfTempMtx(i,j,0, 0) =   CpDry * xy_SurfTempTransCoef(i,j)
          
          xyaa_SurfQVapMtx(i,j,1,-1) = &
            & - LatentHeat * xy_SurfQVapTransCoef(i,j) &
            &   * xy_SurfHumidCoef(i,j) * xy_SurfDQVapSatDTemp(i,j)

          xyaa_SurfQVapMtx(i,j,0, 0) = &
            &   LatentHeat * xy_SurfQVapTransCoef(i,j) &
            &   * xy_SurfHumidCoef(i,j) * xy_SurfDQVapSatDTemp(i,j)
          
        else
          xyaa_SurfTempMtx(i,j,1,-1) = 0.
          xyaa_SurfTempMtx(i,j,0, 0) = 0.
          xyaa_SurfQVapMtx(i,j,1,-1) = 0.
          xyaa_SurfQVapMtx(i,j,0, 0) = 0.
        end if
      end do
    end do

    ! ®, ®η׻
    ! Calculate eastward and northward wind
    !
    xyza_UVLUMtx = xyza_UVMtx
    xyza_UVLUMtx(:,:,1,0) = xyza_UVLUMtx(:,:,1,0) + xy_SurfUVMtx
    
    call PhyImplLUDecomp3( &
      & xyza_UVLUMtx, &     ! (inout)
      & imax * jmax, kmax ) ! (in)
    
    do k = 1, kmax
      xyz_DUDt(:,:,k) = xyr_UFlux(:,:,k-1) - xyr_UFlux(:,:,k)
      xyz_DVDt(:,:,k) = xyr_VFlux(:,:,k-1) - xyr_VFlux(:,:,k)
    end do

    call PhyImplLUSolve3( &
      & xyz_DUDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    call PhyImplLUSolve3( &
      & xyz_DVDt, &            ! (inout)
      & xyza_UVLUMtx, &        ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    ! ٤漾η׻
    ! Calculate temperature and specific humidity
    !
    do l = -1, 1
      
      do k = 1, kmax
        xyza_TempQVapLUMtx(:,:,k,l)   = xyra_TempMtx(:,:,k,l)
        xyza_TempQVapLUMtx(:,:,-k,-l) = xyza_QVapMtx(:,:,k,l)
      end do
      
      xyza_TempQVapLUMtx(:,:, 1, l) =   xyra_TempMtx(:,:,1,l) &
        &                             + xyaa_SurfTempMtx(:,:,1,l)

      xyza_TempQVapLUMtx(:,:,-1,-l) =   xyza_QVapMtx(:,:,1,l) &
        &                             + xyaa_SurfQVapMtx(:,:,1,l)
      
    end do
    
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          xyza_TempQVapLUMtx(i,j,0, 0) =   xyra_TempMtx(i,j,0,0) &
            &                            + xyaa_SurfTempMtx(i,j,0,0) &
            &                            + xyaa_SurfQVapMtx(i,j,0,0) &
            &                            + xya_SurfRadLMtx(i,j,0)
          
          xyza_TempQVapLUMtx(i,j,0, 1) =   xyaa_SurfTempMtx(i,j,0,1) &
            &                            + xya_SurfRadLMtx(i,j,1)
          
          xyza_TempQVapLUMtx(i,j,0,-1) =  xyaa_SurfQVapMtx(i,j,0,1)
        else
          xyza_TempQVapLUMtx(i,j,0, 0) = 1.
          xyza_TempQVapLUMtx(i,j,0, 1) = 0.
          xyza_TempQVapLUMtx(i,j,0,-1) = 0.
        end if
      end do
    end do

    
    call PhyImplLUDecomp3( &
      & xyza_TempQVapLUMtx, &         ! (inout)
      & imax * jmax, (2 * kmax) + 1 ) ! (in)
    
    do k = 1, kmax
      xyz_DelTempQVap(:,:, k) = xyr_TempFlux(:,:,k-1) - xyr_TempFlux(:,:,k)
      xyz_DelTempQVap(:,:,-k) = xyr_QVapFlux(:,:,k-1) - xyr_QVapFlux(:,:,k)
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          xyz_DelTempQVap(i,j,0) = &
            & - xyr_RadSFlux(i,j,0) - xyr_RadLFlux(i,j,0) &
            & - xyr_TempFlux(i,j,0) - xyr_QVapFlux(i,j,0) &
            & + xy_GroundTempFlux(i,j)
        else
          xyz_DelTempQVap(i,j,0) = 0.
        end if
      end do
    end do

    call PhyImplLUSolve3( &
      & xyz_DelTempQVap, &                ! (inout)
      & xyza_TempQVapLUMtx, &             ! (in)
      & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)

    ! ѲΨη׻
    ! Calculate tendency
    !
    do k = 1, kmax
      xyz_DUDt(:,:,k)    = xyz_DUDt(:,:,k)         / ( 2. * DelTime )
      xyz_DVDt(:,:,k)    = xyz_DVDt(:,:,k)         / ( 2. * DelTime )
      xyz_DTempDt(:,:,k) = xyz_DelTempQVap(:,:, k) / ( 2. * DelTime )
      xyz_DQVapDt(:,:,k) = xyz_DelTempQVap(:,:,-k) / ( 2. * DelTime ) / LatentHeat * CpDry
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfCond(i,j) >= 1 ) then
          xy_DSurfTempDt(i,j) = xyz_DelTempQVap(i,j,0) / ( 2. * DelTime )
        else
          xy_DSurfTempDt(i,j) = 0.
        end if
      end do
    end do

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplTendency

  !-------------------------------------------------------------------

  subroutine PhyImplEvalRadLFluxA( &
    & xyr_RadLFlux, &                                  ! (in)
    & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
    & xyr_RadLFluxA &                                  ! (out)
    & )
    !
    ! $ t-\Delta t $ ˤѲΨ򸵤, 
    ! $ t+\Delta t $ Ĺȥեå (xyr_RadLFluxA) 򻻽Фޤ. 
    ! 
    ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA) 
    ! from the tendency at $ t-\Delta t $ . 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP), intent(out):: xyr_RadLFluxA (0:imax-1, 1:jmax, 0:kmax)
                              ! $ t-\Delta t $ ˤѲΨ򸵤
                              ! Ф줿 $ t+\Delta t $ ˤ
                              ! Ĺȥեå. 
                              !
                              ! Longwave flux at $ t+\Delta t $ 
                              ! calculated from the tendency at 
                              ! $ t-\Delta t $ . 

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_inited ) call PhyImplInit

    ! $ t+\Delta t $ Ĺȥեå (xyr_RadLFluxA) 򻻽
    ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA)
    !
    do k = 0, kmax
      xyr_RadLFluxA(:,:,k) = &
        &   xyr_RadLFlux(:,:,k) &
        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &   * 2. * DelTime
    end do

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplEvalRadLFluxA

  !-------------------------------------------------------------------

  subroutine PhyImplLUDecomp3( &
    & jna_LUMtx, &            ! (inout)
    & JDim, NDim &            ! (in)
    & )
    !
    ! 3 гѹ LU ʬԤޤ. 
    !
    ! LU decomposition of triple diagonal matrix.
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(inout):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix

    ! ѿ
    ! Work variables
    ! 
    integer:: j, n            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! LU ʬ
    ! LU decomposition
    !
    do j = 1, JDim
      jna_LUMtx(j,1,1) = jna_LUMtx(j,1,1) / jna_LUMtx(j,1,0)
    end do

    do n = 2, NDim-1
      do j = 1, JDim
        jna_LUMtx(j,n,0)  =   jna_LUMtx(j,n,0) &
          &                 - jna_LUMtx(j,n,-1) * jna_LUMtx(j,n-1,1)

        jna_LUMtx(j,n,1)  =   jna_LUMtx(j,n,1) / jna_LUMtx(j,n,0)
      end do
    end do

    do j = 1, JDim
      jna_LUMtx(j,NDim,0) =   jna_LUMtx(j,NDim, 0) &
        &                   - jna_LUMtx(j,NDim,-1) * jna_LUMtx(j,NDim-1,1)
    end do

  end subroutine PhyImplLUDecomp3

  !-------------------------------------------------------------------

  subroutine PhyImplLUSolve3( &
    & ijn_Vector, &       ! (inout)
    & jna_LUMtx, &        ! (in)
    & IDim, JDim, NDim &  ! (in)
    & )
    !
    ! LU ʬˤη׻ (3гѹ) Ԥޤ.
    !
    ! Solve with LU decomposition (For triple diagonal matrix). 
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: IDim
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(in):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP), intent(inout):: ijn_Vector(IDim, JDim, NDim)
                              ! ե٥ȥ / . 
                              ! Right-hand side vector / solution

    ! ѿ
    ! Work variables
    ! 
    integer:: i, j, n         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Forward substitution
    !
    do i = 1, IDim
      do j = 1, JDim
        ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMtx(j,1,0)
      end do
    end do

    do n = 2, NDim
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) = (   ijn_Vector(i,j,n) &
            &                   - ijn_Vector(i,j,n-1) * jna_LUMtx(j,n,-1) &
            &                  ) / jna_LUMtx(j,n,0)
        end do
      end do
    end do

    ! 
    ! Backward substitution
    !
    do n = NDim-1, 1, -1
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) =   ijn_Vector(i,j,n) &
            &                 - ijn_Vector(i,j,n+1) * jna_LUMtx(j,n,1)
        end do
      end do
    end do

  end subroutine PhyImplLUSolve3

  !-------------------------------------------------------------------

  subroutine PhyImplInit
    !
    ! phy_implicit ⥸塼νԤޤ. 
    ! NAMELIST#phy_implicit_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "phy_implicit" module is initialized. 
    ! "NAMELIST#phy_implicit_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /phy_implicit_nml/
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "phy_implicit#PhyImplInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( phy_implicit_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = phy_implicit_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    phy_implicit_inited = .true.
  end subroutine PhyImplInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module phy_implicit
