!= ͥեå (Хɥǥ)
!
!= Radiation flux (band model)
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: radiation_band.F90,v 1.1 2009-03-18 07:58:11 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module radiation_band
  !
  != ͥեå (Хɥǥ)
  !
  != Radiation flux (band model)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , 漾, , ͥեå׻
  ! ХɥǥǤ. 
  !
  ! This is a band model that calculates radiation flux from
  ! temperature, specific humidity, and air pressure.
  !
  !== Procedures List
  !
  ! RadiationFlux       :: ͥեåη׻
  ! RadiationDTempDt    :: ͥեåˤ벹Ѳη׻
  ! RadiationFluxOutput :: ͥեåν
  ! RadiationFinalize   :: λ (⥸塼ѿγդ)
  ! ------------        :: ------------
  ! RadiationFlux       :: Calculate radiation flux
  ! RadiationDTempDt    :: Calculate temperature tendency with radiation flux
  ! RadiationFluxOutput :: Output radiation fluxes
  ! RadiationFinalize   :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#radiation_band_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: &
    & RstFileIntValue => IntValue, &
                              ! ꥹȥǡνϴֳ (). 
                              ! Interval of restart data output (numerical value)
    & RstFileIntUnit  => IntUnit, &
                              ! ꥹȥǡνϴֳ (ñ). 
                              ! Interval of restart data output (unit)
    & RstFileIntTime  => IntTime
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ꥹȥǡ
  ! Restart data output
  !
  use gtool_history, only: GT_HISTORY

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RadiationFlux, RadiationDTempDt, RadiationFluxOutput, RadiationFinalize

  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_band_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  logical, save:: Old_Flux_saved = .false.
                              ! ٷ׻եå¸Ȥ򼨤ե饰. 
                              ! Flag for saving of flux calculated once

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gtool_history#GT_HISTORY ѿ. 
                              ! "gtool_history#GT_HISTORY" variable for restart data
  type(DC_DIFFTIME), save:: PrevRstOutputTime
                              ! Υꥹȥեνϻ. 
                              ! Previous output time of a restart file
  logical, save:: flag_rst_output_end
                              ! ׻ǽνϴλΥե饰. 
                              ! Flag for completion of output at the end time of calculation

  ! ĹȥեåѾ
  ! Information for long wave flux
  !
  type(DC_DIFFTIME), save:: IntTimeLong
                              ! Ĺȥեå׻ֳִ. 
                              ! Interval time of long wave flux calculation
  type(DC_DIFFTIME), save:: PrevTimeLong
                              ! Ĺȥեå׻. 
                              ! Time when long wave flux is calculated
  real(DP), save:: DelTimeLongValue
                              ! Ĺȥեå׻ֳִ֤ο. 
                              ! Value of interval step of long wave flux calculation
  character(STRING), save:: DelTimeLongUnit
                              ! Ĺȥեå׻ֳִ֤ñ. 
                              ! Unit of interval step of long wave flux calculation

  integer, save:: LongBandNum
                              ! ĹȥХɿ. 
                              ! Number of long wave band
  real(DP), save:: LongAbsorpCoefQVap (1:MaxNmlArySize)
                              ! $ k_R $ . εۼ. 
                              ! Absorption coefficient of water. 
  real(DP), save:: LongAbsorpCoefDryAir (1:MaxNmlArySize)
                              ! $ \bar{k}_R $ . εۼ. 
                              ! Absorption coefficient of air. 
  real(DP), save:: LongBandWeight (1:MaxNmlArySize)
                              ! Хɥ. 
                              ! Band weight. 
  real(DP), save:: LongPathLengthFact
                              ! ϩĹΥե. 
                              ! Factor of optical length

  real(DP), allocatable, save:: xy_TempSave (:,:)
                              ! $ T $ .      (¸). Temperature (for save)
  real(DP), allocatable, save:: xyr_RadLFluxSave (:,:,:)
                              ! Ĺȥեå (¸). 
                              ! Long wave flux (for save)
  real(DP), allocatable, save:: xyra_DelRadLFluxSave (:,:,:,:)
                              ! ĹɽѲ (¸). 
                              ! Long wave flux tendency with surface temperature (for save)

  ! ûȥեåѾ
  ! Information for short wave flux
  !
  type(DC_DIFFTIME), save:: IntTimeShort
                              ! ûȥեå׻ֳִ. 
                              ! Interval time of short wave flux calculation
  type(DC_DIFFTIME), save:: PrevTimeShort
                              ! ûȥեå׻
                              ! Time when short wave flux is calculated
  real(DP), save:: DelTimeShortValue
                              ! û () եå׻ֳִ֤ο. 
                              ! Value of interval step of short wave (insolation) flux calculation
  character(STRING), save:: DelTimeShortUnit
                              ! û () եå׻ֳִ֤ñ. 
                              ! Unit of interval step of short wave (insolation) flux calculation

  integer, save:: ShortBandNum
                              ! ûȥХɿ. 
                              ! Number of short wave band
  real(DP), save:: ShortAbsorpCoefQVap (1:MaxNmlArySize)
                              ! $ k_S $ . εۼ. 
                              ! Absorption coefficient of water. 
  real(DP), save:: ShortAbsorpCoefDryAir (1:MaxNmlArySize)
                              ! $ \bar{k}_S $ . εۼ. 
                              ! Absorption coefficient of air. 
  real(DP), save:: ShortBandWeight (1:MaxNmlArySize)
                              ! Хɥ. 
                              ! Band weight. 
  real(DP), save:: ShortSecScat
                              !  $ \sec \zeta $ .
                              ! $ \sec \zeta $ of scattering

  real(DP), allocatable, save:: xyr_RadSFluxSave (:,:,:)
                              ! û () եå (¸). 
                              ! Short wave (insolation) flux (for save)

  ! ûѾ
  ! Information for short wave incoming
  !
  real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux
  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)


  character(*), parameter:: module_name = 'radiation_band'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: radiation_band.F90,v 1.1 2009-03-18 07:58:11 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface RadiationFlux
    module procedure RadiationFlux
  end interface

  interface RadiationDTempDt
    module procedure RadiationDTempDt
  end interface

  interface RadiationFluxOutput
    module procedure RadiationFluxOutput
  end interface

  interface RadiationFinalize
    module procedure RadiationFinalize
  end interface

contains

  subroutine RadiationFlux( &
    & xyz_Temp, xyz_QVap, xyr_Press, &   ! (in)
    & xy_SurfTemp, xy_SurfAlbedo, &      ! (in)
    & xyr_RadLFlux, xyr_RadSFlux, &      ! (out)
    & xyra_DelRadLFlux, &                ! (out)
    & flag_rst &                         ! (in) optional
    & )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! û ()
    ! Short wave (insolation) incoming
    !
    use radiation_short_income, only: ShortIncoming
!    use radiation_short_income_sr, only: ShortIncoming

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime, &            ! ׻λ. 
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    ! ꥹȥǡ
    ! Restart data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: operator(-), operator(>=), operator(+), &
      & operator(==), toChar, EvalByUnit

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub, Debug

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo

    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(out):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Long wave flux tendency with surface temperature (for save)
    logical, intent(in), optional:: flag_rst
                              ! ꥹȤǤ뤳Ȥ򼨤ե饰. 
                              ! .true. Ϳ, 
                              ! Ĺ, ûͤ˴ؤꥹ
                              ! ե뤬ɬפˤʤޤ. 
                              ! ꥹȥե˴ؤ
                              ! NAMELIST#radiation_band_nml
                              ! ǻꤵޤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! Flag for restart. 
                              ! If .true. is given, 
                              ! a restart file for long radiation 
                              ! and short radiation is needed. 
                              ! Information about the restart file 
                              ! is specified by "NAMELIST#radiation_band_nml".
                              ! Default value is .false.
                              ! 

    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_TauQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of water 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of water
                              ! 
    real(DP):: xyr_TauDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of air 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of air
                              ! 

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    character(STRING):: str_debug
                              ! ǥХåѿ
                              ! Variable for debug
    logical:: flag_rst_output
                              ! ꥹȥեϤΥե饰. 
                              ! Flag for output of a restart file

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. radiation_band_inited ) call RadiationInit( flag_rst )

    ! ŪۼǳäΤη׻
    ! Calculate optical depth divided by absorption coefficient
    !
    xyr_TauQVap  (:,:,kmax) = 0.
    xyr_TauDryAir(:,:,kmax) = 0.

    do k = kmax-1, 0, -1
      xyr_TauQVap(:,:,k) = &
        &   xyr_TauQVap(:,:,k+1) &
        & + xyz_QVap(:,:,k+1) &
        &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav

      xyr_TauDryAir(:,:,k) = &
        &   xyr_TauDryAir(:,:,k+1) &
        & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do

    ! Ĺȥեåλ
    ! Calculate long wave flux
    !
    if ( TimeN - PrevTimeLong >= IntTimeLong .or. .not. Old_Flux_saved ) then

      if ( .not. Old_Flux_saved ) then
        PrevTimeLong = TimeN
      else
        PrevTimeLong = PrevTimeLong + IntTimeLong
      end if

      if ( Debug() ) then
        str_debug = toChar(TimeN)
        call DbgMessage( '%c: LongFlux is calculated at %c', &
          & c1 = module_name, c2 = trim(str_debug) )
      end if

      call LongFlux( &
        & xyz_Temp, xy_SurfTemp, xyr_TauQVap, xyr_TauDryAir, & ! (in)
        & xyr_RadLFlux, xyra_DelRadLFlux )                     ! (out)

    ! ͤ
    ! Use values in last time
    !
    else

      if ( Debug() ) then
        str_debug = toChar(TimeN)
        call DbgMessage( &
          & '%c: LongFlux is not calculated at %c. Save values are used.', &
          & c1 = module_name, c2 = trim(str_debug) )
      end if

      xyr_RadLFlux = xyr_RadLFluxSave
      xyra_DelRadLFlux = xyra_DelRadLFluxSave
      
      do k = 0, kmax
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & + xyra_DelRadLFlux(:,:,k,1) &
          &     * ( xyz_Temp(:,:,1) - xy_TempSave )

        xyra_DelRadLFlux(:,:,k,1) = &
          &   xyra_DelRadLFlux(:,:,k,1) &
          &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
      end do
    end if

    ! û () եåλ
    ! Calculate short wave (insolation)
    !
    if ( TimeN - PrevTimeShort >= IntTimeShort .or. .not. Old_Flux_saved ) then

      if ( .not. Old_Flux_saved ) then
        PrevTimeShort = TimeN
      else
        PrevTimeShort = PrevTimeShort + IntTimeShort
      end if

      if ( Debug() ) then
        str_debug = toChar(TimeN)
        call DbgMessage( &
          & '%c: ShortFlux is calculated at %c', &
          & c1 = module_name, c2 = trim(str_debug) )
      end if

      ! ûͤη׻
      ! Calculate short wave (insolation) incoming radiation
      !
      call ShortIncoming( &
        & xy_IncomRadSFlux, xy_InAngle ) ! (out)

      ! ûȥեåη׻
      ! Calculate short wave (insolation) flux
      !
      xyr_RadSFlux(:,:,0:kmax-1) = 0.
      xyr_RadSFlux(:,:,  kmax  ) = xy_IncomRadSFlux

      call ShortFlux( &
        & xyr_TauQVap, xyr_TauDryAir, xy_SurfAlbedo, & ! (in)
        & xyr_RadSFlux )                               ! (inout)

    ! ͤ
    ! Use values in last time
    ! 
    else

      if ( Debug() ) then
        str_debug = toChar(TimeN)
        call DbgMessage( &
          & '%c: ShortFlux is not calculated at %c. Save values are used.', &
          & c1 = module_name, c2 = trim(str_debug) )
      end if

      xyr_RadSFlux = xyr_RadSFluxSave
    end if


    ! ׻ͤ¸
    ! Save calculated values in this time
    !
    xy_TempSave          = xyz_Temp (:,:,1)
    xyr_RadLFluxSave     = xyr_RadLFlux
    xyr_RadSFluxSave     = xyr_RadSFlux
    xyra_DelRadLFluxSave = xyra_DelRadLFlux

    if ( .not. Old_Flux_saved ) Old_Flux_saved = .true.

    ! ꥹȥեνϥߥ󥰤Υå
    ! Check output timing of a restart file
    !
    flag_rst_output = TimeN - PrevRstOutputTime >= RstFileIntTime
    if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
      flag_rst_output = .true.
      flag_rst_output_end = .true.
    end if
    flag_rst_output = ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output

    if ( flag_rst_output ) then
      ! Ѥ, ν (˾)  ¸
      ! Save output time (expected) in this time, for next time
      !
      PrevRstOutputTime = PrevRstOutputTime + RstFileIntTime
      
      ! 
      ! Set time
      !
      call HistorySetTime( difftime = TimeN, history = gthst_rst )

      ! ǡ
      ! Data output
      !
      call HistoryPut( &
        & 'PrevTimeLong', EvalByUnit(PrevTimeLong, DelTimeLongUnit), & ! (in)
        & history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'PrevTimeShort', EvalByUnit(PrevTimeShort, DelTimeShortUnit), & ! (in)
        & history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'SurfTemp', xy_TempSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadLFlux', xyr_RadLFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'RadSFlux', xyr_RadSFluxSave, history = gthst_rst ) ! (in)
      call HistoryPut( &
        & 'DelRadLFlux', xyra_DelRadLFluxSave, history = gthst_rst ) ! (in)

    end if

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadiationFlux

  !-------------------------------------------------------------------

  subroutine RadiationDTempDt( &
    & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
    & xyz_DTempDtRadL, xyz_DTempDtRadS &       ! (out)
    & )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    ! 
    ! Temperature tendency with radiation is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav, &  ! $ g $ [m s-2]. 
                                  ! ϲ®. 
                                  ! Gravitational acceleration
      &                  CpDry    ! $ C_p $ [J kg-1 K-1]. 
                                  ! 絤갵Ǯ. 
                                  ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. radiation_band_inited ) call RadiationInit

    ! Ψα黻
    ! Calculate radiation cooling rate
    !
    do k = 1, kmax
      xyz_DTempDtRadL(:,:,k) = &
        & (     xyr_RadLFlux(:,:,k-1) - xyr_RadLFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav

      xyz_DTempDtRadS(:,:,k) = &
        & (     xyr_RadSFlux(:,:,k-1) - xyr_RadSFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav
    end do

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadiationDTempDt

  !-------------------------------------------------------------------

  subroutine LongFlux( &
    & xyz_Temp, xy_SurfTemp, xyr_TauQVap, xyr_TauDryAir, & ! (in)
    & xyr_RadLFlux, xyra_DelRadLFlux &                     ! (out)
    & )
    !
    ! Ĺȥեåη׻
    !
    ! Calculate long wave flux
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: StB  ! $ \sigma_{SB} $ . 
                              ! ƥեܥĥޥ. 
                              ! Stefan-Boltzmann constant

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature

    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyr_TauQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of water 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of water
                              ! 
    real(DP), intent(in):: xyr_TauDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of air 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of air
                              ! 
    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave

    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_Trans (0:imax-1, 1:jmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP):: xyr_Trans1 (0:imax-1, 1:jmax, 0:kmax)
                              ! 1/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 1/2 level
    real(DP):: xyr_Trans2 (0:imax-1, 1:jmax, 0:kmax)
                              ! 3/2 ٥뤫Ʃ᷸. 
                              ! Transmission coefficient above 3/2 level
    real(DP):: xyz_PiB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \pi B = \sigma T^{4} $
    real(DP):: xy_SurfPiB (0:imax-1, 1:jmax)
                              ! ɽ̤ $ \pi B $ . 
                              ! $ \pi B $ on surface

    real(DP):: BandWeightSum  ! ХɥȤ
                              ! Sum of band weights

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: bn              ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands

    ! ¹ʸ ; Executable statement
    !

    ! ХɥȤ
    ! Configure band weight
    !
    BandWeightSum = 0.

    do bn = 1, LongBandNum
      BandWeightSum =  BandWeightSum + LongBandWeight(bn)
    end do

    do bn = 1, LongBandNum
      LongBandWeight(bn) = LongBandWeight(bn) / BandWeightSum
    end do

    ! $ \pi B $ η׻
    ! Calculate $ \pi B $
    !
    xyz_PiB    = StB * ( xyz_Temp**4 )
    xy_SurfPiB = StB * ( xy_SurfTemp**4 )

    do k = 0, kmax

      ! Ʃؿ׻
      ! Calculate transmission functions
      !
      xyr_Trans = 0.
      
      do bn = 1, LongBandNum
        do kk = 0, kmax
          xyr_Trans(:,:,kk) = &
            &   xyr_Trans(:,:,kk) &
            & + LongBandWeight(bn) &
            &   * exp( - LongPathLengthFact &
            &            * (   LongAbsorpCoefQVap(bn) &
            &                  * abs(   xyr_TauQVap(:,:,kk) &
            &                         - xyr_TauQVap(:,:,k)  ) &
            &                + LongAbsorpCoefDryAir(bn) &
            &                  * abs(   xyr_TauDryAir(:,:,kk) &
            &                         - xyr_TauDryAir(:,:,k)  ) ) )
        end do
      end do

      ! ͥեå׻
      ! Calculate radiation flux
      !
      xyr_RadLFlux(:,:,k) = xy_SurfPiB * xyr_Trans(:,:,0)

      do kk = 0, kmax-1
        xyr_RadLFlux(:,:,k) = &
          &   xyr_RadLFlux(:,:,k) &
          & - xyz_PiB(:,:,kk+1) * ( xyr_Trans(:,:,kk) - xyr_Trans(:,:,kk+1) )
      end do

      ! ׻Ʃؿ׻
      ! Calculate transmission functions for correction terms
      !
      xyr_Trans1(:,:,k) = xyr_Trans(:,:,0)
      xyr_Trans2(:,:,k) = xyr_Trans(:,:,1)

    end do

    ! ĹɽѲη׻
    ! Calclate surface temperature tendency with long wave
    !
    do k = 0, kmax
      xyra_DelRadLFlux(:,:,k,0) = &
        & 4.0_DP * xy_SurfPiB / xy_SurfTemp * xyr_Trans1(:,:,k)

      xyra_DelRadLFlux(:,:,k,1) = &
        & 4.0_DP * xyz_PiB(:,:,1) / xyz_Temp(:,:,1) &
        &   * ( xyr_Trans2(:,:,k) - xyr_Trans1(:,:,k) )
    end do

  end subroutine LongFlux

  !-------------------------------------------------------------------

  subroutine ShortFlux( &
    & xyr_TauQVap, xyr_TauDryAir, xy_SurfAlbedo, & ! (in)
    & xyr_RadSFlux &                               ! (inout)
    & )
    !
    ! ûȥեå׻ޤ.
    !
    ! Calculate short wave flux. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_TauQVap (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho q \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of water 
                              ! $ \tau = \int_z^{\infty} k \rho q \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of water
                              ! 
    real(DP), intent(in):: xyr_TauDryAir (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \int_z^{\infty} \rho \, dz $ . 
                              ! ˴ؤŪ 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! ۼ $ k $ ( $ z $ ˵餺) 
                              ! ǳä.
                              ! 
                              ! Optical depth of air 
                              ! $ \tau = \int_z^{\infty} k \rho \, dz $
                              ! divided by absorption coefficient $ k $ 
                              ! (this does not depend to height $ z $
                              ! and constant) of air
                              ! 
    real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(inout):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux

    ! ѿ
    ! Work variables
    !
    real(DP):: BandWeightSum  ! ХɥȤ
                              ! Sum of band weights
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: bn              ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands

    ! ¹ʸ ; Executable statement
    !

    ! ХɥȤ
    ! Configure band weight
    !
    BandWeightSum = 0.

    do bn = 1, ShortBandNum
      BandWeightSum = BandWeightSum + ShortBandWeight(bn)
    end do

    do bn = 1, ShortBandNum
      ShortBandWeight(bn) = ShortBandWeight(bn) / BandWeightSum
    end do

    do bn = 1, ShortBandNum
      do k = 0, kmax

        ! ƥ٥ǤβƩ
        ! Downward transmission on each level
        !
        if ( k /= kmax ) then
          xyr_RadSFlux(:,:,k) = &
            &   xyr_RadSFlux(:,:,k) & 
            & + ShortBandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
            &   * exp( - xy_InAngle(:,:) &
            &            * (   ShortAbsorpCoefQVap(bn) * xyr_TauQVap(:,:,k) &
            &                + ShortAbsorpCoefDryAir(bn) * xyr_TauDryAir(:,:,k) ) &
            &       )
        end if
        
        ! ƥ٥ǤξƩ
        ! Upward transmission on each level
        !
        xyr_RadSFlux(:,:,k) = &
          &   xyr_RadSFlux(:,:,k) & 
          & - ShortBandWeight(bn) * xyr_RadSFlux(:,:,kmax) &
          &   * exp( - xy_InAngle(:,:) &
          &            * (   ShortAbsorpCoefQVap(bn) * xyr_TauQVap(:,:,0) &
          &                + ShortAbsorpCoefDryAir(bn) * xyr_TauDryAir(:,:,0) ) &
          &       ) &
          &   * xy_SurfAlbedo &
          &   * exp( - ShortSecScat &
          &            * (   ShortAbsorpCoefQVap(bn) &
          &                  * ( xyr_TauQVap(:,:,0) - xyr_TauQVap(:,:,k) ) &
          &                + ShortAbsorpCoefDryAir(bn) &
          &                  * ( xyr_TauDryAir(:,:,0) - xyr_TauDryAir(:,:,k) ) &
          &              ) &
          &        )
      end do
    end do

    ! ۼʤξ
    ! In the case of no absorption
    !
    if ( ShortBandNum == 0 ) then
      do k = 0, kmax
        xyr_RadSFlux(:,:,k) = &
          & ( 1.0_DP - xy_SurfAlbedo ) * xyr_RadSFlux(:,:,kmax)
      end do
    end if

  end subroutine ShortFlux

  !-------------------------------------------------------------------

  subroutine RadiationFluxOutput( &
    & xyr_RadSFlux, xyr_RadLFlux, &      ! (in)
    & xyra_DelRadLFlux, xy_DSurfTempDt & ! (in)
    & )
    !
    ! ͥեå (xyr_RadSFlux, xyr_RadLFlux) 
    ! ˤĤ, ¾ΰѤ, ϤԤ. 
    !
    ! Radiation fluxes (xyr_RadSFlux, xyr_RadLFlux) are
    ! corrected by using other arguments, and the corrected values are output.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency

    ! ϤΤκѿ
    ! Work variables for output
    !
    real(DP):: xyr_RadLFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! 줿Ĺȥեå. 
                              ! Corrected longwave flux

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. radiation_band_inited ) call RadiationInit

    ! Ĺȥեå ( ɽեåʬ )
    ! Correct longwave flux ( amount of surface flux )
    !
    do k = 0, kmax
      xyr_RadLFluxCor (:,:,k) = &
        &     xyr_RadLFlux (:,:,k) &
        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * DelTime
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLR', xyr_RadLFluxCor(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLR', xyr_RadLFluxCor(:,:,0) )
    call HistoryAutoPut( TimeN, 'OSR', xyr_RadSFlux(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSR', xyr_RadSFlux(:,:,0) )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadiationFluxOutput

  !-------------------------------------------------------------------

  subroutine RadiationInit( flag_rst )
    !
    ! radiation_band ⥸塼νԤޤ. 
    ! NAMELIST#radiation_band_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "radiation_band" module is initialized. 
    ! "NAMELIST#radiation_band_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: &
      & StartTime             ! ׻ϻ. 

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: DCDiffTimeCreate, EvalByUnit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use gtool_history, only: HistoryCreate, HistoryAddAttr, &
      & HistoryAddVariable, HistoryPut, &
      & HistoryGet, HistoryGetAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    implicit none
    logical, intent(in), optional:: flag_rst
                              ! ꥹȤǤ뤳Ȥ򼨤ե饰. 
                              ! .true. Ϳ, 
                              ! Ĺ, ûͤ˴ؤꥹ
                              ! ե뤬ɬפˤʤޤ. 
                              ! ꥹȥե˴ؤ
                              ! NAMELIST#radiation_band_nml
                              ! ǻꤵޤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! Flag for restart. 
                              ! If .true. is given, 
                              ! a restart file for long radiation 
                              ! and short radiation is needed. 
                              ! Information about the restart file 
                              ! is specified by "NAMELIST#radiation_band_nml".
                              ! Default value is .false.
                              ! 

    character(STRING):: RstInputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of input restart data

    character(STRING):: RstOutputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of output restart data
    character(STRING):: time_range
                              ! λ. 
                              ! Specification of time

    real(DP):: PrevTimeLongValue
                              ! Ĺȥեå׻ ()
                              ! Time (numerical value) when long wave flux is calculated
    character(STRING):: PrevTimeLongUnit
                              ! Ĺȥեå׻ (ñ)
                              ! Time (unit) when long wave flux is calculated
    real(DP):: PrevTimeShortValue
                              ! Ĺȥեå׻ ()
                              ! Time (numerical value) when long wave flux is calculated
    character(STRING):: PrevTimeShortUnit
                              ! Ĺȥեå׻ (ñ)
                              ! Time (unit) when long wave flux is calculated

    character(TOKEN):: dummy_str
                              ! ϥåѤΥߡѿ
                              ! Dummy variable for check of input
    logical:: get_err
                              ! ϻΥ顼ե饰. 
                              ! Error flag for input

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    character(STRING):: title_msg
                              ! ɽղäå. 
                              ! Message added to title

    real:: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation
    character(12):: time_unit
                              ! ñ. Units of date and time

    logical:: flag_mpi_init
#ifdef LIB_MPI
    integer:: err_mpi
#endif

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /radiation_band_nml/ &
      & DelTimeLongValue, DelTimeLongUnit, &
      & DelTimeShortValue, DelTimeShortUnit, &
!
      & LongBandNum, &
      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
      & LongBandWeight, LongPathLengthFact, &
!
      & ShortBandNum, &
      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
      & ShortBandWeight, ShortSecScat, &
!
      & RstInputFile, RstOutputFile
          !
          ! ǥեͤˤĤƤϽ³ "radiation_band#RadiationInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_band#RadiationInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( radiation_band_inited ) return
    call InitCheck

#ifdef LIB_MPI
    ! MPI ˤԤƤ뤫ǧ. 
    ! Confirm initialization of MPI
    !
    call MPI_Initialized(flag_mpi_init, err_mpi)
#else
    flag_mpi_init = .false.
#endif

    ! ǥեͤ
    ! Default values settings
    !

    ! ĹȥեåѾ
    ! Information for long wave flux
    !
    PrevTimeLong = StartTime

    DelTimeLongValue = 3.0_DP
    DelTimeLongUnit  = 'hrs.'

    LongBandNum      = 4
    LongAbsorpCoefQVap     = -999.9_DP
    LongAbsorpCoefDryAir   = -999.9_DP
    LongBandWeight         = -999.9_DP
    LongAbsorpCoefQVap    (1:LongBandNum) = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
    LongAbsorpCoefDryAir  (1:LongBandNum) = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
    LongBandWeight        (1:LongBandNum) = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
    LongPathLengthFact = 1.5_DP

    ! ûȥեåѾ
    ! Information for short wave flux
    !
    PrevTimeShort = StartTime

    DelTimeShortValue = 1.0_DP
    DelTimeShortUnit  = 'hrs.'

    ShortBandNum = 1
    ShortAbsorpCoefQVap    = -999.9_DP
    ShortAbsorpCoefDryAir  = -999.9_DP
    ShortBandWeight        = -999.9_DP
    ShortAbsorpCoefQVap   (1:ShortBandNum) = (/ 0.002_DP /)
    ShortAbsorpCoefDryAir (1:ShortBandNum) = (/ 0.0_DP /)
    ShortBandWeight       (1:ShortBandNum) = (/ 1.0_DP /)
    ShortSecScat = 1.66_DP

    ! ꥹȥե
    ! Information about a restart file
    !
    RstInputFile  = ''
    RstOutputFile = 'rst_rad.nc'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = radiation_band_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ֳִ֤ν
    ! Handle interval time
    !
    call DCDiffTimeCreate( IntTimeLong, &     ! (out)
      & DelTimeLongValue, DelTimeLongUnit )   ! (in)
    call DCDiffTimeCreate( IntTimeShort, &    ! (out)
      & DelTimeShortValue, DelTimeShortUnit ) ! (in)

    ! Хɿ, ۼ, ХɥȤΥå
    ! Check number of band, absorption coefficients, band weight
    !
    call NmlutilAryValid( module_name, &            ! (in)
      & LongAbsorpCoefQVap, 'LongAbsorpCoefQVap', & ! (in)
      & LongBandNum,        'LongBandNum' )         ! (in)

    call NmlutilAryValid( module_name, &                ! (in)
      & LongAbsorpCoefDryAir, 'LongAbsorpCoefDryAir', & ! (in)
      & LongBandNum,          'LongBandNum' )           ! (in)

    call NmlutilAryValid( module_name, &     ! (in)
      & LongBandWeight, 'LongBandWeight', &  ! (in)
      & LongBandNum,    'LongBandNum' )      ! (in)

    call NmlutilAryValid( module_name, &              ! (in)
      & ShortAbsorpCoefQVap, 'ShortAbsorpCoefQVap', & ! (in)
      & ShortBandNum,        'ShortBandNum' )         ! (in)

    call NmlutilAryValid( module_name, &                  ! (in)
      & ShortAbsorpCoefDryAir, 'ShortAbsorpCoefDryAir', & ! (in)
      & ShortBandNum,          'ShortBandNum' )           ! (in)

    call NmlutilAryValid( module_name, &       ! (in)
      & ShortBandWeight, 'ShortBandWeight', &  ! (in)
      & ShortBandNum,    'ShortBandNum' )      ! (in)

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'OLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )

    call HistoryAutoAddVariable( 'OSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'SSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    ! ûѿγ
    ! Allocate variables for short wave (insolation) incoming radiation
    !
    allocate( xy_IncomRadSFlux (0:imax-1, 1:jmax) )
    allocate( xy_InAngle (0:imax-1, 1:jmax) )

    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !
    allocate( xy_TempSave          (0:imax-1, 1:jmax) )
    allocate( xyr_RadLFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyr_RadSFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
    allocate( xyra_DelRadLFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )

    ! ꥹȥե
    ! Input restart file
    !
    if ( present_and_true( flag_rst ) ) then

      if ( trim(RstInputFile) == '' ) then
        call MessageNotify( 'E', module_name, &
          & 'a restart file is needed. ' // &
          & 'Specify the restart file to "RstInputFile" in NAMELIST "radiation_band_nml"' )
      end if

      ! μ
      ! Get time information
      !
      time_range = 'time=' // &
        &          toChar( EvalbyUnit( StartTime, RstFileIntUnit ) )

      ! ե̵ͭǧ
      ! Conform an existence of an input file
      ! 
      call HistoryGetAttr( RstInputFile, 'lon', 'units', & ! (in)
        & dummy_str, &                                     ! (out)
        & flag_mpi_split = flag_mpi_init, &                ! (in) optional
        & err = get_err )                                  ! (out)

      if ( get_err ) then
        call MessageNotify( 'E', module_name, &
          & 'restart/initial data file "%c" is not found.', &
          & c1 = trim(RstInputFile) )
      end if

      ! 
      ! Input
      !
      call HistoryGet( &
        & RstInputFile, 'SurfTemp', &      ! (in)
        & xy_TempSave, &                   ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadLFlux', &      ! (in)
        & xyr_RadLFluxSave, &              ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'RadSFlux', &      ! (in)
        & xyr_RadSFluxSave, &              ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGet( &
        & RstInputFile, 'DelRadLFlux', &   ! (in)
        & xyra_DelRadLFluxSave, &          ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional

      call HistoryGet( &
        & RstInputFile, 'PrevTimeLong', &  ! (in)
        & PrevTimeLongValue, &             ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGetAttr( &
        & RstInputFile, 'PrevTimeLong', 'units', &  ! (in)
        & PrevTimeLongUnit, &                       ! (out)
        & flag_mpi_split = flag_mpi_init )          ! (in) optional
      call DCDiffTimeCreate( PrevTimeLong, &     ! (out)
        & PrevTimeLongValue, PrevTimeLongUnit )  ! (in)
      if ( trim(PrevTimeLongUnit) /= trim(DelTimeLongUnit) ) then
        call MessageNotify( 'E', module_name, &
          & 'unit of PrevTimeLong <%c> in "%c" is differ from DelTimeLongUnit=<%c>', &
          & c1 = trim(PrevTimeLongUnit), c2 = trim(RstInputFile), &
          & c3 = trim(DelTimeLongUnit) )
      end if

      call HistoryGet( &
        & RstInputFile, 'PrevTimeShort', & ! (in)
        & PrevTimeShortValue, &            ! (out)
        & range = time_range, &            ! (in) optional
        & flag_mpi_split = flag_mpi_init ) ! (in) optional
      call HistoryGetAttr( &
        & RstInputFile, 'PrevTimeShort', 'units', & ! (in)
        & PrevTimeShortUnit, &                      ! (out)
        & flag_mpi_split = flag_mpi_init )          ! (in) optional
      call DCDiffTimeCreate( PrevTimeShort, &     ! (out)
        & PrevTimeShortValue, PrevTimeShortUnit ) ! (in)
      if ( trim(PrevTimeShortUnit) /= trim(DelTimeShortUnit) ) then
        call MessageNotify( 'E', module_name, &
          & 'unit of PrevTimeShort <%c> in "%c" is differ from DelTimeShortUnit=<%c>', &
          & c1 = trim(PrevTimeShortUnit), c2 = trim(RstInputFile), &
          & c3 = trim(DelTimeShortUnit) )
      end if

      Old_Flux_saved = .true.
    else
      RstInputFile = ''
      PrevTimeLongUnit  = DelTimeLongUnit
      PrevTimeShortUnit = DelTimeShortUnit
      Old_Flux_saved = .false.
    end if

    ! ϻֳִ֤
    ! Configure time interval of output
    !
    PrevRstOutputTime = StartTime

    ! ꥹȥեκ
    ! Create a restart file
    !
    title_msg = ' restart data for "' // module_name // '" module'
    origin_time = EvalByUnit( StartTime, RstFileIntUnit )
    time_unit = RstFileIntUnit

    call HistoryCreate( &
      &      file = RstOutputFile, &                                ! (in)
      &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
      &    source = FileSource, institution = FileInstitution, &    ! (in)
      &      dims = (/ 'lon  ', 'lat  ', 'sig  ', 'sigm ', &
      &                'sorbl', 'time ' /), &                       ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 2, 0 /), &       ! (in)
      & longnames = (/ 'longitude                             ', &
      &                'latitude                              ', &
      &                'sigma at layer midpoints              ', &
      &                'sigma at layer end-points (half level)', &
      &                'surface or bottom layer               ', &
      &                'time                                  ' /), & ! (in)
      &     units = (/ 'degree_east ', 'degree_north', &
      &                '1           ', '1           ', &
      &                '1           ', time_unit /), &                ! (in)
      & xtypes = (/'double', 'double', 'double', &
      &            'double', 'int   ', 'double'/), &                  ! (in)
      &         origin = origin_time, &         ! (in) optional
      &       interval = RstFileIntValue, &     ! (in) optional
      & flag_mpi_split = flag_mpi_init, &       ! (in) optional
      &        history = gthst_rst )            ! (out) optional

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & 'lon', attrname = 'standard_name', &     ! (in)
      & value = 'longitude', &                   ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'standard_name', &     ! (in)
      & value = 'latitude', &                    ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'standard_name', &     ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'standard_name', &    ! (in)
      & value = 'atmosphere_sigma_coordinate', & ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'time', attrname = 'standard_name', &    ! (in)
      & value = 'time', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'positive', &          ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)
    call HistoryAddAttr( &
      & 'sigm', attrname = 'positive', &         ! (in)
      & value = 'down', &                        ! (in)
      & history = gthst_rst )                    ! (inout)

    call HistoryPut( &
      & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( &
      & 'sig', z_Sigma, &               ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sigm', r_Sigma, &              ! (in)
      & history = gthst_rst )           ! (inout)
    call HistoryPut( & 
      & 'sorbl', (/ 0, 1 /), &          ! (in)
      & history = gthst_rst )           ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( 'lon_weight', &               ! (in)
      & (/'lon'/), &                                       ! (in)
      & 'weight for integration in longitude', 'radian', & ! (in)
      & xtype = 'double', &                                ! (in)
      & history = gthst_rst )                              ! (inout)
    call HistoryAddAttr( &
      & 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lon_weight', x_Lon_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'lat_weight', &                      ! (in)
      & (/'lat'/), &                                              ! (in)
      & 'weight for integration in latitude', units = 'radian', & ! (in)
      & xtype = 'double', &                                       ! (in)
      & history = gthst_rst )                                     ! (inout)
    call HistoryAddAttr( &
      & 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'lat_weight', y_Lat_Weight, &             ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'sig_weight', &      ! (in)
      & (/'sig'/), &                              ! (in)
      & 'weight for integration in sigma', '1', & ! (in)
      & xtype = 'double', &                       ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryAddAttr( &
      & 'sig', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'sig_weight', &                   ! (in)
      & history = gthst_rst )                     ! (inout)
    call HistoryPut( &
      & 'sig_weight', z_DelSigma, &               ! (in)
      & history = gthst_rst )                     ! (inout)

    call HistoryAddVariable( 'PrevTimeLong', &      ! (in)
      & (/ 'time' /), &                             ! (in)
      & 'previous time at which longwave flux is calculated', & ! (in)
      & PrevTimeLongUnit, &                         ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'PrevTimeShort', &     ! (in)
      & (/ 'time' /), &                             ! (in)
      & 'previous time at which shortwave flux is calculated', & ! (in)
      & PrevTimeShortUnit, &                        ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)

    call HistoryAddVariable( 'SurfTemp', &          ! (in)
      & (/ 'lon ', 'lat ', 'time' /), &             ! (in)
      & 'surface temperature', 'K', &               ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadLFlux', &          ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'longwave flux', 'W m-2', &                 ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'RadSFlux', &          ! (in)
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
      & 'shortwave flux', 'W m-2', &                ! (in)
      & xtype = 'double', &                         ! (in)
      & history = gthst_rst )                       ! (inout)
    call HistoryAddVariable( 'DelRadLFlux', &                             ! (in)
      & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
      & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
      & xtype = 'double', &                                               ! (in)
      & history = gthst_rst )                                             ! (inout)

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Restart:' )

    if ( trim(RstInputFile) == '' ) then
      call MessageNotify( 'M', module_name, '  InputFile  = <no input>', c1 = trim( RstInputFile ) )
    else
      call MessageNotify( 'M', module_name, '  InputFile       = %c', c1 = trim( RstInputFile ) )
      call MessageNotify( 'M', module_name, '    PrevTimeLong  = %f [%c]', &
      & d = (/ PrevTimeLongValue /), c1 = trim( PrevTimeLongUnit ) )
      call MessageNotify( 'M', module_name, '    PrevTimeShort = %f [%c]', &
      & d = (/ PrevTimeShortValue /), c1 = trim( PrevTimeShortUnit ) )
    end if

    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim( RstOutputFile ) )
    call MessageNotify( 'M', module_name, '  IntTime    = %r [%c] (same as IntTime in "restart_file_io" module)', &
      & r = (/ RstFileIntValue /), c1 = trim( RstFileIntUnit ) )
!
    call MessageNotify( 'M', module_name, 'DelTime:' )
    call MessageNotify( 'M', module_name, '  DelTimeLong  = %f [%c]', &
      & d = (/ DelTimeLongValue /), c1 = trim( DelTimeLongUnit ) )
    call MessageNotify( 'M', module_name, '  DelTimeShort = %f [%c]', &
      & d = (/ DelTimeShortValue /), c1 = trim( DelTimeShortUnit ) )
!
    call MessageNotify( 'M', module_name, 'LongFlux:' )
    call MessageNotify( 'M', module_name, '  LongBandNum            = %d', i = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongAbsorpCoefQVap     = (/ %*r /)', &
      & r = real( LongAbsorpCoefQVap(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongAbsorpCoefDryAir   = (/ %*r /)', &
      & r = real( LongAbsorpCoefDryAir(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongBandWeight         = (/ %*r /)', &
      & r = real( LongBandWeight(1:LongBandNum) ), n = (/ LongBandNum /) )
    call MessageNotify( 'M', module_name, '  LongPathLengthFact     = %f', d = (/ LongPathLengthFact /) )
!
    call MessageNotify( 'M', module_name, 'ShortFlux:' )
    call MessageNotify( 'M', module_name, '  ShortBandNum           = %d', i = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortAbsorpCoefQVap    = (/ %*r /)', &
      & r = real( ShortAbsorpCoefQVap(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortAbsorpCoefDryAir  = (/ %*r /)', &
      & r = real( ShortAbsorpCoefDryAir(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortBandWeight        = (/ %*r /)', &
      & r = real( ShortBandWeight(1:ShortBandNum) ), n = (/ ShortBandNum /) )
    call MessageNotify( 'M', module_name, '  ShortSecScat           = %f', d = (/ ShortSecScat /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    radiation_band_inited = .true.
  end subroutine RadiationInit

  !-------------------------------------------------------------------

  subroutine RadiationFinalize
    !
    ! ꥹȥեΥ, 
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Close a restart file, and 
    ! deallocate variables in this module. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use gtool_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. radiation_band_inited ) return

    ! ǥե᤹ͤ
    ! Return to default values
    !
    Old_Flux_saved = .false.

    ! ꥹȥեΥ
    ! close a restart file
    !
    call HistoryClose( history = gthst_rst ) ! (inout)

    ! դ
    ! Deallocation
    !
    if ( allocated( xy_IncomRadSFlux     ) ) deallocate( xy_IncomRadSFlux     )
    if ( allocated( xy_InAngle           ) ) deallocate( xy_InAngle           )
    if ( allocated( xy_TempSave          ) ) deallocate( xy_TempSave          )
    if ( allocated( xyr_RadLFluxSave     ) ) deallocate( xyr_RadLFluxSave     )
    if ( allocated( xyr_RadSFluxSave     ) ) deallocate( xyr_RadSFluxSave     )
    if ( allocated( xyra_DelRadLFluxSave ) ) deallocate( xyra_DelRadLFluxSave )

    radiation_band_inited = .false.
  end subroutine RadiationFinalize

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: restart_file_io_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

    if ( .not. restart_file_io_inited ) &
      & call MessageNotify( 'E', module_name, '"restart_file_io" module is not initialized.' )

  end subroutine InitCheck

end module radiation_band
