!= timefilter ⥸塼Υƥȥץ
!
!= Test program for "timefilter"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: timefilter_test.f90,v 1.6 2007/08/03 06:45:22 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! timefilter ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "timefilter" module.
! Confirm compilation and execution of this program.
!
program timefilter_test
  use timefilter, only: TFILTER, Create, Close, Filter, Progress, &
    & PutLine, initialized
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: Create, operator(>), operator(*)
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING, STDERR
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'timefilter_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "timefilter" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS) :: arg
  logical:: OPT_namelist0, OPT_namelist1
  character(STRING):: VAL_namelist0, VAL_namelist1
  type(TFILTER) :: tfilt1, tfilt2
  integer :: i, step
  type(DC_DIFFTIME) :: FilterTimef, DelTimef, CalcTimef
  logical :: err
  integer, parameter:: imax = 4, jmax = 3, kmax = 2
  real :: xy_PsB(0:imax-1,0:jmax-1)
  real :: xy_PsN(0:imax-1,0:jmax-1)
  real :: xy_PsA(0:imax-1,0:jmax-1)
  real :: xy_PsCheckN(0:imax-1,0:jmax-1)
  real(DP) :: xyz_VorB(0:imax-1,0:jmax-1,0:kmax-1)
  real(DP) :: xyz_VorN(0:imax-1,0:jmax-1,0:kmax-1)
  real(DP) :: xyz_VorA(0:imax-1,0:jmax-1,0:kmax-1)
  real(DP) :: xyz_VorCheckN(0:imax-1,0:jmax-1,0:kmax-1)
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './timefilter_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N0', '--namelist0'), &
    & OPT_namelist0, VAL_namelist0, help = "NAMELIST filename 0" )
  call Option( arg, StoA('-N1', '--namelist1'), &
    & OPT_namelist1, VAL_namelist1, help = "NAMELIST filename 1" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )


  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( FilterTimef, -1.0_DP, 'min' )
  step = -10

  call Create( tfilt1, 0.05_DP, err = err )
  call AssertEqual( 'Initialization test 1', .true., err )
  call Create( tfilt1, 0.05_DP, step, err = err )
  call AssertEqual( 'Initialization test 2', .true., err )
  call Create( tfilt2, 0.1_DP, int_time = FilterTimef, err = err )
  call AssertEqual( 'Initialization test 3', .true., err )

  call Create( tfilt1, 0.05_DP, int_step = step, cur_step = 1, &
    & nmlfile = VAL_namelist0 )
  call AssertEqual( 'Initialization test 4 (NAMELIST)', &
    & .true., initialized(tfilt1) )
  call Close( tfilt1 )

  call Create( tfilt2, 0.1_DP, int_time = FilterTimef, &
    & cur_time = FilterTimef, nmlfile = VAL_namelist1 )
  call AssertEqual( 'Initialization test 5 (NAMELIST)', &
    & .true., initialized(tfilt2) )
  call Close( tfilt2 )

  call Create( DelTimef, 10.0_DP, 'sec' )
  call Create( FilterTimef, 1.0_DP, 'min' )
  call Create( CalcTimef, 4.0_DP, 'min' )
  step = 10

  call Create( tfilt1, 0.75_DP, step, cur_step = 1 )
  call AssertEqual( 'Initialization test 6', &
    & .true., initialized(tfilt1) )
  call Create( tfilt2, 0.125_DP, &
    & int_time = FilterTimef, cur_time = DelTimef )
  call AssertEqual( 'Initialization test 7', &
    & .true., initialized(tfilt2) )

  call PutLine( tfilt1 )
  call PutLine( tfilt2, STDERR )


  !---------------------------------------------------------
  !  ե륿ƥ
  !  Filter test
  !---------------------------------------------------------
  xy_PsB = 1.0
  xy_PsN = 2.0
  xy_PsA = 1.0

  do i = 1, 20
!!$    call PutLine( tfilt1 )
    call Filter( tfilt1, xy_PsB, xy_PsN, xy_PsA )
    call Progress( tfilt1 )
  end do
  xy_PsCheckN = 1.25
  call AssertEqual( 'Filter Test 1', xy_PsCheckN, xy_PsN )

  xyz_VorB = 1.0_DP
  xyz_VorN = 10.0_DP
  xyz_VorA = 1.0_DP
  xyz_VorCheckN = 3.84765625_DP

  i = 1
  do
    if ( DelTimef * i > CalcTimef ) exit
    call Filter( tfilt2, xyz_VorB, xyz_VorN, xyz_VorA )
    call Progress( tfilt2, time = DelTimef )
    i = i + 1
  end do
  call AssertEqual( 'Filter Test 2', xyz_VorCheckN, xyz_VorN )

end program timefilter_test
