!= surface_data ⥸塼Υƥȥץ
!
!= Test program for "surface_data"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: surface_data_test.f90,v 1.3 2007/09/03 07:48:47 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! surface_data ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "surface_data" module.
! Confirm compilation and execution of this program.
!

program surface_data_test
  use constants, only: CONST, Create, Get
  use surface_data, only: SRFDAT, Create, Close, &
    & PutLine, initialized, GetAxes, GetData
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'surface_data_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "surface_data" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: x_LonAns (:) ! . Longitude
  real(DP), allocatable:: y_LatAns (:) ! . Latitude

  !---------------------------------------------------------
  !  ɽ̥ǡ
  !  surface data
  !---------------------------------------------------------
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP), allocatable:: xy_SurfTempAns (:,:)

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option

  type(CONST):: const_earth
  real(DP):: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
  type(SRFDAT):: srf_dat00, srf_dat01
  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './surface_data_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth ) ! (inout)
  call Get( constant = const_earth, & ! (inout)
    & PI = PI ) ! (out)

  !---------------------------------------------------------
  !  μ
  !  Get correct answer
  !---------------------------------------------------------
  allocate( x_LonAns (0:imax-1) )
  allocate( y_LatAns (0:jmax-1) )
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lon', &            ! (in)
    & array = x_LonAns )            ! (out)
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'lat', &            ! (in)
    & array = y_LatAns )            ! (out)

  x_LonAns = x_LonAns * PI / 180.0_DP
  y_LatAns = y_LatAns * PI / 180.0_DP

  allocate( xy_SurfTempAns (0:imax-1, 0:jmax-1) )
  call HistoryGet( &
    & file = 'surface_data_test00.nc', & ! (in)
    & varname = 'SurfTemp', &            ! (in)
    & array = xy_SurfTempAns )           ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( srf_dat = srf_dat00, & ! (inout)
    & nmax = nmax, imax = imax, jmax = jmax, & ! (in)
    & PI = PI ) ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(srf_dat00) )
  call PutLine( srf_dat = srf_dat00 ) ! (in)

  !---------------------------------------------------------
  !  ǡƥ
  !  Axes data test
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )

  call GetAxes( srf_dat = srf_dat00, & ! (inout)
    & x_Lon = x_Lon, y_Lat = y_Lat )   ! (out)

  call AssertGreaterThan( 'longitude test 1-1', &
    & answer = x_LonAns - 1.0e-6, &
    & check = x_Lon, &
    & negative_support = .false. )
  call AssertLessThan( 'longitude test 1-2', &
    & answer = x_LonAns + 1.0e-6, &
    & check = x_Lon, &
    & negative_support = .false. )

  call AssertGreaterThan( 'latitude test 2-1', &
    & answer = y_latAns - 1.0e-6, &
    & check = y_lat, &
    & negative_support = .false. )
  call AssertLessThan( 'latitude test 2-2', &
    & answer = y_latAns + 1.0e-6, &
    & check = y_lat, &
    & negative_support = .false. )

  !---------------------------------------------------------
  !  ɽ̲٥ƥ
  !  Surface temperature test
  !---------------------------------------------------------
  allocate( xy_SurfTemp (0:imax-1, 0:jmax-1) )
  call GetData( srf_dat = srf_dat00, & ! (inout)
    & xy_SurfTemp = xy_SurfTemp )   ! (out)

  call AssertGreaterThan( 'surface temperature test 2-1', &
    & answer = xy_SurfTempAns - 1.0e-10, &
    & check = xy_SurfTemp, &
    & negative_support = .false. )
  call AssertLessThan( 'surface temperature test 2-2', &
    & answer = xy_SurfTempAns + 1.0e-10, &
    & check = xy_SurfTemp, &
    & negative_support = .false. )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( srf_dat = srf_dat00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(srf_dat00) )
  call PutLine( srf_dat = srf_dat00 ) ! (in)

  !---------------------------------------------------------
  !  NAMELIST ɤ߹ߥƥ
  !  NAMELIST loading test
  !---------------------------------------------------------
  call Create( srf_dat = srf_dat01, & ! (inout)
    & nmax = nmax, imax = imax, jmax = jmax, &
    & nmlfile = VAL_namelist, err = err ) ! (in)
  call AssertEqual( 'NAMELIST loading test 1', &
    & answer = .true., check = err )
  call PutLine( srf_dat = srf_dat01 ) ! (in)

end program surface_data_test
