!= ץ饤ǡ⥸塼
!
!= Spline curve data generation module
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: spline_data.f90,v 1.2 2007/09/21 13:50:05 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module spline_data
  !
  != ץ饤ǡ⥸塼
  !
  != Spline curve data generation module
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ץ饤ǡޤ.
  ! http://www.netlib.org/fmm/spline.f 򻲹ͤ˺ޤ. 
  !
  ! Spline curve data is generated
  ! This module is created referring to 
  ! http://www.netlib.org/fmm/spline.f
  !
  !== Procedures List
  !
  ! Create        :: SPLDAT ѿν
  ! Close         :: SPLDAT ѿνλ
  ! PutLine       :: SPLDAT ѿ˳ǼƤΰ
  ! initialized   :: SPLDAT ѿꤵƤ뤫ݤ
  ! GetSpline     :: ץ饤ǡκ
  ! ------------  :: ------------
  ! Create        :: Constructor of "SPLDAT"
  ! Close         :: Deconstructor of "SPLDAT"
  ! PutLine       :: Print information of "SPLDAT"
  ! initialized   :: Check initialization of "SPLDAT"
  ! GetSpline     :: Get spline curve data
  !
  !== Usage
  !
  ! Ϥ, SPLDAT ѿ, Create ǽԤޤ.
  ! GetSpline ǥץ饤ǡƤ. 
  ! SPLDAT ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "SPLDAT" by "Create". 
  ! Get spline curve data by using "GetSpline". 
  ! In order to terminate "SPLDAT", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: SPLDAT, Create, Close, PutLine, initialized, GetSpline

  type SPLDAT
    !
    ! ޤ, Create  "SPLDAT" ѿꤷƲ.
    ! ꤵ줿 "SPLDAT" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "SPLDAT" variable by "Create" before usage.
    ! If you reuse "SPLDAT" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: knots_num
                              ! ο (2 ʾ). 
                              ! the number of data points or knots
                              ! (greater than 2)
    real(DP), pointer:: x_knots (:) =>null()
                              ! βǡ (ä¤). 
                              ! The abscissas of the knots 
                              ! in strictly increasing order
    real(DP), pointer:: x_value (:) =>null()
                              ! νļǡ. 
                              ! The ordinates of the knots

    real(DP), pointer:: x_coeffB (:) =>null()
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP), pointer:: x_coeffC (:) =>null()
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP), pointer:: x_coeffD (:) =>null()
                              ! ץ饤󷸿. 
                              ! Spline coefficient

  end type SPLDAT

  character(*), parameter:: version = &
    & '$Name: dcpam4-20071012 $' // &
    & '$Id: spline_data.f90,v 1.2 2007/09/21 13:50:05 morikawa Exp $'

  interface Create
    module procedure SplineDataCreate
  end interface

  interface Close
    module procedure SplineDataClose
  end interface

  interface PutLine
    module procedure SplineDataPutLine
  end interface

  interface initialized
    module procedure SplineDataInitialized
  end interface

  interface NmlRead
    module procedure SplineDataNmlRead
  end interface

  interface GetSpline
    module procedure SplineDataGetSpline
  end interface

!!$  interface Sample
!!$    module procedure SplineDataSample
!!$  end interface

contains

  subroutine SplineDataCreate( spl_dat, &
    & knots_num, x_knots, x_value, &
    & nmlfile, err )
    !
    ! SPLDAT ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! SPLDAT ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *spl_dat* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#spline_data_nml 򻲾ȤƤ. 
    !
    ! Constructor of "SPLDAT".
    ! Initialize *spl_dat* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *spl_dat* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#spline_data_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dcpam_error, only: StoreError, DCPAM_EBADNUMBER, DCPAM_ESMALLVAL
    use dc_error, only: DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(SPLDAT), intent(inout):: spl_dat
    integer, intent(in):: knots_num
                              ! ο (2 ʾ). 
                              ! the number of data points or knots
                              ! (greater than 2)
    real(DP), intent(in):: x_knots (0:knots_num-1)
                              ! βǡ (ä¤). 
                              ! The abscissas of the knots 
                              ! in strictly increasing order
    real(DP), intent(in):: x_value (0:knots_num-1)
                              ! νļǡ. 
                              ! The ordinates of the knots
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#spline_data_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#spline_data_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ץ饤󷸿. 
    !  Spline coefficient
    real(DP):: x_coeffB (0:knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP):: x_coeffC (0:knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP):: x_coeffD (0:knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: workA

    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    integer:: cause_i
    character(*), parameter:: subname = 'SplineDataCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''
    cause_i = 0

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( spl_dat % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'SPLDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (knots_num < 2) then
      stat = DCPAM_ESMALLVAL
      cause_c = 'knots_num'
      cause_i = 2
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "SPLDAT" 
    !  Configure the settings for "SPLDAT"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
!!$    spl_dat % param_r = 0.0_DP
!!$    spl_dat % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    spl_dat % param_i = param_i
!!$    if ( present(param_r) )  spl_dat % param_r = param_r
!!$    if ( present(param_c) )  spl_dat % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = spl_dat % param_i, &   ! (inout)
!!$        & param_r = spl_dat % param_r, &   ! (inout)
!!$        & param_c_ = spl_dat % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( spl_dat % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if

    !-----------------------------------------------------------------
    !  ץ饤󷸿η׻
    !  Calculate spline coefficient
    !-----------------------------------------------------------------
    x_coeffB = 0.0_DP
    x_coeffC = 0.0_DP
    x_coeffD = 0.0_DP
  
    if ( knots_num == 2 ) then
      x_coeffB(0) = ( x_value(1) - x_value(0) ) / ( x_knots(1) - x_knots(0) )
      x_coeffC(0) = 0.0_DP
      x_coeffD(0) = 0.0_DP
      x_coeffB(1) = x_coeffB(0)
      x_coeffC(1) = 0.0_DP
      x_coeffD(1) = 0.0_DP
    else
    
      x_coeffD(0) = x_knots(1) - x_knots(0)
      x_coeffC(1) = ( x_value(1) - x_value(0) ) / x_coeffD(0)

      do i = 1, knots_num-2
        x_coeffD(i)   = x_knots(i+1) - x_knots(i)
        x_coeffB(i)   = 2.0_DP * ( x_coeffD(i-1) + x_coeffD(i) )
        x_coeffC(i+1) = ( x_value(i+1) - x_value(i) ) / x_coeffD(i)
        x_coeffC(i)   = x_coeffC(i+1) - x_coeffC(i)
      enddo

      x_coeffB(0)           = - x_coeffD(0)
      x_coeffB(knots_num-1) = - x_coeffD(knots_num-2)
      x_coeffC(0)           = 0.0_DP
      x_coeffC(knots_num-1) = 0.0_DP
    
      if ( knots_num > 3 ) then
        x_coeffC(0) = &
          &   x_coeffC(2) / ( x_knots(3)-x_knots(1) ) &
          & - x_coeffC(1) / ( x_knots(2)-x_knots(0) )

        x_coeffC(knots_num-1) = &
          &   x_coeffC(knots_num-2) &
          &     / ( x_knots(knots_num-1) - x_knots(knots_num-3) ) &
          & - x_coeffC(knots_num-3) &
          &     / ( x_knots(knots_num-2) - x_knots(knots_num-4) )

        x_coeffC(0) = &
          &   x_coeffC(0) * x_coeffD(0)**2.0_DP &
          &     / ( x_knots(3) - x_knots(0) )

        x_coeffC(knots_num-1) = &
          & - x_coeffC(knots_num-1) &
          &   * x_coeffD(knots_num-2)**2.0_DP &
          &       / ( x_knots(knots_num-1) - x_knots(knots_num-4) )
      endif

      do i = 1, knots_num-1
        workA = x_coeffD(i-1) / x_coeffB(i-1)
        x_coeffB(i) = x_coeffB(i) - workA * x_coeffD(i-1)
        x_coeffC(i) = x_coeffC(i) - workA * x_coeffC(i-1)
      enddo

      x_coeffC(knots_num-1) = x_coeffC(knots_num-1) / x_coeffB(knots_num-1)

      do i = knots_num-2, 0, -1
        x_coeffC(i) = &
          & ( x_coeffC(i) - x_coeffD(i) * x_coeffC(i+1) ) / x_coeffB(i)
      enddo

      x_coeffB(knots_num-1) = &
        &   ( x_value(knots_num-1) - x_value(knots_num-2) ) &
        &       / x_coeffD(knots_num-2) &
        & + x_coeffD(knots_num-2) &
        &     * ( x_coeffC(knots_num-2) + 2.0_DP * x_coeffC(knots_num-1) )

      do i = 0, knots_num-2

        x_coeffB(i) = &
          &    ( x_value(i+1) - x_value(i) ) / x_coeffD(i) &
          &  - x_coeffD(i) * ( x_coeffC(i+1) + 2.0_DP * x_coeffC(i) )

        x_coeffD(i) = &
          & ( x_coeffC(i+1) - x_coeffC(i) ) / x_coeffD(i)

        x_coeffC(i) = 3.0_DP * x_coeffC(i)

      enddo

      x_coeffC(knots_num-1) = 3.0_DP * x_coeffC(knots_num-1)
      x_coeffD(knots_num-1) = x_coeffD(knots_num-2)
    endif

    !-----------------------------------------------------------------
    !  *spl_dat* ͤǼ
    !  Store setting values to *spl_dat*
    !-----------------------------------------------------------------
    spl_dat % knots_num = knots_num

    allocate( spl_dat % x_knots(0:knots_num-1) )
    allocate( spl_dat % x_value(0:knots_num-1) )
    allocate( spl_dat % x_coeffB(0:knots_num-1) )
    allocate( spl_dat % x_coeffC(0:knots_num-1) )
    allocate( spl_dat % x_coeffD(0:knots_num-1) )
    spl_dat % x_knots  = x_knots
    spl_dat % x_value  = x_value
    spl_dat % x_coeffB = x_coeffB
    spl_dat % x_coeffC = x_coeffC
    spl_dat % x_coeffD = x_coeffD

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    spl_dat % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c, cause_i )
    call EndSub( subname )
  end subroutine SplineDataCreate

  subroutine SplineDataClose( spl_dat, err )
    !
    ! SPLDAT ѿνλԤޤ.
    ! ʤ, Ϳ줿 *spl_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "SPLDAT".
    ! Note that if *spl_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SPLDAT), intent(inout):: spl_dat
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SplineDataClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. spl_dat % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'SPLDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "SPLDAT" ξõ
    !  Clear the settings for "SPLDAT"
    !-----------------------------------------------------------------
    deallocate( spl_dat % x_knots  )
    deallocate( spl_dat % x_value  )
    deallocate( spl_dat % x_coeffB )
    deallocate( spl_dat % x_coeffC )
    deallocate( spl_dat % x_coeffD )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    spl_dat % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SplineDataClose

  subroutine SplineDataPutLine( spl_dat, unit, indent, err )
    !
    !  *spl_dat* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *spl_dat*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SPLDAT), intent(in):: spl_dat
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'SplineDataPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "SPLDAT" ΰ
    !  Print the settings for "SPLDAT"
    !-----------------------------------------------------------------
    if ( spl_dat % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SPLDAT:: @initialized=%y', &
        & l = (/spl_dat % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @knots_num=%d', &
        & i = (/spl_dat % knots_num/) )

      call PutLine( spl_dat % x_knots, unit = out_unit, &
        & lbounds = lbound(spl_dat % x_knots), &
        & ubounds = ubound(spl_dat % x_knots), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_knots=' )

      call PutLine( spl_dat % x_value, unit = out_unit, &
        & lbounds = lbound(spl_dat % x_value), &
        & ubounds = ubound(spl_dat % x_value), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_value=' )

      call PutLine( spl_dat % x_coeffB, unit = out_unit, &
        & lbounds = lbound(spl_dat % x_coeffB), &
        & ubounds = ubound(spl_dat % x_coeffB), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_coeffB=' )

      call PutLine( spl_dat % x_coeffC, unit = out_unit, &
        & lbounds = lbound(spl_dat % x_coeffC), &
        & ubounds = ubound(spl_dat % x_coeffC), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_coeffC=' )

      call PutLine( spl_dat % x_coeffD, unit = out_unit, &
        & lbounds = lbound(spl_dat % x_coeffD), &
        & ubounds = ubound(spl_dat % x_coeffD), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_coeffD=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SPLDAT:: @initialized=%y>', &
        & l = (/spl_dat % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SplineDataPutLine

  logical function SplineDataInitialized( spl_dat ) result(result)
    !
    ! *spl_dat* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *spl_dat* is initialized, .true. is returned.
    ! If *spl_dat* is not initialized, .false. is returned.
    !
    implicit none
    type(SPLDAT), intent(in):: spl_dat
  continue
    result = spl_dat % initialized
  end function SplineDataInitialized

  subroutine SplineDataNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /spline_data_nml/ &
!!$      & param_i, param_r, param_c
                              ! spline_data ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! spline_data#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "spline_data" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "spline_data#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'SplineDataNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = spline_data_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'spline_data_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = spline_data_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'spline_data_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SplineDataNmlRead

  subroutine SplineDataGetSpline( spl_dat, &
    & a_Dim, a_Data, &
    & err )
    !
    ! *a_Data* ˥ץ饤ǡ֤ޤ.
    ! *a_Data* 󥵥ǤդǤ. 
    ! *a_Dim* ˤ *a_Data* μǡͿƤ. 
    !
    ! ʤ, Ϳ줿 *spl_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Spline curve data is returned to *a_Data*. 
    ! Array size of *a_Data* is arbitrary. 
    ! Give dimensional data of *a_Data* to *a_Dim*. 
    !
    ! If *spl_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, toChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dcpam_error, only: StoreError, DCPAM_EARGSIZEMISMATCH, &
      & DCPAM_EBADNUMBER
    use dc_error, only: DC_NOERR, DC_ENOTINIT
    use dc_message, only: MessageNotify
    implicit none
    type(SPLDAT), intent(inout):: spl_dat
    real(DP), intent(in):: a_Dim (:)
                              ! ǡ. 
                              ! dimensional data
    real(DP), intent(out):: a_Data (:)
                              ! ץ饤ǡ. 
                              ! Spline curve data
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ץ饤󷸿. 
    !  Spline coefficient
    integer:: knots_num
                              ! ο (2 ʾ). 
                              ! the number of data points or knots
                              ! (greater than 2)

    real(DP):: x_knots  (0:spl_dat%knots_num-1)
                              ! βǡ (ä¤). 
                              ! The abscissas of the knots 
                              ! in strictly increasing order
    real(DP):: x_value  (0:spl_dat%knots_num-1)
                              ! νļǡ. 
                              ! The ordinates of the knots

    real(DP):: x_coeffB (0:spl_dat%knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP):: x_coeffC (0:spl_dat%knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient
    real(DP):: x_coeffD (0:spl_dat%knots_num-1)
                              ! ץ饤󷸿. 
                              ! Spline coefficient

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: size_a_Dim
    integer:: size_a_Data

    integer:: i, k            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    integer:: cause_i
    character(*), parameter:: subname = 'SplineDataGetSpline'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''
    cause_i = 0

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. spl_dat % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'SPLDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *spl_dat* ˳ǼƤͤμФ
    !  Fetch setting values stored in *spl_dat*
    !-----------------------------------------------------------------
    knots_num = spl_dat % knots_num
    x_knots   = spl_dat % x_knots
    x_value   = spl_dat % x_value
    x_coeffB  = spl_dat % x_coeffB
    x_coeffC  = spl_dat % x_coeffC
    x_coeffD  = spl_dat % x_coeffD

    !-----------------------------------------------------------------
    !  󥵥μȳǧ
    !  Get and confirm array size
    !-----------------------------------------------------------------
    size_a_Dim = size( a_Dim )
    size_a_Data = size( a_Data )

    if ( size_a_Dim /= size_a_Data ) then
      stat = DCPAM_EARGSIZEMISMATCH
      cause_c = 'size(a_Dim)=' // trim( toChar(size_a_Dim) ) // &
        &       ' and size(a_Data)=' // trim( toChar(size_a_Data) )
      goto 999
    end if

    if ( size_a_Dim < knots_num ) then
      call MessageNotify( 'W', subname, &
        & 'size of "%c" (%d) must be bigger than "%c=%d".', &
        & c1 = 'a_Dim', c2 = 'knots_num', &
        & i = (/size_a_Dim, knots_num/) )

      stat = DCPAM_EBADNUMBER
      cause_c = 'size of "a_Dim"'
      cause_i = size_a_Dim
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ץ饤ǡκ
    !  Generate spline curve data
    !-----------------------------------------------------------------
    a_Data = 0.0_DP

    k = 0
    do i = 1, size_a_Dim
      if ( k < knots_num - 1 ) then
        if ( a_Dim(i) >= x_knots(k+1) ) then
          k = k + 1
        end if
      end if
      a_Data(i) = &
        &   x_value(k) &
        & + x_coeffB(k) * ( a_Dim(i) - x_knots(k) ) &
        & + x_coeffC(k) * ( a_Dim(i) - x_knots(k) )**2 &
        & + x_coeffD(k) * ( a_Dim(i) - x_knots(k) )**3
    enddo

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c, cause_i )
    call EndSub( subname )
  end subroutine SplineDataGetSpline

!!$  subroutine SplineDataSample( spl_dat, err )
!!$    !--
!!$    ! SplineDataSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *spl_dat*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of SplineDataSample
!!$    !++
!!$    ! If *spl_dat* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(SPLDAT), intent(inout):: spl_dat
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'SplineDataSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. spl_dat % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'SPLDAT'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *spl_dat* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *spl_dat*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = spl_dat % param_i
!!$!!$    param_r = spl_dat % param_r
!!$!!$    param_c = spl_dat % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine SplineDataSample

end module spline_data
