!= sigma_data ⥸塼Υƥȥץ
!
!= Test program for "sigma_data"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: sigma_data_test.f90,v 1.2 2007/09/01 15:50:36 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! sigma_data ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "sigma_data" module.
! Confirm compilation and execution of this program.
!

program sigma_data_test
  use constants, only: CONST, Create, Get
  use sigma_data, only: SIGDAT, Create, Close, &
    & PutLine, initialized, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, toChar
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'sigma_data_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "sigma_data" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option

  type(CONST):: const_earth
  real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air

  type(SIGDAT):: sig_dat00, sig_dat01, sig_dat02, sig_dat03
  type(SIGDAT):: sig_dat04, sig_dat05
  integer, parameter:: kmax_list(4) = (/2,12,16,20/)
  integer:: kmax_list_size
  integer:: k               ! DO 롼Ѻѿ
                            ! Work variables for DO loop
  real(DP), allocatable:: r_Sigma (:)
  real(DP), allocatable:: r_SigmaAns (:)
  real(DP), allocatable:: z_Sigma (:)
  real(DP), allocatable:: z_SigmaAns (:)
  real(DP), allocatable:: z_DelSigma (:)
  real(DP), allocatable:: z_DelSigmaAns (:)
  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './sigma_data_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, & ! (inout)
    & Cp = Cp, RAir = RAir )          ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  err = .false.
  call Create( sig_dat = sig_dat00, &   ! (inout)
    & kmax = 20, Cp = Cp, RAir = RAir ) ! (in)
  call AssertEqual( 'initialization test 0', &
    & answer = .true., check = initialized(sig_dat00) )
  call PutLine( sig_dat = sig_dat00 )   ! (in)

  call Create( sig_dat = sig_dat01, &   ! (inout)
    & kmax = 1, Cp = Cp, RAir = RAir, & ! (in)
    & err = err )                       ! (out)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = err )
  call PutLine( sig_dat = sig_dat01 )   ! (in)

  call Create( sig_dat = sig_dat02, &    ! (inout)
    & kmax = 20, Cp = Cp, RAir = RAir, & ! (in)
    & pattern = 'invalid', &             ! (in)
    & err = err )                        ! (out)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = err )
  call PutLine( sig_dat = sig_dat02 )   ! (in)

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( sig_dat = sig_dat00 ) ! (inout)
  call AssertEqual( 'termination test 0', &
    & answer = .false., check = initialized(sig_dat00) )
  call PutLine( sig_dat = sig_dat00 ) ! (in)

  call Close( sig_dat = sig_dat01, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 1', &
    & answer = .true., check = err )
  call PutLine( sig_dat = sig_dat01 ) ! (in)

  !---------------------------------------------------------
  !  Һɸưƥ
  !  Sigma coordinate auto setting test
  !---------------------------------------------------------
  kmax_list_size = size( kmax_list )
  do k = 1, kmax_list_size
    call Create( sig_dat = sig_dat03, &             ! (inout)
      & kmax = kmax_list(k), Cp = Cp, RAir = RAir ) ! (in)
    call AssertEqual( 'sigma coordinate auto setting test (kmax=' // &
      & trim( toChar(kmax_list(k)) ) // ')', &
      & answer = .true., check = initialized( sig_dat03 ) )
    call Close( sig_dat = sig_dat03 ) ! (inout)
  end do

  !---------------------------------------------------------
  !  ҥ٥ǡƥ
  !  Full sigma coordinate data generation test
  !---------------------------------------------------------
  allocate( r_SigmaAns(0:20) )
  allocate( r_Sigma(0:20) )
  allocate( z_SigmaAns(0:19) )
  allocate( z_Sigma(0:19) )
  allocate( z_DelSigmaAns(0:19) )
  allocate( z_DelSigma(0:19) )

  r_SigmaAns = &
    &  (/1.00, 0.95, 0.90, 0.85, 0.80, &
    &    0.75, 0.70, 0.65, 0.60, 0.55, &
    &    0.50, 0.45, 0.40, 0.35, 0.30, &
    &    0.25, 0.20, 0.15, 0.10, 0.05, 0.00/)

  z_SigmaAns = &
    & (/0.9749237, 0.9249195, 0.8749149, 0.8249098,  0.774904,  &
    &   0.7248973, 0.6748897, 0.6248809, 0.5748705,  0.5248582, &
    &   0.4748433, 0.4248248, 0.3748014, 0.3247708,  0.274729,  &
    &   0.2246685, 0.1745732, 0.1244002, 0.07398598, 0.02074752/)

  z_DelSigmaAns = &
    & (/0.05, 0.05, 0.05, 0.05, 0.05, &
    &   0.05, 0.05, 0.05, 0.05, 0.05, &
    &   0.05, 0.05, 0.05, 0.05, 0.05, &
    &   0.05, 0.05, 0.05, 0.05, 0.05/)

  call Create( sig_dat = sig_dat04, &    ! (inout)
    & kmax = 20, Cp = Cp, RAir = RAir, & ! (in)
    & r_SigmaSet = r_SigmaAns )          ! (in)

  call Get( sig_dat = sig_dat04, &                                   ! (inout)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma, z_DelSigma = z_DelSigma) ! (out)

  call AssertGreaterThan( 'z_Sigma generation test 1-1', &
    & answer = z_SigmaAns - 1.0e-6, &
    & check = z_Sigma, &
    & negative_support = .false. )
  call AssertLessThan( 'z_Sigma generation test 1-2', &
    & answer = z_SigmaAns + 1.0e-6, &
    & check = z_Sigma, &
    & negative_support = .false. )

  call AssertGreaterThan( 'r_Sigma generation test 1-1', &
    & answer = r_SigmaAns - 1.0e-6, &
    & check = r_Sigma, &
    & negative_support = .false. )
  call AssertLessThan( 'r_Sigma generation test 1-2', &
    & answer = r_SigmaAns + 1.0e-6, &
    & check = r_Sigma, &
    & negative_support = .false. )

  call AssertGreaterThan( 'z_DelSigma generation test 1-1', &
    & answer = z_DelSigmaAns - 1.0e-6, &
    & check = z_DelSigma, &
    & negative_support = .false. )
  call AssertLessThan( 'z_DelSigma generation test 1-2', &
    & answer = z_DelSigmaAns + 1.0e-6, &
    & check = z_DelSigma, &
    & negative_support = .false. )

  call Close( sig_dat = sig_dat04 ) ! (inout)

  deallocate( r_SigmaAns )
  deallocate( r_Sigma )
  deallocate( z_SigmaAns )
  deallocate( z_Sigma )
  deallocate( z_DelSigmaAns )
  deallocate( z_DelSigma )

  !---------------------------------------------------------
  !  NAMELIST ե뤫ϥƥ
  !  Input from NAMELIST file test
  !---------------------------------------------------------
  allocate( r_SigmaAns(0:8) )
  allocate( r_Sigma(0:8) )
  allocate( z_SigmaAns(0:7) )
  allocate( z_Sigma(0:7) )

  r_SigmaAns = &
    &  (/1.0, 0.94, 0.86, 0.76, 0.64, 0.50, 0.34, 0.15, 0.0/)

  z_SigmaAns = &
    &  (/0.9698895, 0.8997882, 0.8096323, 0.6993869, 0.5689736, &
    &    0.4181732, 0.2404809, 0.06224254/)

  call Create( sig_dat = sig_dat05, &    ! (inout)
    & kmax = 8, Cp = Cp, RAir = RAir, &  ! (in)
    & nmlfile = VAL_namelist )           ! (in)
  call AssertEqual( 'Input from NAMELIST file test 0', &
    & answer = .true., check = initialized(sig_dat05) )

  call Get( sig_dat = sig_dat05, &          ! (inout)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma) ! (in)

  call AssertGreaterThan( 'z_Sigma input from NAMELIST test 1-1', &
    & answer = z_SigmaAns - 1.0e-6, &
    & check = z_Sigma, &
    & negative_support = .false. )
  call AssertLessThan( 'z_Sigma input from NAMELIST test 1-2', &
    & answer = z_SigmaAns + 1.0e-6, &
    & check = z_Sigma, &
    & negative_support = .false. )

  call AssertGreaterThan( 'r_Sigma input from NAMELIST test 1-1', &
    & answer = r_SigmaAns - 1.0e-6, &
    & check = r_Sigma, &
    & negative_support = .false. )
  call AssertLessThan( 'r_Sigma input from NAMELIST test 1-2', &
    & answer = r_SigmaAns + 1.0e-6, &
    & check = r_Sigma, &
    & negative_support = .false. )

end program sigma_data_test
