!= Һɸ⥸塼
!
!= Sigma coordinate data generation module
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: sigma_data.f90,v 1.3 2007/09/04 01:35:54 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module sigma_data
  !
  != Һɸ⥸塼
  !
  != Sigma coordinate data generation module
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Һɸͥǡޤ.
  !
  ! Sigma coordinate data is generated.
  !
  !== Procedures List
  !
  ! Create        :: SIGDAT ѿν
  ! Get           :: Һɸǡμ
  ! Close         :: SIGDAT ѿνλ
  ! PutLine       :: SIGDAT ѿ˳ǼƤΰ
  ! initialized   :: SIGDAT ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "SIGDAT"
  ! Get           :: Get sigma coordinate data
  ! Close         :: Deconstructor of "SIGDAT"
  ! PutLine       :: Print information of "SIGDAT"
  ! initialized   :: Check initialization of "SIGDAT"
  !
  !== Usage
  !
  ! Ϥ, SIGDAT ѿ, Create ǽԤޤ.
  ! , Get ˤäƦҺɸͽͤɤ߹Ǥ.
  ! SIGDAT ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "SIGDAT" by "Create".
  ! Then, get sigma coordinate data by "Get".
  ! In order to terminate "SIGDAT", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: SIGDAT, Create, Get, Close, PutLine, initialized

  type SIGDAT
    !
    ! ޤ, Create  "SIGDAT" ѿꤷƲ.
    ! ꤵ줿 "SIGDAT" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "SIGDAT" variable by "Create" before usage.
    ! If you reuse "SIGDAT" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    character(TOKEN):: pattern
                              ! ͥǡΥѥ. 
                              ! Initial data pattern
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), pointer:: r_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), pointer:: z_DelSigma (:) =>null()
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
  end type SIGDAT

  character(*), parameter:: version = &
    & '$Name: dcpam4-20070909 $' // &
    & '$Id: sigma_data.f90,v 1.3 2007/09/04 01:35:54 morikawa Exp $'

  interface Create
    module procedure SigmaDataCreate
  end interface

  interface Close
    module procedure SigmaDataClose
  end interface

  interface PutLine
    module procedure SigmaDataPutLine
  end interface

  interface initialized
    module procedure SigmaDataInitialized
  end interface

  interface NmlRead
    module procedure SigmaDataNmlRead
  end interface

  interface Get
    module procedure SigmaDataGet
  end interface

!!$  interface Sample
!!$    module procedure SigmaDataSample
!!$  end interface

contains

  subroutine SigmaDataCreate( sig_dat, &
    & kmax, &
    & Cp, RAir, &
    & r_SigmaSet, &
    & pattern, &
    & nmlfile, err )
    !
    ! SIGDAT ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! SIGDAT ѿꤷƤ.
    !
    !  *Cp*  *RAir* Ⱦ $ \sigma $ 
    ! ٥뤫 $ \sigma $ ٥ݤ˻Ѥޤ. 
    !
    ! ʤ, Ϳ줿 *sig_dat* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#sigma_data_nml 򻲾ȤƤ. 
    !
    ! Constructor of "SIGDAT".
    ! Initialize *sig_dat* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Arguments *Cp* and *RAir* are used when 
    ! full $ \sigma $ level is created from half $ \sigma $ level. 
    !
    ! Note that if *sig_dat* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#sigma_data_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dcpam_error, only: StoreError, DCPAM_EBADPATTERN, DCPAM_EBADNUMBER, &
      & DCPAM_EARGSIZEMISMATCH
    use dc_error, only: DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dc_string, only: LChar
    implicit none
    type(SIGDAT), intent(inout):: sig_dat
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in), optional:: r_SigmaSet (:)
                              ! ǥեȤǤ, kmax ͤ˱,
                              ! ưŪ $ \sigma $ ٥ (Ⱦ) 
                              ! ꤵ (kmax ͤΤ).
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Ūꤹɬפ, 
                              ! ΰͿ.
                              !
                              ! By default, half $ \sigma $ level is 
                              ! specified automatically according to
                              ! the value of kmax (only the value is 
                              ! same as particular values).
                              ! If the half $ \sigma $ level is specified
                              ! manually, give this argument.
    character(*), intent(in), optional:: pattern
                              ! ɽ̥ǡΥѥ. 
                              ! Surface data pattern
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#sigma_data_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#sigma_data_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat
    real(DP):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP):: z_DelSigma (0:kmax-1)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    integer:: k               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: size_r_SigmaSet
    real(DP), parameter:: invalid_value_r_Sigma = -999.0_DP
                              ! ̵ r_Sigma . 
                              ! Invalid value of 'r_Sigma'
    integer:: insufficient_num_r_Sigma
                              ! NAMELIST ե뤫줿 r_Sigma 
                              ! ­ʬǡο. 
                              ! Number of insufficient data of 'r_Sigma'
                              ! loaded from NAMELIST file
    logical:: nmlfile_valid   ! NAMELIST ե뤫ͤ. 
                              ! Validity of values from NAMELIST file
    integer:: stat
    character(STRING):: cause_c
    integer:: cause_i
    character(*), parameter:: subname = 'SigmaDataCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''
    cause_i = 0

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( sig_dat % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'SIGDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʻ
    !  Configure grid point
    !-----------------------------------------------------------------
    sig_dat % kmax = kmax

    !-----------------------------------------------------------------
    !  ʪ
    !  Configure physical constants
    !-----------------------------------------------------------------
    Kappa = RAir / Cp
    sig_dat % Kappa = Kappa

    !-----------------------------------------------------------------
    !  ҺɸͥǡΥѥ
    !  Sigma coordinate data pattern
    !-----------------------------------------------------------------
    if ( .not. present_and_not_empty(pattern) ) then
      sig_dat % pattern = 'default'
    else
      select case ( LChar( trim(sig_dat % pattern) ) )
      case ('default')
      case default
        stat = DCPAM_EBADPATTERN
        cause_c = trim(pattern)
        goto 999
      end select
    end if

    !-----------------------------------------------------------------
    !  Ⱦҥ٥ǡκ
    !  Generate half sigma level data
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
    r_Sigma(0:kmax) = invalid_value_r_Sigma

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST
    nmlfile_valid = .false.
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, & ! (in)
        & r_Sigma_ = r_Sigma, &           ! (inout)
        & err = err )                     ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if

      if ( any( r_Sigma < 0.0_DP ) ) then
        insufficient_num_r_Sigma = count( r_Sigma < 0.0_DP )
        call MessageNotify( 'W', subname, &
          & 'Number of data "%c" from "%c" is "%d" (insufficient). ' // &
          & 'Number of grids must be "%d".', &
          & c1='r_Sigma', c2=trim(nmlfile), &
          & i=(/kmax + 1 - insufficient_num_r_Sigma, kmax + 1/) )
      else
        nmlfile_valid = .true.
        call MessageNotify( 'M', subname, &
          & '"%c" is loaded from "%c".', &
          & c1='r_Sigma', c2=trim(nmlfile) )
        call MessageNotify( 'M', subname, &
          & '%c(%d:%d) = %*f', &
          & c1='r_Sigma', i=(/0, kmax/), d=r_Sigma, n=(/kmax+1/) )
      end if
    end if

    if ( nmlfile_valid ) then
    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    elseif (present(r_SigmaSet)) then
      size_r_SigmaSet = size(r_SigmaSet)
      if (.not. size_r_SigmaSet == kmax + 1) then
        call MessageNotify('W', subname, &
          & 'Size of argument r_SigmaSet (%d) is mismatch to kmax + 1 (%d). ' // &
          & 'Modify the size of r_SigmaSet to kmax + 1 (%d).', &
          & i=(/size_r_SigmaSet, kmax + 1, kmax + 1/))
        stat = DCPAM_EARGSIZEMISMATCH
        cause_c = 'r_SigmaSet'
        goto 999
      end if
      r_Sigma(0:kmax) = r_SigmaSet

    !-------------------------
    !  ư
    !  Automatic setting
    else
      select case ( LChar( trim(sig_dat % pattern) ) )
      case ('default')
        select case (kmax)
        case (2)
          r_Sigma(0:kmax) = (/ &
            & 1.0_DP, 0.63_DP, 0.0_DP /)
        case (12)
          r_Sigma(0:kmax) = (/ &
            & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.85_DP, &
            & 0.75_DP, 0.63_DP, 0.50_DP, 0.36_DP, 0.22_DP, &
            & 0.10_DP, 0.05_DP, 0.00_DP /)
        case (16)
          r_Sigma(0:kmax) = (/ &
            & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.87_DP, &
            & 0.79_DP, 0.70_DP, 0.60_DP, 0.50_DP, 0.41_DP, &
            & 0.33_DP, 0.26_DP, 0.20_DP, 0.15_DP, 0.10_DP, &
            & 0.05_DP, 0.00_DP /)
        case (20)
          r_Sigma(0:kmax) = (/ &
            & 1.00_DP, 0.95_DP, 0.90_DP, 0.85_DP, 0.80_DP, &
            & 0.75_DP, 0.70_DP, 0.65_DP, 0.60_DP, 0.55_DP, &
            & 0.50_DP, 0.45_DP, 0.40_DP, 0.35_DP, 0.30_DP, &
            & 0.25_DP, 0.20_DP, 0.15_DP, 0.10_DP, 0.05_DP, &
            & 0.0_DP /)
        case default
          call MessageNotify('W', subname, &
            & '%c = %*d is only valid. ', &
            & i=(/2,12,16,20/), n=(/4/), c1='kmax' )
          stat = DCPAM_EBADNUMBER
          cause_c = 'kmax'
          cause_i = kmax
          goto 999
        end select
      case default
        stat = DCPAM_EBADPATTERN
        cause_c = trim(pattern)
        goto 999
      end select
    end if

    allocate( sig_dat % r_Sigma(0:kmax) )
    sig_dat % r_Sigma(0:kmax) = r_Sigma(0:kmax)

    !-----------------------------------------------------------------
    !  ҥ٥ǡκ
    !  Generate full sigma level data
    !-----------------------------------------------------------------
    do k = 0, kmax - 1
      z_DelSigma(k) = r_Sigma(k) - r_Sigma(k+1)
    enddo
    allocate( sig_dat % z_DelSigma(0:kmax-1) )
    sig_dat % z_DelSigma = z_DelSigma

    do k = 0, kmax - 1
      z_Sigma(k) = &
        & ( &
        &   ( r_Sigma(k) ** ( 1.0_DP + Kappa ) &
        &     - r_Sigma(k+1) ** ( 1.0_DP + Kappa ) ) &
        &   / ( z_DelSigma(k) *  ( 1.0_DP + Kappa ) ) &
        & ) ** ( 1.0_DP / Kappa )
    enddo

    allocate( sig_dat % z_Sigma(0:kmax-1) )
    sig_dat % z_Sigma = z_Sigma

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( sig_dat % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    sig_dat % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c, cause_i )
    call EndSub( subname )
  end subroutine SigmaDataCreate

  subroutine SigmaDataClose( sig_dat, err )
    !
    ! SIGDAT ѿνλԤޤ.
    ! ʤ, Ϳ줿 *sig_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "SIGDAT".
    ! Note that if *sig_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SIGDAT), intent(inout):: sig_dat
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SigmaDataClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. sig_dat % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'SIGDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "SIGDAT" ξõ
    !  Clear the settings for "SIGDAT"
    !-----------------------------------------------------------------
    deallocate( sig_dat % z_Sigma )
    deallocate( sig_dat % r_Sigma )
    deallocate( sig_dat % z_DelSigma )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    sig_dat % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SigmaDataClose

  subroutine SigmaDataPutLine( sig_dat, unit, indent, err )
    !
    !  *sig_dat* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *sig_dat*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(SIGDAT), intent(in):: sig_dat
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'SigmaDataPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "SIGDAT" ΰ
    !  Print the settings for "SIGDAT"
    !-----------------------------------------------------------------
    if ( sig_dat % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SIGDAT:: @initialized=%y @pattern=%c @kmax=%d', &
        & i=(/sig_dat % kmax/), c1=trim(sig_dat % pattern), &
        & l=(/sig_dat % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Cp=%f @RAir=%f @Kappa=%f', &
        & d=(/sig_dat % Cp, sig_dat % RAir, sig_dat % Kappa/))

      call PutLine( sig_dat % z_Sigma, unit = out_unit, &
        & lbounds = lbound(sig_dat % z_Sigma), &
        & ubounds = ubound(sig_dat % z_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_Sigma=' )

      call PutLine( sig_dat % r_Sigma, unit = out_unit, &
        & lbounds = lbound(sig_dat % r_Sigma), &
        & ubounds = ubound(sig_dat % r_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @r_Sigma=' )

      call PutLine( sig_dat % z_DelSigma, unit = out_unit, &
        & lbounds = lbound(sig_dat % z_DelSigma), &
        & ubounds = ubound(sig_dat % z_DelSigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_DelSigma=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<SIGDAT:: @initialized=%y>', &
        & l=(/sig_dat % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SigmaDataPutLine

  logical function SigmaDataInitialized( sig_dat ) result(result)
    !
    ! *sig_dat* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *sig_dat* is initialized, .true. is returned.
    ! If *sig_dat* is not initialized, .false. is returned.
    !
    implicit none
    type(SIGDAT), intent(in):: sig_dat
  continue
    result = sig_dat % initialized
  end function SigmaDataInitialized

  subroutine SigmaDataNmlRead( nmlfile, &
    & r_Sigma_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: DC_NOERR, DC_ENOFILEREAD
    use dcpam_error, only: StoreError, DCPAM_ENMLARRAYINSUFF
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    real(DP), intent(inout):: r_Sigma_ (:)
    integer, parameter:: size_r_Sigma = 256
    real(DP):: r_Sigma (1:size_r_Sigma)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /sigma_data_nml/ &
      & r_Sigma
                              ! sigma_data ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! sigma_data#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "sigma_data" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "sigma_data#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: size_r_Sigma_
    real(DP), parameter:: invalid_value_r_Sigma = -999.0_DP
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'SigmaDataNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  ̵ʥǥեͤ NAMELIST ѿ
    !  Substitute invalid default values to NAMELIST group
    !-----------------------------------------------------------------
    r_Sigma = invalid_value_r_Sigma

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = sigma_data_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='sigma_data_nml', c2=trim(nmlfile) )
!      write(STDOUT, nml = sigma_data_nml)  ! Size of r_Sigma is too large.
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='sigma_data_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    if ( all( r_Sigma > - 1.0_DP ) ) then
      call MessageNotify( 'W', subname, &
        & 'Array size of "%c" from "%c" exceeds prepared size "%d". ' // &
        & 'Edit "%c" manually.', &
        & c1='r_Sigma', c2=trim(nmlfile), c3='size_r_Sigma', &
        & i=(/size_r_Sigma/) )
      stat = DCPAM_ENMLARRAYINSUFF
      cause_c = 'r_Sigma'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  NAMELIST ѿ
    !  Substitute NAMELIST group to arguments
    !-----------------------------------------------------------------
    size_r_Sigma_ = size( r_Sigma_ )
    r_Sigma_ = r_Sigma(1:size_r_Sigma_)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SigmaDataNmlRead

  subroutine SigmaDataGet( sig_dat, &
    & z_Sigma, r_Sigma, z_DelSigma, &
    & err )
    !
    ! Һɸǡ֤ޤ.
    !    
    ! ʤ, Ϳ줿 *sig_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return sigma coordinate data.
    !
    ! If *sig_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(SIGDAT), intent(inout):: sig_dat
    real(DP), intent(out):: z_Sigma (0:sig_dat%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(out):: r_Sigma (0:sig_dat%kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), intent(out), optional:: z_DelSigma (0:sig_dat%kmax-1)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    integer:: param_i
!!$    real(DP):: param_r
!!$    character(STRING):: param_c

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'SigmaDataGet'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. sig_dat % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'SIGDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  $ \sigma $ (, Ⱦ) ٥
    !  Configure full and half $ \sigma $ level data
    !-----------------------------------------------------------------
    z_Sigma = sig_dat % z_Sigma
    r_Sigma = sig_dat % r_Sigma

    !-----------------------------------------------------------------
    ! $ \Delta \sigma $ () 
    ! Configure $ \Delta \sigma $ (Full)
    !-----------------------------------------------------------------
    if (present(z_DelSigma)) z_DelSigma = sig_dat % z_DelSigma

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine SigmaDataGet


!!$  subroutine SigmaDataSample( sig_dat, err )
!!$    !--
!!$    ! SigmaDataSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *sig_dat*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of SigmaDataSample
!!$    !++
!!$    ! If *sig_dat* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(SIGDAT), intent(inout):: sig_dat
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'SigmaDataSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. sig_dat % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'SIGDAT'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *sig_dat* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *sig_dat*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = sig_dat % param_i
!!$!!$    param_r = sig_dat % param_r
!!$!!$    param_c = sig_dat % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine SigmaDataSample

end module sigma_data
