!= initial_data ⥸塼Υƥȥץ
!
!= Test program for "initial_data"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: initial_data_test.f90,v 1.1 2007/09/01 20:08:12 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! initial_data ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "initial_data" module.
! Confirm compilation and execution of this program.
!

program initial_data_test
  use constants, only: CONST, Create, Get
  use initial_data, only: INIDAT, Create, Close, &
    & PutLine, initialized, GetAxes, GetData
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'initial_data_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "initial_data" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 12         ! ľؿ. 
                              ! Number of vertical level

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: z_Sigma (:) ! . Latitude
  real(DP), allocatable:: r_Sigma (:) ! . Latitude
!!$  real(DP), allocatable:: x_LonAns (:) ! . Longitude
!!$  real(DP), allocatable:: y_LatAns (:) ! . Latitude
!!$  real(DP), allocatable:: z_SigmaAns (:) ! . Latitude
!!$  real(DP), allocatable:: r_SigmaAns (:) ! . Latitude

  !---------------------------------------------------------
  !  ͥǡ
  !  surface data
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Vor (:,:,:)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
  real(DP), allocatable:: xyz_Div (:,:,:)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T (t-\Delta t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure

!!$  real(DP), allocatable:: xyz_VorAns (:,:,:)
!!$                              ! $ \zeta (t-\Delta t) $ . . Vorticity
!!$  real(DP), allocatable:: xyz_DivAns (:,:,:)
!!$                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
!!$  real(DP), allocatable:: xyz_TempAns (:,:,:)
!!$                              ! $ T (t-\Delta t) $ .     . Temperature
!!$  real(DP), allocatable:: xyz_QVapAns (:,:,:)
!!$                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
!!$  real(DP), allocatable:: xy_PsAns (:,:)
!!$                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure


  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option

  type(INIDAT):: ini_dat00, ini_dat01
  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './initial_data_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( ini_dat = ini_dat00, & ! (inout)
    & nmax = nmax, imax = imax, jmax = jmax, kmax = kmax ) ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(ini_dat00) )
  call PutLine( ini_dat = ini_dat00 ) ! (in)

  !---------------------------------------------------------
  !  ǡƥ
  !  Axes data test
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( z_Sigma (0:kmax-1) )
  allocate( r_Sigma (0:kmax) )

  call GetAxes( ini_dat = ini_dat00, &       ! (inout)
    & x_Lon = x_Lon, y_Lat = y_Lat, &        ! (out)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma ) ! (out)

  call PutLine( x_Lon, &
    & lbounds = lbound(x_Lon), &
    & ubounds = ubound(x_Lon), &
    & indent = ' x_Lon=' )

  call PutLine( y_Lat, &
    & lbounds = lbound(y_Lat), &
    & ubounds = ubound(y_Lat), &
    & indent = ' y_Lat=' )

  call PutLine( z_Sigma, &
    & lbounds = lbound(z_Sigma), &
    & ubounds = ubound(z_Sigma), &
    & indent = ' z_Sigma=' )

  call PutLine( r_Sigma, &
    & lbounds = lbound(r_Sigma), &
    & ubounds = ubound(r_Sigma), &
    & indent = ' r_Sigma=' )

  !---------------------------------------------------------
  !  ͥǡƥ
  !  Initial data test
  !---------------------------------------------------------
  allocate( xyz_Vor (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_Div (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xy_Ps (0:imax-1, 0:jmax-1) )

  call GetData( ini_dat = ini_dat00, & ! (inout)
    & xyz_Vor = xyz_Vor, &   ! (out)
    & xyz_Div = xyz_Div, &   ! (out)
    & xyz_Temp = xyz_Temp, & ! (out)
    & xyz_QVap = xyz_QVap, & ! (out)
    & xy_Ps = xy_Ps )        ! (out)

  call PutLine( xyz_Vor, &
    & lbounds = lbound(xyz_Vor), &
    & ubounds = ubound(xyz_Vor), &
    & indent = ' xyz_Vor=' )

  call PutLine( xyz_Div, &
    & lbounds = lbound(xyz_Div), &
    & ubounds = ubound(xyz_Div), &
    & indent = ' xyz_Div=' )

  call PutLine( xyz_Temp, &
    & lbounds = lbound(xyz_Temp), &
    & ubounds = ubound(xyz_Temp), &
    & indent = ' xyz_Temp=' )

  call PutLine( xy_Ps, &
    & lbounds = lbound(xy_Ps), &
    & ubounds = ubound(xy_Ps), &
    & indent = ' xy_Ps=' )

  call PutLine( xyz_QVap, &
    & lbounds = lbound(xyz_QVap), &
    & ubounds = ubound(xyz_QVap), &
    & indent = ' xyz_QVap=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( ini_dat = ini_dat00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(ini_dat00) )
  call PutLine( ini_dat = ini_dat00 ) ! (in)

  !---------------------------------------------------------
  !  NAMELIST ɤ߹ߥƥ
  !  NAMELIST loading test
  !---------------------------------------------------------
  call Create( ini_dat = ini_dat01, & ! (inout)
    & nmax = nmax, imax = imax, jmax = jmax, kmax = kmax, &
    & nmlfile = VAL_namelist, err = err ) ! (in)
  call AssertEqual( 'NAMELIST loading test 1', &
    & answer = .true., check = err )
  call PutLine( ini_dat = ini_dat01 ) ! (in)


end program initial_data_test
