!= ⥸塼
!
!= Initial data generation module
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: initial_data.f90,v 1.8 2007/09/04 19:07:18 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module initial_data
  !
  != ⥸塼
  !
  != Initial data generation module
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! GCM νͤȤʤǡޤ.
  ! եؤνϤϼץǹԤȤꤷƤޤ.
  !
  ! Initial data for GCM is generated.
  ! File output is expected to done by a main program.
  !
  !== Procedures List
  !
  ! Create        :: INIDAT ѿν
  ! GetAxes       :: ǡμ
  ! GetData       :: ͥǡμ
  ! Close         :: INIDAT ѿνλ
  ! PutLine       :: INIDAT ѿ˳ǼƤΰ
  ! initialized   :: INIDAT ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "INIDAT"
  ! GetAxes       :: Get axes data
  ! GetData       :: Get initial data
  ! Close         :: Deconstructor of "INIDAT"
  ! PutLine       :: Print information of "INIDAT"
  ! initialized   :: Check initialization of "INIDAT"
  !
  !== Usage
  !
  ! Ϥ, INIDAT ѿ, Create ǽԤޤ.
  ! , GetData ˤäƽͤɤ߹Ǥ.
  ! ǡɤ߹ˤ GetAxes ѤƤ.
  ! Ǹ, INIDAT ѿνλ Close ˤƹԤޤ.
  !
  ! First, initialize "INIDAT" by "Create".
  ! Then, get initial data by "GetData".
  ! If axes data is needed, get it by "GetAxes".
  ! Finally, terminate "INIDAT" by "Close".
  !

  use dc_types, only: TOKEN, DP
  implicit none
  private
  public:: INIDAT, Create, GetData, GetAxes, Close, PutLine, initialized

  type INIDAT
    !
    ! ޤ, Create  "INIDAT" ѿꤷƲ.
    ! 줿 "INIDAT" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "INIDAT" variable by "Create" before usage.
    ! If you reuse "INIDAT" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.    ! initialization flag
    character(TOKEN):: pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
                              ! 
                              ! * "AGCM 5.3 Default"
                              ! 
    integer:: nmax ! ȿ. 
                   ! Maximum truncated wavenumber
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air

    real(DP):: Omega      ! $ \Omega $ . ž®      Angular velocity

    real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet

    real(DP), pointer:: x_Lon (:) =>null()
                              ! . Longitude
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), pointer:: r_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), pointer:: z_DelSigma (:) =>null()
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
    real(DP), pointer:: n_WaveNumber (:) =>null()
                              ! ȿ֤μǡ

    real(DP), pointer:: xyz_Vor (:,:,:) =>null()
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
    real(DP), pointer:: xyz_Div (:,:,:) =>null()
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
    real(DP), pointer:: xyz_Temp (:,:,:) =>null()
                              ! $ T (t-\Delta t) $ .     . Temperature
    real(DP), pointer:: xyz_QVap (:,:,:) =>null()
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
    real(DP), pointer:: xy_Ps (:,:) =>null()
                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure

!change
    real(DP), pointer:: n_ESp(:)           ! ͥ륮ڥȥ
    real(DP), pointer:: Vor_bc(:,:)        ! η

  end type INIDAT

  logical, save:: wa_module_initialized_stored = .false.

  character(*), parameter:: version = &
    & '$Name: dcpam4-20070909 $' // &
    & '$Id: initial_data.f90,v 1.8 2007/09/04 19:07:18 morikawa Exp $'

  interface Create
    module procedure InitialDataCreate
  end interface

  interface Close
    module procedure InitialDataClose
  end interface

  interface PutLine
    module procedure InitialDataPutLine
  end interface

  interface initialized
    module procedure InitialDataInitialized
  end interface

  interface NmlRead
    module procedure InitialDataNmlRead
  end interface

  interface GetData
    module procedure InitialDataGetData
  end interface

  interface GetAxes
    module procedure InitialDataGetAxes
  end interface

contains

  subroutine InitialDataCreate( ini_dat, &
    & nmax, imax, jmax, kmax, &
    & Cp, RAir,  &
    & r_SigmaSet, &
    & Omega, &
    & RPlanet, &
    & pattern, &
    & wa_module_initialized, &
    & nmlfile, err )
    !
    ! INIDAT ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! INIDAT ѿꤷƤ.
    !
    ! ץʥ *Cp*  *RAir* Ⱦ $ \sigma $ 
    ! ٥뤫 $ \sigma $ ٥ݤ˻Ѥޤ. 
    ! ΰͿʤ, ϵǤɸ 
    ! (constants ⥸塼뤫ǥե) Ѥޤ.
    !
    ! ʤ, Ϳ줿 *ini_dat* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#initial_data_nml 򻲾ȤƤ. 
    !
    ! Constructor of "INIDAT". 
    ! Initialize *ini_dat* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Optinal arguments *Cp* and *RAir* are used when 
    ! full $ \sigma $ level is created from half $ \sigma $ level. 
    ! If these arguments are not given, standard values on Earth 
    ! (default valuses provided by "constants" module) are used instead.
    !
    ! Note that if *ini_dat* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#initial_data_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_error, only: DC_NOERR, DC_EALREADYINIT, DC_ENEGATIVE, &
      & DC_ENOFILEREAD, DC_ENOTINIT
    use dc_string, only: LChar
    use dcpam_error, only: StoreError, DCPAM_EBADPATTERN
    use dc_message, only: MessageNotify
    use constants, only: CONST, Create, Get
    use wa_module, only: wa_Initial, x_Lon_spml => x_Lon, y_Lat_spml => y_Lat
    use sigma_data, only: SIGDAT, Create, Close, &
      & PutLine, initialized, Get
!    use spml_mod, only: xy_w
    use w_module, only: l_nm, w_Lapla_w
    use wa_module, only: xy_w, w_xy

    implicit none
    type(INIDAT), intent(inout):: ini_dat
    integer, intent(in):: nmax ! ȿ. 
                               ! Maximum truncated wavenumber
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in), optional:: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in), optional:: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in), optional:: Omega      ! $ \Omega $ . ž®      Angular velocity
    real(DP), intent(in), optional:: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    real(DP), intent(in), optional:: r_SigmaSet (:)
                              ! ǥեȤǤ, kmax ͤ˱,
                              ! ưŪ $ \sigma $ ٥ (Ⱦ) 
                              ! ꤵ (kmax ͤΤ).
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Ūꤹɬפ, 
                              ! ΰͿ.
                              !
                              ! By default, half $ \sigma $ level is 
                              ! specified automatically according to
                              ! the value of kmax (only the value is 
                              ! same as particular values).
                              ! If the half $ \sigma $ level is specified
                              ! manually, give this argument.
    character(*), intent(in), optional:: pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
                              ! 
                              ! * "AGCM 5.3 Default"
                              ! 
    logical, intent(in), optional :: wa_module_initialized
                              ! wa_module (SPMODEL 饤֥) ե饰. 
                              ! SPMODEL 饤֥ wa_module  
                              ! 
                              ! ˥ץ 
                              ! wa_Initial ˤäƽƤ, 
                              !  wa_Initial Ƥ֤ȥ顼ޤ.
                              ! ΰ .true. Ϳ뤳Ȥ, 
                              ! wa_Initial ƤФʤ褦ˤޤ.
                              ! 
                              ! "wa_module" (SPMODEL library) 
                              ! initialization flag. 
                              ! 
                              ! When "wa_module" (SPMODEL library) 
                              ! is initialized by
                              ! "wa_Initial" already, second "wa_Initial"
                              ! causes an error.
                              ! If .true. is specified to this argument,
                              ! "wa_Initial" is not called.
                              ! 
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#initial_data_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#initial_data_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(CONST):: const_earth
    type(SIGDAT):: sig_dat

    integer:: k, l            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'InitialDataCreate'

!change
    ! ʬ
    integer              :: random_seed_size   ! μĹ
    integer, allocatable :: seedarray(:)       ! μ
    real, allocatable    :: harvest(:)         ! 
    integer    :: seed=0             ! seed(1)ꤹ

    ! ǥ˹碌
    real(DP)   :: U_scale=10.0D0     ! ٤ͭѤ®٥

    ! N=21
!    integer    :: nzero=14           ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=18           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=42
!    integer    :: nzero=21           ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=25           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=42_ver2 ȿԡ礭
!    integer    :: nzero=30           ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=25           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=42_ver3 ȿԡ򾮤
!    integer    :: nzero=14           ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=25           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=85
    integer    :: nzero=30           ! ͥ륮ڥȥʬۤΥѥ᥿
    integer    :: gamma=30           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=170
!    integer    :: nzero=40           ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=40           ! ͥ륮ڥȥʬۤΥѥ᥿

    ! N=170_ver2
!    integer    :: nzero=4            ! ͥ륮ڥȥʬۤΥѥ᥿
!    integer    :: gamma=40           ! ͥ륮ڥȥʬۤΥѥ᥿

    real(DP)   :: Etotal=1.0D0       ! ͥ륮
    real(DP)   :: Radius=1.0D0       ! Ⱦ

    real(DP), pointer :: xy_StrFunc(:,:)    ! ʻǡ(ήؿ)
    real(DP), pointer :: xyz_StrFunc(:,:,:) ! ʻǡ(ήؿ)
    real(DP), pointer :: xy_Vor(:,:)        ! (ľʬ)
    real(DP), pointer :: xyz_Vor(:,:,:)       ! (ľʬ)

    ! ѿ(ڥȥǡ)
    real(DP), allocatable  :: w_Vor(:)           ! (ľʬ)
    real(DP), allocatable  :: w_StrFunc(:)       ! ήؿ
    real(DP), allocatable  :: n_ESp(:)           ! ͥ륮ڥȥ
    real(DP), allocatable  :: Vor_bc(:,:)           ! η
    real(DP), allocatable  :: Vor_tmp(:,:)           ! ¸
    real(DP), allocatable  :: n_EnsSp(:)         ! 󥹥ȥեڥȥ

    ! ѥ᥿
    integer :: n, m

  continue
    call BeginSub(subname, version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (ini_dat % initialized) then
      stat = DC_EALREADYINIT
      cause_c = 'INIDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʻ
    !  Configure grid point
    !-----------------------------------------------------------------
    ini_dat % nmax = nmax
    ini_dat % imax = imax
    ini_dat % jmax = jmax
    ini_dat % kmax = kmax

    !-----------------------------------------------------------------
    !  ͥǡΥѥ
    !  Get initial data pattern from argument
    !-----------------------------------------------------------------
    if ( present(pattern) ) then
      ini_dat % pattern = pattern
    else
      ini_dat % pattern = ''
    end if

    !---------------------------------------------------------
    !  ʪν
    !  Prepare physical constants
    !---------------------------------------------------------
    call Create( const_earth, nmlfile = nmlfile ) ! (inout)
    call Get( constant = const_earth, &               ! (inout)
      & Cp = ini_dat % Cp, RAir = ini_dat % RAir, &   ! (out)
      & Omega = ini_dat % Omega, &                    ! (out)
      & RPlanet = ini_dat % RPlanet )                   ! (out)

    if ( present(Cp) ) ini_dat % Cp = Cp
    if ( present(RAir) ) ini_dat % RAir = RAir
    if ( present(Omega) ) ini_dat % Omega = Omega
    if ( present(RPlanet) ) ini_dat % RPlanet = RPlanet

    !-----------------------------------------------------------------
    !  NAMELIST ͤ
    !  Get values from NAMELIST
    !-----------------------------------------------------------------
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & nmax = ini_dat % nmax, &   ! (inout)
!!$        & imax = ini_dat % imax, &   ! (inout)
!!$        & jmax = ini_dat % jmax, &   ! (inout)
!!$        & kmax = ini_dat % kmax, &   ! (inout)
        & Cp = ini_dat % Cp, &   ! (inout)
        & RAir = ini_dat % RAir, &   ! (inout)
        & Omega = ini_dat % Omega, &   ! (inout)
        & RPlanet = ini_dat % RPlanet, &   ! (inout)
        & pattern_ = ini_dat % pattern, &  ! (inout)
        & err = err )                          ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (ini_dat % nmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'nmax'
      goto 999
    end if
    if (ini_dat % imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (ini_dat % jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (ini_dat % kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ͥǡΥѥ
    !  Initial data pattern
    !-----------------------------------------------------------------
    if ( trim(ini_dat % pattern) == '' ) then
      ini_dat % pattern = 'AGCM 5.3 Default'  ! ߤϻŪ AGCM 5.3 ΥǥեͤǥեȤˤ
    else
      select case ( LChar( trim(ini_dat % pattern) ) )
      case ('agcm 5.3 default')
      case default
        stat = DCPAM_EBADPATTERN
        cause_c = trim(ini_dat % pattern)
        goto 999
      end select
    end if

    !-----------------------------------------------------------------
    !  ٷټǡ
    !  Create longitude and latitude axes data
    !-----------------------------------------------------------------
    if ( .not. present_and_true(wa_module_initialized) ) then
      if (wa_module_initialized_stored) then
        call MessageNotify('W', subname, &
          & 'spml library wa_module can not be initialized more than once.' // &
          & ' Object (DYNSP) was not initialized.')
        stat = DC_ENOTINIT
        cause_c = 'DYNSP'
        goto 999
      else
        call wa_Initial( ini_dat % nmax, ini_dat % imax, ini_dat % jmax, ini_dat % kmax ) ! (in)
        wa_module_initialized_stored = .true.
      end if
    elseif ( present_and_true(wa_module_initialized) ) then
      wa_module_initialized_stored = .true.
    end if

    allocate( ini_dat % x_Lon (0:ini_dat%imax-1) )
    ini_dat % x_Lon = x_Lon_spml
    allocate( ini_dat % y_Lat (0:ini_dat%jmax-1) )
    ini_dat % y_Lat = y_Lat_spml

    !-----------------------------------------------------------------
    !  ҥ٥뼴ǡ
    !  Create sigma level axis data
    !-----------------------------------------------------------------
    call Create( sig_dat = sig_dat, &               ! (inout)
      & kmax = ini_dat % kmax, &                    ! (in)
      & Cp = ini_dat % Cp, RAir = ini_dat % RAir, & ! (in)
      & r_SigmaSet = r_SigmaSet, &                  ! (in)
      & nmlfile = nmlfile )                         ! (in)

    allocate( ini_dat % r_Sigma (0:ini_dat%kmax) )
    allocate( ini_dat % z_Sigma (0:ini_dat%kmax-1) )
    allocate( ini_dat % z_DelSigma (0:ini_dat%kmax-1) )

    call Get( sig_dat = sig_dat, &          ! (inout)
      & z_Sigma = ini_dat % z_Sigma, &      ! (out)
      & r_Sigma = ini_dat % r_Sigma, &      ! (out)
      & z_DelSigma = ini_dat % z_DelSigma ) ! (out)



    allocate( ini_dat % n_WaveNumber (1:ini_dat%nmax-1) )
    do l = 1, ini_dat % nmax
      ini_dat % n_WaveNumber(l) = l
    end do

    !-----------------------------------------------------------------
    !  ͥǡκ
    !  Generate initial data
    !-----------------------------------------------------------------
    allocate( ini_dat % xyz_Vor (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1) )
    allocate( ini_dat % xyz_Div (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1) )
    allocate( ini_dat % xyz_Temp (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1) )
    allocate( ini_dat % xyz_QVap (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1) )
    allocate( ini_dat % xy_Ps (0:ini_dat%imax-1, 0:ini_dat%jmax-1) )

    select case ( LChar( trim(ini_dat % pattern) ) )

    !-----------------------------------
    !  AGCM5.3 ΥǥեȽ
    !  AGCM5.3 default initial values
    case ('agcm 5.3 default')
!      ini_dat % xyz_Vor = 0.0_DP
      ini_dat % xyz_Div = 0.0_DP
      ini_dat % xyz_QVap = 1.0e-10_DP
      ini_dat % xy_Ps = 1.0e5_DP

      ini_dat % xyz_Temp = 285.0_DP
!      ini_dat % xyz_Temp = 124.0_DP  ! 
!       ini_dat % xyz_Temp = 141.0_DP


!      do k = 0, ini_dat % kmax - 1
!        do i = 0, ini_dat % imax - 1
!          do j = 0, ini_dat % jmax - 1
!            ini_dat % xyz_Temp(i,j,k) = ini_dat % xyz_Temp(i,j,k) &
!              &  + 0.1_DP * sin ( real( i * j * ( kmax - 1 - k ) ) &
!              &                  / real( ini_dat % imax * ini_dat % jmax * ini_dat % kmax, DP ) * 10.0_DP &
!              &                 )
!          end do
!        end do
!      end do

    allocate( xy_StrFunc(0:imax-1,0:jmax-1) )
    allocate( xyz_StrFunc(0:imax-1,0:jmax-1,0:kmax-1) )
    allocate( xy_Vor(0:imax-1,0:jmax-1) )
    allocate( xyz_Vor(0:imax-1,0:jmax-1,0:kmax-1) )
    allocate( w_Vor((nmax+1)*(nmax+1)),w_StrFunc((nmax+1)*(nmax+1)) )
    allocate( n_ESp(1:nmax),n_EnsSp(1:nmax) )
    allocate( Vor_bc(0:imax-1,0:jmax-1) )
    allocate( Vor_tmp(0:imax-1,0:jmax-1) )

!change
!#   Kitamura, Matsuda νͤ

    ! 
    call random_seed(size=random_seed_size)
    allocate(seedarray(random_seed_size))
    call random_seed(get=seedarray)
    seedarray(1)=seed
    call random_seed(put=seedarray)

    ! ѤŬήؿ
    w_StrFunc = 0.0d0
    do n=1,nmax
       allocate(harvest(-n:n))
       call random_number(harvest)
       w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))=2.0 * harvest - 1 ! [-1,1] ΰ
       n_ESp(n) = 0.5 * n*(n+1)*sum(w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2)
       deallocate(harvest)
    enddo

    ! ڥȥʬۤη
    do n=1,nmax
      do m=-n,n
        if ( n_ESp(n) .ne. 0.0d0 ) then
          w_StrFunc(l_nm(n,m)) = w_StrFunc(l_nm(n,m)) &
            & * sqrt( (dble(n)**(gamma/2)/dble(n+nzero)**gamma) /n_ESp(n))
        endif
      enddo
    enddo

    ! ͥ륮ڥȥƷ׻
    do n=1,nmax
      n_ESp(n) = 0.5 * n*(n+1)* sum( w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2 )
    enddo

    ! ͥ륮礭.
    w_StrFunc = w_StrFunc * sqrt(Etotal/sum(n_ESp))
    ! ήؿ  
    xy_StrFunc = xy_w(w_StrFunc)
    w_Vor = w_Lapla_w(w_StrFunc)/Radius**2

    xy_Vor =  xy_w(w_Vor)

    ! ٤Τ¸ߤͿ
    xyz_Vor(:,:,0) = xy_Vor
    xyz_Vor(:,:,1) = -xy_Vor

    ! xyz_Vor ͭ
    ! ®٥/Ⱦ ͭ
!    xyz_Vor = xyz_Vor * U_scale / ini_dat % RPlanet
     xyz_Vor = xyz_Vor * 10.0D0 / 6.371e6
!!! 2008/01/24 Ⱦ¤ͭ
!!    xyz_Vor = xyz_Vor * 50.0D0 / 7.149e7

    ini_dat % xyz_Vor = xyz_Vor

    ! ٤ + ͭ
!    Vor_bc = (-xy_Vor) * U_scale / ini_dat % RPlanet
    Vor_bc = (-xy_Vor) * 10.0D0 / 6.371e6
!!! 2008/01/14 Ⱦ¤ͭ
!!    Vor_bc = (-xy_Vor) * 50.0D0 / 7.149e7
    allocate( ini_dat % Vor_bc(0:imax-1,0:jmax-1))
    ini_dat % Vor_bc = Vor_bc

    ! ͥ륮ڥȥơ׻
    do n=1,nmax
      n_ESp(n) = 0.5 / (n*(n+1)) * sum( w_Vor(l_nm(n,(/(m,m=-n,n)/)))**2 )
    enddo

    allocate( ini_dat % n_ESp(1:nmax))
    ini_dat % n_ESp = n_ESp

    deallocate(seedarray)


    end select

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    ini_dat % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine InitialDataCreate

  subroutine InitialDataClose( ini_dat, err )
    !
    ! INIDAT ѿνλԤޤ.
    ! ʤ, Ϳ줿 *ini_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "INIDAT".
    ! Note that if *ini_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(INIDAT), intent(inout):: ini_dat
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'InitialDataClose'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. ini_dat % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'INIDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "INIDAT" ξõ
    !  Clear the settings for "INIDAT"
    !-----------------------------------------------------------------
    deallocate( ini_dat % x_Lon )
    deallocate( ini_dat % y_Lat )
    deallocate( ini_dat % r_Sigma )
    deallocate( ini_dat % z_Sigma )
    deallocate( ini_dat % xyz_Vor )
    deallocate( ini_dat % xyz_Div )
    deallocate( ini_dat % xyz_Temp )
    deallocate( ini_dat % xyz_QVap )
    deallocate( ini_dat % xy_Ps )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    ini_dat % initialized = .false.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine InitialDataClose

  subroutine InitialDataPutLine( ini_dat, unit, indent, err )
    !
    !  *ini_dat* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *ini_dat*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    use dc_string, only: Printf, PutLine
    implicit none
    type(INIDAT), intent(inout):: ini_dat
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνϤɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'InitialDataPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "INIDAT" ΰ
    !  Print the settings for "INIDAT"
    !-----------------------------------------------------------------
    if (ini_dat % initialized) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<INIDAT:: @initialized=%y @pattern="%c"', &
        & c1 = trim( ini_dat % pattern ), &
        & l = (/ini_dat % initialized/))

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @nmax=%d @imax=%d @jmax=%d @kmax=%d', &
        & i = (/ini_dat % nmax, ini_dat % imax, ini_dat % jmax, ini_dat % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Cp=%f @RAir=%f', &
        & d = (/ini_dat % Cp, ini_dat % RAir/) )

      call PutLine( ini_dat % x_Lon, unit = out_unit, &
        & lbounds = lbound(ini_dat % x_Lon), &
        & ubounds = ubound(ini_dat % x_Lon), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_Lon=' )

      call PutLine( ini_dat % y_Lat, unit = out_unit, &
        & lbounds = lbound(ini_dat % y_Lat), &
        & ubounds = ubound(ini_dat % y_Lat), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat=' )

      call PutLine( ini_dat % z_Sigma, unit = out_unit, &
        & lbounds = lbound(ini_dat % z_Sigma), &
        & ubounds = ubound(ini_dat % z_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_Sigma=' )

      call PutLine( ini_dat % r_Sigma, unit = out_unit, &
        & lbounds = lbound(ini_dat % r_Sigma), &
        & ubounds = ubound(ini_dat % r_Sigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @r_Sigma=' )

      call PutLine( ini_dat % z_DelSigma, unit = out_unit, &
        & lbounds = lbound(ini_dat % z_DelSigma), &
        & ubounds = ubound(ini_dat % z_DelSigma), &
        & indent = indent_str(1:indent_len) // &
        & ' @z_DelSigma=' )

      call PutLine( ini_dat % xyz_Vor, unit = out_unit, &
        & lbounds = lbound(ini_dat % xyz_Vor), &
        & ubounds = ubound(ini_dat % xyz_Vor), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyz_Vor=' )

      call PutLine( ini_dat % xyz_Div, unit = out_unit, &
        & lbounds = lbound(ini_dat % xyz_Div), &
        & ubounds = ubound(ini_dat % xyz_Div), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyz_Div=' )

      call PutLine( ini_dat % xyz_Temp, unit = out_unit, &
        & lbounds = lbound(ini_dat % xyz_Temp), &
        & ubounds = ubound(ini_dat % xyz_Temp), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyz_Temp=' )

      call PutLine( ini_dat % xy_Ps, unit = out_unit, &
        & lbounds = lbound(ini_dat % xy_Ps), &
        & ubounds = ubound(ini_dat % xy_Ps), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_Ps=' )

      call PutLine( ini_dat % xyz_QVap, unit = out_unit, &
        & lbounds = lbound(ini_dat % xyz_QVap), &
        & ubounds = ubound(ini_dat % xyz_QVap), &
        & indent = indent_str(1:indent_len) // &
        & ' @xyz_QVap=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<INIDAT:: @initialized=%y>', &
        & l=(/ini_dat % initialized/))
    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine InitialDataPutLine

  logical function InitialDataInitialized( ini_dat ) result(result)
    !
    ! *ini_dat* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *ini_dat* is initialized, .true. is returned.
    ! If *ini_dat* is not initialized, .false. is returned.
    !
    implicit none
    type(INIDAT), intent(in):: ini_dat
  continue
    result = ini_dat % initialized
  end function InitialDataInitialized

  subroutine InitialDataNmlRead( nmlfile, &
!!$    & nmax, imax, jmax, kmax, &
    & Cp, RAir, &
    & Omega, &
    & RPlanet, &
    & pattern_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: nmax ! ȿ. 
!!$                               ! Maximum truncated wavenumber
!!$    integer, intent(inout):: imax ! ٳʻ. 
!!$                               ! Number of grid points in longitude
!!$    integer, intent(inout):: jmax ! ٳʻ. 
!!$                               ! Number of grid points in latitude
!!$    integer, intent(inout):: kmax ! ľؿ. 
!!$                               ! Number of vertical level
    real(DP), intent(inout), optional:: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(inout), optional:: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(inout), optional:: Omega      ! $ \Omega $ . ž®      Angular velocity
    real(DP), intent(inout), optional:: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
    character(*), intent(inout):: pattern_
    character(TOKEN):: pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
                              ! 
                              ! * "AGCM 5.3 Default"
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /initial_data_nml/ &
!!$      & nmax, imax, jmax, kmax, &
      & Cp, RAir, &
      & Omega, RPlanet, &
      & pattern
                              ! initial_data ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! initial_data#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "initial_data" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "initial_data#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'InitialDataNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group-EEE:---
    !-----------------------------------------------------------------
    pattern = pattern_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = initial_data_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='initial_data_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = initial_data_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='initial_data_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments-EEE:---
    !-----------------------------------------------------------------
    pattern_ = pattern

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine InitialDataNmlRead

  subroutine InitialDataGetAxes( ini_dat, &
    & x_Lon, y_Lat, z_Sigma, r_Sigma, z_DelSigma, &
    & n_WaveNumber, &
    & err )
    !
    ! ɸǡ֤ޤ.
    !
    ! ʤ, Ϳ줿 *ini_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return axes data.
    !
    ! If *ini_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(INIDAT), intent(inout):: ini_dat
    real(DP), intent(out), optional:: x_Lon (0:ini_dat%imax-1)
                              ! . Longitude
    real(DP), intent(out), optional:: y_Lat (0:ini_dat%jmax-1)
                              ! . Latitude
    real(DP), intent(out), optional:: z_Sigma (0:ini_dat%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(out), optional:: r_Sigma (0:ini_dat%kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
    real(DP), intent(out), optional:: z_DelSigma (0:ini_dat%kmax-1)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
    real(DP), intent(out), optional:: n_WaveNumber (1:ini_dat%nmax)
                              ! ȿ֤μǡ
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'InitialDataGetAxes'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. ini_dat % initialized) then
      stat = DC_ENOTINIT
      cause_c = 'INIDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *ini_dat* ˳ǼɸǡμФ
    !  Fetch axes data from *ini_dat*
    !-----------------------------------------------------------------
    if ( present(x_Lon     ) ) x_Lon      = ini_dat % x_Lon
    if ( present(y_Lat     ) ) y_Lat      = ini_dat % y_Lat
    if ( present(z_Sigma   ) ) z_Sigma    = ini_dat % z_Sigma
    if ( present(r_Sigma   ) ) r_Sigma    = ini_dat % r_Sigma
    if ( present(z_DelSigma) ) z_DelSigma = ini_dat % z_DelSigma
    if ( present(n_WaveNumber) ) n_WaveNumber = ini_dat % n_WaveNumber

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine InitialDataGetAxes


  subroutine InitialDataGetData( ini_dat, &
    & xyz_Vor, xyz_Div, xyz_Temp, xyz_QVap, xy_Ps, n_ESp, Vor_bc, &
    & err )
    !
    ! GCM Ѥνͥǡ֤ޤ.
    ! , ȯ, , 漾, ɽ̵֤ޤ.
    !
    ! ʤ, Ϳ줿 *ini_dat*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Return initial data for GCM.
    ! Vorticity, divergence, temperature, specific humidity, surface pressure
    ! are returned.
    !
    ! If *ini_dat* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT

!change
!    use spml_mod, only: xy_w
!    use w_module, only: l_nm, w_Lapla_w

    implicit none
    type(INIDAT), intent(inout):: ini_dat
    real(DP), intent(out):: xyz_Vor (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
    real(DP), intent(out):: xyz_Div (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
    real(DP), intent(out):: xyz_Temp (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1)
                              ! $ T (t-\Delta t) $ .     . Temperature
    real(DP), intent(out):: xyz_QVap (0:ini_dat%imax-1, 0:ini_dat%jmax-1, 0:ini_dat%kmax-1)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:ini_dat%imax-1, 0:ini_dat%jmax-1)
                              ! $ P_s (t-\Delta t) $ .   ɽ̵. Surface pressure
    real(DP), intent(out), optional:: n_ESp(1:ini_dat%nmax)           ! ͥ륮ڥȥ
    real(DP), intent(out), optional:: Vor_bc(0:ini_dat%imax-1, 0:ini_dat%jmax-1)  ! η

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'InitialDataGet'

  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. ini_dat % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'INIDAT'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *ini_dat* ˳ǼͥǡμФ
    !  Fetch initial data from *ini_dat*
    !-----------------------------------------------------------------
    xyz_Vor  = ini_dat % xyz_Vor
    xyz_Div  = ini_dat % xyz_Div
    xyz_Temp = ini_dat % xyz_Temp
    xy_Ps    = ini_dat % xy_Ps
    xyz_QVap = ini_dat % xyz_QVap

    if ( present(n_ESp) ) n_ESp = ini_dat % n_ESp
    if ( present(Vor_bc) ) Vor_bc = ini_dat % Vor_bc

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine InitialDataGetData

end module initial_data
