!= phy_radiation_flux ⥸塼Υƥȥץ
!
!= Test program for "phy_radiation_flux"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_radiation_flux_test.f90,v 1.2 2007/09/25 12:37:25 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_radiation_flux ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_radiation_flux" module.
! Confirm compilation and execution of this program.
!

program phy_radiation_flux_test
  use phy_radiation_flux, only: PHYRADFLX, Create, Close, &
    & PutLine, initialized, RadiationFlux, RadiationDelTemp
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine, Printf
  use dc_message, only: MessageNotify
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_radiation_flux_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_radiation_flux" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure

  real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP):: y_Lat (0:jmax-1) ! . Latitude

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP):: xyr_RadLFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
  real(DP):: xya_SurfRadLMatrix (0:imax-1, 0:jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
  real(DP):: xyra_DelRadLFlux (0:imax-1, 0:jmax-1, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
  real(DP):: xyr_RadSFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

  !-----------------------------------
  !  ѴΨ
  !  Temperature tendency
  real(DP):: xyz_DRadLTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
  real(DP):: xyz_DRadSTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYRADFLX):: phy_radflx00, phy_radflx01, phy_radflx02, phy_radflx03
  logical:: err

  integer:: i                 ! DO 롼Ѻѿ
                              ! Work variables for DO loop

  character(*), parameter:: subname = 'phy_radiation_flux_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_radiation_flux_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, &            ! (inout)
    & PI = PI, Grav = Grav, Cp = Cp, StB = StB ) ! (out)

  !---------------------------------------------------------
  !  ٥ǡν
  !  Prepare latitude data
  !---------------------------------------------------------
  y_Lat = &
    & (/ -81.65059, -70.83464, -59.95486, -49.06072, &
    &    -38.16121, -27.25921, -16.35593,  -5.45204, &
    &      5.45204,  16.35593,  27.25921,  38.16121, &
    &     49.06072,  59.95486,  70.83464,  81.65059 /) * PI / 180.0_DP

  !---------------------------------------------------------
  !  ɽ̥ǡν
  !  Prepare surface data
  !---------------------------------------------------------
  xy_SurfTemp = 273.0_DP
  xy_SurfAlbedo = 0.3_DP

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_radflx = phy_radflx00, &    ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & y_Lat = y_Lat, &                         ! (in)
    & Grav = Grav, Cp = Cp, StB = StB, &       ! (in)
    & xy_SurfTemp = xy_SurfTemp, &             ! (in)
    & xy_SurfAlbedo = xy_SurfAlbedo, &         ! (in)
    & current_time_value = 0.0_DP, &           ! (in)
    & current_time_unit = 'sec', &             ! (in)
    & delta_time_value = 10.0_DP, &            ! (in)
    & delta_time_unit = 'minute', &            ! (in)
    & delta_time_value_RadLong = 30.0_DP, &    ! (in)
    & delta_time_unit_RadLong = 'minute', &    ! (in)
    & delta_time_value_RadShort = 20.0_DP, &   ! (in)
    & delta_time_unit_RadShort = 'minute' )    ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_radflx00) )
  call PutLine( phy_radflx = phy_radflx00 ) ! (in)

  !---------------------------------------------------------
  !  RadiationFlux ƥ
  !  RadiationFlux test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'Temp', &                      ! (in)
    & array = xyz_Temp )                       ! (out)

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'QVap', &                      ! (in)
    & array = xyz_QVap )                       ! (out)

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'PressM', &                    ! (in)
    & array = xyr_Press )                      ! (out)


  do i = 1, 4
    call RadiationFlux( phy_radflx = phy_radflx00, & ! (inout)
      & xyz_Temp = xyz_Temp, &                       ! (in)
      & xyz_QVap = xyz_QVap, &                       ! (in)
      & xyr_Press = xyr_Press, &                     ! (in)
      & xyr_RadLFlux = xyr_RadLFlux, &               ! (out)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &   ! (out)
      & xyra_DelRadLFlux = xyra_DelRadLFlux, &       ! (out)
      & xyr_RadSFlux = xyr_RadSFlux )                ! (out)

    call Printf(fmt = '')
    call MessageNotify('M', subname, 'current_time=%d minutes', &
      & i = (/ i * 10 /) )
    call PutLine( phy_radflx = phy_radflx00 ) ! (in)
    call Printf(fmt = '')

    call PutLine( xyr_RadLFlux, indent = ' xyr_RadLFlux=' )
    call PutLine( xya_SurfRadLMatrix, indent = ' xya_SurfRadLMatrix=' )
    call PutLine( xyra_DelRadLFlux, indent = ' xyra_DelRadLFlux=' )
    call PutLine( xyr_RadSFlux, indent = ' xyr_RadSFlux=' )

  end do

  !---------------------------------------------------------
  !  RadiationDelTemp ƥ
  !  RadiationDelTemp test
  !---------------------------------------------------------
  call RadiationDelTemp( phy_radflx = phy_radflx00, & ! (inout)
    & xyr_RadLFlux = xyr_RadLFlux, &                  ! (in)
    & xyr_RadSFlux = xyr_RadSFlux, &                  ! (in)
    & xyr_Press = xyr_Press, &                        ! (in)
    & xyz_DRadLTempDt = xyz_DRadLTempDt, &            ! (out)
    & xyz_DRadSTempDt = xyz_DRadSTempDt )             ! (out)

  call PutLine( xyz_DRadLTempDt, indent = ' xyz_DRadLTempDt=' )
  call PutLine( xyz_DRadSTempDt, indent = ' xyz_DRadSTempDt=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_radflx = phy_radflx00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_radflx00) )
  call PutLine( phy_radflx = phy_radflx00 ) ! (in)

  call Close( phy_radflx = phy_radflx02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_radiation_flux_test
