!= phy_hs94 ⥸塼Υƥȥץ
!
!= Test program for "phy_hs94"
!
! Authors::   unknown
! Version::   $Id: phy_hs94_test.f90,v 1.3 2007/08/03 06:45:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_hs94 ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_hs94" module.
! Confirm compilation and execution of this program.
!

program phy_hs94_test
  use phy_hs94, only: PHYHS94, Create, Close, &
    & PutLine, initialized, Forcing
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_hs94_test $Name: dcpam4-20070909 $ :: ' // &
    & 'Test program of "phy_hs94" module'
  character(*), parameter:: source = &
    & 'dcmodel project: hierarchical numerical models ' // &
    & '(See http://www.gfd-dennou.org/library/dcmodel)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYHS94):: phy_hs00, phy_hs01, phy_hs02, phy_hs03
  logical:: err
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_hs94_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_hs = phy_hs00, &                                   ! (inout)
    & imax = 32, jmax = 16, kmax = 12, &                                 ! (in)
    & y_Lat = &
    &   (/-81.65059_DP, -70.83464_DP, -59.95486_DP, -49.06072_DP, &
    &      38.16121_DP, -27.25921_DP, -16.35593_DP,  -5.45204_DP, &
    &       5.45204_DP,  16.35593_DP,  27.25921_DP,  38.16121_DP, &
    &      49.06072_DP,  59.95486_DP,  70.83464_DP,  81.65059_DP /) , &  ! (in)
    & z_Sigma = &
    &   (/0.994997_DP,  0.9799879_DP, 0.9499499_DP,  0.8897859_DP, &
    &     0.7996277_DP, 0.689378_DP,  0.5641075_DP,  0.4286365_DP, &
    &     0.2879657_DP, 0.1572454_DP, 0.07398598_DP, 0.02074752_DP /), & ! (in)
    & DelTime = 1200.0_DP, &                                             ! (in)
    & Cp = 1004.6_DP, RAir = 287.04_DP )                                 ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_hs00) )
  call PutLine( phy_hs00 ) ! (in)

!!$  call Create( phy_hs = phy_hs00, & ! (inout)
!!$    & err = err )                         ! (out)
!!$  call AssertEqual( 'initialization test 2', &
!!$    & answer = .true., check = err )
!!$  call PutLine( phy_hs = phy_hs00 ) ! (in)

!!$  call Create( phy_hs = phy_hs01, & ! (inout)
!!$    & param_i = 256, param_r = 98.7_DP, & ! (in)
!!$    & nmlfile = VAL_namelist )            ! (in)
!!$  call AssertEqual( 'initialization test 3 (NAMELIST)', &
!!$    & answer = .true., check = initialized(phy_hs01) )
!!$  call PutLine( phy_hs = phy_hs01 ) ! (in)

!!$  call Create( phy_hs = phy_hs02, & ! (inout)
!!$    & param_i = -32, param_r = 0.5_DP, param_c = 'foo', & ! (in)
!!$    & err = err )                                         ! (out)
!!$  call AssertEqual( 'initialization test 4', &
!!$    & answer = .true., check = err )

!!$  call Create( phy_hs = phy_hs02, &  ! (inout)
!!$    & param_i = 256, &           ! (in)
!!$    & err = err )                ! (out)
!!$  call AssertEqual( 'initialization test 5', &
!!$    & answer = .true., check = err )

!!$  call Create( phy_hs = phy_hs03, & ! (inout)
!!$    & param_i = -32, param_r = 0.5_DP, param_c = 'foo', & ! (in)
!!$    & nmlfile = VAL_namelist )                            ! (in)
!!$  call AssertEqual( 'initialization test 6 (NAMELIST)', &
!!$    & answer = .true., check = initialized(phy_hs03) )
!!$  call PutLine( phy_hs = phy_hs03 ) ! (in)

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_hs = phy_hs00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_hs00) )
  call PutLine( phy_hs = phy_hs00 ) ! (in)

  call Close( phy_hs = phy_hs02, & ! (inout)
    & err = err )                    ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_hs94_test
