!= Held and Suarez (1994) ˤ붯Ȼ
!
!= Forcing and dissipation suggested by Held and Suarez (1994)
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: phy_hs94.f90,v 1.6 2007/09/04 01:35:52 morikawa Exp $
! Tag Name::  $Name: dcpam4-20070909 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_hs94
  != Held and Suarez (1994) ˤ붯Ȼ
  !
  != Forcing and dissipation suggested by Held and Suarez (1994)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Held and Suarez (1994) Ƥ봥絤 GCM ٥ޡѤ
  ! Ȼ׻ޤ. 
  ! Ϳ붯ȻȤ, پӾоξؤδñʥ˥塼ȥѤ, 
  ! ໤ɽ벼Υ쥤꡼໤Ѥޤ. 
  ! ܺ٤ʲ˵ޤ. 
  !
  ! Forcing and dissipation for dry air GCM benchmark
  ! suggested by Held and Suarez (1994) are caluclate.
  ! We use simple Newtonian relaxation of the temperature field to a
  ! zonally symmetric state and Rayleigh damping of low-level winds to
  ! represent boundary-layer friction.
  ! Their specifications are detailed as follows.
  !
  ! \[
  !    \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} = 
  !        - k_v (\sigma) \Dvect{v}, \] \[
  !    \left( \DP{T}{t} \right)_{\mathrm{HS94}} = 
  !        - k_T (\phi, \sigma) [T - T_{eq} (\phi,p)], \] \[
  !    T_{eq} = \mathrm{max}
  !     \left\{
  !        200 \mathrm{K}, 
  !        \left[
  !          315 \mathrm{K} - (\Delta T)_y \sin^2\phi 
  !                         - (\Delta \theta)_z 
  !                           \log \left(\frac{p}{p_0}\right) \cos^2\phi
  !        \right] \left(\frac{p}{p_0}\right)^\kappa
  !     \right\}, \] \[
  !    k_T = k_a + (k_s - k_a) 
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right) \cos^4\phi,
  !     \] \[
  !    k_v = k_f
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right),
  !     \] \[
  !    \sigma_b = 0.7, \qquad 
  !    k_f = 1 \mathrm{day}^{-1}, \qquad
  !    k_a = \Dinv{40} \mathrm{day}^{-1}, \qquad
  !    k_s = \Dinv{4} \mathrm{day}^{-1}, \] \[
  !    (\Delta T)_y = 60 \mathrm{K}, \qquad
  !    (\Delta \theta)_z = 10 \mathrm{K}, \qquad
  !    p_0 = 1000 \mathrm{hPa}, \qquad
  !    \kappa = \frac{R}{c_p}.
  ! \]
  !
  ! Forcing Ǥ, Ϳ줿®٤䲹 ( $ t+\Delta t$ ) 
  ! ФưʲΤ褦˶ȻŬѤޤ.
  !
  ! By Forcing, forcing and dissipation are applied to 
  ! given wind and temperature ($ t+\Delta t$ is expected) as follows.
  !
  ! \[
  !    \hat{\Dvect{v}}^{t+\Delta t} = 
  !      \Dvect{v}^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} \] \[
  !    \hat{T}^{t+\Delta t} = 
  !      T^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{T}{t} \right)_{\mathrm{HS94}}
  ! \]
  !
  !== Procedures List
  !
  ! Create        :: PHYHS94 ѿν
  ! Close         :: PHYHS94 ѿνλ
  ! PutLine       :: PHYHS94 ѿ˳ǼƤΰ
  ! initialized   :: PHYHS94 ѿꤵƤ뤫ݤ
  ! Forcing       :: Ȼη׻
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYHS94"
  ! Close         :: Deconstructor of "PHYHS94"
  ! PutLine       :: Print information of "PHYHS94"
  ! initialized   :: Check initialization of "PHYHS94"
  ! Forcing       :: Calculate forcing and dissipation
  !
  !== Usage
  !
  ! Ϥ, PHYHS94 ѿ, Create ǽԤޤ.
  ! Ȼη׻ Forcing Ѥޤ.
  ! PHYHS94 ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYHS94" by "Create".
  ! Use "Forcing" in order to calculate forcing and dissipation
  ! In order to terminate "PHYHS94", use "Close".
  !
  !== References
  !
  ! * Held, I. M., Suarez, M. J., 1994: 
  !   A proposal for the intercomparison of the dynamical cores of
  !   atmospheric general circuation models.
  !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYHS94, Create, Close, PutLine, initialized, Forcing

  type PHYHS94
    !
    ! ޤ, Create  "PHYHS94" ѿꤷƲ.
    ! ꤵ줿 "PHYHS94" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYHS94" variable by "Create" before usage.
    ! If you reuse "PHYHS94" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat

    !-----------------------------------
    !  Held and Suarez (1994) ǻѤ뷸
    !  Coefficient used by Held and Suarez (1994) 
    real(DP):: P0             ! $ p_0 $ .
    real(DP):: DelTempY       ! $ (\Delta T)_y $ .
    real(DP):: DelPotTempZ    ! $ (\Delta \theta)_z $ .
    real(DP), pointer:: z_kv (:) =>null()
                              ! $ k_v $ .
    real(DP), pointer:: yz_kt (:,:) =>null()
                              ! $ k_T $ .
  end type PHYHS94

  character(*), parameter:: version = &
    & '$Name: dcpam4-20070909 $' // &
    & '$Id: phy_hs94.f90,v 1.6 2007/09/04 01:35:52 morikawa Exp $'

  interface Create
    module procedure PhyHS94Create
  end interface

  interface Close
    module procedure PhyHS94Close
  end interface

  interface PutLine
    module procedure PhyHS94PutLine
  end interface

  interface initialized
    module procedure PhyHS94Initialized
  end interface

  interface NmlRead
    module procedure PhyHS94NmlRead
  end interface

  interface Forcing
    module procedure PhyHS94Forcing
  end interface

!!$  interface Sample
!!$    module procedure PhyHS94Sample
!!$  end interface

contains

  subroutine PhyHS94Create( phy_hs, &
    & imax, jmax, kmax, &
    & y_Lat, z_Sigma, DelTime, &
    & Cp, RAir, &
    & day_seconds, &
    & nmlfile, err )
    !
    ! PHYHS94 ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYHS94 ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_hs* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_hs94_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYHS94".
    ! Initialize *phy_hs* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_hs* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_hs94_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use dc_date_types, only: DAY_SECONDS_EARTH
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in), optional:: day_seconds
                              ! 1 ÿ. 
                              ! ΰͿʤ, 1 ÿ
                              ! 86400.0 Ȥʤޤ. 
                              ! 
                              ! Seconds in day. 
                              ! If this argument is not given, seconds in day
                              ! become 86400.0 .
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_hs94_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_hs94_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: day_seconds_work
                              ! 1 ÿ. 
                              ! Seconds in day. 
    real(DP):: SigmaB         ! $ \sigma_b $ .
    real(DP):: kf             ! $ k_f $ .
    real(DP):: ka             ! $ k_a $ .
    real(DP):: ks             ! $ k_s $ .

    integer:: j, k            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHS94Create'
  continue
    call BeginSub( subname,  version = version, &
      & fmt = 'Cp=<%f> RAir=<%f>', &
      & d=(/Cp, RAir/) )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_hs % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if
    if ( present(day_seconds) ) then
      if (day_seconds < 0.0_DP) then
        stat = DC_ENEGATIVE
        cause_c = 'day_seconds'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  "PHYHS94" 
    !  Configure the settings for "PHYHS94"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
    phy_hs % imax  = imax 
    phy_hs % jmax  = jmax 
    phy_hs % kmax  = kmax 
    phy_hs % Kappa = RAir / Cp
    phy_hs % DelTime = DelTime

    allocate( phy_hs % y_Lat (0:jmax-1) )
    phy_hs % y_Lat = y_Lat

    allocate( phy_hs % z_Sigma (0:kmax-1) )
    phy_hs % z_Sigma = z_Sigma

    if ( present(day_seconds) ) then
      day_seconds_work = day_seconds
    else
      day_seconds_work = DAY_SECONDS_EARTH
    end if

    phy_hs % P0          = 1000.0e2_DP
    phy_hs % DelTempY    = 60.0_DP
    phy_hs % DelPotTempZ = 10.0_DP

    SigmaB = 0.7_DP
    kf     = 1.0_DP / day_seconds_work
    ka     = 1.0_DP / ( 40.0_DP * day_seconds_work )
    ks     = 1.0_DP / (  4.0_DP * day_seconds_work )

    call DbgMessage( &
      & 'day_seconds=<%f>, SigmaB=<%f>, kf=<%f>, ka=<%f>, ks=<%f>', &
      & d=(/day_seconds_work, SigmaB, kf, ka, ks/) )

    allocate( phy_hs % z_kv (0:kmax-1) )

    phy_hs % z_kv = &
      & kf * max( 0.0_DP, &
      &           (    z_Sigma - SigmaB ) &
      &             / ( 1.0_DP - SigmaB ) &
      &         )

    allocate( phy_hs % yz_kt (0:jmax-1,0:kmax-1) )

    do k = 0, kmax - 1
      do j = 0, jmax - 1
        phy_hs % yz_kt(j,k) = &
          & ka + ( ks - ka ) &
          &  * max( 0.0_DP, &
          &         ( z_Sigma(k) - SigmaB ) &
          &           / ( 1.0_DP - SigmaB ) &
          &       ) * cos( y_Lat(j) ) ** 4
      end do
    end do

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_hs % param_i = param_i
!!$    if ( present(param_r) )  phy_hs % param_r = param_r
!!$    if ( present(param_c) )  phy_hs % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_hs % param_i, &   ! (inout)
!!$        & param_r = phy_hs % param_r, &   ! (inout)
!!$        & param_c_ = phy_hs % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_hs % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHS94Create

  subroutine PhyHS94Close( phy_hs, err )
    !
    ! PHYHS94 ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYHS94".
    ! Note that if *phy_hs* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHS94Close'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_hs % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYHS94" ξõ
    !  Clear the settings for "PHYHS94"
    !-----------------------------------------------------------------
    deallocate( phy_hs % z_Sigma )
    deallocate( phy_hs % y_Lat )
    deallocate( phy_hs % z_kv )
    deallocate( phy_hs % yz_kt )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_hs % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHS94Close

  subroutine PhyHS94PutLine( phy_hs, unit, indent, err )
    !
    !  *phy_hs* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_hs*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf
    implicit none
    type(PHYHS94), intent(in):: phy_hs
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyHS94PutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYHS94" ΰ
    !  Print the settings for "PHYHS94"
    !-----------------------------------------------------------------
    if ( phy_hs % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYHS94:: @initialized=%y', &
        & l=(/phy_hs % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d @DelTime', &
        & i=(/phy_hs % imax, phy_hs % jmax, phy_hs % kmax/), &
        & d=(/phy_hs % DelTime/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @y_Lat=%*f', &
        & d=phy_hs % y_Lat, n=(/phy_hs % jmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @z_Sigma=%*f', &
        & d=phy_hs % z_Sigma, n=(/phy_hs % kmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Kappa=%f @P0=%f', &
        & d=(/phy_hs % Kappa, phy_hs % P0/) )

!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @Cp=%f @RAir=%f @Kappa=%f', &
!!$        & d=(/phy_hs % Cp, phy_hs % RAir, phy_hs % Kappa/) )
!!$
!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @SigmaB=%f @P0=%f @kf=%f @ka=%f @ks=%f', &
!!$        & d=(/phy_hs % SigmaB, phy_hs % P0, &
!!$        &     phy_hs % kf, phy_hs % ka, phy_hs % ks/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTempY=%f @DelPotTempZ=%f', &
        & d=(/phy_hs % DelTempY, phy_hs % DelPotTempZ/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @z_kv=%*f', &
        & d=phy_hs % z_kv, n=(/phy_hs % kmax/) )

!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @yz_kt=%*f', &
!!$        & d=pack( phy_hs % yz_kt ), n=(/phy_hs % jmax * phy_hs % kmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYHS94:: @initialized=%y>', &
        & l=(/phy_hs % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHS94PutLine

  logical function PhyHS94Initialized( phy_hs ) result(result)
    !
    ! *phy_hs* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_hs* is initialized, .true. is returned.
    ! If *phy_hs* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYHS94), intent(in):: phy_hs
  continue
    result = phy_hs % initialized
  end function PhyHS94Initialized

  subroutine PhyHS94NmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_hs94_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_hs94 ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_hs94#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "phy_hs94" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_hs94#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyHS94NmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_hs94_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='phy_hs94_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = phy_hs94_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='phy_hs94_nml', c2=trim(nmlfile), &
!!$        & i=(/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHS94NmlRead

  subroutine PhyHS94Forcing( phy_hs, &
    & xyz_U,    xyz_V, &
    & xyz_Temp, xy_Ps, &
    & err )
    !
    ! ȤͿ줿® xyz_U, ® xyz_V, 
    !  xyz_Temp Ф, 
    ! پӾоξؤδñʥ˥塼ȥѤ, 
    ! ໤ɽ벼Υ쥤꡼໤Ѥޤ. 
    !
    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Simple Newtonian relaxation of the temperature field to a
    ! zonally symmetric state and Rayleigh damping of low-level winds to
    ! represent boundary-layer friction are applied to 
    ! arguments 
    ! zonal wind 'xyz_U', meridional wind 'xyz_V', 
    ! temperature 'xyz_Temp'.
    !
    ! If *phy_hs* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    real(DP), intent(inout):: xyz_U (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ U $ . ®. 
                              ! Zonal wind
    real(DP), intent(inout):: xyz_V (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ V $ . ®. 
                              ! Meridional wind
    real(DP), intent(inout):: xyz_Temp (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T $ . . 
                              ! Temperature
    real(DP), intent(in):: xy_Ps (0:phy_hs%imax-1, 0:phy_hs%jmax-1)
                              ! $ P_s $ . ɽ̵. 
                              ! Surface pressure
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: y_Lat (0:phy_hs%jmax-1)
                              ! . Latitude
    real(DP):: z_Sigma (0:phy_hs%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat

    real(DP):: P0             ! $ p_0 $ .
    real(DP):: DelTempY       ! $ (\Delta T)_y $ .
    real(DP):: DelPotTempZ    ! $ (\Delta \theta)_z $ .
    real(DP):: z_kv (0:phy_hs%kmax-1)
                              ! $ k_v $ .
    real(DP):: yz_kt (0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ k_T $ .
    real(DP):: xyz_TempEQ (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T_{eq} $ . ʿղ. 
                              ! Equilibrium temperature
    real(DP):: xyz_Press (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T $ . . 
                              ! Pressure
    integer:: j, k            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHS94Forcing'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_hs % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_hs* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_hs*
    !-----------------------------------------------------------------
    jmax = phy_hs % jmax
    kmax = phy_hs % kmax

    y_Lat   = phy_hs % y_Lat
    z_Sigma = phy_hs % z_Sigma
    DelTime = phy_hs % DelTime
    Kappa   = phy_hs % Kappa

    P0          = phy_hs % P0
    DelTempY    = phy_hs % DelTempY
    DelPotTempZ = phy_hs % DelPotTempZ
    z_kv        = phy_hs % z_kv
    yz_kt       = phy_hs % yz_kt

    !-----------------------------------------------------------------
    !  ® $ U $ ® $ V $ إ쥤꡼໤Ŭ
    !  Apply Rayleigh damping to zonal wind $ U $ and meridional wind $ V $
    !-----------------------------------------------------------------
!    do k = 0, kmax - 1
!      xyz_U (:,:,k) = &
!        & xyz_U (:,:,k) &
!        & * ( 1.0_DP - 2.0_DP * DelTime * z_kv (k) )

!      xyz_V (:,:,k) = &
!        & xyz_V (:,:,k) &
!        & * ( 1.0_DP - 2.0_DP * DelTime * z_kv (k) )
!    end do

    !-----------------------------------------------------------------
    !   $ T $ إ˥塼ȥѤŬ
    !  Apply Newtonian relaxation to temperature $ T $
    !-----------------------------------------------------------------
!    do k = 0, kmax - 1
!       xyz_Press(:,:,k) = z_Sigma(k) * xy_Ps
!    enddo

!    do j = 0, jmax - 1
!      xyz_TempEQ(:,j,:) = &
!        & max( 200.0_DP, &
!        &      ( 315.0_DP &
!        &        - DelTempY * sin( y_Lat(j) ) ** 2 &
!        &        - DelPotTempZ * log( xyz_Press(:,j,:) / P0 ) &
!        &                                 * cos( y_Lat(j) ) ** 2 &
!        &      ) &
!        &      * ( xyz_Press(:,j,:) / P0 ) ** Kappa &
!        &     )
!    end do

!    do k = 0, kmax - 1
!      do j = 0, jmax - 1
!        xyz_Temp (:,j,k) = xyz_Temp (:,j,k) &
!          & - 2.0_DP * DelTime &
!          &   * yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
!      end do
!    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHS94Forcing


!!$  subroutine PhyHS94Sample( phy_hs, err )
!!$    !--
!!$    ! PhyHS94Sample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyHS94Sample
!!$    !++
!!$    ! If *phy_hs* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYHS94), intent(inout):: phy_hs
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyHS94Sample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_hs % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYHS94'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_hs* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_hs*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_hs % param_i
!!$!!$    param_r = phy_hs % param_r
!!$!!$    param_c = phy_hs % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyHS94Sample

end module phy_hs94
