!= phy_dryconv_adjust ⥸塼Υƥȥץ
!
!= Test program for "phy_dryconv_adjust"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_dryconv_adjust_test.f90,v 1.1 2007/09/25 22:37:54 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_dryconv_adjust ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_dryconv_adjust" module.
! Confirm compilation and execution of this program.
!

program phy_dryconv_adjust_test
  use phy_dryconv_adjust, only: PHYDRYCONV, Create, Close, &
    & PutLine, initialized, DryConvectAdjust
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_dryconv_adjust_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "phy_dryconv_adjust" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
  real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
  real(DP):: xyz_Press (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
  real(DP):: xyz_DDryTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ήĴˤ벹ѲΨ. 
                              ! Temperature tendency by dry convective adjustment

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYDRYCONV):: phy_dryconv00, phy_dryconv01, phy_dryconv02, phy_dryconv03
  logical:: err
  character(*), parameter:: subname = 'phy_dryconv_adjust_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './phy_dryconv_adjust_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 600.0_DP

  call Get( constant = const_earth, & ! (inout)
    & Cp = Cp, RAir = RAir )          ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_dryconv = phy_dryconv00, &  ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    & RAir = RAir, Cp = Cp, &                  ! (in)
    & DelTime = DelTime )                      ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_dryconv00) )
  call PutLine( phy_dryconv = phy_dryconv00 ) ! (in)


  !---------------------------------------------------------
  !  DryConvectAdjust ƥ
  !  DryConvectAdjust test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_dryconv_adjust_test00.nc', & ! (in)
    & varname = 'Temp', &                      ! (in)
    & array = xyz_Temp )                       ! (out)

  call HistoryGet( &
    & file = 'phy_dryconv_adjust_test00.nc', & ! (in)
    & varname = 'Press', &                     ! (in)
    & array = xyz_Press )                      ! (out)

  call HistoryGet( &
    & file = 'phy_dryconv_adjust_test00.nc', & ! (in)
    & varname = 'PressM', &                    ! (in)
    & array = xyr_Press )                      ! (out)

  call DryConvectAdjust( phy_dryconv = phy_dryconv00, & ! (inout)
    & xyz_Press = xyz_Press, xyr_Press = xyr_Press, &   ! (in)
    & xyz_Temp = xyz_Temp, &                            ! (inout)
    & xyz_DDryTempDt = xyz_DDryTempDt )                 ! (out)

  call PutLine( xyz_DDryTempDt, indent = ' xyz_DDryTempDt=' )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_dryconv = phy_dryconv00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_dryconv00) )
  call PutLine( phy_dryconv = phy_dryconv00 ) ! (in)

  call Close( phy_dryconv = phy_dryconv02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program phy_dryconv_adjust_test
