!= ȯ®٤Ϥץ
!
!= A program that generates velocity from vorticity and divergence
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: convert_vordiv2uv.f90,v 1.1 2007/09/26 02:50:15 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! ϥե "Vor"  "Div" Ȥѿξ򻲾Ȥ, 
! "U"  "V" ѴƽϥեؤȽϤޤ. 
! ϥեˤϼǡ "lon", "lon_weight", "lat", "lat_weight", 
! "sig", "sigm" ǼƤ
! ꤷޤ. 
!
! Variables "Vor" and "Div" in an input file are converted into 
! "U" and "V". The velocities are output to an output file. 
! It is expected that axes data "lon", "lon_weight", "lat", "lat_weight", 
! "sig", "sigm" are stored in input file.
!

program convert_vordiv2uv
  use constants, only: CONST, Create, Get
  use dc_types, only: DP, STRING
  use dc_message, only: MessageNotify
  use dyn_spectral_as83, only: DYNSPAS83, Create, Close, PutLine, &
    & initialized, VorDiv2UV
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: HistoryGet, HistoryGetPointer
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'convert_vordiv2uv $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "dyn_spectral_as83" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax
                              ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RPlanet    ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega      ! $ \Omega $ . ž®.     Angular velocity
!!$  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: EpsVT      ! $ 1/\epsilon_v - 1 $ .
  integer:: VisOrder    ! ĶǴμ.  Order of hyper-viscosity
  real(DP):: EFoldTime  ! ȿФ e-folding time. E-folding time for maximum wavenumber
  real(DP):: DelTime

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), pointer:: x_Lon (:)
                              ! . Longitude
  real(DP), pointer:: x_Lon_Weight(:)
                   ! ٺɸŤ. 
                   ! Weight of longitude
  real(DP), pointer:: y_Lat (:)
                              ! . Latitude
  real(DP), pointer:: y_Lat_Weight(:)
                   ! ٺɸŤ. 
                   ! Weight of latitude
  real(DP), pointer:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), pointer:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: xyz_Vor (:,:,:)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
  real(DP), allocatable:: xyz_Div (:,:,:)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
  real(DP), allocatable:: xyz_U (:,:,:)
                              ! $ U $ . ®. Zonal wind
  real(DP), allocatable:: xyz_V (:,:,:)
                              ! $ V $ . ®. Meridional wind

  !---------------------------------------------------------
  !  ϥǡ
  !  Input/Output data
  !---------------------------------------------------------
  type(GT_HISTORY):: gthist
  character(STRING):: input_data
  character(STRING):: output_data

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
!!$  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
!!$                              ! Existence of '-N', '--namelist' option
!!$  character(STRING):: VAL_namelist
!!$                              ! -N, --namelist ץ. 
!!$                              ! Value of '-N', '--namelist' option
  logical:: OPT_input         ! -I, --input ץ̵ͭ. 
                              ! Existence of '-I', '--input' option
  character(STRING):: VAL_input
                              ! -I, --input ץ. 
                              ! Value of '-I', '--input' option
  logical:: OPT_output        ! -O, --output ץ̵ͭ. 
                              ! Existence of '-O', '--output' option
  character(STRING):: VAL_output
                              ! -O, --output ץ. 
                              ! Value of '-O', '--output' option

  type(DYNSPAS83):: dyn_sp_as00
  logical:: err

  character(*), parameter:: subname = 'vordiv2uv'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './convert_vordiv2uv [Options] --input=<file> --output=<file>' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
!!$  call Option( arg, StoA('-N', '--namelist'), &
!!$    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Option( arg, StoA('-I', '--input'), &
    & OPT_input, VAL_input, help = "input data file" )
  call Option( arg, StoA('-O', '--output'), &
    & OPT_output, VAL_output, help = "output data file" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ϥǡ
  !  Input/Output data
  !---------------------------------------------------------
  input_data = VAL_input
  output_data = VAL_output

  if ( trim(input_data) == '' ) then
    call MessageNotify('E', subname, 'Specify input data like "--input=VorDiv.nc"')
  end if

  if ( trim(output_data) == '' ) then
    call MessageNotify('E', subname, 'Specify output data like "--output=UV.nc"')
  end if

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  DelTime = 480.0_DP

  call Get( constant = const_earth, &              ! (inout)
    & PI = PI, RPlanet = RPlanet, Omega = Omega, & ! (out)
    & Cp = Cp, RAir = RAir, EpsVT = EpsVT, &       ! (out)
    & VisOrder = VisOrder, EFoldTime = EFoldTime ) ! (out)

  !---------------------------------------------------------
  !  ǡ
  !  Get axes data
  !---------------------------------------------------------
  call HistoryGetPointer ( &
    & file = input_data, varname = 'lon', & ! (in)
    & array = x_Lon )                       ! (out)

  call HistoryGetPointer ( &
    & file = input_data, varname = 'lon_weight', & ! (in)
    & array = x_Lon_Weight )                       ! (out)

  call HistoryGetPointer ( &
    & file = input_data, varname = 'lat', & ! (in)
    & array = y_Lat )                       ! (out)

  call HistoryGetPointer ( &
    & file = input_data, varname = 'lat_weight', & ! (in)
    & array = y_Lat_Weight )                       ! (out)

  call HistoryGetPointer ( &
    & file = input_data, varname = 'sig', & ! (in)
    & array = z_Sigma )                     ! (out)

  call HistoryGetPointer ( &
    & file = input_data, varname = 'sigm', & ! (in)
    & array = r_Sigma )                      ! (out)

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Configure grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  imax = size ( x_Lon )
  jmax = size ( y_Lat )
  kmax = size ( z_Sigma )

  !-------------------------------------
  !  øʺȿư
  !  Irresponsible auto-setting of maximum truncated wavenumber
  if ( imax < 32 .and. jmax < 16 ) then
    call MessageNotify('E', subname, '"imax=%d" and "jmax=%d" is too small', &
      & i = (/imax, jmax/) )
  elseif ( imax < 64 .and. jmax < 32 ) then
    nmax = 10
  elseif ( imax < 128 .and. jmax < 64 ) then
    nmax = 21
  elseif ( imax < 192 .and. jmax < 96 ) then
    nmax = 42
  else
    nmax = 63
  end if

  call MessageNotify('M', subname, &
    & 'Resolution is nmax=%d imax=%d, jmax=%d, kmax=%d', &
    & i = (/nmax, imax, jmax, kmax/) )

  !---------------------------------------------------------
  !  
  !  Initialization
  !---------------------------------------------------------
  call Create( dyn_sp_as = dyn_sp_as00, &           ! (inout)
    & nmax = nmax, &                                ! (in)
    & imax = imax, jmax = jmax, kmax = kmax, &      ! (in)
    & PI = PI, RPlanet = RPlanet, &                 ! (in)
    & Omega = Omega, Cp = Cp, RAir = RAir, &        ! (in)
    & EpsVT = EpsVT, &                              ! (in)
    & VisOrder = VisOrder, EFoldTime = EFoldTime, & ! (in)
    & DelTIme = DelTime )                           ! (in)
  call PutLine( dyn_sp_as00 ) ! (in)


  !---------------------------------------------------------
  !  ȯǡɤ߹
  !  Load vorticity and divergence data
  !---------------------------------------------------------
  allocate( xyz_Vor(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_Div(0:imax-1, 0:jmax-1, 0:kmax-1) )

  call HistoryGet ( &
    & file = input_data, varname = 'Vor', & ! (in)
    & array = xyz_Vor )                     ! (out)

  call HistoryGet ( &
    & file = input_data, varname = 'Div', & ! (in)
    & array = xyz_Div )                     ! (out)

  !---------------------------------------------------------
  !  ®٥ǡѴ
  !  Convert into velocities
  !---------------------------------------------------------
  allocate( xyz_U(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_V(0:imax-1, 0:jmax-1, 0:kmax-1) )

  call VorDiv2UV( dyn_sp_as = dyn_sp_as00, &  ! (inout)
    & xyz_Vor = xyz_Vor, xyz_Div = xyz_Div, & ! (in)
    & xyz_U   = xyz_U,   xyz_V   = xyz_V )    ! (out)


  !---------------------------------------------------------
  !  ǡ
  !  Output data
  !---------------------------------------------------------
  call HistoryCreate( &
    & history = gthist,   &                                 ! (inout)
    & file = output_data, &                                 ! (in)
    & title = 'U and V data converted from "' // &
    &   trim(input_data) // '"', &                          ! (in)
    & source = source, institution = institution, &         ! (in)
    & dims = StoA('lon', 'lat', 'sig', 'sigm'), &           ! (in)
    & dimsizes = (/imax, jmax, kmax, kmax + 1/), &          ! (in)
    & longnames = &
    &   StoA('longitude', 'latitude', &
    &        'sigma at layer midpoints', &
    &        'sigma at layer end-points (half level))'), &  ! (in)
    & units = StoA('degree_east', 'degree_north', &
    &              '1', '1') )                              ! (in)

  call HistoryPut( &
    & history = gthist, &                               ! (inout)
    & varname = 'lon', array = x_Lon / PI * 180.0_DP )  ! (in)
  call HistoryPut( &
    & history = gthist, &                               ! (inout)
    & varname = 'lat', array = y_Lat / PI * 180.0_DP )  ! (in)
  call HistoryPut( &
    & history = gthist, &                 ! (inout)
    & varname = 'sig', array = z_Sigma )  ! (in)
  call HistoryPut( &
    & history = gthist, &                 ! (inout)
    & varname = 'sigm', array = r_Sigma ) ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                            ! (inout)
    & varname = 'lon', attrname = 'standard_name', & ! (in)
    & value = 'longitude' )                          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                            ! (inout)
    & varname = 'lat', attrname = 'standard_name', & ! (in)
    & value = 'latitude' )                           ! (in)

  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sig', attrname = 'standard_name', &   ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                              ! (inout)
    & varname = 'sigm', attrname = 'standard_name', &  ! (in)
    & value = 'atmosphere_sigma_coordinate' )          ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sig', attrname = 'positive', &   ! (in)
    & value = 'down' )                            ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                         ! (inout)
    & varname = 'sigm', attrname = 'positive', &  ! (in)
    & value = 'down' )                            ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                                 ! (inout)
    & varname = 'lon_weight', &                           ! (in)
    & dims = StoA('lon'), &                               ! (in)
    & longname = 'weight for integration in longitude', & ! (in)
    & units = 'radian', xtype = 'double' )                ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                             ! (inout)
    & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lon_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist, &                            ! (inout)
    & varname = 'lon_weight', array = x_Lon_Weight ) ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                                ! (inout)
    & varname = 'lat_weight', &                          ! (in)
    & dims = StoA('lat'), &                              ! (in)
    & longname = 'weight for integration in latitude', & ! (in)
    & units = 'radian', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                             ! (inout)
    & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lat_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist, &                            ! (inout)
    & varname = 'lat_weight', array = y_Lat_Weight ) ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'U', &                              ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'eastward wind', &                 ! (in)
    & units = 'm/s', xtype = 'double' )             ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                          ! (inout)
    & varname = 'U', attrname = 'standard_name', & ! (in)
    & value = 'eastward_wind' )                    ! (in)

  call HistoryAddVariable( &
    & history = gthist, &                           ! (inout)
    & varname = 'V', &                              ! (in)
    & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
    & longname = 'northward wind', &                ! (in)
    & units = 'm/s', xtype = 'double' )             ! (in)
  call HistoryAddAttr( &
    & history = gthist, &                          ! (inout)
    & varname = 'V', attrname = 'standard_name', & ! (in)
    & value = 'northward_wind' )                   ! (in)

  call HistoryPut( &
    & history = gthist, &            ! (inout)
    & varname = 'U', array = xyz_U ) ! (in)
  call HistoryPut( &
    & history = gthist, &            ! (inout)
    & varname = 'V', array = xyz_V ) ! (in)

  call HistoryClose( history = gthist ) ! (inout)

  !---------------------------------------------------------
  !  λ
  !  Termination
  !---------------------------------------------------------
  call Close( dyn_sp_as00 ) ! (inout)
  call PutLine( dyn_sp_as00 )

end program convert_vordiv2uv
