!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_surface_coeff.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_surface_coeff_mod

  implicit none

  private
  public :: physics_surface_coeff

contains

  subroutine physics_surface_coeff( &
       & xy_SurfVelBulkCoeff , & ! (out) 
       & xy_SurfTempBulkCoeff, & ! (out) 
       & xy_SurfQvapBulkCoeff, & ! (out) 
       & xy_SurfBulkRiNum    , & ! (in) 
       & xy_SurfVelAbs       , & ! (in) 
       & xy_SurfVelRoughLength   , & ! (in) 
       & xy_SurfTempRoughLength  , & ! (in) 
       & xy_SurfGeoPot            ) ! (in) 

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: FKarm 
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Output
    !
    real(DBKIND), intent(out) :: &
         & xy_SurfVelBulkCoeff(im,jm)      , & ! (out) Х륯ư
         & xy_SurfTempBulkCoeff(im,jm)     , & ! (out) Х륯
         & xy_SurfQvapBulkCoeff(im,jm)         ! (out) Х륯漾

    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & xy_SurfBulkRiNum(im,jm)         , & ! (in) Х륯ң
         & xy_SurfVelAbs(im,jm)            , & ! (in)  ®
         & xy_SurfVelRoughLength(im,jm)    , & ! (in) ɽĹ (ư)
         & xy_SurfTempRoughLength(im,jm)   , & ! (in) ɽĹ (Ǯ)
         & xy_SurfGeoPot(im,jm)                ! (in) ǲز

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_surface_coeff"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j

    logical            :: Newtral = .FALSE.                 ! ΩǤ뤫ݤ
    real(DBKIND), parameter :: ConstBulkCoeff  = -1.        ! Х륯
    real(DBKIND), parameter :: VelBulkCoeffMin  = 0.        ! Х륯Ǿ
    real(DBKIND), parameter :: TempBulkCoeffMin = 0.        ! ԥХ륯Ǿ
    real(DBKIND), parameter :: QvapBulkCoeffMin = 0.        ! Х륯Ǿ
    real(DBKIND), parameter :: VelBulkCoeffMax  = 1.        ! Х륯
    real(DBKIND), parameter :: TempBulkCoeffMax = 1.        ! ԥХ륯
    real(DBKIND), parameter :: QvapBulkCoeffMax = 1.        ! Х륯
    
    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ɽ̥Х륯׻
    !----------------------------------------------------------------

    ! ---- 1. ΩХ륯 ----

      if ( ConstBulkCoeff .LT. 0.   ) then

         xy_SurfVelBulkCoeff  = ( FKarm &
              &                  / LOG ( xy_SurfGeoPot / xy_SurfVelRoughLength ) )**2
         xy_SurfTempBulkCoeff = ( FKarm &
              &                  / LOG ( xy_SurfGeoPot / xy_SurfTempRoughLength ) )**2
         xy_SurfQvapBulkCoeff = xy_SurfTempBulkCoeff

      else
         xy_SurfVelBulkCoeff  = ConstBulkCoeff
         xy_SurfTempBulkCoeff = ConstBulkCoeff
         xy_SurfQvapBulkCoeff = ConstBulkCoeff
      end if

    ! ---- 2. ΩХ륯 ----

      if ( .NOT. Newtral ) then

         do i = 1, im
            do j = 1, jm
               if ( xy_SurfBulkRiNum(i,j) .GT. 0. ) then 
                  xy_SurfVelBulkCoeff(i,j) = xy_SurfVelBulkCoeff(i,j) &
                       &     / ( 1. + 10.* xy_SurfBulkRiNum(i,j) &
                       &              / SQRT( 1. + 5.* xy_SurfBulkRiNum(i,j) ) )
                  xy_SurfTempBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j) &
                       &     / ( 1. + 15.* xy_SurfBulkRiNum(i,j) &
                       &              / SQRT( 1. + 5.* xy_SurfBulkRiNum(i,j) ) )
                  xy_SurfQvapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)
               else
                  xy_SurfVelBulkCoeff(i,j) = xy_SurfVelBulkCoeff(i,j) &
                       &     * ( 1. - 10.* xy_SurfBulkRiNum(i,j) &
                       &              / ( 1. + 75. * xy_SurfVelBulkCoeff(i,j) &
                       &                      * SQRT( - xy_SurfGeoPot(i,j) &
                       &                               / xy_SurfVelRoughLength(i,j) &
                       &                               * xy_SurfBulkRiNum(i,j) ) &
                       &                ) &
                       &      )

                  xy_SurfTempBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j) &
                       &     * ( 1. - 15.* xy_SurfBulkRiNum(i,j) &
                       &              / ( 1. + 75. * xy_SurfTempBulkCoeff(i,j) &
                       &                      * SQRT( - xy_SurfGeoPot(i,j) &
                       &                               / xy_SurfTempRoughLength(i,j) &
                       &                               * xy_SurfBulkRiNum(i,j) ) &
                       &                ) &
                       &      )
                  xy_SurfQvapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)
               end if               
            end do
         end do

      end if

    ! ---- 3. /Ǿ Ƚ ----

      do i = 1, im
         do j = 1, jm
         xy_SurfVelBulkCoeff(i,j)  = &
              & MAX( MIN( xy_SurfVelBulkCoeff(i,j) , VelBulkCoeffMax ), & 
              &      VelBulkCoeffMin )
         xy_SurfTempBulkCoeff(i,j) = &
              & MAX( MIN( xy_SurfTempBulkCoeff(i,j) , TempBulkCoeffMax ), & 
              &      TempBulkCoeffMin )
         xy_SurfQvapBulkCoeff(i,j) = &
              & MAX( MIN( xy_SurfQvapBulkCoeff(i,j) , QvapBulkCoeffMax ), & 
              &      QvapBulkCoeffMin )
         end do
      end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_surface_coeff


end module physics_surface_coeff_mod
















