!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------

module physics_radiation_main_mod
  ! == DESCRIPTION
  ! * Ĺͷ׻⥸塼ˤ 2 ΥबѰդƤ.
  !   use ʸ񤭴뤳Ȥˤꥹڤ괹򤪤ʤ.
  ! * ûȥեå׻⥸塼ˤ 2 ΥबѰդƤ.
  !   use ʸ񤭴뤳Ȥˤꥹڤ괹򤪤ʤ.
  !
  ! == TODO
  ! * ʪΥᥤǤϤʤ, ʲäΥ٥ use ʸ
  !   񤭴뤳ȤˤƤɤΤ?
  ! * usu ʸѹưǤˤ̵ΤǤʤ餫λȤ
  !   ɬ.
  !
  ! == History
  !   2005-09-21 Yamada Yukiko     create
  !   2007-05-04 Masaki Ishiwatari physics_radiation_incoming_sr is made
  !   2007-05-11 Masaki Ishiwatari interface is changed.
  !   2007-5-12 M.Ishiwatari ͥ⥸塼iterface ѹ. xyr_Temp ɲ.
  !
  implicit none

  private
  public :: physics_radiation_main
  public :: physics_radiation_deltemp

contains

  subroutine physics_radiation_main( &
    & xyr_RadLFlux              , & ! (out) Ĺȥեå
    & xyo_SurfRadLMatrix        , & ! (out) Աɽ
    & xyro_DelRadLFlux          , & ! (out) ĹɽѲ
    & xyr_RadSFlux              , & ! (out) ͥեå
    & xyz_Temp                  , & ! (in) ()
    & xyr_Temp                  , & ! (in) (Ⱦ)
    & xy_SurfTemp               , & ! (in) ɽ̲ 
    & xyz_Qvap                  , & ! (in) 漾
    & xyr_Press                 , & ! (in) 
    & x_Lon                     , & 
    & y_Lat                     , &
    & xy_SurfAlbedo )               ! (in) ɽ٥

    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: Grav

    ! Switch for incoming solar radiation
    !use physics_radiation_incoming_mod, only: physics_radiation_incoming
    use physics_radiation_incoming_sr_mod, only: physics_radiation_incoming

    use physics_radiation_short_mod,  only: physics_radiation_short

    ! Switch for incoming solar radiation
    use physics_radiation_long_mod,  only: physics_radiation_long
    !use physics_radiation_long_runaway_mod,  only: physics_radiation_long

    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use dycore_time_mod, only: CurrentTime, CurrentLoop

    implicit none

    real(DBKIND), intent(out) :: xyr_RadLFlux(im,jm,km+1) ! Ĺȥեå
    real(DBKIND), intent(out) :: xyo_SurfRadLMatrix(im,jm,-1:1) 
                                                          !Աɽ
    real(DBKIND), intent(out) :: xyro_DelRadLFlux(im,jm,km+1,0:1)
                                                          ! ĹɽѲ
    real(DBKIND), intent(out) :: xyr_RadSFlux(im,jm,km+1) ! ͥեå
    real(DBKIND), intent(in) :: xyz_Temp(im,jm,km)
    real(DBKIND), intent(in) :: xyr_Temp(im,jm,km+1)
    real(DBKIND), intent(in) :: xy_SurfTemp(im,jm)
    real(DBKIND), intent(in) :: xyz_Qvap(im,jm,km)
    real(DBKIND), intent(in) :: xyr_Press(im,jm,km+1)
    real(DBKIND), intent(in) :: xy_SurfAlbedo(im,jm)
    real(DBKIND), intent(in) :: x_Lon(im) 
    real(DBKIND), intent(in) :: y_Lat(jm)


    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_radiation_main"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: k

    real(DBKIND) :: &
         & xyr_TauQvap(im,jm,km+1)   , &  !" Ū
         & xyr_TauDryAir(im,jm,km+1) , &  !" Ū
         & xy_InAngle(im,jm)              !" sec(ͳ)


    ! (2007-5-20 ) ϻ֤ñ̤ꤷ
    ! Ǥ褦ˤʤȤʤ.
    !real(DBKIND), parameter :: RadLDelTime = 3.0
    !real(DBKIND), parameter :: RadSDelTime = 1.0
    real(DBKIND), parameter :: RadLDelTime = 0.0
    real(DBKIND), parameter :: RadSDelTime = 0.0
    
    real(DBKIND),allocatable,save :: xy_TempOld(:,:)
    real(DBKIND),allocatable,save :: xyr_RadLFluxOld(:,:,:)
    real(DBKIND),allocatable,save :: xyr_RadSFluxOld(:,:,:)
    real(DBKIND),allocatable,save :: xyro_DelRadLFluxOld(:,:,:,:)
    real(DBKIND),save :: RadLTime, RadSTime
    
    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ͷ׻
    !----------------------------------------------------------------

    ! , ͷ׻δֳ֤򳰤Ϳ褦ˤʤȤʤ. 
    ! AGCM5 Ǥ, ûȤ 1 , ĹȤ 3 ֳִ. 

    if ( CurrentLoop .EQ. 1 ) then
       RadLTime = -999.0d0 * 60*60
       RadSTime = -999.0d0 * 60*60
       
       allocate( &
            & xy_TempOld(im,jm), &
            & xyr_RadLFluxOld(im,jm,km+1), &
            & xyr_RadSFluxOld(im,jm,km+1), &
            & xyro_DelRadLFluxOld(im,jm,km+1,0:1) &
            & )
    end if
    
    ! ---- 1.  η׻ ----
    xyr_TauQvap   = 0.0d0
    xyr_TauDryAir = 0.0d0

    do k = km , 1, -1
       xyr_TauQvap(:,:,k) = xyr_TauQvap(:,:,k+1) &
            &           + xyz_Qvap(:,:,k)     & 
            &           * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav 
       
       xyr_TauDryAir(:,:,k) = xyr_TauDryAir(:,:,k+1) &
            &           + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav 
    end do


    ! ---- 2. Ĺȥեåλ ----
    ! (2007-5-4 ) 
    ! * ѿѰդƸƥѥäȤ狼褦ˤǤʤ?
    if ( (CurrentTime - RadLTime) .GE. (RadLDelTime*60*60) ) then
       
       RadLTime = CurrentTime
       
       call physics_radiation_long( &
            & xyr_RadLFlux          , & ! (out) Ĺȥեå
            & xyro_DelRadLFlux      , & ! (out) ĹɽѲ
            & xyz_Temp              , & ! (in)  ()
            & xyr_Temp              , & ! (in)  (Ⱦ)
            & xy_SurfTemp           , & ! (in) ɽ̲
            & xyr_TauQvap           , & ! (in) Ū
            & xyr_TauDryAir           ) ! (in) Ū
       
    ! ---- 2*. Ĺȥեå׻ʤ ----
    else
       
       xyr_RadLFlux = xyr_RadLFluxOld
       xyro_DelRadLFlux = xyro_DelRadLFluxOld
       
       do k = 1, km+1
          xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k) &
               & +  xyro_DelRadLFlux(:,:,k,1) &
               &  * (xyz_Temp(:,:,1) - xy_TempOld(:,:) )
          xyro_DelRadLFlux(:,:,k,1) = xyro_DelRadLFlux(:,:,k,1) &
               & / (xy_TempOld(:,:)**3) * (xyz_Temp(:,:,1)**3)
       end do
    end if


    ! ---- 3. Ĺȱѹ ----    
    xyo_SurfRadLMatrix(:,:,0)  = xyro_DelRadLFlux(:,:,1,0)
    xyo_SurfRadLMatrix(:,:,1)  = xyro_DelRadLFlux(:,:,1,1)
    xyo_SurfRadLMatrix(:,:,-1) = 0.0d0


    if ( (CurrentTime - RadSTime) .GE. (RadSDelTime*60*60) ) then

       ! ----  4. û ----
       call physics_radiation_incoming( &
         & xyr_RadSFlux(:,:,km+1)   , & ! (out) ûȥեå
         & xy_InAngle              , & ! (out) sec(ͳ)
         & x_Lon                   , & !(in) 
         & y_Lat                    ) !(in) 
       
       ! ----  5. ûȥեå ----
       call physics_radiation_short( &
            & xyr_RadSFlux         , & ! (inout) ûȥեå
            & xyr_TauQvap          , & ! (in) Ū
            & xyr_TauDryAir        , & ! (in) Ū
            & xy_InAngle           , & ! (in) sec(ͳ)
            & xy_SurfAlbedo          ) ! (in) ɽ٥

    else
       xyr_RadSFlux = xyr_RadSFluxOld
    end if


    ! ---- Ťͤ¸ ----
    xy_TempOld = xyz_Temp(:,:,1)
    xyr_RadLFluxOld = xyr_RadLFlux
    xyr_RadSFluxOld = xyr_RadSFlux
    xyro_DelRadLFluxOld = xyro_DelRadLFlux


    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

   end subroutine physics_radiation_main



  subroutine physics_radiation_deltemp( &
    & xyz_DRadLTempDt, xyz_DRadSTempDt, & !(out)
    & xyr_RadLFlux, xyr_RadSFlux, xyr_Press & !(in)
    & )
    !
    !== ͲǮΨη׻
    !
    ! û, Ĺͤ줾βǮΨ׻.
    !
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: Cp    ,& ! 絤갵Ǯ 
         &                   Grav     ! ϲ®
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    implicit none
    real(DBKIND), intent(out) :: xyz_DRadLTempDt(im,jm,km) ! ĹȲǮΨ
    real(DBKIND), intent(out) :: xyz_DRadSTempDt(im,jm,km) ! ûȲǮΨ
    real(DBKIND), intent(in) :: xyr_RadLFlux(im,jm,km+1) ! Ĺȥեå
    real(DBKIND), intent(in) :: xyr_RadSFlux(im,jm,km+1) ! ûȥեå
    real(DBKIND), intent(in) :: xyr_Press(im,jm,km+1) !  (Ⱦ)
    character(STRING), parameter:: subname = "physics_radiation_deltemp"
      ! ѿ
    integer(INTKIND) :: k
      ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   Ψα黻 (ǮΨǤ?)
    !----------------------------------------------------------------

    do k = 1, km
       xyz_DRadLTempDt(:,:,k) =( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k+1) ) &
            & / (xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
       xyz_DRadSTempDt(:,:,k) =( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k+1) ) &
            & / (xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Cp * Grav
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_radiation_deltemp


end module physics_radiation_main_mod
















