!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------

module physics_ps_correction_mod
  !
  != ʪ ɽ̵Ĵ⥸塼
  !
  !== 
  !
  ! ŷ롦ȯˤ絤̤Ԥ.
  ! 
  !
  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_ps_correction

contains

  subroutine physics_ps_correction( &
    & xyz_Qvap   , & !(inout)
    & xy_SurfPress, & !(inout)
    & xyr_QvapFlux , & !(in)
    & xyz_DCumulusQvapDt, & !(in)
    & xyr_Press  , &  !(in)
    & DelTimePhy          ) !(in) 
    ! ŷ롦ȯˤ絤̤

    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: EL    ,& ! ζŷǮ 
         &                   Grav     ! ϲ®
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    real(DBKIND), intent(inout) :: xyz_Qvap    ( im*jm, km )  ! 漾 
    real(DBKIND), intent(inout) :: xy_SurfPress   ( im*jm )   !  ɽ̵
    real(DBKIND), intent(in) :: xyr_Press   ( im*jm, km+1 ) ! (Ⱦ)
    real(DBKIND), intent(in) :: xyr_QvapFlux   ( im*jm, km+1 ) ! q եå
    real(DBKIND), intent(in) :: xyz_DCumulusQvapDt   ( im*jm, km ) ! q ŷ
    real(DBKIND), intent(in) :: DelTimePhy                        ! 2t

    real(DBKIND) :: xyz_DelPress  ( im*jm, km )   ! 
    real(DBKIND) :: xy_DelSurfPress ( im*jm )   ! Ps Ѳ
    character(STRING),  parameter:: subname = "physics_ps_correction"
    integer(INTKIND) :: ij ! 롼ѿ
    integer(INTKIND) :: k ! 롼ѿ

    continue

    ! Ͻ
    call BeginSub(subname)

    ! 
    do k = 1, km
      do ij = 1, im*jm
            xyz_DelPress( IJ,K ) = xyr_Press( IJ,K ) - xyr_Press( IJ,K+1 )
      enddo
    enddo

    ! 絤
    do ij = 1, im*jm
       xy_DelSurfPress(IJ) = xyr_QvapFlux(IJ,1)/EL*GRAV *DelTimePhy * 0.01
       do K = 1, km
         xy_DelSurfPress(IJ) = xy_DelSurfPress(IJ) &
           & + xyz_DCumulusQvapDt(IJ,K) * DelTimePhy &
           &   * xyz_DelPress(IJ,K) * 0.01
       enddo
    enddo

    ! q ͤ
    do k = 1, km
      do ij = 1, im*jm
         xyz_Qvap ( ij,k ) &
           &  = xy_SurfPress(ij) /( xy_SurfPress(ij) + xy_DelSurfPress(ij) )&
           &    * xyz_Qvap(IJ,K)
      enddo
    enddo

    ! Ps ͤ
    do ij = 1, im*jm
       xy_SurfPress ( IJ ) = xy_SurfPress(IJ) + xy_DelSurfPress(IJ)
    enddo 

    ! λ
    call EndSub(subname)

  end subroutine physics_ps_correction

end module physics_ps_correction_mod
