!== Held and Suarez (1994) ٥ޡƥȥץ
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam.f90,v 1.3 2006/08/21 08:01:09 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
program dcpam
  !
  !dcpam ΥƥȥץȤƤ Held and Suarez (1994) ٥ޡƥ
  !ԤʤץǤ. ߤ main/init.f90 ˤäƽͤ
  !ɬפޤ.
  !

  !----- NAMELIST ̾⥸塼 -----
  use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close

  !----- ʪ⥸塼 -----
  use constants_mod, only: SecPerDay

  !----- ¤λȥ⥸塼 -----
  use dycore_type_mod, only: DYCORE_VARS, DYCORE_DIMS, STRING, INTKIND, REKIND

  !----- ʻ⥸塼 -----
  use dycore_grid_mod, only: dycore_grid_init, dycore_grid_end, &
       &                     im, jm, km, nm

  !----- ǡI/O⥸塼 -----
  use dycore_in_mod,   only: dycore_in_init,                  &
       &                     dycore_in_dims, dycore_in_vars,  &
       &                     dycore_in_end
  use dycore_out_mod,  only: dycore_out_init, dycore_out_put, &
       &                     dycore_out_end

  !----- ϳز⥸塼 (ڥȥǥ) -----
  use dycore_dynamics_mod, only: dycore_dynamics_init, &
       &                         dycore_dynamics_prediction,  &
       &                         dycore_dynamics_diagnostic,  &
       &                         dycore_dynamics_diffusion,  &
       &                         dycore_dynamics_end


  !----- Held and Suarez(1994) ⥸塼 -----
  use dycore_hs94forcing_mod, only: dycore_hs94forcing_init, &
       &                            dycore_hs94forcing     , &
       &                            dycore_hs94forcing_end

  !----- ֹե륿⥸塼 -----
  use dycore_time_mod, only: dycore_time_init, dycore_time_progress, &
       &                     dycore_time_end,  dycore_time_filter,   &
       &                     StepInterval, OutputStep, &
       &                     CurrentLoop, CurrentTime, DelTime
!      ! &                     dycore_time_filter

  !----- ޥɥ饤ϥġ -----
  use dc_args, only: ARGS, Open, Debug, Help, Strict, Close

  !----- ǥХåѥġ -----
  use dc_trace,  only: SetDebug, DbgMessage, BeginSub, EndSub
  use dc_message,only: MessageNotify
  use dc_string, only: toChar, Printf
  implicit none

  logical :: CalcDynamics    = .true. ! ϳإα黻
  logical :: CalcDiffusion   = .true. ! Ȼα黻
  logical :: CalcHS94forcing = .true. ! Held and Suarez(1994) ˤ붯

  namelist /dcpam_nml/ CalcDynamics, CalcDiffusion, CalcHS94forcing
    ! ¸Ԥ

  !-------------------------------------------------------------------
  !   ѿ
  !-------------------------------------------------------------------
  !----- ǡƤ (ּΤ߽) -----
  type(DYCORE_DIMS)          :: Dims       ! ǡ

  !----- ׻ʻǡƤ -----
  type(DYCORE_VARS)          :: Vars_b     ! ʻǡ(t-t)
  type(DYCORE_VARS)          :: Vars_n     ! ʻǡ(t)
  type(DYCORE_VARS)          :: Vars_a     ! ʻǡ(t+t)

  !----- ѿ -----
  !for time measure in temporarily
  real(REKIND) :: &
       & start_time_init, end_time_init, &
       & start_time_dynmcs, end_time_dynmcs, store_time_dynmcs = 0.0, &
       & start_time_diff, end_time_diff, store_time_diff = 0.0, &
       & start_time_diag, end_time_diag, store_time_diag = 0.0, &
       & start_time_hs94, end_time_hs94, store_time_hs94 = 0.0, &
       & total_time = 0.0 , remaining_time = 0.0
  integer(INTKIND) :: dateval(1:8)

  !for nmlfile_mod
  integer(INTKIND)   :: nmlstat, nmlunit
  logical            :: nmlreadable

  !for dc_args
  type(ARGS) :: arg

  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: dcpam.f90,v 1.3 2006/08/21 08:01:09 morikawa Exp $'
  character(STRING),  parameter:: subname = "dcpam"

continue
  !-------------------------------------------------------------------
  !   ǥХå⡼ɳ
  !-------------------------------------------------------------------
  call Open(arg)
  call Debug(arg); call Help(arg) ; call Strict(arg)
  call Close(arg)

  call BeginSub(subname, version=version)

  !-------------------------------------------------------------------
  !   use CPU_TIME
  !-------------------------------------------------------------------
  call cpu_time(start_time_init)

  !-------------------------------------------------------------------
  !   NAMELIST file Setting
  !-------------------------------------------------------------------
  call nmlfile_init('dcpam.nml')

  !----------------------------------------------------------------
  !   Read init_nml
  !----------------------------------------------------------------
  call nmlfile_open(nmlunit, nmlreadable)
  if (nmlreadable) then
     read(nmlunit, nml=dcpam_nml, iostat=nmlstat)
     call DbgMessage('Stat of NAMELIST dcpam_nml Input is <%d>', &
          &           i=(/nmlstat/))
     write(0, nml=dcpam_nml)
  else
     call DbgMessage('Not Read NAMELIST dcpam_nml')
     call MessageNotify('W', subname, &
          & 'Can not Read NAMELIST dcpam_nml. Force Use Default Value.')
  end if
  call nmlfile_close

  !-------------------------------------------------------------------
  !   ʻμ
  !-------------------------------------------------------------------
  call dycore_grid_init

  !-------------------------------------------------------------------
  !   ͥǡɤ߹ (gt4f90io ξ̥⥸塼)
  !     (ե̾ɤ߹ѿ NAMELIST ѹ)
  !-------------------------------------------------------------------
  call dycore_in_init
  call dycore_in_dims(  &
       & Dims          )  ! intent(out): ǡ

  call dycore_in_vars( &
       & Vars_b      , & ! intent(out): ʻǡ(t-t)
       & Vars_n    )     ! intent(out): ʻǡ(t)

  !-------------------------------------------------------------------
  !   ֡ ƥåפ˴ؤ
  !-------------------------------------------------------------------
  call dycore_time_init

  !-------------------------------------------------------------------
  !   ǡϤν
  !-------------------------------------------------------------------
  call dycore_out_init( &
       & Dims           ) ! intent(in): ǡ

  !-------------------------------------------------------------------
  !   ϳز黻ν
  !-------------------------------------------------------------------
  call dycore_dynamics_init( &
       & Dims              , & ! intent(in): ǡ
       & Vars_a          )     ! intent(out): ʻǡ(t+t)

  !-------------------------------------------------------------------
  !   Held and Suarez(1994) ⥸塼ν
  !-------------------------------------------------------------------
  call dycore_hs94forcing_init( &
       & Dims            )     ! intent(in): ǡ

  !-------------------------------------------------------------------
  !   use CPU_TIME
  !-------------------------------------------------------------------
  call cpu_time(end_time_init)
  call date_and_time(values=dateval)
  call Printf(6, &
       & 'Elapsed Time=<%r>, Start=<%r>, Stop=<%r>, ' // &
       & 'Now=<%d/%d/%d  %d:%d:%d>', &
       & r=(/end_time_init - start_time_init, &
       &     start_time_init, end_time_init/), &
       & i=(/dateval(1), dateval(2), dateval(3), &
       &     dateval(5), dateval(6), dateval(7)  /) )


  !-------------------------------------------------------------------
  !   (test) ͥǡɤޤƤ뤫å
  !-------------------------------------------------------------------
!!$  call dycore_out_put    &
!!$       &  ( Vars_b   )  ! intent(in) : ʻǡ(t-t)
!!$  call dycore_out_put    &
!!$       &  ( Vars_n   )  ! intent(in) : ʻǡ(t)

  MainLoop : do
     call BeginSub( subname, &
          & 'MainLoop : CurrentLoop=<%d>, CurrentTime=<%f>', &
          & i=(/CurrentLoop/), d=(/CurrentTime/) )
     !----------------------------------------------------------------
     !   ʪ黻
     !----------------------------------------------------------------

     !----------------------------------------------------------------
     !   ϳز黻
     !----------------------------------------------------------------
     if (CalcDynamics) then
        call cpu_time(start_time_dynmcs)
        call dycore_dynamics_prediction( &
          & Dims          , &   ! intent(in)   : ǡ
          & Vars_b        , &   ! intent(in)   : ʻǡ(t-t)
          & Vars_n        , &   ! intent(in)   : ʻǡ(t)
          & Vars_a  )           ! intent(inout): ʻǡ(t+t)
        call cpu_time(end_time_dynmcs)
        store_time_dynmcs = store_time_dynmcs &
             & + (end_time_dynmcs - start_time_dynmcs)


        call cpu_time(start_time_diff)
        if (CalcDiffusion) then
           call dycore_dynamics_diffusion( &
             & Vars_b    , &  ! intent(in)   : ʻǡ(t-t)
             & Vars_a  )      ! intent(inout): ʻǡ(t+t)
        else
           call DbgMessage('Not Consider Diffusion.')
        end if
        call cpu_time(end_time_diff)
        store_time_diff = store_time_diff &
             & + (end_time_diff - start_time_diff)


        call cpu_time(start_time_diag)
        !-----  ǽ  -----
        call dycore_dynamics_diagnostic( &
          & Dims            , & ! intent(in)   : ǡ
          & Vars_a  )           ! intent(inout): ʻǡ(t+t)
        call cpu_time(end_time_diag)
        store_time_diag = store_time_diag &
             & + (end_time_diag - start_time_diag)

     else
        call cpu_time(start_time_dynmcs)
        call DbgMessage('Not Calculate Dynamics.')
        Vars_a%xyz_VelLon = Vars_b%xyz_VelLon  ! ®ٷʬ
        Vars_a%xyz_VelLat = Vars_b%xyz_VelLat  ! ®ٰʬ
        Vars_a%xyz_Vor    = Vars_b%xyz_Vor   ! 
        Vars_a%xyz_Div    = Vars_b%xyz_Div   ! ȯ
        Vars_a%xyz_Temp   = Vars_b%xyz_Temp  ! 
        Vars_a%xyz_QVap   = Vars_b%xyz_QVap  ! 漾
        Vars_a%xy_Ps      = Vars_b%xy_Ps     ! ɽ̵
        call cpu_time(end_time_dynmcs)
        store_time_dynmcs = store_time_dynmcs &
             & + (end_time_dynmcs - start_time_dynmcs)


        call cpu_time(start_time_diff)
        if (CalcDiffusion) then
           call dycore_dynamics_diffusion( &
             & Vars_b    , &  ! intent(in)   : ʻǡ(t-t)
             & Vars_a  )      ! intent(inout): ʻǡ(t+t)
        else
           call DbgMessage('Not Consider Diffusion.')
        end if
        call cpu_time(end_time_diff)
        store_time_diff = store_time_diff &
             & + (end_time_diff - start_time_diff)


        call cpu_time(start_time_diag)
        !-----  ǽ  -----
        call dycore_dynamics_diagnostic( &
          & Dims            , & ! intent(in)   : ǡ
          & Vars_a  )           ! intent(inout): ʻǡ(t+t)
        call cpu_time(end_time_diag)
        store_time_diag = store_time_diag &
             & + (end_time_diag - start_time_diag)

     end if


     !----------------------------------------------------------------
     !   Held and Suarez(1994) βǮβû
     !----------------------------------------------------------------
     call cpu_time(start_time_hs94)
     if (CalcHS94forcing) then
        call dycore_hs94forcing(  &
          & Vars_b     , & ! intent(in): ʻǡ (t-t)
          & Vars_n     , & ! intent(in): ʻǡ (t)
          & Vars_a   )     ! intent(inout): ʻǡ(t+t)
     else
        call DbgMessage('Not Calculate Held-Suarez Forcing.')
     end if
     call cpu_time(end_time_hs94)
     store_time_hs94 = store_time_hs94 &
          & + (end_time_hs94 - start_time_hs94)

     !----------------------------------------------------------------
     !   ե륿
     !----------------------------------------------------------------
     call dycore_time_filter( &
       & Vars_b           , & ! intent(in)   : ʻǡ(t-t)
       & Vars_n           , & ! intent(inout): ʻǡ(t)
       & Vars_a  )            ! intent(in)   : ʻǡ(t+t)

     !----------------------------------------------------------------
     !   ǡν
     !----------------------------------------------------------------
     call dycore_out_put( &
       & Vars_n  )            ! intent(in): ʻǡ(t)

!!$     !----------------------------------------------------------------
!!$     !   ꥹȥե
!!$     !----------------------------------------------------------------
!!$     call dycore_restart_put( &
!!$       & Vars_n           , & ! intent(in): ʻǡ(t)
!!$       & Vars_a  )            ! intent(in): ʻǡ(t+t)

     !----------------------------------------------------------------
     !   ﹹ
     !----------------------------------------------------------------
     call dycore_time_progress( &
       & Vars_b           , & ! intent(inout): ʻǡ(t-t)
       & Vars_n           , & ! intent(inout): ʻǡ(t)
       & Vars_a  )            ! intent(inout): ʻǡ(t+t)

     !-------------------------------------------------------------------
     !   use CPU_TIME
     !-------------------------------------------------------------------
     if ( mod(CurrentLoop, StepInterval) == 0 ) then
        call Printf(6, '')
        call Printf(6, '-- ***              ***  ')
        call Printf(6, '-- *** TIME         ***  ')
        call Printf(6, '-- ***      KEEPING ***  ')
        call Printf(6, '-- ***              ***  ')
        call Printf(6, &
             & '--CurrentLoop=<%d>, CurrentTime=<%f>, Day=<%f>', &
             & i=(/CurrentLoop/), d=(/CurrentTime, CurrentTime/SecPerDay /) )

        call Printf(6, '--Remaining Loop  ' // &
             & ': RemainingLoop=<%d>, RemainingTime=<%f>, Day=<%f>', &
             & i=(/StepInterval * OutputStep - CurrentLoop/), &
             & d=(/StepInterval * OutputStep * DelTime - CurrentTime , &
             &     ( StepInterval * OutputStep * DelTime &
             &        - CurrentTime ) / SecPerDay /)    )

        call cpu_time(total_time)
        remaining_time = &
             &  ( total_time / real(CurrentLoop, REKIND) ) &
             &    * real( StepInterval * OutputStep - CurrentLoop, REKIND )

        call Printf(6, '--Remaining Real Time Forecast  ' // &
             & ': RemainingRealTime=<%r>, Min=<%r>, Hour=<%r>, Day=<%r>', &
             & r=(/remaining_time, remaining_time / 6.0e1, &
             &     remaining_time/ 3.6e3, &
             &     remaining_time/ 8.64e4 /) )

        call date_and_time(values=dateval)
        call Printf(6, '--Current Time <%d/%d/%d  %d:%d:%d>', &
             & i=(/dateval(1), dateval(2), dateval(3), &
             &     dateval(5), dateval(6), dateval(7)  /) )

        call Printf(6, '--[Categoly]  : [Stored]       ' //  &
             &          '[Current]      [Start]        [Stop] '  )

        call Printf(6, '--Dynamics    : <%r> <%r> <%r> <%r> ',  &
             & r=(/store_time_dynmcs, &
             &     end_time_dynmcs - start_time_dynmcs, &
             &     start_time_dynmcs, end_time_dynmcs/)   )

        call Printf(6, '--Diffusion   : <%r> <%r> <%r> <%r> ', &
             & r=(/store_time_diff, &
             &     end_time_diff - start_time_diff, &
             &     start_time_diff, end_time_diff/)   )

        call Printf(6, '--Diagnostic  : <%r> <%r> <%r> <%r> ', &
             & r=(/store_time_diag, &
             &     end_time_diag - start_time_diag, &
             &     start_time_diag, end_time_diag/)   )

        call Printf(6, '--hs94forcing : <%r> <%r> <%r> <%r> ', &
             & r=(/store_time_hs94, &
             &     end_time_hs94 - start_time_hs94, &
             &     start_time_hs94, end_time_hs94/)   )
     end if

     !----------------------------------------------------------------
     !   롼פȴФɤȽ
     !----------------------------------------------------------------
     if ( CurrentLoop > StepInterval * OutputStep ) then
        exit MainLoop
     endif

     call EndSub(subname)
  enddo MainLoop

  call dycore_out_end

  call EndSub(subname)
end program dcpam
