!= Хĥǥ
!
!= Bucket model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: bucket_model.f90,v 1.15 2014/05/07 09:39:22 murashin Exp $
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module Bucket_Model

  ! ⥸塼 ; USE statements
  !


  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP      ! ټ¿. Double precision.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  logical, save :: bucket_model_inited = .false.
                              ! ե饰.
                              ! Initialization flag


  logical, save :: FlagSnow   ! ΰ 󡿥.
                              ! treatment of snow on/off.

  ! ³
  ! Public procedure
  !
  public :: BucketSetFlagOceanFromMatthews
!!$  public :: BucketEvap
!!$  public :: BucketEvapAdjust
  public :: BucketIntegration
  public :: BucketPRCPAdjust
  public :: BucketModHumidCoef
  public :: BucketModEvapAndLatentHeatFlux
  public :: BucketModelInit


  ! ѿ
  ! Private variables
  !
  real(DP), save:: SoilMoistCritAmnt
                        ! ھʬ̤ξ
                        ! Critical amount of soil moisture
  real(DP), save:: SoilMoistCritAmntforEvapEff
                        ! ɽ٤ 1 Ȥ
                        ! Critical amount of soil moisture for evaporation efficiency

  real(DP), save:: SoilMoistMeaningLess = -1.0d0
                        ! ξξ˻ѤʪŪˤϰ̣Τʤѿ
                        ! Meaning less value for soil moisture on the ocean

  real(DP), save:: HumidCoefSnowThreshold = 1.0d-50
                        !
                        ! Threshold of surface snow amount for surface humid coefficient determination

  character(*), parameter:: module_name = 'bucket_model'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: bucket_model.f90,v 1.15 2014/05/07 09:39:22 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine BucketSetFlagOceanFromMatthews( &
    & xy_SurfType,                           & ! (in)
    & xy_FlagOceanGrid                       & ! (out)
    & )
    !
    !
    !
    ! Set flagx for ocean grid point from Matthews' index
    !

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in ) :: xy_SurfType     (0:imax-1, 1:jmax)
                              ! 
                              ! Surface index
    logical , intent(out) :: xy_FlagOceanGrid(0:imax-1, 1:jmax)
                              ! 
                              ! Flag for ocean grid


    ! ѿ
    ! Work variables
    !

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. bucket_model_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    !
    ! Set index for calculation method
    !
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfType(i,j) == 0 ) then
          ! ocean
          xy_FlagOceanGrid(i,j) = .true.
        else
          ! land
          xy_FlagOceanGrid(i,j) = .false.
        end if
      end do
    end do


  end subroutine BucketSetFlagOceanFromMatthews

  !--------------------------------------------------------------------------------------

  subroutine BucketIntegration(        &
    & xy_FlagOceanGrid,                & ! (in )
    & xy_DSoilMoistDt, xy_DSurfSnowDt, & ! (in )
    & xy_SoilMoistB, xy_SurfSnowB,     & ! (in )
    & xy_SoilMoistA, xy_SurfSnowA      & ! (out)
    )

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & ThresholdSurfSnow,          &
      & TempCondWater

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &             ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_DSoilMoistDt ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_DSurfSnowDt  ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ǧ
    ! Initialization check
    !
    if ( .not. bucket_model_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    xy_SoilMoistA = xy_SoilMoistB + xy_DSoilMoistDt * 2.0_DP * DelTime

    ! Remove negative values
    !
    do j = 1, jmax
      do i = 0, imax-1
        if( xy_SoilMoistA(i,j) < 0.0_DP ) xy_SoilMoistA(i,j) = 0.0_DP
      end do
    end do

    if ( FlagSnow ) then
      xy_SurfSnowA = xy_SurfSnowB + xy_DSurfSnowDt * 2.0_DP * DelTime

      ! Remove negative values
      !
      do j = 1, jmax
        do i = 0, imax-1
          if( xy_SurfSnowA (i,j) < 0.0_DP ) xy_SurfSnowA (i,j) = 0.0_DP
        end do
      end do
    else
      xy_SurfSnowA = xy_SurfSnowB
    end if


    ! Fill meaningless value in ocean grid
    !
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_FlagOceanGrid(i,j) ) then
          xy_SoilMoistA(i,j) = SoilMoistMeaningLess
          xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
        end if
      end do
    end do


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine BucketIntegration

  !--------------------------------------------------------------------------------------
!!$
!!$  ! This is wrong under the condition that water vapor flux is negative (transported 
!!$  ! downward). (2011/12/17, yot)
!!$
!!$  subroutine BucketEvap(                 &
!!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
!!$    & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
!!$    & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
!!$    )
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: &
!!$      & DelTime, &             ! $ \Delta t $ [s]
!!$      & TimesetClockStart, TimesetClockStop
!!$
!!$    ! ʻ
!!$    ! Grid points settings
!!$    !
!!$    use gridset, only: imax, & ! ٳʻ.
!!$                               ! Number of grid points in longitude
!!$      &                jmax, & ! ٳʻ.
!!$                               ! Number of grid points in latitude
!!$      &                kmax    ! ľؿ.
!!$                               ! Number of vertical level
!!$
!!$    ! ȳɹ
!!$    ! Setting constants of snow and sea ice
!!$    !
!!$    use constants_snowseaice, only: &
!!$      & ThresholdSurfSnow,          &
!!$      & TempCondWater
!!$
!!$    logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
!!$    real(DP), intent(in ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
!!$
!!$
!!$    ! ǧ
!!$    ! Initialization check
!!$    !
!!$    if ( .not. bucket_model_inited ) then
!!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
!!$    end if
!!$
!!$
!!$    ! ׻ַ¬
!!$    ! Start measurement of computation time
!!$    !
!!$    call TimesetClockStart( module_name )
!!$
!!$
!!$    if ( .not. FlagBucketModel ) then
!!$      xy_SoilMoistA = xy_SoilMoistB
!!$      xy_SurfSnowA  = xy_SurfSnowB
!!$      return
!!$    end if
!!$
!!$
!!$    if ( FlagBucketModelSnow ) then
!!$
!!$      ! Evaporation is subtracted from surface snow and soil moisture
!!$      !
!!$      xy_SurfSnowA = xy_SurfSnowB - xy_SurfEvapFlux * 2.0d0 * DelTime
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          if ( xy_SurfSnowA(i,j) < 0.0d0 ) then
!!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j) + xy_SurfSnowA(i,j)
!!$            xy_SurfSnowA (i,j) = 0.0d0
!!$          else
!!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j)
!!$          end if
!!$        end do
!!$      end do
!!$    else
!!$      ! Evaporation is subtracted from soil moisture
!!$      !
!!$      xy_SoilMoistA = xy_SoilMoistB - xy_SurfEvapFlux * 2.0d0 * DelTime
!!$      xy_SurfSnowA  = xy_SurfSnowB
!!$    end if
!!$
!!$    ! Remove negative values
!!$    !
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if( xy_SoilMoistA(i,j) < 0.0d0 ) xy_SoilMoistA(i,j) = 0.0d0
!!$        if( xy_SurfSnowA (i,j) < 0.0d0 ) xy_SurfSnowA (i,j) = 0.0d0
!!$      end do
!!$    end do
!!$
!!$    ! Fill meaningless value in ocean grid
!!$    !
!!$    do j = 1, jmax
!!$      do i = 0, imax-1
!!$        if ( xy_FlagOceanGrid(i,j) ) then
!!$          xy_SoilMoistA(i,j) = SoilMoistMeaningLess
!!$          xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
!!$        end if
!!$      end do
!!$    end do
!!$
!!$    ! ׻ַ¬
!!$    ! Pause measurement of computation time
!!$    !
!!$    call TimesetClockStop( module_name )
!!$
!!$
!!$  end subroutine BucketEvap
!!$
!!$  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine BucketEvapAdjust(           &
!!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in   )
!!$    & xy_SoilMoist, xy_SurfSnow          & ! (inout)
!!$    )
!!$
!!$    ! ʻ
!!$    ! Grid points settings
!!$    !
!!$    use gridset, only: imax, & ! ٳʻ.
!!$                               ! Number of grid points in longitude
!!$      &                jmax, & ! ٳʻ.
!!$                               ! Number of grid points in latitude
!!$      &                kmax    ! ľؿ.
!!$                               ! Number of vertical level
!!$
!!$    logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
!!$    real(DP), intent(in   ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
!!$    real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP) :: xy_SoilMoistB( 0:imax-1, 1:jmax )
!!$    real(DP) :: xy_SurfSnowB ( 0:imax-1, 1:jmax )
!!$    real(DP) :: xy_SoilMoistA( 0:imax-1, 1:jmax )
!!$    real(DP) :: xy_SurfSnowA ( 0:imax-1, 1:jmax )
!!$
!!$
!!$    ! ǧ
!!$    ! Initialization check
!!$    !
!!$    if ( .not. bucket_model_inited ) then
!!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
!!$    end if
!!$
!!$
!!$    xy_SoilMoistB = xy_SoilMoist
!!$    xy_SurfSnowB  = xy_SurfSnow
!!$
!!$    call BucketEvap(                       &
!!$      & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
!!$      & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
!!$      & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
!!$      )
!!$
!!$    xy_SoilMoist = xy_SoilMoistA
!!$    xy_SurfSnow  = xy_SurfSnowA
!!$
!!$
!!$  end subroutine BucketEvapAdjust
!!$
  !--------------------------------------------------------------------------------------

  subroutine BucketPRCPAdjust(                            &
    & xy_FlagOceanGrid, xy_SurfRainFlux, xy_SurfSnowFlux, &  ! (in )
    & xy_SoilMoist, xy_SurfSnow                           &  ! (inout)
    & )

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & CpDry,            &
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure
      & Grav,             &
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & LatentHeat,       &
                              ! $ L $ [J kg-1] .
                              ! ŷǮ.
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN,   &             ! ƥå $ t $ λ. Time of step $ t $.
      & DelTime, &             ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_DelSigma
                              ! $ \Delta \sigma $ ().
                              ! $ \Delta \sigma $ (Full)

    logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
!!$    real(DP) :: xy_TempIncByFusion( 0:imax-1, 1:jmax )
!!$                              ! Temperature increase by fusion

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ǧ
    ! Initialization check
    !
    if ( .not. bucket_model_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


!!$    ! Initialize an array for temperature increase by fusion
!!$    !
!!$    xy_TempIncByFusion = 0.0d0


    if ( FlagSnow ) then
      ! Precipitation is added to soil moisture or surface snow
      !
      do j = 1, jmax
        do i = 0, imax-1

          xy_SoilMoist(i,j) = xy_SoilMoist(i,j) &
            & + xy_SurfRainFlux(i,j) * 2.0_DP * DelTime
          xy_SurfSnow (i,j) = xy_SurfSnow (i,j) &
            & + xy_SurfSnowFlux(i,j) * 2.0_DP * DelTime

        end do
      end do
    else
      ! Precipitation is added to soil moisture
      !
!!$      xy_SoilMoist = xy_SoilMoist + xy_SurfPRCPFlux * 2.0d0 * DelTime
      xy_SoilMoist = xy_SoilMoist &
        & + ( xy_SurfRainFlux + xy_SurfSnowFlux ) * 2.0_DP * DelTime
    end if

    ! Calculation of Run-off
    !
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SoilMoist(i,j) > SoilMoistCritAmnt ) &
          & xy_SoilMoist(i,j) = SoilMoistCritAmnt
      end do
    end do

    ! Fill meaningless value in ocean grid
    !
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_FlagOceanGrid(i,j) ) then
          xy_SoilMoist(i,j) = SoilMoistMeaningLess
          xy_SurfSnow (i,j) = SoilMoistMeaningLess
        end if
      end do
    end do

    ! ҥȥǡ
    ! History data output
    !
!!$    call HistoryAutoPut( TimeN, 'TempIncByFusion' , xy_TempIncByFusion )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine BucketPRCPAdjust

  !--------------------------------------------------------------------------------------

  subroutine BucketModHumidCoef(                   &
    & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
    & xy_SurfHumidCoef                             & ! (inout)
    & )

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & ThresholdSurfSnow

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfHumidCoef( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. bucket_model_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Surface humidity coefficient is modified.
    !
    if ( FlagSnow ) then
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_FlagOceanGrid(i,j) ) then
            xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
!!$          else if ( xy_SurfSnow(i,j) > ThresholdSurfSnow ) then
          else if ( xy_SurfSnow(i,j) > HumidCoefSnowThreshold ) then
            xy_SurfHumidCoef(i,j) = 1.0_DP
          else
            xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
            if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
          end if
        end do
      end do
    else
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_FlagOceanGrid(i,j) ) then
            xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
          else
            xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
            if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
          end if
        end do
      end do
    end if


  end subroutine BucketModHumidCoef

  !--------------------------------------------------------------------------------------

  subroutine BucketModEvapAndLatentHeatFlux(       &
    & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
    & xy_SurfEvapFlux, xy_SurfLatentHeatFlux       & ! (inout)
    & )

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &             ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & LatentHeat,       &
                              ! $ L $ [J kg-1] .
                              ! ŷǮ.
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    logical , intent(in   ) :: xy_FlagOceanGrid     ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SoilMoist         ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ) :: xy_SurfSnow          ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfEvapFlux      ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfLatentHeatFlux( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ǧ
    ! Initialization check
    !
    if ( .not. bucket_model_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    if ( FlagSnow ) then
      ! Surface water vapor flux is limited up to the water and snow amount on land. 
      !
      do j = 1, jmax
        do i = 0, imax-1

          if ( .not. xy_FlagOceanGrid(i,j)  ) then
            if ( xy_SurfEvapFlux(i,j) > 0.0_DP ) then
              ! Water vapor flux is positive (transported upward).

              if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >           &
                &     xy_SoilMoist(i,j) + xy_SurfSnow(i,j)          ) then
                ! All snow and all water is evaporated.
                xy_SurfEvapFlux(i,j) = &
                  & ( xy_SoilMoist(i,j) + xy_SurfSnow(i,j) ) / ( 2.0_DP * DelTime )
                xy_SurfLatentHeatFlux(i,j) =                                    &
                  & (                                                           &
                  &     LatentHeat                        * xy_SoilMoist(i,j)   &
                  &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)    &
                  & )                                                           &
                  & / ( 2.0_DP * DelTime )
              else if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime > xy_SurfSnow(i,j) ) then
                ! All snow and a part of water is evaporated.
                xy_SurfLatentHeatFlux(i,j) =                                      &
                  & (                                                             &
                  &     LatentHeat * ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime - xy_SurfSnow(i,j) )  &
                  &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)      &
                  & )                                                             &
                  & / ( 2.0_DP * DelTime )
              else
                ! Only a part of snow is evaporated.
                xy_SurfLatentHeatFlux(i,j) =                                      &
                  & ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
              end if

            else
              ! Water vapor flux is negative (transported downward).

              if ( xy_SurfSnow(i,j) > 0.0_DP ) then
                ! Water vapor is converted to snow. 
                xy_SurfLatentHeatFlux(i,j) =                                      &
                  &   ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
              end if

            end if
          end if

        end do
      end do
    else
      ! Surface water vapor flux is limited up to the water amount on land. 
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( ( .not. xy_FlagOceanGrid(i,j)                                  ) .and.&
            &  ( xy_SurfEvapFlux(i,j)                    >  0.0_DP            ) .and.&
            &  ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >  xy_SoilMoist(i,j) ) ) &
            & then
            xy_SurfEvapFlux(i,j) = xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )

            xy_SurfLatentHeatFlux(i,j) = LatentHeat * xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )

          end if
        end do
      end do
    end if

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine BucketModEvapAndLatentHeatFlux

  !-------------------------------------------------------------------------------------

  subroutine BucketModelInit( &
    & ArgFlagSnow             & ! (in)
    & )
    !
    ! bucket_model ⥸塼νԤޤ. 
    ! NAMELIST#bucket_model_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "bucket_model" module is initialized. 
    ! "NAMELIST#bucket_model_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid


    ! ʸ ; Declaration statements
    !
    implicit none

    logical, intent(in) :: ArgFlagSnow


    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /bucket_model_nml/                         &
      & SoilMoistCritAmnt, SoilMoistCritAmntforEvapEff


    ! ¹ʸ ; Executable statement
    !

    if ( bucket_model_inited ) return


    FlagSnow = ArgFlagSnow


    ! ǥեͤ
    ! Default values settings
    !

    ! Values from Manabe (1969)
    !  Manabe, Climate and the ocean circulation I. The atmospheric circulation and 
    !  the hydrology of the Earth's surface, Mon. Wea. Rev., 97, 739-774, 1969
    !
    SoilMoistCritAmnt            = 1.0e3_DP * 0.15e0_DP
    SoilMoistCritAmntforEvapEff  = 1.0e3_DP * 0.15e0_DP * 0.75e0_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = bucket_model_nml, &    ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


!!$    ! ҥȥǡϤΤΤؤѿϿ
!!$    ! Register of variables for history data output
!!$    !
!!$    call HistoryAutoAddVariable( 'TempIncByFusion', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'temperature increase by fusion', 'K' )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

    call MessageNotify( 'M', module_name, '  SoilMoistCritAmnt           = %f', d = (/ SoilMoistCritAmnt  /) )
    call MessageNotify( 'M', module_name, '  SoilMoistCritAmntforEvapEff = %f', d = (/ SoilMoistCritAmntforEvapEff /) )
    call MessageNotify( 'M', module_name, '  FlagSnow                    = %y', l = (/ FlagSnow /) )


    bucket_model_inited = .true.

  end subroutine BucketModelInit

  !--------------------------------------------------------------------------------------

end module Bucket_Model
