!= 絬϶ŷ
!
!= Large scale condensation
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_lscond.f90,v 1.7 2008-04-20 18:55:50 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_lscond
  !
  != 絬϶ŷ
  !
  != Large scale condensation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 絬϶ŷˤäƲ٤漾Ĵᤷޤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! a large scale condensation process.
  !
  !== Procedures List
  !
  ! Create        :: PHYLSC ѿν
  ! Close         :: PHYLSC ѿνλ
  ! PutLine       :: PHYLSC ѿ˳ǼƤΰ
  ! initialized   :: PHYLSC ѿꤵƤ뤫ݤ
  ! LScaleCond    :: ٤漾Ĵ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYLSC"
  ! Close         :: Deconstructor of "PHYLSC"
  ! PutLine       :: Print information of "PHYLSC"
  ! initialized   :: Check initialization of "PHYLSC"
  ! LScaleCond    :: Adjust temperature and specific humidity
  !
  !== Usage
  !
  ! Ϥ, PHYLSC ѿ, Create ǽԤޤ.
  ! LScaleCond ѤƲ٤ȼ٤ĴԤޤ. 
  ! PHYLSC ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYLSC" by "Create".
  ! In order to adjust temperature and specific humidity, use "LScaleCond". 
  ! In order to terminate "PHYLSC", use "Close".
  !

  use dc_types, only: DP, TOKEN
  use phy_saturate_nha92, only: PHYSATNHA
  implicit none
  private
  public:: PHYLSC, Create, Close, PutLine, initialized, LScaleCond

  type PHYLSC
    !
    ! ޤ, Create  "PHYLSC" ѿꤷƲ.
    ! ꤵ줿 "PHYLSC" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYLSC" variable by "Create" before usage.
    ! If you reuse "PHYLSC" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
    integer:: IterationMax
                              ! ƥ졼. 
                              ! Number of iteration
    integer :: dummy0    ! 8 ӥåȶѤΥߡѿ.      Dummy variable for 8 bit boundary

    !-----------------------------------
    !  ˰漾׻ѥ֥
    !  Object for calculation of saturation specific humidity
    type(PHYSATNHA):: phy_sat

  end type PHYLSC

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_lscond.f90,v 1.7 2008-04-20 18:55:50 morikawa Exp $'

  interface Create
    module procedure PhyLSCondCreate
  end interface

  interface Close
    module procedure PhyLSCondClose
  end interface

  interface PutLine
    module procedure PhyLSCondPutLine
  end interface

  interface initialized
    module procedure PhyLSCondInitialized
  end interface

  interface NmlRead
    module procedure PhyLSCondNmlRead
  end interface

  interface LScaleCond
    module procedure PhyLSCondLScaleCond
  end interface

!!$  interface Sample
!!$    module procedure PhyLSCondSample
!!$  end interface

contains

  subroutine PhyLSCondCreate( phy_lsc, &
    & imax, jmax, kmax, &
    & Grav, Cp, EL, RVap, EpsV, ES0, &
    & DelTime, &
    & nmlfile, err )
    !
    ! PHYLSC ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYLSC ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_lsc* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_lscond_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYLSC".
    ! Initialize *phy_lsc* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_lsc* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_lscond_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use phy_saturate_nha92, only: PhySatNhaCreate
    implicit none
    type(PHYLSC), intent(inout):: phy_lsc
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(in):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP), intent(in):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_lscond_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_lscond_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyLSCondCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_lsc % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYLSC'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYLSC" 
    !  Configure the settings for "PHYLSC"
    !-----------------------------------------------------------------
    phy_lsc % imax    = imax   
    phy_lsc % jmax    = jmax   
    phy_lsc % kmax    = kmax   
    phy_lsc % Grav    = Grav   
    phy_lsc % Cp      = Cp     
    phy_lsc % EL      = EL     
    phy_lsc % RVap    = RVap   
    phy_lsc % EpsV    = EpsV   
    phy_lsc % ES0     = ES0    
    phy_lsc % DelTime = DelTime

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_lsc % param_r = 0.0_DP
!!$    phy_lsc % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_lsc % param_i = param_i
!!$    if ( present(param_r) )  phy_lsc % param_r = param_r
!!$    if ( present(param_c) )  phy_lsc % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_lsc % param_i, &   ! (inout)
!!$        & param_r = phy_lsc % param_r, &   ! (inout)
!!$        & param_c_ = phy_lsc % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ׳м٤԰εƸ
    !  Configure critical relative humidity and admissible error of unstability
    !-----------------------------------------------------------------
    phy_lsc % CrtlRH = 1.0_DP
    phy_lsc % IterationMax = 3

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_lsc % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if

    !-----------------------------------------------------------------
    !  ˰漾׻ѥ֥Ȥν
    !  Initialize object for calculation of saturation specific humidity
    !-----------------------------------------------------------------
    call PhySatNhaCreate( &
      & phy_sat_nha = phy_lsc % phy_sat, &       ! (out)
      & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
      & EpsV = EpsV, &                           ! (in)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_lsc % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyLSCondCreate

  subroutine PhyLSCondLScaleCond( phy_lsc, &
    & xyz_Temp, xyz_QVap, &
    & xyz_Press, xyr_Press, &
    & xy_Rain, xyz_DTempDt, xyz_DQVapDt, &
    & err )
    !
    ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! ʤ, Ϳ줿 *phy_lsc*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Adjust temperature and specific humidity by 
    ! convective adjustment scheme.
    !
    ! If *phy_lsc* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: CalcQVapSat, CalcDQVapSatDTemp
    implicit none
    type(PHYLSC), intent(inout):: phy_lsc
    real(DP), intent(inout):: xyz_Temp (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! $ P_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(in):: xyr_Press (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xy_Rain (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1)
                              ! ѱˤ߿. 
                              ! Precipitation by cumulus scheme
    real(DP), intent(out):: xyz_DTempDt (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! ѱˤ벹ѲΨ. 
                              ! Temperature tendency by cumulus scheme
    real(DP), intent(out):: xyz_DQVapDt (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! ѱˤ漾ѲΨ. 
                              ! Specific humidity tendency by cumulus scheme
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
    integer:: IterationMax
                              ! ƥ졼. 
                              ! Number of iteration

    real(DP):: xyz_QVapB (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
!!$    real(DP):: xyz_QVapSat (0:phy_lsc%imax-1, 0:phy_lsc%jmax-1, 0:phy_lsc%kmax-1)
!!$                              ! ˰漾. 
!!$                              ! Saturation specific humidity. 
    real(DP):: QVapSat
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: DelQVap
                              ! Ĵˤ漾Ѳ. 
                              ! Specific humidity variation by adjustment
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment
    real(DP):: DQVapSatDTemp
                              ! $ \DD{q_{\rm{sat}}}{T} $
    integer:: Iteration
    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyLSCondLScaleCond'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_lsc % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYLSC'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_lsc* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_lsc*
    !-----------------------------------------------------------------
    imax    = phy_lsc % imax   
    jmax    = phy_lsc % jmax   
    kmax    = phy_lsc % kmax   
    Grav    = phy_lsc % Grav   
    Cp      = phy_lsc % Cp     
    EL      = phy_lsc % EL     
    RVap    = phy_lsc % RVap   
    EpsV    = phy_lsc % EpsV   
    ES0     = phy_lsc % ES0    
    DelTime = phy_lsc % DelTime

    CrtlRH       = phy_lsc % CrtlRH
    IterationMax = phy_lsc % IterationMax

    !-----------------------------------------------------------------
    !  Ĵ "QVap", "Temp" ¸
    !  Store "QVap", "Temp" before adjustment
    !-----------------------------------------------------------------
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp

    !-----------------------------------------------------------------
    !  Ĵ
    !  Adjustment
    !-----------------------------------------------------------------
    do k = kmax-1, 0, -1
      do i = 0, imax-1
        do j = 0, jmax-1
          
          !-------------------------
          !  ˰漾׻
          !  Calculate saturation specific humidity 
          call CalcQVapSat( phy_lsc % phy_sat, & ! (in)
            &    Temp = xyz_Temp(i,j,k), &       ! (in)
            &   Press = xyz_Press(i,j,k), &      ! (in)
            & QVapSat = QVapSat )                ! (out)

!!$          QVapSat = &
!!$            & EpsV * ES0 &
!!$            &   * exp( EL / RVap &
!!$            &           * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp(i,j,k) ) ) &
!!$            &   / xyz_Press(i,j,k)
          
          !-------------------------
          !  ˰¤Ƥ, ٤漾Ѳ׻
          !  Calculate tendency of temperature and humidity 
          !  if moist is saturation. 

          if ( ( xyz_QVap(i,j,k) / QVapSat ) >= CrtlRH ) then
            
            do Iteration = 1, IterationMax
              
              !-------------------------
              !  ˰漾׻
              !  Calculate saturation specific humidity
              call CalcQVapSat( phy_lsc % phy_sat, & ! (in)
                &    Temp = xyz_Temp(i,j,k), &       ! (in)
                &   Press = xyz_Press(i,j,k), &      ! (in)
                & QVapSat = QVapSat )                ! (out)

              call CalcDQVapSatDTemp( phy_lsc % phy_sat, & ! (in)
                &          Temp = xyz_Temp(i,j,k), &       ! (in)
                &         Press = xyz_Press(i,j,k), &      ! (in)
                & DQVapSatDTemp = DQVapSatDTemp )          ! (out)

!!$              QVapSat = &
!!$                & EpsV * ES0  &
!!$                &   * exp( EL / RVap &
!!$                &           * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp(i,j,k) ) ) &
!!$                &   / xyz_Press(i,j,k)
!!$
!!$              DQVapSatDTemp = &
!!$                & EL * QVapSat / ( RVap * xyz_Temp(i,j,k) * xyz_Temp(i,j,k) )
              !-------------------------
              !  ٤漾Ѳʬ˥塼ȥˡǵ
              !  Calculate variation of temperature and specific humidity 
              !  with Newton method
              DelTemp = &
                & EL / Cp * ( xyz_QVap(i,j,k) - QVapSat ) &
                &    / ( 1.0_DP + EL / Cp * DQVapSatDTemp )
              DelQVap = DQVapSatDTemp * DelTemp 
              
              !-------------------------
              !  ٤漾Ĵ
              !  Adjust temperature and specific humidity
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
              xyz_QVap(i,j,k) = QVapSat + DelQVap
              
            end do
            
          end if
        end do
      end do
    end do
    
    !-----------------------------------------------------------------
    !  漾ѲΨ, ѲΨ, ߿̤λ
    !  Calculate specific humidity tendency, temperature tendency, 
    !  precipitation
    !-----------------------------------------------------------------
    xy_Rain     = 0.0_DP
    xyz_DTempDt = 0.0_DP
    xyz_DQvapDt = 0.0_DP

    xyz_DQVapDt = xyz_DQVapDt & 
      & + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    xyz_DTempDt = xyz_DTempDt &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    do k = kmax-1, 0, -1
      xy_Rain = xy_Rain &
        & + ( xyz_Temp(:,:,k) - xyz_TempB(:,:,k) ) &
        &     * Cp / ( 2.0_DP * DelTime ) &
        &     * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyLSCondLScaleCond

  subroutine PhyLSCondClose( phy_lsc, err )
    !
    ! PHYLSC ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_lsc*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYLSC".
    ! Note that if *phy_lsc* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: PhySatNhaClose
    implicit none
    type(PHYLSC), intent(inout):: phy_lsc
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyLSCondClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_lsc % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYLSC'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYLSC" ξõ
    !  Clear the settings for "PHYLSC"
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  ˰漾׻ѥ֥Ȥνλ
    !  Terminate object for calculation of saturation specific humidity
    !-----------------------------------------------------------------
    call PhySatNhaClose( &
      & phy_sat_nha = phy_lsc % phy_sat, & ! (inout)
      & err = err )                        ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_lsc % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyLSCondClose

  subroutine PhyLSCondPutLine( phy_lsc, unit, indent, err )
    !
    !  *phy_lsc* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_lsc*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: PhySatNhaPutLine
    implicit none
    type(PHYLSC), intent(in):: phy_lsc
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyLSCondPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYLSC" ΰ
    !  Print the settings for "PHYLSC"
    !-----------------------------------------------------------------
    if ( phy_lsc % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYLSC:: @initialized=%y', &
        & l = (/phy_lsc % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_lsc % imax, phy_lsc % jmax, phy_lsc % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f', &
        & d = (/ phy_lsc % Grav, phy_lsc % Cp/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @EL=%f @RVap=%f @EpsV=%f @ES0=%f', &
        & d = (/ phy_lsc % EL, phy_lsc % RVap, &
        &        phy_lsc % EpsV, phy_lsc % ES0/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & d = (/phy_lsc % DelTime/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @CrtlRH=%f @IterationMax=%d', &
        & d = (/ phy_lsc % CrtlRH/), &
        & i = (/ phy_lsc % IterationMax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // ' @phy_sat=' )
      call PhySatNhaPutLine( &
        & phy_sat_nha = phy_lsc % phy_sat, &           ! (in)
        & unit = out_unit, &                           ! (in)
        & indent = indent_str(1:indent_len) // '  ', & ! (in)
        & err = err )                                  ! (out)

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYLSC:: @initialized=%y>', &
        & l = (/phy_lsc % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyLSCondPutLine

  logical function PhyLSCondInitialized( phy_lsc ) result(result)
    !
    ! *phy_lsc* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_lsc* is initialized, .true. is returned.
    ! If *phy_lsc* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYLSC), intent(in):: phy_lsc
  continue
    result = phy_lsc % initialized
  end function PhyLSCondInitialized

  subroutine PhyLSCondNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_lscond_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_lscond ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_lscond#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_lscond" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_lscond#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyLSCondNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_lscond_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_lscond_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_lscond_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_lscond_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyLSCondNmlRead

!!$  subroutine PhyLSCondSample( phy_lsc, err )
!!$    !--
!!$    ! PhyLSCondSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_lsc*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyLSCondSample
!!$    !++
!!$    ! If *phy_lsc* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYLSC), intent(inout):: phy_lsc
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyLSCondSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_lsc % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYLSC'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_lsc* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_lsc*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_lsc % param_i
!!$!!$    param_r = phy_lsc % param_r
!!$!!$    param_c = phy_lsc % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyLSCondSample

end module phy_lscond
