*-----------------------------------------------------------------------
*     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE SWCQNP(NCP)

      CHARACTER CP*(*), CVAL*(*)
      PARAMETER (NPARA = 14)
      LOGICAL   LCHREQ, LFIRST
      CHARACTER CPARAS(NPARA)*8
      CHARACTER CPARAL(NPARA)*40
      CHARACTER CX(NPARA)*80, CMSG*80

      EXTERNAL  LCHREQ, LENC

      SAVE

      DATA      CPARAS( 1)/'WSNAME01'/, CX( 1)/'X       '/
      DATA      CPARAS( 2)/'WSNAME02'/, CX( 2)/'PS      '/
      DATA      CPARAS( 3)/'WSNAME03'/, CX( 3)/'Tek     '/
      DATA      CPARAS( 4)/'WSNAME04'/, CX( 4)/'Gtk     '/
      DATA      CPARAS( 5)/'FNAME   '/, CX( 5)/'dcl     '/
      DATA      CPARAS( 6)/'TITLE   '/, CX( 6)/'*       '/
      DATA      CPARAS( 7)/'CLRMAP  '/, CX( 7)/'colormap'/
      DATA      CPARAS( 8)/'BITMAP  '/, CX( 8)/'bitmap  '/
      DATA      CPARAS( 9)/'CL2TN   '/, CX( 9)/'cl2tnmap'/
      DATA      CPARAS(10)/'FONT1   '/, CX(10)/'font1u  '/
      DATA      CPARAS(11)/'FONT2   '/, CX(11)/'font2u  '/
      DATA      CPARAS(12)/'LPR     '/, CX(12)/'lpr     '/
      DATA      CPARAS(13)/'CIMGFMT '/, CX(13)/'png     '/
      DATA      CPARAS(14)/'CMAPLIST'/, CX(14)/'cmaplist'/

      DATA      CPARAL( 1)/'DEVICE_NAME01'/
      DATA      CPARAL( 2)/'DEVICE_NAME02'/
      DATA      CPARAL( 3)/'DEVICE_NAME03'/
      DATA      CPARAL( 4)/'DEVICE_NAME04'/
      DATA      CPARAL( 5)/'FRAME_NAME'/
      DATA      CPARAL( 6)/'TITLE'/
      DATA      CPARAL( 7)/'COLORMAP'/
      DATA      CPARAL( 8)/'BITMAP'/
      DATA      CPARAL( 9)/'COLOR_TO_TONE_MAP'/
      DATA      CPARAL(10)/'FONT1'/
      DATA      CPARAL(11)/'FONT2'/
      DATA      CPARAL(12)/'LPR'/
      DATA      CPARAL(13)/'IMAGE_FORMAT'/
      DATA      CPARAL(14)/'COLORMAP_LIST'/

      DATA      LFIRST / .TRUE. /


      NCP = NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCQID(CP, IDX)

      DO 10 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IDX = N
          RETURN
        END IF
   10 CONTINUE
      CMSG = 'PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E', 'SWCQID', CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCQCP(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAS(IDX)
      ELSE
        CALL MSGDMP('E', 'SWCQCP', 'IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCQCL(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAL(IDX)
      ELSE
        CALL MSGDMP('E', 'SWCQCL', 'IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCQVL(IDX, CVAL)

      IF (LFIRST) THEN
        CALL RTCGET('SW', CPARAS, CX, NPARA)
        CALL RLCGET(CPARAL, CX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CVAL = CX(IDX)
      ELSE
        CALL MSGDMP('E', 'SWCQVL', 'IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCSVL(IDX, CVAL)

      IF (LFIRST) THEN
        CALL RTCGET('SW', CPARAS, CX, NPARA)
        CALL RLCGET(CPARAL, CX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CX(IDX) = CVAL
      ELSE
        CALL MSGDMP('E', 'SWCSVL', 'IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SWCQIN(CP, IN)

      DO 20 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IN = N
          RETURN
        END IF
   20 CONTINUE

      IN = 0

      RETURN
      END
