module cloud_cold
! CReSS αʪ
! ܴؿǤ, ͤ礭ʪ̤Τ٤׻ФƤ,
! ɤտŪ exp(log()) Ȥ׻Ԥä
! 򤹤.
! Ȥ, Ǥդʪ a**b ξ, exp(b*log(a)) .
! ʤʤ, a**b=exp(log(a**b))=exp(b*log(a)) Ǥ.
! ޤ, ʪ a*b ξ, exp(log(a)+log(b)) ȤƤ.
! Τʪ̤껻äƤ,
! exp(-a) Ȥ뤳Ȥǳ껻򤹤.
  use Thermo_Const
  use Cloud_Basic

contains

!-----------------------------------------
!  cold bulk parameterization
!-----------------------------------------

real function NUAvi( temp, pres, qv, qi, rhob )
  ! ڳ˷Ǥɹ׻. (4.71)
  ! , Τޤޤ꼰ǤϤʤ, CReSS ꥸʥ.
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: rhob     ! ܾ̩ [kg/m3]
  real :: tmpqvs, tmpqvi, SSi, tmp
  real, parameter :: a=15.25, b=5.17
  integer :: i

  call ptcheck( temp )

  NUAvi=0.0

  if(qv>qthres)then
     tmpqvs=qvss( temp, pres )
     tmpqvi=qvsi( temp, pres )
     SSi=qv/tmpqvi-1.0

     if(qv>qthres.and.temp>tscp.and.temp<ti0)then

        tmp=b+a*SSi

        if(tmp<40.0)then
           NUAvi=mi0*exp(tmp)/rhob-qi
           if(NUAvi>qv-tmpqvi)then
              NUAvi=qv-tmpqvi
           end if
           if(NUAvi<0.0)then
              NUAvi=0.0
           end if
        else
           NUAvi=qv-tmpqvi
        end if

     end if
  end if

  return

end function NUAvi


real function NUANvi( temp, pres, qv, qi, rhob )
  ! δؿ CReSS ˼Ƥʤ. ޤ, ǻȤ Ni Ť Ni_calc
  ! ؿѤƤ.
  ! ڳ˷Ǥɹ׻. (4.74)
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: rhob     ! ܾ̩ [kg/m3]

  call ptcheck( temp )

  NUANvi=NUAvi( temp, pres, qv, qi, rhob )/mi0

  return

end function NUANvi


real function NUFci( temp, qc, rhob )
  ! ˷Ǥɹ׻. (4.76)
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: qc    ! 庮 [kg/kg]
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
  real :: tmpa, tmpb, temps

  call ptcheck( temp )

  if((qc>=qthres).and.(temp>tscp).and.(temp<ti0))then
     temps=t0-temp
     tmpa=exp(Bigga*temps)-1.0
     tmpb=rhob*qc*qc/Nc/rhow

     NUFci=Biggb*tmpa*tmpb

  else

     NUFci=0.0

  end if

  return

end function NUFci


real function NUFNci( temp, qc )
  ! ˷Ǥɹ׻. (4.77)
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: qc    ! 庮 [kg/kg]
  real :: tmpa, tmpb, temps

  call ptcheck( temp )

  if((qc>=qthres).and.(temp>tscp).and.(temp<ti0))then
     temps=t0-temp
     tmpa=exp(Bigga*temps)-1.0
     tmpb=qc/rhow

     NUFNci=Biggb*tmpa*tmpb

  else

     NUFNci=0.0

  end if

  return

end function NUFNci


real function NUCNci( temp, pres, qc, rhob )
  ! ܿ˷Ǥɹ׻. (4.87)
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qc    ! 庮 [kg/kg]
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
  real :: dNcdtb, dNcdtv, dNcdtt, ft, tmpa, tmpb
  real :: Tcl, Kn, Nar, Dar, Dc, F1, F2

  call ptcheck( temp )

  if(qc>=qthres)then
     Kn=Knudsen( temp, pres )
     Dar=Daero( temp, pres )
     Nar=Naero( temp )
     Dc=Dbc( qc, rhob )
     Tcl=temp   ! , Tcl = temp Τ, ʲη׻ɬȤʤ̵̣ʴؿ.

     F1=2.0*pi*Dc*Nc*Nar
     F2=kappaaero*(temp-Tcl)/pres
     tmpa=0.4*(1.0+1.45*Kn+0.4*exp(-1.0/Kn))*(kappaa+2.5*Kn*kappaaero)
     tmpb=(1.0+3.0*Kn)*(2.0*kappaa+5.0*kappaaero*Kn+kappaaero)
     ft=tmpa/tmpb

     dNcdtb=F1*Dar
     dNcdtv=F1*F2*Rv*temp/Lv(temp)
     dNcdtt=F1*F2*ft

     NUCNci=(dNcdtb+dNcdtv+dNcdtt)/rhob

  else

     NUCNci=0.0

  end if

  return

end function NUCNci


real function NUCci( temp, pres, qc, rhob )
  ! ܿ˷Ǥɹ׻. (4.88)
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qc    ! 庮 [kg/kg]
  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]

  call ptcheck( temp )

  NUCci=rhob*qc*NUCNci( temp, pres, qc, rhob )/Nc

  return

end function NUCci


real function NUHci( temp, qcnew, dt )
  ! Ѽ˷Ǥɹ׻. (4.90)
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp     !  [K]
  real, intent(in) :: qcnew    ! 庮 [kg/kg]
  real, intent(in) :: dt       ! ֳִ [s]

  call ptcheck( temp )

  if(temp<t0-40.0)then
     NUHci=0.5*qcnew/dt
  else
     NUHci=0.0
  end if

  return

end function NUHci


real function NUHNci( rhob, dt )
  ! Ѽ˷Ǥɹ׻. (4.89)
  ! Ǥ, ꡼ץեå, ˰ĴͤѤ.
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: rhob     ! ܾ̩ [kg/m3]
  real, intent(in) :: dt       ! ֳִ [s]

  NUHNci=0.5*Nc/(dt*rhob)

  return

end function NUHNci


real function SPNxi( types, temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                  rhob, rho0, Ni, Ns, Ng, opt_PGF, opt_CLcg )
  ! ɹ˷Ǥɹ׻. (4.91)
  ! Ǥ, 㡦Ǥβ٤Ϥξβ temp ͿȤ.
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ɹμ 's' = , 'g' = 
  real, intent(in) :: temp     !  [K]
  real, intent(in) :: pres     !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob     ! ܾ̩ [kg/m3]
  real, intent(in) :: rho0     ! ɽ̤δܾ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  character(1), intent(in), optional :: opt_PGF  ! 줬ꤵ, check_PG ʤ.
  real, intent(in), optional :: opt_CLcg  ! 줬ꤵ, CLcx ʤ.
  real :: ft
  character(1) :: PG_flag

  call ptcheck( temp )

  if(temp>=270.16)then
     ft=0.0
  else if(temp<270.16.and.temp>268.16)then
     ft=0.5*(270.16-temp)
  else if(temp==268.16)then
     ft=1.0
  else if(temp<268.16.and.temp>=265.16)then
     ft=(temp-265.16)/3.0
  else if(temp<265.16)then
     ft=0.0
  end if

  select case (types(1:1))
  case ('s')
     if(present(opt_CLcg))then
        SPNxi=3.5e8*ft*opt_CLcg/rhob
     else
        SPNxi=3.5e8*ft*CLxy( 'cs', temp, pres, qc, qs, rhob, rho0 )/rhob
     end if
  case ('g')
     if(present(opt_PGF))then
        PG_flag=opt_PGF(1:1)
     else
        if(present(Ni).and.present(Ns).and.present(Ng))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng )
        else if(present(Ni).and.present(Ns))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ns=Ns )
        else if(present(Ni).and.present(Ng))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ng=Ng )
        else if(present(Ns).and.present(Ng))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns, Ng=Ng )
        else if(present(Ni))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
        else if(present(Ns))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
        else if(present(Ng))then
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
        else
           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
        end if
     end if

     select case (PG_flag(1:1))
     case('d')
        if(present(opt_CLcg))then
           SPNxi=3.5e8*ft*opt_CLcg/rhob
        else
           SPNxi=3.5e8*ft*CLxy( 'cg', temp, pres, qc, qg, rhob, rho0 )/rhob
        end if
     case('w')
        SPNxi=0.0
     case('f')
        SPNxi=0.0
     end select
  end select

  return

end function SPNxi


real function SPxi( types, temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                 Ni, Ns, Ng, opt_PGF, opt_CLcg )
  ! ɹ˷Ǥɹ׻. (4.92)
  ! Ǥ, 㡦Ǥβ٤Ϥξβ temp ͿȤ.
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ɹμ 's' = , 'g' = 
  real, intent(in) :: temp     !  [K]
  real, intent(in) :: pres     !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob     ! ܾ̩ [kg/m3]
  real, intent(in) :: rho0     ! ɽ̤δܾ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  character(1), intent(in), optional :: opt_PGF  ! 줬ꤵ, check_PG ʤ.
  real, intent(in), optional :: opt_CLcg  ! 줬ꤵ, CLcx ʤ.

  call ptcheck( temp )

  if(present(opt_PGF).and.present(opt_CLcg))then
     SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                  rhob, rho0, opt_PGF=opt_PGF, opt_CLcg=opt_CLcg )
  else
     if(present(Ni).and.present(Ns).and.present(Ng))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ni, Ns, Ng )
     else if(present(Ni).and.present(Ns))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ni=Ni, Ns=Ns )
     else if(present(Ni).and.present(Ng))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ni=Ni, Ng=Ng )
     else if(present(Ns).and.present(Ng))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ns=Ns, Ng=Ng )
     else if(present(Ni))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ni=Ni )
     else if(present(Ns))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ns=Ns )
     else if(present(Ng))then
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0, Ng=Ng )
     else
        SPxi=mi0*SPNxi( types(1:1), temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                     rhob, rho0 )
     end if
  end if

  return

end function SPxi


real function VDvx( types, temp, pres, qv, qc, qr, qx, rhob, rho0,  &
  &                 opt_CLcx, opt_MLxr, opt_VENTx, opt_Gw, opt_Gi )
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qc    ! 庮 [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qx    ! types(1:1) κ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0 ! ɽ̤δ̩ [kg/m3]
  real, intent(in), optional :: opt_CLcx   ! types(1:1)  CLcx [1/s]
  real, intent(in), optional :: opt_MLxr   ! types(1:1)  MLxr [1/s]
  real, intent(in), optional :: opt_VENTx  ! types(1:1)  VENTx [1/s]
  real, intent(in), optional :: opt_Gw     ! Gw [1/s]
  real, intent(in), optional :: opt_Gi     ! Gi [1/s]
  ! ѿ opt_ Ϳ, ٤Ϳ.
  real :: Sw, Si, GwTP, GiTP, tmpML, tmpqvs, tmpqvi, tmpVENTx, tmpCLcx

  call ptcheck( temp )

  if(temp>tscp.and.qx>qthres)then  ! CReSS ꥸʥ

     tmpqvs=qvss( temp, pres )
     tmpqvi=qvsi( temp, pres )

     if(types(1:1)=='r')then
        Sw=qv/tmpqvs
        if(present(opt_Gw))then
           GwTP=opt_Gw
        else
           GwTP=Gw( temp, pres, rhob )
        end if

        if(Sw<1.0)then
           if(present(opt_VENTx))then
              tmpVENTx=opt_VENTx
           else
              tmpVENTx=VENTx( types(1:1), temp, pres, qx, rhob, rho0 )
           end if

           VDvx=2.0*pi*(Sw-1.0)*GwTP*tmpVENTx/rhob

        !-- ʲ, CReSS ꥸʥ
!           if(VDvx<tmpqvs)then
!              VDvx=tmpqvs
!           end if

        else
           VDvx=0.0
        end if

     else

        if(present(opt_VENTx))then
           tmpVENTx=opt_VENTx
        else
           tmpVENTx=VENTx( types(1:1), temp, pres, qx, rhob, rho0 )
        end if

        if(temp<ti0)then
           Si=qv/tmpqvi

           if(present(opt_Gi))then
              GiTP=opt_Gi
           else
              GiTP=Gi( temp, pres, rhob )
           end if

           if(present(opt_CLcx))then
              tmpCLcx=opt_CLcx
           else
              tmpCLcx=CLxy( 'c'//types(1:1), temp, pres, qc, qx, rhob, rho0 )
           end if

           VDvx=2.0*pi*(Si-1.0)*GiTP*tmpVENTx/rhob  &
  &             -(Ls(temp)*Lf(temp)/(kappaa*Rv*temp*temp))  &
  &             *GiTP*tmpCLcx

        else

           Sw=qv/tmpqvs

           if(present(opt_Gw))then
              GwTP=opt_Gw
           else
              GwTP=Gw( temp, pres, rhob )
           end if

           if(present(opt_MLxr))then
              tmpML=opt_MLxr
           else
              tmpML=MLxr( types(1:1), temp, pres, qv, qc, qr, qx, rhob, rho0 )
           end if

           if(tmpML>=0.0)then
              VDvx=2.0*pi*(Sw-1.0)*GwTP*tmpVENTx/rhob
           else
              VDvx=2.0*pi*Dv( temp, pres )*(qv-tmpqvs)*tmpVENTx
           end if
        end if
     end if

  else

     VDvx=0.0

  end if

  return

end function VDvx


real function VDvi( temp, pres, qv, qi, rhob, Ni )
! ɹεĹ. Ni ͿʤȤ, (4.75) Ƿ׻.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qi    ! ɹ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real :: tmpni, tmpa, tmpb, a1, a2, mbi

  call ptcheck( temp )

  if(temp>tscp.and.qi>qthres)then
     if(present(Ni))then
        tmpni=Ni
     else
        tmpni=Ni_calc( qi )
     end if

     if(tmpni>0.0)then
        a1=Koenig1( temp )
        a2=Koenig2( temp )
        mbi=qi*rhob/tmpni

        tmpa=(qv-qvsi( temp, pres ))*a1*(mbi**a2)*tmpni
        tmpb=(qvss( temp, pres )-qvsi( temp, pres ))*rhob

        if(tmpb/=0.0)then
           VDvi=tmpa/tmpb
        else
           VDvi=0.0
        end if
     else
        VDvi=0.0
     end if

  else

     VDvi=0.0

  end if

  return

end function VDvi


real function CLxy( typexy, temp, pres, qx, qy, rhob, rho0, Nx, Ny,  &
  &                 opt_Ux, opt_Uy )
! ߿γҴ־ʻ׻. (4.106)
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  character(2), intent(in) :: typexy  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qx    ! typexy(1:1) κ [kg/kg]
  real, intent(in) :: qy    ! typexy(2:2) κ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! typexy(1:1) οǻ [1/m3]
  real, intent(in), optional :: Ny  ! typexy(2:2) οǻ [1/m3]
  real, intent(in), optional :: opt_Ux  ! typexy(1:1) ® [m/s]
  real, intent(in), optional :: opt_Uy  ! typexy(2:2) ® [m/s]
  ! opt_ ͿȤ, ٤Ƥ opt_ Ϳ뤳.
  real, parameter :: tmpalpha=0.04
  real :: tmpa, tmpb, tmpc, tmpni
  real :: rhox, tmpExy, lamdax, lamday, tmpnx, tmpny, Ubx, Uby
  real :: auy, buy
  character(2) :: tmp_typexy

  call ptcheck( temp )

  if((qx>=qthres).and.(qy>=qthres))then

     if(typexy(1:2)=='ir')then
        tmp_typexy='ri'
     else
        tmp_typexy=typexy(1:2)
     end if

     if(tmp_typexy(1:1)/='c'.and.tmp_typexy(1:1)/='i')then  ! ʳ
        if(tmp_typexy(1:2)/='ri')then
           tmpExy=Exy( tmp_typexy(1:2) )
        else
           tmpExy=Exy( 'ir' )
        end if

        if(present(Nx))then
           lamdax=lamx( tmp_typexy(1:1), qx, rhob, Nx )
           tmpnx=nx0( tmp_typexy(1:1), qx, rhob, Nx )
           if(present(opt_Ux))then
              Ubx=opt_Ux
           else
              Ubx=UhxN( tmp_typexy(1:1), qx, rhob, rho0, Nx )
           end if
        else
           lamdax=lamx( tmp_typexy(1:1), qx, rhob )
           tmpnx=nx0( tmp_typexy(1:1), qx, rhob )
           if(present(opt_Ux))then
              Ubx=opt_Ux
           else
              Ubx=UhxN( tmp_typexy(1:1), qx, rhob, rho0 )
           end if
        end if
     else if(tmp_typexy(1:1)=='c')then
        if(present(Ny))then
           tmpExy=Exy( tmp_typexy(1:2), temp, pres, qx, qy, rhob, rho0, Ny )
        else
           tmpExy=Exy( tmp_typexy(1:2), temp, pres, qx, qy, rhob, rho0 )
        end if
     else if(tmp_typexy(1:1)=='i')then
        tmpExy=Exy( tmp_typexy(1:2) )
     end if

     if(tmp_typexy(2:2)/='c'.and.tmp_typexy(2:2)/='i')then
        if(present(Ny))then
           lamday=lamx( tmp_typexy(2:2), qy, rhob, Ny )
           tmpny=nx0( tmp_typexy(2:2), qy, rhob, Ny )
           if(present(opt_Uy))then
              Uby=opt_Uy
           else
              Uby=UhxN( tmp_typexy(2:2), qy, rhob, rho0, Ny )
           end if
        else
           lamday=lamx( tmp_typexy(2:2), qy, rhob )
           tmpny=nx0( tmp_typexy(2:2), qy, rhob )
           if(present(opt_Uy))then
              Uby=opt_Uy
           else
              Uby=UhxN( tmp_typexy(2:2), qy, rhob, rho0 )
           end if
        end if
     end if

     select case(tmp_typexy(1:1))
     case ('c')
        auy=auc
        buy=buc
     case ('i')
        auy=aui
        buy=bui
     case ('r')
        auy=aur
        buy=bur
        rhox=rhow
     case ('s')
        rhox=rhos
     case ('g')
        rhox=rhog
     end select

     if((tmp_typexy(1:1)=='r'.or.tmp_typexy(1:1)=='s'.or.tmp_typexy(1:1)=='g').and.tmp_typexy(1:2)/='ri')then
        tmpa=pi*pi*rhox*tmpExy/rhob
        tmpb=sqrt((Ubx-Uby)*(Ubx-Uby)+tmpalpha*Ubx*Uby)*tmpnx*tmpny
        tmpc=5.0*exp(-(6.0*log(lamdax)+log(lamday)))  &
  &         +2.0*exp(-(5.0*log(lamdax)+2.0*log(lamday)))  &
  &         +0.5*exp(-(4.0*log(lamdax)+3.0*log(lamday)))
        CLxy=tmpa*tmpb*tmpc
     else if(tmp_typexy(1:1)=='c'.or.tmp_typexy(1:1)=='i')then
        if(temp>tscp)then
           tmpa=0.25*pi*tmpExy*tmpny*qx*auy*gamma_func(3.0+buy)
           tmpb=exp(-(3.0+buy)*log(lamday))
           tmpc=sqrt(rho0/rhob)
           CLxy=tmpa*tmpc*tmpb
write(*,*) "value chec", qx
write(*,*) "value chec", tmpExy, tmpny, qx, auy, gamma_func(3.0+buy)
write(*,*) "CLxy check", tmpa, tmpb, tmpc, CLxy
        else
           CLxy=0.0
        end if
     else if(tmp_typexy(1:2)=='ri')then
        if(temp>tscp)then
           if(present(Ny))then
              tmpni=Ny
           else
              tmpni=Ni_calc( qy )
           end if
           tmpa=pi*pi*tmpExy*tmpni*tmpnx*auy*gamma_func(6.0+buy)
           tmpb=exp(-(log(24.0)+(6.0+buy)*log(lamdax)))
           tmpc=sqrt(rho0/rhob)
           CLxy=tmpa*tmpc*tmpb
        else
           CLxy=0.0
        end if
     end if

  else

     CLxy=0.0

  end if

  return

end function CLxy


real function CLNxy( typexy, temp, pres, qx, qy, rhob, rho0, Nx, Ny,  &
  &                  opt_Ux, opt_Uy )
! ߿γҴ־ʻ׻. (4.107)
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  character(2), intent(in) :: typexy  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qx    ! typexy(1:1) κ [kg/kg]
  real, intent(in) :: qy    ! typexy(2:2) κ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! typexy(1:1) οǻ [1/m3]
  real, intent(in), optional :: Ny  ! typexy(2:2) οǻ [1/m3]
  real, intent(in), optional :: opt_Ux  ! typexy(1:1) ® [m/s]
  real, intent(in), optional :: opt_Uy  ! typexy(2:2) ® [m/s]
  ! opt_ ͿȤ, ٤Ƥ opt_ Ϳ뤳.
  real, parameter :: tmpalpha=0.04
  real :: tmpa, tmpb, tmpc, tmpni
  real :: rhox, tmpExy, lamdax, lamday, tmpnx, tmpny, Ubx, Uby
  real :: auy, buy

  call ptcheck( temp )

  if(qx>=qthres.and.qy>=qthres)then

     if(typexy(1:1)/='c'.and.typexy(1:1)/='i')then  ! ʳ
        if(typexy(1:2)/='ri')then
           tmpExy=Exy( typexy(1:2) )
        else
           tmpExy=Exy( 'ir' )
        end if

        if(present(Nx))then
           lamdax=lamx( typexy(1:1), qx, rhob, Nx )
           tmpnx=nx0( typexy(1:1), qx, rhob, Nx )
           if(present(opt_Ux))then
              Ubx=opt_Ux
           else
              Ubx=UhxN( typexy(1:1), qx, rhob, rho0, Nx )
           end if
        else
           lamdax=lamx( typexy(1:1), qx, rhob )
           tmpnx=nx0( typexy(1:1), qx, rhob )
           if(present(opt_Ux))then
              Ubx=opt_Ux
           else
              Ubx=UhxN( typexy(1:1), qx, rhob, rho0 )
           end if
        end if
     else if(typexy(1:1)=='c')then
        if(present(Ny))then
           tmpExy=Exy( typexy(1:2), temp, pres, qx, qy, rhob, rho0, Ny )
        else
           tmpExy=Exy( typexy(1:2), temp, pres, qx, qy, rhob, rho0 )
        end if
     else if(typexy(1:1)=='i')then
        tmpExy=Exy( typexy(1:2) )
     end if

     if(present(Ny))then
        lamday=lamx( typexy(2:2), qy, rhob, Ny )
        tmpny=nx0( typexy(2:2), qy, rhob, Ny )
        if(present(opt_Uy))then
           Uby=opt_Uy
        else
           Uby=UhxN( typexy(2:2), qy, rhob, rho0, Ny )
        end if
     else
        lamday=lamx( typexy(2:2), qy, rhob )
        tmpny=nx0( typexy(2:2), qy, rhob )
        if(present(opt_Uy))then
           Uby=opt_Uy
        else
           Uby=UhxN( typexy(2:2), qy, rhob, rho0 )
        end if
     end if

     select case(typexy(1:1))
     case ('c')
        auy=auc
        buy=buc
     case ('i')
        auy=aui
        buy=bui
     case ('r')
        auy=aur
        buy=bur
        rhox=rhow
     case ('s')
        rhox=rhos
     case ('g')
        rhox=rhog
     end select

     if(typexy(1:1)=='r'.or.typexy(1:1)=='s'.or.typexy(1:1)=='g'.and.typexy(1:2)/='ri')then
        tmpa=0.5*pi*tmpExy/rhob
        tmpb=sqrt((Ubx-Uby)*(Ubx-Uby)+tmpalpha*Ubx*Uby)*tmpnx*tmpny
        tmpc=1.0*exp(-(3.0*log(lamdax)+log(lamday)))  &
  &         +1.0*exp(-(2.0*log(lamdax)+2.0*log(lamday)))  &
  &         +1.0*exp(-(log(lamdax)+3.0*log(lamday)))
        CLNxy=tmpa*tmpb*tmpc
     else if(typexy(1:1)=='c'.or.typexy(1:1)=='i')then
!        tmpa=0.25*pi*tmpExy*tmpny*qx*auy*gamma_func(3.0+buy)
!        tmpb=lamday**(3.0+buy)
!        tmpc=sqrt(rho0/rhob)
!        CLNxy=tmpa*tmpc/tmpb
        CLNxy=0.0
     else if(typexy(1:2)=='ri')then
        if(present(Ny))then
           tmpni=Ny
        else
           tmpni=tmpny/lamday
        end if
        tmpa=0.25*pi*tmpExy*tmpni*tmpnx*auy*gamma_func(3.0+buy)
        tmpb=exp(-(log(rhob)+(3.0+buy)*log(lamdax)))
        tmpc=sqrt(rho0/rhob)
        CLNxy=tmpa*tmpc*tmpb
     end if

  else

     CLNxy=0.0

  end if

  return

end function CLNxy


real function PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                 Ni, Ns, Ng, opt_PGd, opt_PGw )
! ǤξĹ׻. (4.116) ¾.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  real, intent(in), optional :: opt_PGd  ! ĹΨ [1/s]
  real, intent(in), optional :: opt_PGw  ! ĹΨ [1/s]
  ! opt_ ѿꤵ, ٤Ƥ opt_ ꤵʤФʤʤ.
  real :: tmpPGd, tmpPGw, tmpa, tmpb, tmpc, tmpd, tmp1, tmp2, temps, VENTsg

  call ptcheck( temp )

  temps=ti0-temp

  if(temps>=0.0.and.qg>qthres)then
     if(present(opt_PGd).and.present(opt_PGw))then

        tmpPGd=opt_PGd
        tmpPGw=opt_PGw

     else

        if(present(Ni).and.present(Ns).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng )
        else if(present(Ni).and.present(Ns))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ns=Ns )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ns=Ns )
        else if(present(Ni).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ng=Ng )
        else if(present(Ns).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns, Ng=Ng )
        else if(present(Ni))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
        else if(present(Ns))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
        else if(present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
        else
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
        end if

     end if

     if(tmpPGd<=tmpPGw)then
        PGdw=tmpPGd
     else
        PGdw=tmpPGw
     end if

  else

     PGdw=0.0

  end if

  return

end function PGdw


real function AGNi( qi, rhob, rho0, Ni )
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: rhob  ! 絤δ̩ [kg/m^3]
  real, intent(in) :: rho0  ! ɽ̤δ̩ [kg/m^3]
  real, intent(in), optional :: Ni    ! ɹοǻ [1/m^3]
  ! Ni ͿʤϤξβ׻Τ, ʲɬ.
  real :: c1, tmpNi

  if(qi>qthres)then
     if(present(Ni))then
        tmpNi=Ni
     else
        tmpNi=Ni_calc( qi )
     end if

     c1=(qi*aui*Eii*spii/rhoi)*((rho0/rhob)**(1.0/3.0))
     AGNi=-0.5*c1*tmpNi  ! c1 褫 rhob  AGiN ˤ 1/rhob 껦.

  else

     AGNi=0.0

  end if

  return

end function AGNi


real function AGNs( qs, rhob, Ns )
! CReSS3.4.1  agsn  rhob Ϳ (ؿ) ۤʤ.
! ܴؿϥޥ˥奢˱äͿƤ.
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: rhob  ! 絤̩ [kg/m^3]
  real, intent(in), optional :: Ns    ! οǻ [1/m^3]
  real, parameter :: Ibus=1610.0
  real :: c1, c2, c3, tmpNs

  if(qs>=qthres)then
     if(present(Ns))then
        tmpNs=Ns
     else
        tmpNs=nx0( 's', qs, rhob )/lamx( 's', qs, rhob )
     end if

     c1=(aus*Ess*Ibus)/(2880.0*rhob)
     c2=exp(((2.0+bus)/3.0)*(log(rhob*qs)-log(pi*tmpNs*rhos)))
     c3=(pi**2)*exp(6.0*log(tmpNs))
     AGNs=-c1*c2*c3

  else

     AGNs=0.0

  end if

  return

end function AGNs


real function CNcr( scheme, temp, pres, qc, rhob )  ! 꼰ʸǧ
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  use Phys_Const
  implicit none
  character(1), intent(in) :: scheme    ! Ѵμ
  ! 'B' = Berry  (CReSS), 'K' = Kessler, 'L' = Lin 
  real, intent(in) :: temp !  [K]
  real, intent(in) :: pres !  [Pa]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: rhob  ! 絤̩ [kg/m^3]
  real :: tmp_qcm, tmp_sigma, coe, tmpa, tmpb

  call ptcheck( temp )

     select case (scheme(1:1))
     case ('B')
        tmp_qcm=rhow*pi*(Dcm**3)*Nc/(6.0*rhob)
        if(temp>tscp.and.qc>=tmp_qcm)then  ! CReSS ꥸʥ (temp>tscp)
           tmpa=0.104*g*Ecc/mu_air( temp, pres )
           tmpb=(rhob**4)*(qc**7)/Nc/rhow
           CNcr=tmpa*(tmpb**(1.0/3.0))
        else
           CNcr=0.0
        end if

     case ('K')  ! (4.132)  Udc ͤ狼ʤΤ, ʸǧ.
        write(*,*) "WARNING (CNcr) : This scheme is not valid."
     case ('L')
        tmp_qcm=2.0e-3
        tmp_sigma=0.15
        if(qc>tmp_qcm)then
           coe=Nc/(tmp_sigma*tmp_sigma*(qc-tmp_qcm))
           CNcr=(rhob*(qc-tmp_qcm)**2)*(1.2e-4+1.569e-12*(10.0**(coe)))
        else
           CNcr=0.0
        end if

     end select

  return

end function CNcr


real function CNis( temp, pres, qi, qv, rhob, rho0, Ni,  &
  &                 opt_VDvi )
! ɹؤѴ.
! Ni ۤͿʤ, temp, pres, qv Ǥ.
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: rhob  ! 絤δ̩ [kg/m^3]
  real, intent(in) :: rho0  ! ɽ̤δ̩ [kg/m^3]
  real, intent(in), optional :: Ni    ! ɹοǻ [1/m^3]
  real, intent(in), optional :: opt_VDvi  ! VDvi  [1/s]
  real :: a1, c1, Dmi, Dms, dt1, dt2, Si, tmp_vdvi, tmpmi

  if(qi>=qthres)then
     Si=qv/qvsi( temp, pres )
     a1=(Si-1.0)/Gi( temp, pres, rhob )
     c1=rhob*aui*Eii*spii*((rho0/rhob)**(1.0/3.0))/rhoi

     if(present(Ni))then
        Dmi=Dbi( qi, rhob, Ni )
        if(present(opt_VDvi))then
           tmp_vdvi=opt_VDvi
        else
           tmp_vdvi=VDvi( temp, pres, qv, qi, rhob, Ni )
        end if
        tmpmi=qi*rhob/Ni
     else
        Dmi=Dbi( qi, rhob )
        if(present(opt_VDvi))then
           tmp_vdvi=opt_VDvi
        else
           tmp_vdvi=VDvi( temp, pres, qv, qi, rhob )
        end if
        tmpmi=qi*rhob/Ni_calc( qi )
     end if

     ! , κǾ̤ľ¤׻.
     ! ̩ rhos,  ms0 ľ¤ (6*ms0/(pi*rhos))**(1/3)
     Dms=exp((1.0/3.0)*(log(6.0*ms0)-log(pi*rhos)))

!     dt1=2.0*(Dms**2-Dmi**2)*rhoi/a1
     dt2=6.0*log(Dms/Dmi)/c1
     CNis=qi/dt2

     if(tmp_vdvi>=0.0)then  ! ʲ, CReSS ꥸʥ
        if(tmpmi<0.5*ms0)then

           CNis=CNis+tmp_vdvi*(tmpmi/(ms0-tmpmi))

        else

           CNis=CNis+tmp_vdvi*(1.0-0.5*ms0/tmpmi)

        end if
     end if

  !-- ʲ, CReSS ꥸʥ
     if(CNis>qi)then
        CNis=qi
     end if

  else

     CNis=0.0

  end if

  return

end function CNis


real function CNsg( temp, pres, qc, qs, rhob, rho0, Ns )
! δؿ CReSS3.4.1 Ⱦۤʤ. (convers.f90 ǧ)
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp   !  [K]
  real, intent(in) :: pres   !  [Pa]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: rhob  ! 絤δ̩ [kg/m^3]
  real, intent(in) :: rho0  ! ɽ̤δ̩ [kg/m^3]
  real, intent(in), optional :: Ns    ! οǻ [1/m^3]
  real :: tmpa, tmpb, tmpc, Ecs, tmpNs, lamdas

  call ptcheck( temp )

  if(qs>=qthres)then
     if(present(Ns))then
        Ecs=Exy( 'cs', temp, pres, qc, qs, rhob, rho0, Ns )
        lamdas=lamx( 's', qs, rhob, Ns )
        tmpNs=Ns
     else
        Ecs=Exy( 'cs', temp, pres, qc, qs, rhob, rho0 )
        lamdas=lamx( 's', qs, rhob )
        tmpNs=nx0( 's', qs, rhob )/lamdas
     end if

     tmpa=rhog/(rhog-rhos)
     tmpb=3.0*pi*rho0*((rhob*qc*Ecs*aus)**2)*gamma_func(2.0*bus+2.0)*tmpNs
     tmpc=exp(-(log(8.0*rhob*(rhog-rhos))+(2.0*bus+1.0)*log(lamdas)))

     CNsg=tmpa*tmpb*tmpc

  else

     CNsg=0.0

  end if

  return

end function CNsg


real function CNNsg( temp, pres, qc, qs, rhob, rho0, Ns )
                     ! , qc Τ.
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp   !  [K]
  real, intent(in) :: pres   !  [Pa]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: rhob  ! 絤δ̩ [kg/m^3]
  real, intent(in) :: rho0  ! ɽ̤δ̩ [kg/m^3]
  real, intent(in), optional :: Ns    ! οǻ [1/m^3]
  real :: tmpa, tmpb, tmpc, Ecs, tmpNs

  call ptcheck( temp )

  if(qs>=qthres)then
     if(present(Ns))then
        Ecs=Exy( 'cs', temp, pres, qc, qs, rhob, rho0, Ns )
        tmpNs=Ns
     else
        Ecs=Exy( 'cs', temp, pres, qc, qs, rhob, rho0 )
        tmpNs=nx0( 's', qs, rhob )/lamx( 's', qs, rhob )
     end if

     tmpa=rho0/rhob
     tmpb=3.0*pi*aus*Ecs*rhob*qc*tmpNs
     tmpc=2.0*(rhog-rhos)

     CNNsg=tmpa*tmpb/tmpc

  else

     CNNsg=0.0

  end if

  return

end function CNNsg


real function MLic( temp, qi, dt )
! δؿϥ꡼ץեåξΤŬѲǽ.
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: qi    ! ɹ [kg/kg]
  real, intent(in) :: dt    ! ֳִ [s] (礭ʻ֥ƥå)

  call ptcheck( temp )

  if(temp>ti0.and.qi>qthres)then
     MLic=0.5*qi/dt
  else
     MLic=0.0
  end if

  return

end function MLic


real function MLxr( types, temp, pres, qv, qc, qr, qx, rhob, rho0, Nx,  &
  &                 opt_CLcx, opt_CLrx, opt_VENTx )
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  character(1), intent(in) :: types  ! 's' = , 'g' = 
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qx    ! types(1:1) κ [kg/kg]
  real, intent(in) :: rhob  ! ʿѾ̩ [kg/m^3]
  real, intent(in) :: rho0  ! ɽ̤Ǥδ̩ [kg/m3]
  real, intent(in), optional :: Nx    ! types(1:1) οǻ [1/m3]
  real, intent(in), optional :: opt_CLcx   ! CLcx  [1/s]
  real, intent(in), optional :: opt_CLrx   ! CLrx  [1/s]
  real, intent(in), optional :: opt_VENTx  ! VENTx  [1/s]
  ! opt_ ѿꤵϤ٤ƻꤷʤФʤʤ.
  real :: tc, tmpa, tmpb, VENTILAT, tmpCLcx, tmpCLrx
! ͻϰѲФƤۤȤѲʤȲꤹ. (qvss Ȥ)

  call ptcheck( temp )

  if(temp>ti0.and.qx>qthres)then
     tc=temp-t0
     if(present(opt_CLcx).and.present(opt_CLrx).and.present(opt_VENTX))then
        VENTILAT=opt_VENTx
        tmpCLcx=opt_CLcx
        tmpCLrx=opt_CLrx
     else
        if(present(Nx))then
           VENTILAT=VENTx( types(1:1), temp, pres, qx, rhob, rho0, Nx )
           tmpCLcx=CLxy( 'c'//types(1:1), temp, pres, qc, qx, rhob, rho0, Ny=Nx )
           tmpCLrx=CLxy( 'r'//types(1:1), temp, pres, qr, qx, rhob, rho0, Ny=Nx )
        else
           VENTILAT=VENTx( types(1:1), temp, pres, qx, rhob, rho0 )
           tmpCLcx=CLxy( 'c'//types(1:1), temp, pres, qc, qx, rhob, rho0 )
           tmpCLrx=CLxy( 'r'//types(1:1), temp, pres, qr, qx, rhob, rho0 )
        end if
     end if

     tmpa=2.0*pi*VENTILAT  &
  &       *(kappaa*tc+Lv( temp )*Dv( temp, pres )*rhob*(qv-qvss( t0, pres )))/rhob
     tmpb=Cw*tc*(tmpCLcx+tmpCLrx)
     MLxr=(tmpa+tmpb)/Lf( temp )
  else
     MLxr=0.0
  end if

  return

end function MLxr


real function FRrg( temp, qr, rhob )
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: rhob  ! ʿѾ̩ [kg/m^3]
  real :: ts, lamr

  call ptcheck( temp )

  if(qr>=qthres)then

     if(temp<tscp)then  ! CReSS ꥸʥ

        FRrg=qr

     else
        ts=ti0-temp
        lamr=lamx( 'r', qr, rhob )
        FRrg=20.0*pi*pi*nr0*rhow*Biggb*(exp(Bigga*ts)-1.0)  &
  &                                    *exp(-(log(rhob)+7.0*log(lamr)))

     !-- ʲ, CReSS ꥸʥ
        if(FRrg>qr)then
           FRrg=qr
        end if

     end if

  else

     FRrg=0.0

  end if

  return

end function FRrg


real function FRNrg( temp, rhob, qr )
  use Math_Const
  use Thermo_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: rhob  ! ʿѾ̩ [kg/m^3]
  real, intent(in) :: qr    ! κ [kg/kg]
  real :: ts, lamr

  call ptcheck( temp )

  if(qr>=qthres)then

     if(temp<tscp)then  ! CReSS ꥸʥ

        lamr=lamx( 'r', qr, rhob )
        FRNrg=nr0/lamr

     else
        ts=ti0-temp
        lamr=lamx( 'r', qr, rhob )
        FRNrg=pi*nr0*rhow*Biggb*(exp(Bigga*ts)-1.0)  &
  &                             *exp(-(log(6.0*rhob)+4.0*log(lamr)))

     !-- ʲ, CReSS ꥸʥ
        if(FRNrg>qr)then
           lamr=lamx( 'r', qr, rhob )
           FRNrg=nr0/lamr
        end if

     end if

  else

     FRNrg=0.0

  end if

  return

end function FRNrg


real function SHsr( temp, pres, qc, qr, qs, rhob, rho0, Ns,  &
  &                 opt_CLcs, opt_CLrs )
! ι߿夫οΥ׻. (4.149)
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ns    ! οǻ [1/m3]
  real, intent(in), optional :: opt_CLcs  ! CLcs  [1/s]
  real, intent(in), optional :: opt_CLrs  ! CLrs  [1/s]
  ! opt_ ѿꤵϤ٤ƻꤷʤФʤʤ.

  if(temp>ti0.and.qs>qthres)then
     if(present(opt_CLcs).and.present(opt_CLrs))then
           SHsr=opt_CLcs+opt_CLrs
     else
        if(present(Ns))then
           SHsr=CLxy( 'cs', temp, pres, qc, qs, rhob, rho0, Ny=Ns )  &
 &             +CLxy( 'rs', temp, pres, qr, qs, rhob, rho0, Ny=Ns )
        else
           SHsr=CLxy( 'cs', temp, pres, qc, qs, rhob, rho0 )  &
 &             +CLxy( 'rs', temp, pres, qr, qs, rhob, rho0 )
        end if
     end if
  else
     SHsr=0.0
  end if

end function SHsr


real function SHgr( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                 Ni, Ns, Ng, opt_CLcg, opt_CLrg, opt_CLig, opt_CLsg,  &
  &                 opt_PGF, opt_PGdw )
! ι߿夫οΥ׻. (4.150)-(4.151)
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    !  [1/m3]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ni    ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns    ! οǻ [1/m3]
  real, intent(in), optional :: Ng    ! Ǥοǻ [1/m3]
  real, intent(in), optional :: opt_CLcg  ! CLcg  [1/s]
  real, intent(in), optional :: opt_CLrg  ! CLrg  [1/s]
  real, intent(in), optional :: opt_CLig  ! CLig  [1/s]
  real, intent(in), optional :: opt_CLsg  ! CLsg  [1/s]
  character(1), intent(in), optional :: opt_PGF  ! check_PG 
  real, intent(in), optional :: opt_PGdw  ! PGdw  [1/s]
  ! opt_ ѿꤵϤ٤ƻꤷʤФʤʤ.
  real :: tmp_clcg, tmp_clrg, tmp_clig, tmp_clsg, tmp_pg
  character(1) :: PG_flag

  if(qg>qthres)then
     if(temp>ti0)then
        if(present(opt_CLcg).and.present(opt_CLrg))then
           SHgr=opt_CLcg+opt_CLrg
        else
           if(present(Ng))then
              SHgr=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0, Ny=Ng )  &
 &                +CLxy( 'rg', temp, pres, qr, qg, rhob, rho0, Ny=Ng )
           else
              SHgr=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0 )  &
 &                +CLxy( 'rg', temp, pres, qr, qg, rhob, rho0 )
           end if
        end if
     else
        if(present(opt_CLcg).and.present(opt_CLrg).and.  &
  &        present(opt_CLig).and.present(opt_CLsg).and.present(opt_PGF))then

           if(opt_PGF(1:1)=='w')then
              SHgr=opt_CLcg+opt_CLrg+opt_CLig+opt_CLsg-opt_PGdw
           else
              SHgr=0.0
           end if

        else

           PG_flag=check_PG( temp, pres, qv, qc, qr, qi, qs, qg,  &
  &                          rhob, rho0, Ni, Ns, Ng )
           if(PG_flag(1:1)=='w')then
              if(present(Ng))then
                 SHgr=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0, Ny=Ng )  &
 &                   +CLxy( 'rg', temp, pres, qr, qg, rhob, rho0, Ny=Ng )
              else
                 SHgr=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0 )  &
 &                   +CLxy( 'rg', temp, pres, qr, qg, rhob, rho0 )
              end if
              if(present(Ni).and.present(Ns).and.present(Ng))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni, Ny=Ng )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns, Ny=Ng )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                         Ni=Ni, Ns=Ns, Ng=Ng )
              else if(present(Ni).and.present(Ns))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                         Ni=Ni, Ns=Ns )
              else if(present(Ni).and.present(Ng))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni, Ny=Ng )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Ny=Ng )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                         Ni=Ni, Ng=Ng )
              else if(present(Ns).and.present(Ng))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Ny=Ng )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns, Ny=Ng )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                         Ns=Ns, Ng=Ng )
              else if(present(Ni))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0 )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
              else if(present(Ns))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0 )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
              else if(present(Ng))then
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Ny=Ng )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Ny=Ng )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
              else
                 SHgr=SHgr  &
  &                  +CLxy( 'ig', temp, pres, qi, qg, rhob, rho0 )  &
  &                  +CLxy( 'sg', temp, pres, qs, qg, rhob, rho0 )  &
  &                  -PGdw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
              end if
           else
              SHgr=0.0
           end if
        end if
     end if
  else
     SHgr=0.0
  end if

end function SHgr

!--------------------------------------------------
! ʲ, ٤ιˤľܽФʤ, cloud_basic Ȥ
! ۤʤΩ֤̯ʴؿ.
!--------------------------------------------------

real function PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                Ni, Ns, Ng, opt_CLcg, opt_CLrg, opt_CLig, opt_CLsg )
! ǤξĹ()׻. (4.116) ¾.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  real, intent(in), optional :: opt_CLcg  ! CLcg  [1/s]
  real, intent(in), optional :: opt_CLrg  ! CLrg  [1/s]
  real, intent(in), optional :: opt_CLig  ! CLig  [1/s]
  real, intent(in), optional :: opt_CLsg  ! CLsg  [1/s]
  ! opt_ ѿꤵϤ٤ƻꤷʤФʤʤ.
  real :: tmpPGd, tmpPGw, tmpa, tmpb, tmpc, tmpd, temps, VENTsg
  real :: tmp1, tmp2, tmp3, tmp4

  call ptcheck( temp )

  temps=ti0-temp

  if(temps>=0.0.and.qg>qthres)then
     if(present(opt_CLcg).and.present(opt_CLrg).and.  &
  &     present(opt_CLig).and.present(opt_CLsg))then

        tmp1=opt_CLcg
        tmp2=opt_CLrg
        tmp3=opt_CLig
        tmp4=opt_CLsg

     else
        if(present(Ng))then
           tmp1=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0, Ny=Ng )
        else
           tmp1=CLxy( 'cg', temp, pres, qc, qg, rhob, rho0 )
        end if

        if(present(Ng))then
           tmp2=CLxy( 'rg', temp, pres, qr, qg, rhob, rho0, Ny=Ng )
        else
           tmp2=CLxy( 'rg', temp, pres, qr, qg, rhob, rho0 )
        end if

        if(present(Ni))then  ! tmp1 ϼĹǤѤ뤿, ƥݥ
           if(present(Ng))then
              tmp3=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni, Ny=Ng )
           else
              tmp3=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni )
           end if
        else
           if(present(Ng))then
              tmp3=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Ny=Ng )
           else
              tmp3=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0 )
           end if
        end if

        if(present(Ns))then  ! tmp2 ϼĹǤѤ뤿, ƥݥ
           if(present(Ng))then
              tmp4=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns, Ny=Ng )
           else
              tmp4=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns )
           end if
        else
           if(present(Ng))then
              tmp4=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Ny=Ng )
           else
              tmp4=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0 )
           end if
        end if
     end if

     PGd=tmp1+tmp2+tmp3+tmp4

  else

     PGd=0.0

  end if

  return

end function PGd


real function PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0,  &
  &                Ni, Ns, Ng, opt_CLig, opt_CLsg, opt_VENTg )
! ǤξĹ()׻. (4.116) ¾.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  real, intent(in), optional :: opt_CLig  ! CLig  [1/s]
  real, intent(in), optional :: opt_CLsg  ! CLig  [1/s]
  real, intent(in), optional :: opt_VENTg ! VENTg  [1/s]
  ! opt_ ѿꤵϤ٤ƻꤷʤФʤʤ.
  real :: tmpPGd, tmpPGw, tmpa, tmpb, tmpc, tmpd, tmp1, tmp2, temps, VENTsg
  real :: tmpE1, tmpE2

  call ptcheck( temp )

  temps=ti0-temp

  if(temps>=0.0)then
     if(present(opt_CLig).and.present(opt_CLsg).and.present(opt_VENTg))then
        tmp1=opt_CLig
        tmp2=opt_CLsg
        VENTsg=opt_VENTg
     else
        if(present(Ni))then  ! tmp1 ϼĹǤѤ뤿, ƥݥ
           if(present(Ng))then
              tmp1=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni, Ny=Ng )
           else
              tmp1=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Nx=Ni )
           end if
        else
           if(present(Ng))then
              tmp1=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0, Ny=Ng )
           else
              tmp1=CLxy( 'ig', temp, pres, qi, qg, rhob, rho0 )
           end if
        end if

        if(present(Ns))then  ! tmp2 ϼĹǤѤ뤿, ƥݥ
           if(present(Ng))then
              tmp2=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns, Ny=Ng )
           else
              tmp2=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Nx=Ns )
           end if
        else
           if(present(Ng))then
              tmp2=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0, Ny=Ng )
           else
              tmp2=CLxy( 'sg', temp, pres, qs, qg, rhob, rho0 )
           end if
        end if

        if(present(Ng))then
           VENTsg=VENTx( 'g', temp, pres, qg, rhob, rho0, Ng )
        else
           VENTsg=VENTx( 'g', temp, pres, qg, rhob, rho0 )
        end if

     end if

     tmpa=2.0*pi*(kappaa*temps+Lv( temp )*Dv( temp, pres )  &
  &               *rhob*(qvss( ti0, pres )-qv))*VENTsg  ! , qg Ǥ褤ǧ.
     tmpb=rhob*(Lf( temp )-Cw*temps)

!-- ʲ, ޥ˥奢˵ܤƤʤ (CL'ig, CL'sg ζŪʷ׻)
     tmpc=tmp1/Exy('ig')+tmp2/Exy('sg')

     tmpd=1.0+(Ci*temps)/(Lf( temp )-Cw*temps)
     tmpPGw=tmpa/tmpb+tmpc*tmpd
     PGw=tmpPGw

  else

     PGw=0.0

  end if

  return

end function PGw


character(1) function check_PG( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng,  &
  &                             opt_PGw, opt_PGd )
! ǤξĹĹĹȽ̤.
! 'd' = Ĺ, 'w' = Ĺ, 'f' = ĹΨ.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qv    ! κ [kg/kg]
  real, intent(in) :: qc    ! κ [kg/kg]
  real, intent(in) :: qr    ! κ [kg/kg]
  real, intent(in) :: qi    ! ɹκ [kg/kg]
  real, intent(in) :: qs    ! κ [kg/kg]
  real, intent(in) :: qg    ! Ǥκ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ϾǤδ̩ [kg/m3]
  real, intent(in), optional :: Ni  ! ɹοǻ [1/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real, intent(in), optional :: Ng  ! Ǥοǻ [1/m3]
  real, intent(in), optional :: opt_PGw  ! ĹΨ [1/s]
  real, intent(in), optional :: opt_PGd  ! ĹΨ [1/s]
  ! opt_PG ꤵ, ξȤꤷʤФʤʤ.
  real :: tmpPGd, tmpPGw, tmpa, tmpb, tmpc, tmpd, tmp1, tmp2, temps, VENTsg

  call ptcheck( temp )

  temps=ti0-temp

  if(temps>=0.0)then
     if(present(opt_PGw).and.present(opt_PGd))then
           tmpPGd=opt_PGd
           tmpPGw=opt_PGw
     else
        if(present(Ni).and.present(Ns).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni, Ns, Ng )
        else if(present(Ni).and.present(Ns))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ns=Ns )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ns=Ns )
        else if(present(Ni).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni, Ng=Ng )
        else if(present(Ns).and.present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns, Ng=Ng )
        else if(present(Ni))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ni=Ni )
        else if(present(Ns))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ns=Ns )
        else if(present(Ng))then
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0, Ng=Ng )
        else
           tmpPGd=PGd( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
           tmpPGw=PGw( temp, pres, qv, qc, qr, qi, qs, qg, rhob, rho0 )
        end if
     end if

     if(tmpPGd<=tmpPGw)then
        check_PG='d'
     else
        check_PG='w'
     end if

  else

     check_PG='f'

  end if

  return

end function check_PG


subroutine adjust_deposit_rate_CReSS( temp, pres, qv, tmpvdvi, tmpvdvs, tmpvdvg )
! CReSS ꥸʥ.
! Τ˹ԤäƤ뤫.
! ɹʪξΨĴᤷƤ.
! ĴѿĴѿ˾񤭤뤳Ȥ.
  implicit none
  real, intent(in) :: temp          !  [K]
  real, intent(in) :: pres          !  [Pa]
  real, intent(in) :: qv            !  [kg/kg]
  real, intent(inout) :: tmpvdvi    ! VDvi
  real, intent(inout) :: tmpvdvs    ! VDvs
  real, intent(inout) :: tmpvdvg    ! VDvg
  real :: tmp, Si

  tmp=tmpvdvi+tmpvdvs+tmpvdvg
  Si=qv-qvsi( temp, pres )

  if(tmp/=0.0)then
     if((Si<tmp.and.Si>0.0).or.(Si>tmp.and.Si<0.0))then
        tmpvdvi=tmpvdvi*Si/tmp
        tmpvdvs=tmpvdvs*Si/tmp
        tmpvdvg=tmpvdvg*Si/tmp
     end if
  end if

end subroutine adjust_deposit_rate_CReSS

end module
