!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module cloud_warm
! CReSS の雲物理過程
  use Thermo_Function
  use Thermo_Const
  use special_function
  use Derivation
  use Cloud_Const
  use Cloud_Basic

contains

real function Src_theta_warm( temp, pres, qv, qr )
! warm rain 過程での theta のソース項
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  ! 気温 [K]
  real, intent(in) :: pres  ! トータル気圧 [Pa]
  real, intent(in) :: qv  ! 水蒸気混合比 [kg/kg]
  real, intent(in) :: qr  ! 雨水混合比 [kg/kg]
  real :: vapor_qv, rhob

  vapor_qv=qvss( temp, pres )
  rhob=TP_2_rho( temp, pres )

  Src_theta_warm=Lv( temp )*EVrv( temp, qv, qr, pres )

  Src_theta_warm=rhob*Src_theta_warm/(cpd*exner_func_dry( pres ))

  return

end function Src_theta_warm



!--------------------------------------
! warm bulk physics
!--------------------------------------

real function CNcr( qc, a )
  implicit none
  real, intent(in) :: qc
  real, intent(in), optional :: a
  real, parameter :: k1=1.0e-3
  real :: tmp

  if(present(a))then
     tmp=a
  else
     tmp=1.0e-3
  end if

  if(qc>tmp)then

     CNcr=k1*(qc-tmp)

  else

     CNcr=0.0

  end if

  return

end function CNcr

real function CLcr( qc, qr )
  implicit none
  real, intent(in) :: qc
  real, intent(in) :: qr
  real, parameter :: k2=2.2

  CLcr=k2*qc*(qr**0.875)

  return

end function CLcr

real function EVrv( temp, qv, qr, p )
  implicit none
  real, intent(in) :: temp  ! 温度 [K]
  real, intent(in) :: qv    ! 水蒸気混合比 [kg/kg]
  real, intent(in) :: qr    ! 雨水混合比 [kg/kg]
  real, intent(in) :: p     ! 圧力 [Pa]
  real :: C, qvs, rhob

  rhob=TP_2_rho( temp, p )
  qvs=qvss( temp, p )
  C=1.6+124.9*(rhob*qr)**0.2046

  EVrv=((1.0-qv/qvs)*C*(rhob*qr)**0.525)/(rhob*(5.4e5+2.55e6/(p*qvs)))

  return

end function EVrv

real function term_v_warm( rhob, qr, rho0 )
  implicit none
  real, intent(in) :: rhob
  real, intent(in) :: qr
  real, intent(in) :: rho0

  term_v_warm=36.34*(rho0/rhob)*((rhob*qr)**0.1346)

  return

end function term_v_warm





end module
