program fft_solver
! Holton (2004) non-divergent barotropic vortex model
  use gtool_history
  use Derivation
  use Statistics
  use Math_Const
  use Phys_Const
  use Basis
  use ffts
  use fft_saveval_define
  use fft_saveval_alloc
  use fft_val_define
  use fft_rotate
  use fft_read_namelist
  use fft_val_alloc
  use fft_time_scheme
  use fftsub_mod
  use fft_force_solv

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, subm
  integer :: access, status

  type(GT_HISTORY) :: dmp_hst

!-- namelist の読み込み

  call fft_read_name()

!-- allocating array

  call fft_saveval_allocate()
  call fft_val_allocate()

!-- 初期値化 (計算領域の設定や境界条件の設定, 特にポアソン計算について)

  call fft_all_clear()

!-- 格子点の再定義

  call fft_val_coordinate()

write(*,*) "starting initialization."

!-- calculating rotate array 2,3,5,7

  call rotate_array_d()

!-- calculating rotate array jnt

  call prim_calc( jxnt, pxfact(1:4), pxfact(5) )
  call prim_calc( jynt, pyfact(1:4), pyfact(5) )
  call prim_calc( nx, p1xfact(1:4), p1xfact(5) )
  call prim_calc( ny, p1yfact(1:4), p1yfact(5) )

  write(*,*) "prim_calc check", jxnt, pxfact
  write(*,*) "prim_calc check", jynt, pyfact
  write(*,*) "prim_calc check", nx, p1xfact
  write(*,*) "prim_calc check", ny, p1yfact

  call fft_rotate_allocate()

  call fft_rotate_calc()

!-- reading initial data

  if(resopt==0)then
     call HistoryGet( trim(ininame), trim(adjustl(inixd)), xi )
     call HistoryGet( trim(ininame), trim(adjustl(iniyd)), yi )
!     call HistoryGet( trim(ininame), trim(adjustl(inif)), fi )
     call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )
     nrt=1
  else if(resopt==1)then
     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(restn)), nrt )
     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(rest)), restime )
  end if

  do i=1,nx
     xd(i)=real(x(i))
  end do
  do j=1,ny
     yd(j)=real(y(j))
  end do

!-- 初期データからモデルにおける物理・スペクトル空間への置き換え
  if(resopt==0)then
     write(*,*) "starting interpolation of initial data."
!     call auto_interpolation_1d( yi, y, fi, coril )
     call auto_interpolation_2d( xi, yi, x, y, zi, tmpr )

     do j=1,ny
        do i=1,nx
           zd(i,j)=real(tmpr(i,j))
           zor(i,j)=tmpr(i,j)
        end do
     end do

!  call grad_1d( y, coril, betaf )

!-- setting psi

     write(*,*) "setting initial data of psi."

     call ffttp_2d( nx, ny, zor(1:nx,1:ny), zko(1:nx,1:ny),  &
  &                 'r', 'o', prim_factx=p1xfact, prim_facty=p1yfact,  &
  &                 omegax_fix=omegax1br, omegaxn_fix=omegax1nr,  &
  &                 omegay_fix=omegay1br, omegayn_fix=omegay1nr )

     basezeta=zko(1,1)
     call zetak2psik( zko(1:nx,1:ny), psiko(1:nx,1:ny) )
     call psik2zetak( psiko(1:nx,1:ny), zko(1:nx,1:ny), basezeta )

     write(*,*) "normally pass the initialization."

  else if(resopt==1)then

     write(*,*) "Start as restart mode. nrt, restime = ", nrt, restime

     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                   tmpr(1:nx,1:ny) )
     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(respsii)),  &
  &                   tmpi(1:nx,1:ny) )
     do j=1,ny
        do i=1,nx
           psiko(i,j)=dble(tmpr(i,j))+img_cdp*tmpi(i,j)
        end do
     end do

     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(reszetar)),  &
  &                   tmpr(1:nx,1:ny) )
     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(reszetai)),  &
  &                   tmpi(1:nx,1:ny) )
     do j=1,ny
        do i=1,nx
           zko(i,j)=dble(tmpr(i,j))+img_cdp*tmpi(i,j)
        end do
     end do

     basezeta=zko(1,1)

  end if

!-- 出力ファイルの初期化
  if(resopt==0)then
     call HistoryCreate( file=trim(adjustl(foname)),  &
  &       title='BAROTRO result data', source='test',  &
  &       institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=0.0,  &
  &       interval=real(dmpstp)*real(dt), history=dmp_hst )
  else if(resopt==1)then
     do i=1,subn
        status=access( 'swap'//trim(adjustl(subhead(i)))//'.'//  &
  &                    trim(adjustl(foname)), ' ' )
        if(status/=0)then
           subm=i
           exit
        end if
     end do
     call HistoryCreate( file='swap'//trim(adjustl(subhead(subm)))//'.'//  &
  &                           trim(adjustl(foname)),  &
  &       title='BAROTRO result data', &
  &       source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=restime,  &
  &       interval=real(dmpstp)*real(dt), history=dmp_hst )
  
  end if

  call HistoryPut( 'x', xd, history=dmp_hst )
  call HistoryPut( 'y', yd, history=dmp_hst )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
  &                        longname='X wind', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
  &                        longname='Y wind', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  write(*,*) "time integration start."

  if(resopt==0)then
     !-- 出力等の処理 (初期値の出力)

     call psik2ukvk( psiko(1:nx,1:ny), uk(1:nx,1:ny), vk(1:nx,1:ny) )

     call ffttp_2d( nx, ny, psiko(1:nx,1:ny), psior(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=p1xfact,  &
  &                 prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                 omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                 omegayn_fix=omegay1ni )

     call ffttp_2d( nx, ny, uk(1:nx,1:ny), ur(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=p1xfact,  &
  &                 prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                 omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                 omegayn_fix=omegay1ni )

     call ffttp_2d( nx, ny, vk(1:nx,1:ny), vr(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=p1xfact,  &
  &                 prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                 omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                 omegayn_fix=omegay1ni )

     call ffttp_2d( nx, ny, zko(1:nx,1:ny), zor(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=p1xfact,  &
  &                 prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                 omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                 omegayn_fix=omegay1ni )

     do j=1,ny
        do i=1,nx
           psid(i,j)=real(psior(i,j))
           ud(i,j)=real(ur(i,j))
           vd(i,j)=real(vr(i,j))
           zd(i,j)=real(zor(i,j))
           write(*,*) "psid()", psid(i,j), zd(i,j)
        end do
     end do

     write(*,*) "*******************************************"
     write(*,*) "File damp (time =", 0.0d0, "[s])."
     write(*,*) "*******************************************"

     call HistoryPut( 'psi', psid, history=dmp_hst )
     call HistoryPut( 'zeta', zd, history=dmp_hst )
     call HistoryPut( 'u', ud, history=dmp_hst )
     call HistoryPut( 'v', vd, history=dmp_hst )
  end if

!-- solver スタート

  do it=nrt,nt

     select case (time_flag(1:3))
     case ('L-F')
        call fft_time_schematic( it, psiko, psikn, zopt1 )
     case ('AB2')
        call fft_time_schematic( it, psiko, psikn, zopt1 )
     case default
        call fft_time_schematic( it, psiko, psikn )
     end select

     psiko=psikn

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", dble(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        call psik2ukvk( psiko(1:nx,1:ny), uk(1:nx,1:ny), vk(1:nx,1:ny) )
        call psik2zetak( psiko(1:nx,1:ny), zko(1:nx,1:ny), zkopt=basezeta )

        call ffttp_2d( nx, ny, psiko(1:nx,1:ny), psior(1:nx,1:ny),  &
  &                    'i', 'o', prim_factx=p1xfact,  &
  &                    prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                    omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                    omegayn_fix=omegay1ni )

        call ffttp_2d( nx, ny, uk(1:nx,1:ny), ur(1:nx,1:ny),  &
  &                    'i', 'o', prim_factx=p1xfact,  &
  &                    prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                    omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                    omegayn_fix=omegay1ni )

        call ffttp_2d( nx, ny, vk(1:nx,1:ny), vr(1:nx,1:ny),  &
  &                    'i', 'o', prim_factx=p1xfact,  &
  &                    prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                    omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                    omegayn_fix=omegay1ni )

        call ffttp_2d( nx, ny, zko(1:nx,1:ny), zor(1:nx,1:ny),  &
  &                    'i', 'o', prim_factx=p1xfact,  &
  &                    prim_facty=p1yfact, omegax_fix=omegax1bi,  &
  &                    omegaxn_fix=omegax1ni, omegay_fix=omegay1bi,  &
  &                    omegayn_fix=omegay1ni )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", dble(it)*dt, "[s])."
        write(*,*) "*******************************************"

        do j=1,ny
           do i=1,nx
              psid(i,j)=real(psior(i,j))
              ud(i,j)=real(ur(i,j))
              vd(i,j)=real(vr(i,j))
              zd(i,j)=real(zor(i,j))
           end do
        end do

        call HistoryPut( 'psi', psid, history=dmp_hst )
        call HistoryPut( 'zeta', zd, history=dmp_hst )
        call HistoryPut( 'u', ud, history=dmp_hst )
        call HistoryPut( 'v', vd, history=dmp_hst )

     end if

     !-- リスタートファイル出力処理
     if(mod(it,restp)==0)then

        select case (time_flag(1:3))
        case ('L-F','AB2')
           call make_restart( it+1, real(it)*real(dt), psiko, zko, zopt1 )
        case default
           call make_restart( it+1, real(it)*real(dt), psiko, zko )
        end select

     end if

  end do

!-- solver ストップ

  call HistoryClose( history=dmp_hst )

  write(*,*) "solver is normally."

end program fft_solver
