module fft_saveval_define

!-- setting variables

!-- parameter

  integer, parameter :: subn=26
  character(1), dimension(subn), parameter ::  &
  &                                      subhead=(/'a','b','c','d','e','f',  &
  &                                                'g','h','i','j','k','l',  &
  &                                                'm','n','o','p','q','r',  &
  &                                                's','t','u','v','w','x',  &
  &                                                'y','z'/)
  character(8), parameter :: rest='+restime'
  character(6), parameter :: restn='+restn'
  character(5), parameter :: respsir='psikr'
  character(5), parameter :: respsii='psiki'
  character(3), parameter :: reszetar='zkr'
  character(3), parameter :: reszetai='zki'
  character(5), parameter :: reszoptr='zoptr'
  character(5), parameter :: reszopti='zopti'

!-- namelist variables

  integer, save :: nxi     ! grid number of x direction
  integer, save :: nyi     ! grid number of y direction
  integer, save :: hxnt    ! trancation wave number of x direction
  integer, save :: hynt    ! trancation wave number of y direction
  integer, save :: nx      ! grid number of x direction
  integer, save :: ny      ! grid number of y direction
  integer, save :: jxnt    ! grid number of x direction calculating integration
  integer, save :: jynt    ! grid number of y direction calculating integration
  integer, save :: nt      ! grid number of time
  integer, save :: dmpstp  ! output interval
  integer, save :: restp   ! restart output interval
  integer, save :: resopt  ! restart option
  integer, save :: force_type  ! Type of the stretching forcing
  integer, save :: force_wn  ! Azimuthal wavenumber for stretching forcing
  integer, save :: force_kr(2)  ! Radial range of stretching forcing in grid number

  double precision, save :: Lx      ! calculating domain of x direction
  double precision, save :: Ly      ! calculating domain of y direction
  double precision, save :: dt      ! grid interval of time
  double precision, save :: nu      ! diffusion coefficient
  double precision, save :: mu      ! damping coefficient
  double precision, save :: zetam   ! maximum vorticity of the outer eyewall
  double precision, save :: sth_thres_zeta 
                                    ! threshold of vorticity for stretching
  double precision, save :: cent_lat! centered latitude on the f-plane

  character(3), save :: time_flag    ! time integration type
  character(1000), save :: ininame   ! input file name
  character(1000), save :: foname    ! output file name
  character(1000), save :: sth_fname ! stretching coefficient file name
  character(1000), save :: resfname  ! restart file name
  character(100), save :: inix       ! X-coordinate name
  character(100), save :: iniy       ! y-coordinate name
  character(100), save :: iniz       ! initial zeta name
  character(100), save :: sth_vname  ! stretching coefficient variable name
  character(100), save :: inixd      ! X-coordinate name for double
  character(100), save :: iniyd      ! y-coordinate name for double

  logical, save :: flag_stretch      ! Flag for stretching forcing
  logical, save :: flag_fric         ! Flag for friction

!-- others variables

  integer, save :: kxnt    ! 2*hxnt+1
  integer, save :: kynt    ! 2*hynt+1
  integer, save :: nrt     ! restart time step
  double precision, save :: xmin    ! minimum x-coordinate
  double precision, save :: ymin    ! minimum x-coordinate
  double precision, save :: dx      ! grid interval of x direction
  double precision, save :: dy      ! grid interval of y direction
  double precision, save :: f0      ! Coriolis parameter
  double precision, save :: tcx     ! Vortex center of x direction
  double precision, save :: tcy     ! Vortex center of y direction
  real, save :: restime             ! restart starting time
  double precision, allocatable, dimension(:), save :: xi ! array of x direction
  double precision, allocatable, dimension(:), save :: yi ! array of y direction
  real, allocatable, dimension(:), save :: xd ! array of x direction
  real, allocatable, dimension(:), save :: yd ! array of y direction
  double precision, allocatable, dimension(:), save :: xj ! array of x direction
  double precision, allocatable, dimension(:), save :: yj ! array of y direction
  double precision, allocatable, dimension(:), save :: x  ! array of x direction
  double precision, allocatable, dimension(:), save :: y  ! array of y direction
!ORG  double precision, allocatable, dimension(:), save :: t  ! array of time
  double precision, allocatable, dimension(:,:), save :: cr  ! stretching coefficient
  double precision, allocatable, dimension(:,:), save :: cr_isp  ! stretching coefficient for ISPACK
  double precision, allocatable, dimension(:,:), save :: zinit_isp  ! initial vorticity for ISPACK

!-- rotate arrays for fft

  integer, dimension(5), save :: pxfact
  integer, dimension(5), save :: pyfact
  integer, dimension(5), save :: p1xfact
  integer, dimension(5), save :: p1yfact
  complex(kind(0d0)), save :: basezeta
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegaxjbr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegaxjnr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegaxjbi
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegaxjni
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegayjbr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegayjnr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegayjbi
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegayjni
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegax1br
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegax1nr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegax1bi
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegax1ni
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegay1br
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegay1nr
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegay1bi
  complex(kind(0d0)), allocatable, dimension(:,:), save :: omegay1ni

!-- rotate arrays for ISPACK

  integer, allocatable, dimension(:), save :: ITJR
  integer, allocatable, dimension(:), save :: ITIR
  integer, allocatable, dimension(:), save :: ITJJ
  integer, allocatable, dimension(:), save :: ITIJ
  double precision, allocatable, dimension(:), save :: TJR
  double precision, allocatable, dimension(:), save :: TIR
  double precision, allocatable, dimension(:), save :: TJJ
  double precision, allocatable, dimension(:), save :: TIJ

!-- monitoring variables
  complex(kind(0d0)), allocatable, dimension(:,:), save :: dmp_stretchk
  complex(kind(0d0)), allocatable, dimension(:,:), save :: dmp_advectk

end module fft_saveval_define
