!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Thermo_Const  ! 物理(熱力学)定数集
  ! 単位はすべて MKS 単位系
  ! 値は
  ! * 理科年表（国立天文台編）平成 20 年版
  ! * List, R. J. 1951: Smithonian Meteorological Tables, 6th rev.
  ! * Iribarnem J. V. and W. L. Godson, 1973: Atmospheric Thermodynamics.
  ! より.
  implicit none
  real, parameter :: Rd=287.0  ! 乾燥大気の気体定数 [J / K kg]
  real, parameter :: Rv=461.0  ! 水蒸気の気体定数 [J / K kg]
  real, parameter :: Md=28.96  ! 乾燥大気の分子量 [kg / kmol]
  real, parameter :: Mv=18.0  ! 水蒸気の分子量 [kg / kmol]
  real, parameter :: e0=611.0  ! 凝固点での水蒸気圧 [Pa]
  real, parameter :: ei0=611.73  ! 凝固点での氷飽和での蒸気圧 [Pa]
  real, parameter :: Cpd=1004.0  ! 乾燥大気の定圧比熱 [J / K kg]
  real, parameter :: Cpv=1870.0  ! 水蒸気の定圧比熱 [J / K kg]
  real, parameter :: Cvd=719.0  ! 乾燥大気の定積比熱 [J / K kg]
  real, parameter :: Cvv=1410.0  ! 水蒸気の定積比熱 [J / K kg]
  real, parameter :: p0=1.0e5  ! 基準気圧 [Pa]
  real, parameter :: p00=1.01325e5  ! 標準大気圧 [Pa]
  real, parameter :: LH0=2.5e6  ! 水蒸気の潜熱 [J / kg]
  real, parameter :: LHS=2.8e6  ! 水蒸気の昇華潜熱 [J / kg]
  real, parameter :: LF0=3.337e5  ! 0 degC での水の融解熱 [J / kg]
  real, parameter :: LFm40=2.357e5  ! -40 degC での水の融解熱 [J / kg]
  real, parameter :: kalm=0.4  ! カルマン定数
  real, parameter :: eps_rdrv=287.0/461.0  ! 水蒸気と乾燥大気の分子量比
  real, parameter :: rhow=1.0e3  ! 水の密度 [kg/m^3]
  real, parameter :: t0=273.15  ! 標準気圧での水の凝固点 [K]
  real, parameter :: ti0=273.16  ! 水の三重点での凝固点 [K]

  real, parameter :: Rd_dp=287.0d0  ! 乾燥大気の気体定数 [J / K kg]
  real, parameter :: Rv_dp=461.0d0  ! 水蒸気の気体定数 [J / K kg]
  real, parameter :: Md_dp=28.96d0  ! 乾燥大気の分子量 [kg / kmol]
  real, parameter :: Mv_dp=18.0d0  ! 水蒸気の分子量 [kg / kmol]
  real, parameter :: e0_dp=611.0d0  ! 凝固点での水蒸気圧 [Pa]
  real, parameter :: ei0_dp=611.73d0  ! 凝固点での氷飽和での蒸気圧 [Pa]
  real, parameter :: Cpd_dp=1004.0d0  ! 乾燥大気の定圧比熱 [J / K kg]
  real, parameter :: Cpv_dp=1870.0d0  ! 水蒸気の定圧比熱 [J / K kg]
  real, parameter :: Cvd_dp=719.0d0  ! 乾燥大気の定積比熱 [J / K kg]
  real, parameter :: Cvv_dp=1410.0d0  ! 水蒸気の定積比熱 [J / K kg]
  real, parameter :: p0_dp=1.0d5  ! 基準気圧 [Pa]
  real, parameter :: p00_dp=1.01325d5  ! 標準大気圧 [Pa]
  real, parameter :: LH0_dp=2.5d6  ! 水蒸気の潜熱 [J / kg]
  real, parameter :: LHS_dp=2.8d6  ! 水蒸気の昇華潜熱 [J / kg]
  real, parameter :: LF0_dp=3.337d5  ! 0 degC での水の融解熱 [J / kg]
  real, parameter :: LFm40_dp=2.357d5  ! -40 degC での水の融解熱 [J / kg]
  real, parameter :: kalm_dp=0.4d0  ! カルマン定数
  real, parameter :: eps_rdrv_dp=287.0d0/461.0d0  ! 水蒸気と乾燥大気の分子量比
  real, parameter :: rhow_dp=1.0d3  ! 水の密度 [kg/m^3]
  real, parameter :: t0_dp=273.15d0  ! 標準気圧での水の凝固点 [K]
  real, parameter :: ti0_dp=273.16d0  ! 水の三重点での凝固点 [K]

end module
