program wind
! 解析的な気圧場を与え, 空間微分ルーチンから地衡風や渦度を計算するルーチン.
! また, 流線も計算する.
  use Math_Const
  use trajectory
  use Derivation
  use gtool_history
  implicit none
  integer :: i, j
  integer, parameter :: nx=300, ny=300    ! 水平格子点数
  integer, parameter :: tstep=20000       ! 流線の計算ステップ
  real, dimension(nx,ny) :: u, v          ! 地衡風
  real, dimension(nx,ny) :: rot_2d, pres  ! 鉛直渦度と気圧
  real, dimension(tstep,1) :: tx, ty      ! 流線の x, y 座標
  real :: x(nx), y(ny)                    ! 空間座標
  real, parameter :: xmin=-pi, xmax=pi    ! x 軸の領域 
  real, parameter :: ymin=-pi, ymax=pi    ! y 軸の領域
  real, parameter :: dt=0.1               ! 流線の計算時間間隔
  real :: dx, dy                          ! 格子解像度
  character(3) :: sche
  logical :: FTF

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)

  write(*,*) "input scheme of time integration."
  write(*,*) "EU1 or RK4."
  read(*,*) sche

  do j=1,ny
     do i=1,nx
        pres(i,j)=cos(x(i))+cos(y(j))  ! 解析的な気圧場を与える.
     end do
  end do

  do j=1,ny
     call grad_1d( x, pres(:,j), v(:,j) )  ! dp/dx を計算
  end do
  do i=1,nx
     call grad_1d( y, pres(i,:), u(i,:) )  ! dp/dy を計算
  end do

  v=-v

  call curl( x, y, u, v, rot_2d )  ! u, v から地衡風渦度を計算

  call Stream_Line_2d( dt,  &                ! 時間間隔
  &                    tstep,  &             ! 時間ステップ
  &                    0.1, 0.1,  &          ! パーセルの初期位置 (x,y) 座標
  &                    x, y,  &              ! x, y 座標値
  &                    u, v,  &              ! x, y の各点で定義されている速度場
  &                    tx(:,1), ty(:,1),  &  ! 実際の流線の軌跡
  &                    FTF,  &               ! 流線が計算領域外に出たかの判別
  &                    sche )                ! 時間スキーム

!-- gtool writing (netcdf)

  call HistoryCreate( &                             ! ヒストリー作成
    & file='wind.nc', title='derivation test program', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )

  call HistoryPut('x',x)                            ! 次元変数出力
  call HistoryPut('y',y)                            ! 次元変数出力

  call HistoryAddVariable( &                        ! 変数定義
    & varname='pres', dims=(/'x','y'/), &
    & longname='pressure', units='1', xtype='float')

  call HistoryPut('pres',pres)                      ! 変数出力

  call HistoryAddVariable( &                        ! 変数定義
    & varname='rot', dims=(/'x','y'/), &
    & longname='rotation', units='1/s', xtype='float')

  call HistoryPut('rot',rot_2d)                      ! 変数出力

  call HistoryAddVariable( &                        ! 変数定義
    & varname='u', dims=(/'x','y'/), &
    & longname='X-wind', units='1', xtype='float')

  call HistoryPut('u',u)                      ! 変数出力

  call HistoryAddVariable( &                        ! 変数定義
    & varname='v', dims=(/'x','y'/), &
    & longname='Y-wind', units='1', xtype='float')

  call HistoryPut('v',v)                      ! 変数出力
  call HistoryClose

  open(unit=10,file='wind.dat',status='unknown')
     do i=1,tstep
        write(10,*) tx(i,1), ty(i,1)
     end do
  close(unit=10)

end program
