program phase1

!-- FFT 롼٥åȿμФå.
!-- 濴˥ԡĥʬۤˤĤ, FFT Ԥ
!-- 1. ѴΤȥꥸʥκ
!-- 2.  0 ʬΤɽ
!-- 3.  1 ʬ 0 ʬ¤ɽ

  use ffts
  use dcl
  use dcl_automatic

  implicit none

  integer, parameter :: nx=200, ny=300
  integer, parameter :: ifft=5

  integer :: i, j
  integer, dimension(ifft) :: pxfact, pyfact
  real :: x(nx), y(ny)
  real, dimension(nx,ny) :: val1, val2
  complex, dimension(nx,ny) :: cpval1, cpval2, sp1, sp2, spi1, spi2
  complex, allocatable, dimension(:,:) :: omegaxbr, omegaybr, omegaxbi, omegaybi
  complex, allocatable, dimension(:,:) :: omegaxnr, omegaynr, omegaxni, omegayni

  call rotate_array_f()
  call prim_calc( nx, pxfact(1:4), pxfact(5) )
  call prim_calc( ny, pyfact(1:4), pyfact(5) )

  allocate(omegaxnr(0:nx-1,0:nx-1))
  allocate(omegaynr(0:ny-1,0:ny-1))
  allocate(omegaxni(0:nx-1,0:nx-1))
  allocate(omegayni(0:ny-1,0:ny-1))
  allocate(omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1))
  allocate(omegaybr(0:pyfact(5)-1,0:pyfact(5)-1))
  allocate(omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1))
  allocate(omegaybi(0:pyfact(5)-1,0:pyfact(5)-1))

  call rotate_calc( nx, 'r', pxfact,  &
  &               omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &               omegaxnr(0:nx-1,0:nx-1) )
  call rotate_calc( nx, 'i', pxfact,  &
  &               omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &               omegaxni(0:nx-1,0:nx-1) )
  call rotate_calc( ny, 'r', pyfact,  &
  &               omegaybr(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &               omegaynr(0:ny-1,0:ny-1) )
  call rotate_calc( ny, 'i', pyfact,  &
  &               omegaybi(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &               omegayni(0:ny-1,0:ny-1) )

  do j=1,ny
     do i=1,nx
        val1(i,j)=exp(-(((real(i)-0.5*real(nx))/real(nx))**2  &
  &                    +((real(j)-0.5*real(ny))/real(ny))**2))
        cpval1(i,j)=val1(i,j)
     end do
  end do

  x=(/((real(i)/real(nx)),i=1,nx)/)
  y=(/((real(j)/real(ny)),j=1,ny)/)

  call ffttp_2d( nx, ny, cpval1(1:nx,1:ny), cpval2(1:nx,1:ny),  &
  &              'r', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &              omegax_fix=omegaxbr, omegaxn_fix=omegaxnr,  &
  &              omegay_fix=omegaybr, omegayn_fix=omegaynr )

  sp1=0.0
  sp2=0.0

!-- WN0
  sp1(1,1)=cpval2(1,1)

!-- WN0
  sp2(1,1)=cpval2(1,1)

!-- WNK1
  sp2(2,1)=cpval2(2,1)
  sp2(nx,1)=cpval2(nx,1)

!-- WNL1
  sp2(1,2)=cpval2(1,2)
  sp2(1,ny)=cpval2(1,ny)

  call ffttp_2d( nx, ny, cpval2(1:nx,1:ny), cpval1(1:nx,1:ny),  &
  &              'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &              omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &              omegay_fix=omegaybi, omegayn_fix=omegayni )

  call ffttp_2d( nx, ny, sp1(1:nx,1:ny), spi1(1:nx,1:ny),  &
  &              'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &              omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &              omegay_fix=omegaybi, omegayn_fix=omegayni )

  call ffttp_2d( nx, ny, sp2(1:nx,1:ny), spi2(1:nx,1:ny),  &
  &              'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &              omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &              omegay_fix=omegaybi, omegayn_fix=omegayni )

  do j=1,ny
     do i=1,nx
        val2(i,j)=real(cpval1(i,j))
     end do
  end do

!------------- DCL
  call SGISET('IFONT',2 )
  CALL GLRSET( 'RMISS', -999.0 )
  CALL GLLSET( 'LMISS', .TRUE. )
  call UZFACT(0.75)

  call color_setting( 80, (/0.0, 1.0/), min_tab=15999,  &
  &                   max_tab=95999, col_min=10, col_max=99 )

  call DclOpenGraphics(1)

  call Dcl_2D_cont_shade( 'Full',  &
  &                       x, y, val1, val2,  &
  &                       (/0.0, 1.0/), (/0.0, 1.0e-4/),  &
  &                       (/'X (km)', 'Y (km)'/),  &
  &                       (/'(f6.1)', '(f6.1)'/),  &
  &                       c_num=(/10, 80/), no_tone=.true. )

  do j=1,ny
     do i=1,nx
        val2(i,j)=real(spi1(i,j))
     end do
  end do

  call Dcl_2D_cont_shade( 'WN0',  &
  &                       x, y, val1, val2,  &
  &                       (/0.0, 1.0/), (/0.0, 1.0e-4/),  &
  &                       (/'X (km)', 'Y (km)'/),  &
  &                       (/'(f6.1)', '(f6.1)'/),  &
  &                       c_num=(/10, 80/), no_tone=.true. )

  do j=1,ny
     do i=1,nx
        val2(i,j)=real(spi2(i,j))
     end do
  end do

  call Dcl_2D_cont_shade( 'WN1',  &
  &                       x, y, val1, val2,  &
  &                       (/0.0, 1.0/), (/0.0, 1.0e-4/),  &
  &                       (/'X (km)', 'Y (km)'/),  &
  &                       (/'(f6.1)', '(f6.1)'/),  &
  &                       c_num=(/10, 80/), no_tone=.true. )

  call DclCloseGraphics

end program phase1
