! GTContSave - }ϐƂĕۑ
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTContSave(cont, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, get_attr, add_member, url
    use iso_varying_string
    type(GT_CONTOURS), intent(inout):: cont
    type(VARYING_STRING), intent(in), optional:: name
    type(VARYING_STRING), intent(out), optional:: name_result
    type(VARYING_STRING):: vname, title, member
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        vname = GTGraphSaveName()
    endif
    call get_attr(cont%var, "long_name", title)
    title = "contours of " // title
    call Create(var, char(vname), xtype="int", overwrite=.TRUE., &
        long_name=char(title))
    call Put_Attr(var, "gt_structure_class", "contours")
    if (cont%shade) then
        call Put_Attr(var, "gt_contours_shade", "true")
    else
        call Put_Attr(var, "gt_contours_shade", "false")
    endif
    if (cont%contours) then
        call Put_Attr(var, "gt_contours_contours", "true")
    else
        call Put_Attr(var, "gt_contours_contours", "false")
    endif

    ! }̃oɂȂĂ̂̏o
    call add_member(var, url(cont%var))
    if (associated(cont%v_axis)) then
        if (cont%v_axis%saved /= "") then
            call add_member(var, cont%v_axis%saved)
        else
            call Save(cont%v_axis, resultname=member)
            call add_member(var, member)
        endif
    endif
    if (associated(cont%h_axis)) then
        if (cont%h_axis%saved /= "") then
            call add_member(var, cont%h_axis%saved)
        else
            call Save(cont%h_axis, resultname=member)
            call add_member(var, member)
        endif
    endif
    
    call Close(var)
    print *, char(title), " stored at ", char(vname)
    if (present(name_result)) name_result = vname
end subroutine
