! GTAxisSave - WϐƂĕۑ
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTAxisSave(axis, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_Axis
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, add_member, url
    use iso_varying_string
    type(GT_AXIS), intent(inout):: axis
    type(VARYING_STRING), intent(in), optional:: name
    type(VARYING_STRING), intent(out), optional:: name_result
    type(VARYING_STRING):: vname, title
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        vname = GTGraphSaveName()
    endif
    if (axis%vertical) then
        title = "vertical axis of " // axis%title
    else
        title = "horizontal axis of " // axis%title
    endif
    call Create(var, char(vname), xtype="int", overwrite=.TRUE., &
        long_name=char(title))
    call Put_Attr(var, "gt_structure_class", "axis")
    ! }̃oɂȂĂ̂̏o

    call add_member(var, url(axis%var))
    
    call Close(var)
    print *, char(title), " stored at ", char(vname)
    axis%saved = vname
    if (present(name_result)) name_result = vname
end subroutine
