! gtaxisdefault.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

type(GT_AXIS) function GTAxisDefault(base_var, dimno, vertical) result(result)
    use gtgraph_types, only: GT_AXIS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open, ndims, get, name, get_attr
    use iso_varying_string
    type(GT_VARIABLE), intent(in):: base_var
    integer, intent(in):: dimno
    logical, intent(in), optional:: vertical
    real, pointer:: values(:)
continue
    call Open(result%var, base_var, dimno)
    ! c
    result%vertical = .FALSE.
    if (present(vertical)) result%vertical = vertical
    ! ̏㉺lAł͂Ƃ肠őŏƂA
    ! ؂̂悢lւ̕ϊ DclScalingPoint ɂ䂾˂B
    call get(result%var, values)
    result%upper = maxval(values)
    result%lower = minval(values)
    deallocate(values)
    ! 擾
    call get_attr(result%var, 'long_name', result%title)
    if (result%title == '') result%title = Name(result%var)
    ! PʂɊւĂ͂ GT_VARIABLE 
    ! C^[tFCXׂł
    call get_attr(result%var, 'units', result%units)
    if (result%units == '') then
        call get_attr(result%var, 'unit', result%units, &
            default="units not given")
    endif
    ! d`h~邽߂̃tO
    result%drawn = .FALSE.
    ! dZ[uh~邽߂̃tO
    result%saved = ""
end function

! Tu[` Axes  Axis ̕ł邱ƂɒӁB
! ݂̂ƂKW 2 ΂ŕ`悳Ȃ΂ȂȂB

subroutine GTAxesDraw(h_axis, v_axis, parent, set_space)
    use gtgraph_types, only: GT_AXIS, GT_FIGURE
    use gtdata_generic, only: Get
    use iso_varying_string
    use dc_string, only: GTStringQuoteForDcl
    use dc_error
    use dcl
    implicit none
    type(GT_AXIS), intent(inout):: h_axis, v_axis
    type(GT_FIGURE), intent(in):: parent
    logical, intent(in), optional:: set_space
    logical:: set_space_mode
    real, pointer:: value(:)
    type(VARYING_STRING):: xtitle, ytitle, xunits, yunits
continue
    ! ͂Ȃ낤
    if (.not. associated(parent%h_axis)) return
    if (.not. associated(parent%v_axis)) return
    ! IvV
    set_space_mode = .FALSE.
    if (present(set_space)) set_space_mode = set_space
    ! `ƂƂ͋ԐݒłB
    call DclSetWindow(h_axis%lower, h_axis%upper, &
        v_axis%lower, v_axis%upper)
    call DclSetTransFunction()
    if (.not. h_axis%drawn .and. .not. v_axis%drawn) then
        xtitle = GTStringQuoteForDcl(h_axis%title)
        ytitle = GTStringQuoteForDcl(v_axis%title)
        xunits = GTStringQuoteForDcl(h_axis%units)
        yunits = GTStringQuoteForDcl(v_axis%units)
        call DclSetTitle(char(xtitle), char(ytitle), &
            char(xunits), char(yunits))
        ! Oڐ
        call DclSetParm('AXIS:INNER', -1)
        call DclDrawScaledAxis()
    else if (h_axis%drawn) then
        ytitle = GTStringQuoteForDcl(v_axis%title)
        yunits = GTStringQuoteForDcl(v_axis%units)
        call DclSetTitle("", char(ytitle), "", char(yunits))
        call DclDrawScaledAxis(side="rl")
    else if (v_axis%drawn) then
        xtitle = GTStringQuoteForDcl(h_axis%title)
        xunits = GTStringQuoteForDcl(h_axis%units)
        call DclSetTitle(char(xtitle), "", char(xunits), "")
        call DclDrawScaledAxis(side="tb")
    endif
    if (set_space_mode) then
        call get(h_axis%var, value)
        call DclSetXGrid(value)
        deallocate(value)
        call get(v_axis%var, value)
        call DclSetYGrid(value)
        deallocate(value)
    endif
    h_axis%drawn = .TRUE.
    v_axis%drawn = .TRUE.
end subroutine

subroutine GTAxisClose(axis)
    use gtgraph_types, only: GT_AXIS
    use gtdata_generic, only: Close
    type(GT_AXIS), intent(inout):: axis
continue
    call Close(axis%var)
end subroutine
