! fake NetCDF library

character(len=80) function nf_strerror(ncerr) result(result)
    use netcdf_f77
    integer, intent(in)::	ncerr
    select case(ncerr)
    case(NF_NOERR)
        result = "no error"
    case default
        write(result, "('unknown error ', i4)"), ncerr
    end select
end function

integer function nf_create(filename, mode, ncid) result(result)
    use netcdf_f77
    integer, intent(out):: ncid
    integer, intent(in):: mode
    character(len = *), intent(in):: filename
continue
    ncid = 1
    print *, "fake NF_CREATE", mode, filename
    result = NF_NOERR
end function

integer function nf_open(path, cmode, ncid) result(result)
    use netcdf_f77
    character(len=*), intent(in)::	path
    integer, intent(in)::		cmode
    integer, intent(out)::		ncid
continue
    ncid = 1
    print *, "NF_OPEN", cmode, path
    result = NF_NOERR
end function

integer function nf_close(ncid) result(result)
    use netcdf_f77
    integer, intent(in):: ncid
continue
    print *, "fake/NF_CLOSE", ncid
    result = NF_NOERR
end function

! ϐ̐ nvars ₢킹
integer function nf_inq_nvars(ncid, nvars) result(result)
    use netcdf_f77
    integer, intent(in)::       ncid
    integer, intent(out)::      nvars
    nvars = MAX(0, ncid)
    print *, "fake/NF_INQ_NVARS(", ncid, ") = ", nvars
    result= NF_NOERR
end function

! ϐ name  ID varid m
integer function nf_inq_varid(ncid, name, varid) result(result)
    use netcdf_f77
    integer, intent(in)::		ncid
    character(len=*), intent(in)::	name
    integer, intent(out)::		varid
    varid = 1
    print *, "fake/NF_INQ_VARID(", ncid, name, ") = ", varid
    result = NF_NOERR
end function

! Oɑ΂鎟 ID ₢킹
integer function nf_inq_dimid(ncid, name, dimid) result(result)
    use netcdf_f77
    integer, intent(in)::		ncid
    character(len=*), intent(in)::	name
    integer, intent(out)::		dimid
    dimid = 1
    print *, "fake/NF_INQ_DIMID(", ncid, name, ") = ", dimid
    result = NF_NOERR
end function

!  ID 璷 len ₢킹
integer function nf_inq_dimlen(ncid, dimid, len) result(result)
    use netcdf_f77
    integer, intent(in)::		ncid
    integer, intent(in)::		dimid
    integer, intent(out)::		len
    len = 1
    print *, "fake/NF_INQ_DIMLEN(", ncid, dimid, ") = ", len
    result = NF_NOERR
end function

! ϐ varid 玟 ndims m
integer function nf_inq_varndims(ncid, varid, ndims) result(result)
    use netcdf_f77
    integer, intent(in)::		ncid, varid
    integer, intent(out)::		ndims
    ndims = 1
    print *, "fake NF_INQ_DIMLEN(", ncid, varid, ") = ", ndims
    result = NF_NOERR
end function

! ϐ varid 玟ID z dimids 𓾂
integer function nf_inq_vardimid(ncid, varid, dimids) result(result)
    use netcdf_f77
    integer, intent(in)::		ncid, varid
    integer, intent(out)::		dimids(*)
    dimids(1) = 1
    print *, "fake NF_INQ_VARDIMID(", ncid, varid, ") = ", dimids(1)
    result = NF_NOERR
end function