/* mpfcoa.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static real c_b3 = 1.f;

/* ----------------------------------------------------------------------- */
/*     MAP PROJECTION (LAMBERT CONICAL 1)               93/02/20 S.SAKAI */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int mpfcoa_0_(int n__, real *xlon, real *ylat, real *x, real 
	*y, real *ylat0)
{
    /* Builtin functions */
    double sin(doublereal), cos(doublereal), sqrt(doublereal), atan2(
	    doublereal, doublereal), asin(doublereal), r_sign(real *, real *);

    /* Local variables */
    extern doublereal rfpi_(void);
    static real r__, s, bk, ck, dk, rc, pi, th;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    extern doublereal xmplon_(real *);
    static real dlm, rna;

    switch(n__) {
	case 1: goto L_mpicoa;
	case 2: goto L_mpscoa;
	}

    th = pi / 2 - s * *ylat;
    r__ = ck * sin(th / 2);
    dlm = xmplon_(xlon) * dk;
    *x = r__ * sin(dlm);
    *y = -s * r__ * cos(dlm);
    return 0;
/* ----------------------------------------------------------------------- */

L_mpicoa:
    r__ = sqrt(*x * *x + *y * *y);
    if (r__ == 0.f) {
	*xlon = 0.f;
    } else {
	*xlon = atan2(*x, -s * *y) / dk;
    }
    if (dabs(*xlon) <= pi) {
	rc = r__ / ck;
	if (rc <= 1.f) {
	    *ylat = s * (pi / 2 - asin(rc) * 2);
	    return 0;
	}
    }
    *xlon = rna;
    *ylat = rna;
    return 0;
/* ----------------------------------------------------------------------- */

L_mpscoa:
    pi = rfpi_();
    glrget_("RUNDEF", &rna, (ftnlen)6);
    s = r_sign(&c_b3, ylat0);
    bk = cos((pi / 2 - dabs(*ylat0)) / 2);
    ck = 2 / bk;
    dk = bk * bk;
    return 0;
} /* mpfcoa_ */

/* Subroutine */ int mpfcoa_(real *xlon, real *ylat, real *x, real *y)
{
    return mpfcoa_0_(0, xlon, ylat, x, y, (real *)0);
    }

/* Subroutine */ int mpicoa_(real *x, real *y, real *xlon, real *ylat)
{
    return mpfcoa_0_(1, xlon, ylat, x, y, (real *)0);
    }

/* Subroutine */ int mpscoa_(real *ylat0)
{
    return mpfcoa_0_(2, (real *)0, (real *)0, (real *)0, (real *)0, ylat0);
    }

