/* cr3s.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/*     COORDINATE ROTATION (3D SPHERICAL) */
/*                                              93/02/19   S.SAKAI */
/*                                              93/10/29   S.SAKAI */
/*                                            2000/04/28   S.SAKAI */
/* ----------------------------------------------------------------------- */
/*     Copyright (C) 2000 GFD Dennou Club. All rights reserved. */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int cr3s_(real *theta, real *phi, real *psi, real *theta0, 
	real *phi0, real *theta1, real *phi1)
{
    /* Initialized data */

    static logical lfirst = TRUE_;

    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), acos(doublereal), sqrt(
	    doublereal), asin(doublereal), atan2(doublereal, doublereal);

    /* Local variables */
    extern doublereal rfpi_(void);
    static real a, b, c__, repsl, cp, pi, sp;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    static real ct0, st0, cte, ste;

    if (lfirst) {
	glrget_("REPSL", &repsl, (ftnlen)5);
	pi = rfpi_();
	lfirst = FALSE_;
    }
    cte = cos(*theta);
    ste = sin(*theta);
    ct0 = cos(*theta0);
    st0 = sin(*theta0);
    cp = cos(*phi0 - *phi);
    sp = sin(*phi0 - *phi);
    a = ct0 * cte + st0 * ste * cp;
    if (dabs(a) <= .8f) {
	*theta1 = acos(a);
    } else {
/* Computing 2nd power */
	r__1 = ste * sp;
/* Computing 2nd power */
	r__2 = ct0 * ste * cp - st0 * cte;
	c__ = sqrt(r__1 * r__1 + r__2 * r__2);
	*theta1 = asin(c__);
	if (a <= 0.f) {
	    *theta1 = pi - *theta1;
	}
    }
    a = sp * st0;
    b = -ct0 * ste + st0 * cte * cp;
    if (a == 0.f && b == 0.f) {
	*phi1 = *phi0 - *phi - *psi;
    } else {
	*phi1 = atan2(a, b) - *psi;
    }
    return 0;
} /* cr3s_ */

