!------------------------------------------------------------------------
! Copyright (c) 2002-2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  ee_module ƥȥץ
!
!  2002/08/20  ݹ
!      2007/11/09  ݹ  顼åɲ
!      2011/02/15  ʿ dc_test Ȥ褦ѹ
!
program ee_intavr

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use ee_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yx_Data(0:jm-1,0:im-1)    ! ʻҥǡ
  real(8)            :: x_Data(0:im-1)            ! ʻҥǡ
  real(8)            :: y_Data(0:jm-1)            ! ʻҥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11
  integer :: j

  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','ee_test_intavr', &
       'ee_module integral/average function tests')

 !---------------- ɸͤ ---------------------
  call ee_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yx_Data = sin(pi*yx_X) * cos(pi*yx_Y)
  write(6,*) 'f = sin(pi*X)*cos(pi*Y)'

    call check0d(IntYX_yx(yx_Data),  0.0d0, 'IntYX_yx')
    call check0d(AvrYX_yx(yx_Data),  0.0d0, 'AvrYX_yx')

    call check1d(y_IntX_yx(yx_Data), (/(0.0d0, j=0,jm-1)/), 'y_IntX_yx')
    call check1d(y_AvrX_yx(yx_Data), (/(0.0d0, j=0,jm-1)/), 'y_AvrX_yx')

    call check1d(x_IntY_yx(yx_Data), (/(0.0d0, j=0,jm-1)/), 'x_IntY_yx')
    call check1d(x_AvrY_yx(yx_Data), (/(0.0d0, j=0,jm-1)/), 'x_AvrY_yx')

  yx_Data = (1 - sin(pi*yx_X)) * cos(pi*yx_Y)**2
  write(6,*) 'f = (1-sin(pi*X)) * cos(pi*Y)**2'

    call check0d(IntYX_yx(yx_Data), 2.0d0, 'IntYX_yx')
    call check0d(AvrYX_yx(yx_Data), 5.0d-1, 'AvrYX_yx')

    call check1d(y_IntX_yx(yx_Data), 2.0d0*cos(pi*y_Y)**2, 'y_IntX_yx')
    call check1d(y_AvrX_yx(yx_Data), cos(pi*y_Y)**2, 'y_AvrX_yx')

    call check1d(x_IntY_yx(yx_Data), &
      (1.0d0-sin(pi*x_X)), 'x_IntY_yx')
    call check1d(x_AvrY_yx(yx_Data), &
      (5.0d-1)*(1.0d0-sin(pi*x_X)), 'x_AvrY_yx')

  x_Data = 1 - sin(2*pi*x_X)
  write(6,*) 'f = 1-sin(2*pi*X)'

    call check0d(IntX_x(x_Data), 2.0d0, 'IntX_x')
    call check0d(AvrX_x(x_Data), 1.0d0, 'AvrX_x')

  y_Data = cos(pi*y_Y)**2
  write(6,*) 'f = cos(pi*Y)**2'

    call check0d(IntY_y(y_Data), 1.0d0, 'IntY_y')
    call check0d(AvrY_y(y_Data), 5.0d-1, 'AvrY_y')

  call MessageNotify('M','ee_test_intavr', &
       'ee_module integral/average function tests succeeded!')

contains

  subroutine check1d(var1,sol1,funcname)
    real(8) :: var1(:)                  ! Ƚꤹ
    real(8) :: sol1(:)                  ! ϲ
    character(len=*) :: funcname        ! ؿ̾

    call AssertEqual(     &
      message = funcname, &
      answer = sol1,       &
      check = var1,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check1d

  subroutine check0d(var0,sol0,funcname)
    real(8) :: var0                       ! Ƚꤹ
    real(8) :: sol0                       ! ϲ
    character(len=*) :: funcname          ! ؿ̾

    call AssertEqual(      &
      message = funcname,  &
      answer = sol0,       &
      check = var0,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check0d

end program ee_intavr
