/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(THREADED_ANIMATION_RESOLUTION)

#include <WebCore/AcceleratedTimeline.h>
#include <WebCore/ProcessQualified.h>
#include <WebCore/TimelineIdentifier.h>
#include <WebCore/WebAnimationTime.h>
#include <wtf/Ref.h>
#include <wtf/TZoneMalloc.h>

namespace WebKit {

using TimelineID = WebCore::ProcessQualified<WebCore::TimelineIdentifier>;

class RemoteAnimationTimeline final : public RefCounted<RemoteAnimationTimeline> {
    WTF_MAKE_TZONE_ALLOCATED(RemoteAnimationTimeline);
public:
    static Ref<RemoteAnimationTimeline> create(TimelineID, const WebCore::AcceleratedTimeline&, MonotonicTime);

    void updateCurrentTime(MonotonicTime);
    const WebCore::WebAnimationTime& currentTime() const { return m_currentTime; }
    const TimelineID& identifier() const { return m_identifier; }

private:
    RemoteAnimationTimeline(TimelineID, Seconds, WebCore::WebAnimationTime);

    TimelineID m_identifier;
    Seconds m_originTime;
    WebCore::WebAnimationTime m_currentTime;
};

} // namespace WebKit

#endif // ENABLE(THREADED_ANIMATION_RESOLUTION)
