<template name="file-header">
    /*
        Generated by sbus code generator

        Copyright (C) 2017 Red Hat

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */

    #include <inttypes.h>
    #include <talloc.h>

    #include "${sbus-path}/sbus_request.h"
    #include "${header:arguments}"
    #include "${header:keygens}"

</template>

<template name="key">
    const char *
    _sbus_key_${key-signature}<loop line name="key-argument">_${key-index}</loop>
       (TALLOC_CTX *mem_ctx,
        struct sbus_request *sbus_req,
        struct _sbus_invoker_args_${key-signature} *args)
    {
        if (sbus_req->sender == NULL) {
            return talloc_asprintf(mem_ctx, "-:%u:%s:%s.%s:%s<loop name="key-argument">:%${key-format}</loop>",
                sbus_req->type, sbus_req->destination, sbus_req->interface,
                sbus_req->member, sbus_req->path<loop name="key-argument">, args->arg${key-index}</loop>);
        }

        return talloc_asprintf(mem_ctx, "%"PRIi64":%u:%s:%s.%s:%s<loop name="key-argument">:%${key-format}</loop>",
            sbus_req->sender->uid, sbus_req->type, sbus_req->destination, sbus_req->interface,
            sbus_req->member, sbus_req->path<loop name="key-argument">, args->arg${key-index}</loop>);
    }

</template>

<template name="key-no-arguments">
    const char *
    _sbus_key_${key-signature}
       (TALLOC_CTX *mem_ctx,
        struct sbus_request *sbus_req)
    {
        if (sbus_req->sender == NULL) {
            return talloc_asprintf(mem_ctx, "-:%u:%s:%s.%s:%s",
                sbus_req->type, sbus_req->destination, sbus_req->interface,
                sbus_req->member, sbus_req->path);
        }

        return talloc_asprintf(mem_ctx, "%"PRIi64":%u:%s:%s.%s:%s",
            sbus_req->sender->uid, sbus_req->type, sbus_req->destination,
            sbus_req->interface, sbus_req->member, sbus_req->path);
    }

</template>
