/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_56 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 27039, "epsg", 27039,
        "Nahrwan 1967 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4270\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"270");
    add_srs_wkt (p, 12,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 27040, "epsg", 27040,
        "Nahrwan 1967 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 40N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4270\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"270");
    add_srs_wkt (p, 12,
        "40\"]]");
    p = add_epsg_def_ex (filter, first, last, 27120, "epsg", 27120,
        "Naparima 1972 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Naparima_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-10,375,165,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Naparima 1972 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
        "a 1972\",DATUM[\"Naparima_1972\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6271\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4271");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-63]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2712");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 27200, "epsg", 27200,
        "NZGD49 / New Zealand Map Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "New_Zealand_Map_Grid", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=60231");
    add_proj4text (p, 1,
        "50 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.0");
    add_proj4text (p, 2,
        "24,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / New Zealand Map Grid\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"New_Zealand_Map_Grid\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",-41],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",173],PARAMETER[\"false_easting\",2510000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",6023150],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"27200\"]]");
    p = add_epsg_def_ex (filter, first, last, 27205, "epsg", 27205,
        "NZGD49 / Mount Eden Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393");
    add_proj4text (p, 1,
        "611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +to");
    add_proj4text (p, 2,
        "wgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Eden Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-36.8798652777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.764339361111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",300000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27205\"]]");
    p = add_epsg_def_ex (filter, first, last, 27206, "epsg", 27206,
        "NZGD49 / Bay of Plenty Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.4661972");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bay of Plenty Circuit\",GEOGCS[\"NZGD4");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-37.7612498055556],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",176.46619725],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27206\"]]");
    p = add_epsg_def_ex (filter, first, last, 27207, "epsg", 27207,
        "NZGD49 / Poverty Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Poverty Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-38.6247027777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",177.885636277778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27207\"]]");
    p = add_epsg_def_ex (filter, first, last, 27208, "epsg", 27208,
        "NZGD49 / Hawkes Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805");
    add_proj4text (p, 1,
        "277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hawkes Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-39.6509293055556],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",176.673680527778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27208\"]]");
    p = add_epsg_def_ex (filter, first, last, 27209, "epsg", 27209,
        "NZGD49 / Taranaki Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.2280117");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Taranaki Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39.1357583055556],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",174.22801175],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27209\"]]");
    p = add_epsg_def_ex (filter, first, last, 27210, "epsg", 27210,
        "NZGD49 / Tuhirangi Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Tuhirangi Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39.5124703888889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.640036805556],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27210\"]]");
    p = add_epsg_def_ex (filter, first, last, 27211, "epsg", 27211,
        "NZGD49 / Wanganui Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wanganui Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-40.2419471388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.488099611111],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27211\"]]");
    p = add_epsg_def_ex (filter, first, last, 27212, "epsg", 27212,
        "NZGD49 / Wairarapa Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wairarapa Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-40.9255326388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",175.647349666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27212\"]]");
    p = add_epsg_def_ex (filter, first, last, 27213, "epsg", 27213,
        "NZGD49 / Wellington Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wellington Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-41.3013196388889],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",174.776623111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27213\"]]");
    p = add_epsg_def_ex (filter, first, last, 27214, "epsg", 27214,
        "NZGD49 / Collingwood Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Collingwood Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-40.7147590555556],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",172.6720465],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27214\"]]");
    p = add_epsg_def_ex (filter, first, last, 27215, "epsg", 27215,
        "NZGD49 / Nelson Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168");
    add_proj4text (p, 1,
        "055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Nelson Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-41.2745447222222],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",173.299316805556],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27215\"]]");
    p = add_epsg_def_ex (filter, first, last, 27216, "epsg", 27216,
        "NZGD49 / Karamea Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Karamea Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-41.2899115277778],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",172.109028194444],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27216\"]]");
    p = add_epsg_def_ex (filter, first, last, 27217, "epsg", 27217,
        "NZGD49 / Buller Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Buller Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-41.8108028611111],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.581260055556],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27217\"]]");
    p = add_epsg_def_ex (filter, first, last, 27218, "epsg", 27218,
        "NZGD49 / Grey Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Grey Circuit\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-42.3336942777778],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",171.549771305556],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27218\"]]");
    p = add_epsg_def_ex (filter, first, last, 27219, "epsg", 27219,
        "NZGD49 / Amuri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Amuri Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-42.6891165833333],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",173.010133388889],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27219\"]]");
    p = add_epsg_def_ex (filter, first, last, 27220, "epsg", 27220,
        "NZGD49 / Marlborough Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Marlborough Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-41.5444866666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",173.802074111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27220\"]]");
    p = add_epsg_def_ex (filter, first, last, 27221, "epsg", 27221,
        "NZGD49 / Hokitika Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hokitika Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-42.8863223611111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",170.9799935],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"27221\"]]");
    p = add_epsg_def_ex (filter, first, last, 27222, "epsg", 27222,
        "NZGD49 / Okarito Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Okarito Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-43.1101281388889],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",170.260925833333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27222\"]]");
    p = add_epsg_def_ex (filter, first, last, 27223, "epsg", 27223,
        "NZGD49 / Jacksons Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,");
    add_proj4text (p, 2,
        "-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Jacksons Bay Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-43.9778028888889],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",168.606267],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27223\"]]");
    p = add_epsg_def_ex (filter, first, last, 27224, "epsg", 27224,
        "NZGD49 / Mount Pleasant Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Pleasant Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-43.5906375833333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",172.727193583333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27224\"]]");
    p = add_epsg_def_ex (filter, first, last, 27225, "epsg", 27225,
        "NZGD49 / Gawler Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484");
    add_proj4text (p, 1,
        "722222 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Gawler Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-43.7487115555556],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.360748472222],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27225\"]]");
    p = add_epsg_def_ex (filter, first, last, 27226, "epsg", 27226,
        "NZGD49 / Timaru Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Timaru Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-44.4022203611111],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",171.057250833333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27226\"]]");
    p = add_epsg_def_ex (filter, first, last, 27227, "epsg", 27227,
        "NZGD49 / Lindis Peak Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Lindis Peak Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-44.7352679722222],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",169.467755083333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27227\"]]");
    p = add_epsg_def_ex (filter, first, last, 27228, "epsg", 27228,
        "NZGD49 / Mount Nicholas Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Nicholas Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-45.1329025833333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",168.398641194444],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27228\"]]");
    p = add_epsg_def_ex (filter, first, last, 27229, "epsg", 27229,
        "NZGD49 / Mount York Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount York Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",-45.5637261666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",167.738861777778],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27229\"]]");
    p = add_epsg_def_ex (filter, first, last, 27230, "epsg", 27230,
        "NZGD49 / Observation Point Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Observation Point Circuit\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",-45.8161966111111],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",170.628595166667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",300000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27230\"]]");
    p = add_epsg_def_ex (filter, first, last, 27231, "epsg", 27231,
        "NZGD49 / North Taieri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891");
    add_proj4text (p, 1,
        "111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +t");
    add_proj4text (p, 2,
        "owgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Taieri Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-45.8615133611111],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",170.282589111111],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.99996],PARAMETER[\"false_easting\",300000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",700000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27231\"]]");
    p = add_epsg_def_ex (filter, first, last, 27232, "epsg", 27232,
        "NZGD49 / Bluff Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +towgs84=");
    add_proj4text (p, 2,
        "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bluff Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-46.6000096111111],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",168.342872],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",300002.66],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",699999.58],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"27232\"]]");
    p = add_epsg_def_ex (filter, first, last, 27258, "epsg", 27258,
        "NZGD49 / UTM zone 58S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 58S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27258\"]]");
    p = add_epsg_def_ex (filter, first, last, 27259, "epsg", 27259,
        "NZGD49 / UTM zone 59S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 59S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27259\"]]");
    p = add_epsg_def_ex (filter, first, last, 27260, "epsg", 27260,
        "NZGD49 / UTM zone 60S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 60S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27260\"]]");
    p = add_epsg_def_ex (filter, first, last, 27291, "epsg", 27291,
        "NZGD49 / North Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.524");
    add_proj4text (p, 1,
        "3848086 +y_0=365759.3658464114 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-39],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",175.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",300000],PARAMETER[\"false_northing\",40000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"British yard (Sears 1922)\",0.914398414616029,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27291\"]]");
    p = add_epsg_def_ex (filter, first, last, 27292, "epsg", 27292,
        "NZGD49 / South Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.207");
    add_proj4text (p, 1,
        "3080143 +y_0=457199.2073080143 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / South Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-44],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",171.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",50000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"British yard (Sears 1922)\",0.914398414616029,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27292\"]]");
    p = add_epsg_def_ex (filter, first, last, 27391, "epsg", 27391,
        "NGO 1948 (Oslo) / NGO zone I", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone I\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7");
    add_srs_wkt (p, 4,
        "229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-4.66666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27391\"]]");
    p = add_epsg_def_ex (filter, first, last, 27392, "epsg", 27392,
        "NGO 1948 (Oslo) / NGO zone II", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone II\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-2.33333333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27392\"]]");
    p = add_epsg_def_ex (filter, first, last, 27393, "epsg", 27393,
        "NGO 1948 (Oslo) / NGO zone III", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=637");
    add_proj4text (p, 1,
        "7492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.");
    add_proj4text (p, 2,
        "889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone III\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10");
    add_srs_wkt (p, 4,
        ".7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merc");
    add_srs_wkt (p, 7,
        "ator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",0],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27393\"]]");
    p = add_epsg_def_ex (filter, first, last, 27394, "epsg", 27394,
        "NGO 1948 (Oslo) / NGO zone IV", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,");
    add_proj4text (p, 2,
        "7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone IV\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",2.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"27394\"]]");
    p = add_epsg_def_ex (filter, first, last, 27395, "epsg", 27395,
        "NGO 1948 (Oslo) / NGO zone V", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone V\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7");
    add_srs_wkt (p, 4,
        "229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",6.16666666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"27395\"]]");
    p = add_epsg_def_ex (filter, first, last, 27396, "epsg", 27396,
        "NGO 1948 (Oslo) / NGO zone VI", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VI\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",10.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27396\"]]");
    p = add_epsg_def_ex (filter, first, last, 27397, "epsg", 27397,
        "NGO 1948 (Oslo) / NGO zone VII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VII\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10");
    add_srs_wkt (p, 4,
        ".7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merc");
    add_srs_wkt (p, 7,
        "ator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",14.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27397\"]]");
    p = add_epsg_def_ex (filter, first, last, 27398, "epsg", 27398,
        "NGO 1948 (Oslo) / NGO zone VIII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VIII\",GEOGCS[\"NGO ");
    add_srs_wkt (p, 1,
        "1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",1");
    add_srs_wkt (p, 4,
        "0.7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",18.3333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"27398\"]]");
    p = add_epsg_def_ex (filter, first, last, 27429, "epsg", 27429,
        "Datum 73 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193");
    add_proj4text (p, 1,
        ",36.649,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / UTM zone 29N\",GEOGCS[\"Datum 73\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Datum_73\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27429\"]]");
    p = add_epsg_def_ex (filter, first, last, 27492, "epsg", 27492,
        "Datum 73 / Modified Portuguese Grid (deprecated)", 0, 1,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4274\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",39.6666666666667],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-8.13190611111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",180.598],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",-86.99],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"27492\"]]");
    p = add_epsg_def_ex (filter, first, last, 27493, "epsg", 27493,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",39.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-8.13190611111111],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27500, "epsg", 27500,
        "ATF (Paris) / Nord de Guerre", 0, 0,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=5.399999999999999 +k_0=0.99950908 +x_0=500000");
    add_proj4text (p, 2,
        " +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.33720");
    add_proj4text (p, 3,
        "8333333333 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATF (Paris) / Nord de Guerre\",GEOGCS[\"ATF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Ancienne_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 4,
        "ris RGS\",2.33720833333333,AUTHORITY[\"EPSG\",\"8914\"]]");
    add_srs_wkt (p, 5,
        ",UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "105\"]],AUTHORITY[\"EPSG\",\"4901\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",55],PARAMETER[\"central_meridian\",6],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.99950908],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27500\"]]");
    p = add_epsg_def_ex (filter, first, last, 27561, "epsg", 27561,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",55],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877341],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27562, "epsg", 27562,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",600000],PARAMETER[\"false_northing\",200000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27563, "epsg", 27563,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",49],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877499],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27564, "epsg", 27564,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6807");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 5,
        "03\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",46.85],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99994471],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",234.358],PARAMETER[\"false_northing\",185861.369],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27564\"]]");
    p = add_epsg_def_ex (filter, first, last, 27571, "epsg", 27571,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"680");
    add_srs_wkt (p, 4,
        "7\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",55],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.999877341],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",1200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "71\"]]");
    p = add_epsg_def_ex (filter, first, last, 27572, "epsg", 27572,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",52],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99987742],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",2200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "72\"]]");
    p = add_epsg_def_ex (filter, first, last, 27573, "epsg", 27573,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",49],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999877499],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",600000],PARAMETER[\"false_northing\",3200000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "7573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27574, "epsg", 27574,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",46.85],PARAMETER[\"central_meridian\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99994471],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",234.358],PARAMETER[\"false_northing\",4185861.369");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27581, "epsg", 27581,
        "NTF (Paris) / France I (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France I (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",55],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.999877341],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",600000],PARAMETER[\"false_northing\",1200000],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27581\"]]");
    p = add_epsg_def_ex (filter, first, last, 27582, "epsg", 27582,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",600000],PARAMETER[\"false_northing\",2200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27582\"]]");
    p = add_epsg_def_ex (filter, first, last, 27583, "epsg", 27583,
        "NTF (Paris) / France III (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France III (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "6021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",49],PARAMETER[\"central_meridian\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.999877499],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",600000],PARAMETER[\"false_northing\",320000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27583\"]]");
    p = add_epsg_def_ex (filter, first, last, 27584, "epsg", 27584,
        "NTF (Paris) / France IV (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France IV (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",46.85],PARAMETER[\"central_meridian\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.99994471],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",234.358],PARAMETER[\"false_northing\",418586");
    add_srs_wkt (p, 11,
        "1.369],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"27584\"]]");
    p = add_epsg_def_ex (filter, first, last, 27591, "epsg", 27591,
        "NTF (Paris) / Nord France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Nord France (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francais");
    add_srs_wkt (p, 2,
        "e_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4");
    add_srs_wkt (p, 3,
        "66021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",55],PARAMETER[\"central_meridian\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.999877341],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",600000],PARAMETER[\"false_northing\",20000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27591\"]]");
    p = add_epsg_def_ex (filter, first, last, 27592, "epsg", 27592,
        "NTF (Paris) / Centre France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Centre France (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Franca");
    add_srs_wkt (p, 2,
        "ise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293");
    add_srs_wkt (p, 3,
        ".466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",52],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"scale_factor\",0.99987742],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",600000],PARAMETER[\"false_northing\",20000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27592\"]]");
    p = add_epsg_def_ex (filter, first, last, 27593, "epsg", 27593,
        "NTF (Paris) / Sud France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Sud France (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "6021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",49],PARAMETER[\"central_meridian\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.999877499],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",600000],PARAMETER[\"false_northing\",200000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27593\"]]");
    p = add_epsg_def_ex (filter, first, last, 27594, "epsg", 27594,
        "NTF (Paris) / Corse (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Corse (deprecated)\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",46.85],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99994471],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",234.358],PARAMETER[\"false_northing\",185861.36");
    add_srs_wkt (p, 11,
        "9],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27594\"]]");
    p = add_epsg_def_ex (filter, first, last, 27700, "epsg", 27700,
        "OSGB36 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "Ordnance_Survey_of_Great_Britain_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSGB36 / British National Grid\",GEOGCS[\"OSGB3");
    add_srs_wkt (p, 1,
        "6\",DATUM[\"Ordnance_Survey_of_Great_Britain_1936\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Airy 1830\",6377563.396,299.3249646,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7001\"]],AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4277\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-2],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "012717],PARAMETER[\"false_easting\",400000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",-100000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"27700\"]]");
    p = add_epsg_def_ex (filter, first, last, 28191, "epsg", 28191,
        "Palestine 1923 / Palestine Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6");
    add_proj4text (p, 2,
        "356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-4");
    add_proj4text (p, 3,
        ".42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Grid\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldner\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",31.7340969444444],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",35.2120805555556],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",170251.555],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"28191\"]]");
    p = add_epsg_def_ex (filter, first, last, 28192, "epsg", 28192,
        "Palestine 1923 / Palestine Belt", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.212080555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=170251.555 +y_0=1126867.909 +a=6378300.7");
    add_proj4text (p, 2,
        "89 +b=6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8");
    add_proj4text (p, 3,
        ".001,-4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Belt\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31.7340969444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",35.2120805555556],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",170");
    add_srs_wkt (p, 10,
        "251.555],PARAMETER[\"false_northing\",1126867.909],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "8192\"]]");
    p = add_epsg_def_ex (filter, first, last, 28193, "epsg", 28193,
        "Palestine 1923 / Israeli CS Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=");
    add_proj4text (p, 2,
        "6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-");
    add_proj4text (p, 3,
        "4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Israeli CS Grid\",GEOGCS[\"Pal");
    add_srs_wkt (p, 1,
        "estine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldn");
    add_srs_wkt (p, 7,
        "er\"],PARAMETER[\"latitude_of_origin\",31.7340969444444]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",35.2120805555556],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",170251.555],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",1126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"28193\"]]");
    p = add_epsg_def_ex (filter, first, last, 28232, "epsg", 28232,
        "Pointe Noire / UTM zone 32S", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Congo_1960_Pointe_Noire", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-148,51,-291,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pointe Noire / UTM zone 32S\",GEOGCS[\"Pointe N");
    add_srs_wkt (p, 1,
        "oire\",DATUM[\"Congo_1960_Pointe_Noire\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6282\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4282\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",9],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"28232\"]]");
    p = add_epsg_def_ex (filter, first, last, 28348, "epsg", 28348,
        "GDA94 / MGA zone 48", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 48\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28348\"]]");
    p = add_epsg_def_ex (filter, first, last, 28349, "epsg", 28349,
        "GDA94 / MGA zone 49", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 49\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28349\"]]");
    p = add_epsg_def_ex (filter, first, last, 28350, "epsg", 28350,
        "GDA94 / MGA zone 50", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 50\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28350\"]]");
    p = add_epsg_def_ex (filter, first, last, 28351, "epsg", 28351,
        "GDA94 / MGA zone 51", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 51\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28351\"]]");
    p = add_epsg_def_ex (filter, first, last, 28352, "epsg", 28352,
        "GDA94 / MGA zone 52", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 52\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28352\"]]");
    p = add_epsg_def_ex (filter, first, last, 28353, "epsg", 28353,
        "GDA94 / MGA zone 53", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 53\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28353\"]]");
    p = add_epsg_def_ex (filter, first, last, 28354, "epsg", 28354,
        "GDA94 / MGA zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 54\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28354\"]]");
    p = add_epsg_def_ex (filter, first, last, 28355, "epsg", 28355,
        "GDA94 / MGA zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 55\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28355\"]]");
    p = add_epsg_def_ex (filter, first, last, 28356, "epsg", 28356,
        "GDA94 / MGA zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 56\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28356\"]]");
    p = add_epsg_def_ex (filter, first, last, 28357, "epsg", 28357,
        "GDA94 / MGA zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 57\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28357\"]]");
    p = add_epsg_def_ex (filter, first, last, 28358, "epsg", 28358,
        "GDA94 / MGA zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 58\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28358\"]]");
    p = add_epsg_def_ex (filter, first, last, 28402, "epsg", 28402,
        "Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",2500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"28402\"]]");
    p = add_epsg_def_ex (filter, first, last, 28403, "epsg", 28403,
        "Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",3500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28403\"]]");
    p = add_epsg_def_ex (filter, first, last, 28404, "epsg", 28404,
        "Pulkovo 1942 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28404\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28405, "epsg", 28405,
        "Pulkovo 1942 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28405\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28406, "epsg", 28406,
        "Pulkovo 1942 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28406\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28407, "epsg", 28407,
        "Pulkovo 1942 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28407\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28408, "epsg", 28408,
        "Pulkovo 1942 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28408\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28409, "epsg", 28409,
        "Pulkovo 1942 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28409\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28410, "epsg", 28410,
        "Pulkovo 1942 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28410");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28411, "epsg", 28411,
        "Pulkovo 1942 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28411");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28412, "epsg", 28412,
        "Pulkovo 1942 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28412");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28413, "epsg", 28413,
        "Pulkovo 1942 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28413");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28414, "epsg", 28414,
        "Pulkovo 1942 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28414");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28415, "epsg", 28415,
        "Pulkovo 1942 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28415");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28416, "epsg", 28416,
        "Pulkovo 1942 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28416");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28417, "epsg", 28417,
        "Pulkovo 1942 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28417");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28418, "epsg", 28418,
        "Pulkovo 1942 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2841");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 28419, "epsg", 28419,
        "Pulkovo 1942 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2841");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 28420, "epsg", 28420,
        "Pulkovo 1942 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 28421, "epsg", 28421,
        "Pulkovo 1942 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "1\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

