#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the simplifier's basic functionality.

tac

mkdir .tmp

$ANOMY/bin/simplify.pl \
    "mime=no" \
    "testing=yes" \
    "url=http://blah/" \
    "temp=./.tmp" \
    "header=HEADER" <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: moo
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

This is MIME preamble.  Blah blah!  Blah!

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/ms-tnef; charset="iso-8859-1"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

this is a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: quoted-printable

Here comes=20a=20word=20with=20no=20spaces!

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment;
 filename="aaaaaaaaa0aaaaaaaaa1aaaaaaaaa2aaaaaaaaa3aaaaaaaaa4aaaaaaaaa5aaaaaaaaa6aaaaaaaaa7aaaaaaaa.vbs.txt"
Content-Transfer-Encoding: 8bit

this is also a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--

This is MIME postamble!  Is that a word?

EOF
echo "*** Exit code was $? ***" >>test.out

$ANOMY/bin/simplify.pl "testing=yes" "temp=./.tmp" \
      "url=http://blah/" "header=HEADER2" <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
Sender: xxx@example.com
Subject: moo
To: fake@example.com

This is a plain text message, old old style!  Blah blah!

EOF
echo "*** Exit code was $? ***" >>test.out
$ANOMY/bin/simplify.pl "testing=yes"  "temp=./.tmp" "url=http://blah/" "header=HEADER2" <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: moo
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

This is MIME preamble.  Blah blah!  Blah!

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/html; charset="iso-8859-1"
Content-Transfer-Encoding: 8bit

<html><body>this is an HTML part</body></html>

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: quoted-printable

Here comes=20a=20word=20with=20no=20spaces!

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment;
 filename="aaaaaaaaa0aaaaaaaaa1aaaaaaaaa2aaaaaaaaa3aaaaaaaaa4aaaaaaaaa5aaaaaaaaa6aaaaaaaaa7aaaaaaaa.vbs.txt"
Content-Transfer-Encoding: 8bit

this is also a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--

This is MIME postamble!  Is that a word?

EOF
echo "*** Exit code was $? ***" >>test.out

rm -rf .tmp
exit 0
